/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.SinglePolylineGeography;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polyline;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2RegionUnion;
import org.apache.sedona.shaded.s2.S2Shape;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class PolylineGeography
extends Geography {
    private static final Logger logger = Logger.getLogger(PolylineGeography.class.getName());
    public final List<S2Polyline> polylines;

    private static int sizeofInt() {
        return 4;
    }

    public PolylineGeography() {
        super(Geography.GeographyKind.POLYLINE);
        this.polylines = new ArrayList<S2Polyline>();
    }

    public PolylineGeography(S2Polyline polyline) {
        super(Geography.GeographyKind.POLYLINE);
        this.polylines = new ArrayList<S2Polyline>();
        this.polylines.add(polyline);
    }

    public PolylineGeography(List<S2Polyline> polylines) {
        super(Geography.GeographyKind.POLYLINE);
        this.polylines = new ArrayList<S2Polyline>(polylines);
    }

    public PolylineGeography(Geography.GeographyKind kind, S2Polyline polyline) {
        super(kind);
        if (kind != Geography.GeographyKind.POLYLINE && kind != Geography.GeographyKind.SINGLEPOLYLINE) {
            throw new IllegalArgumentException("Invalid GeographyKind for PolylineGeography: " + kind);
        }
        this.polylines = new ArrayList<S2Polyline>();
        this.polylines.add(polyline);
    }

    @Override
    public int dimension() {
        return this.polylines.isEmpty() ? -1 : 1;
    }

    @Override
    public int numShapes() {
        return this.polylines.size();
    }

    @Override
    public S2Shape shape(int id) {
        return this.polylines.get(id);
    }

    @Override
    public S2Region region() {
        ArrayList<S2Region> polylineRegionCollection = new ArrayList<S2Region>();
        polylineRegionCollection.addAll(this.polylines);
        return new S2RegionUnion(polylineRegionCollection);
    }

    @Override
    public void getCellUnionBound(List<S2CellId> cellIds) {
        super.getCellUnionBound(cellIds);
    }

    public List<S2Polyline> getPolylines() {
        return ImmutableList.copyOf(this.polylines);
    }

    @Override
    public void encode(UnsafeOutput out, EncodeOptions opts) throws IOException {
        out.writeInt(this.polylines.size());
        boolean useFast = opts.getCodingHint() == EncodeOptions.CodingHint.FAST;
        for (S2Polyline pl : this.polylines) {
            if (useFast) {
                S2Polyline.FAST_CODER.encode(pl, (OutputStream)out);
                continue;
            }
            S2Polyline.COMPACT_CODER.encode(pl, (OutputStream)out);
        }
        out.flush();
    }

    public static PolylineGeography decode(Input in, EncodeTag tag) throws IOException {
        if (!(in instanceof UnsafeInput)) {
            throw new IllegalArgumentException("Expected UnsafeInput");
        }
        return PolylineGeography.decode((UnsafeInput)in, tag);
    }

    public static PolylineGeography decode(UnsafeInput in, EncodeTag tag) throws IOException {
        PolylineGeography geo = new PolylineGeography();
        if ((tag.getFlags() & 1) != 0) {
            logger.fine("Decoded empty PointGeography.");
            return geo;
        }
        tag.skipCovering(in);
        try {
            int count = in.readInt();
            if (count < 0) {
                throw new IOException("PolylineGeography.decodeTagged error: negative count: " + count);
            }
            if (tag.getKind() == Geography.GeographyKind.SINGLEPOLYLINE) {
                return new SinglePolylineGeography(S2Polyline.decode((InputStream)in));
            }
            for (int i = 0; i < count; ++i) {
                S2Polyline pl = S2Polyline.decode((InputStream)in);
                geo.polylines.add(pl);
            }
        }
        catch (EOFException e) {
            throw new IOException("PolylineGeography.decodeTagged error: insufficient data to decode all parts of the geography.", e);
        }
        return geo;
    }

    public CoordinateSequence getCoordinateSequence() {
        int totalVerts = 0;
        for (S2Polyline pl : this.polylines) {
            totalVerts += pl.numVertices();
        }
        Coordinate[] coords = new Coordinate[totalVerts];
        int idx = 0;
        for (S2Polyline pl : this.polylines) {
            int n = pl.numVertices();
            int i = 0;
            while (i < n) {
                Coordinate c;
                S2Point pt = pl.vertex(i);
                S2LatLng ll = new S2LatLng(pt);
                double lat = ll.latDegrees();
                double lon = ll.lngDegrees();
                coords[idx] = c = new Coordinate(lon, lat);
                ++i;
                ++idx;
            }
        }
        return new CoordinateArraySequence(coords);
    }
}

