/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.Lists;
import org.apache.sedona.shaded.guava.primitives.UnsignedLongs;
import org.apache.sedona.shaded.s2.Matrix;
import org.apache.sedona.shaded.s2.R2Rect;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Cap;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2Edge;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2FractalBuilder;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2LaxPolygonShape;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2PointIndex;
import org.apache.sedona.shaded.s2.S2Polygon;
import org.apache.sedona.shaded.s2.S2RobustCrossProd;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;

public class TestDataGenerator {
    public static final S1Angle DEFAULT_LOOP_RADIUS = TestDataGenerator.kmToAngle(10.0);
    public static final double DEFAULT_NESTED_LOOP_GAP = 5.0;
    public static final double DEFAULT_CROSSING_LOOP_RADIUS_RATIO = 10.0;
    public static final double EARTH_RADIUS_METERS = 6371010.0;
    public static final int DEFAULT_RANDOM_SEED = 123455;
    public Random rand;

    public TestDataGenerator() {
        this.rand = new Random(123455L);
    }

    public TestDataGenerator(int seed) {
        this.rand = new Random(seed);
    }

    public void resetSeed() {
        this.rand.setSeed(123455L);
    }

    public void setSeed(int seed) {
        this.rand.setSeed(seed);
    }

    public double nextDouble() {
        return this.rand.nextDouble();
    }

    public int nextInt() {
        return this.rand.nextInt();
    }

    public int nextInt(int n) {
        return this.rand.nextInt(n);
    }

    public long nextLong() {
        return this.rand.nextLong();
    }

    public boolean nextBoolean() {
        return this.rand.nextBoolean();
    }

    public void nextBytes(byte[] bytes) {
        this.rand.nextBytes(bytes);
    }

    public S2Point getRandomPoint() {
        return S2Point.normalize(new S2Point(2.0 * this.rand.nextDouble() - 1.0, 2.0 * this.rand.nextDouble() - 1.0, 2.0 * this.rand.nextDouble() - 1.0));
    }

    public S1Angle randomAngleInRange(double minRadians, double maxRadians) {
        return S1Angle.radians(minRadians + this.rand.nextDouble() * (maxRadians - minRadians));
    }

    public S2CellId getRandomCellId(int level) {
        int face = this.random(6);
        long pos = this.rand.nextLong() & 0xFFFFFFFFFFFFFFFL;
        return S2CellId.fromFacePosLevel(face, pos, level);
    }

    public S2CellId getRandomCellId(S2CellId parent, int level) {
        Preconditions.checkArgument(level >= parent.level());
        int levelDiff = level - parent.level();
        int childrenAtLevel = 1 << levelDiff * 2;
        return parent.childBegin(level).advance(this.uniform(childrenAtLevel));
    }

    public S2CellId getRandomCellId() {
        return this.getRandomCellId(this.random(31));
    }

    public S2CellId randomCell() {
        int face = this.rand.nextInt(6);
        long pos = this.rand.nextLong() & 0x3DL;
        int level = this.rand.nextInt(30);
        return S2CellId.fromFacePosLevel(face, pos, level);
    }

    public double uniform(double min2, double max) {
        Preconditions.checkArgument(min2 <= max);
        return min2 + this.rand.nextDouble() * (max - min2);
    }

    public int uniform(int bound) {
        Preconditions.checkState(bound > 0);
        return this.rand.nextInt(bound);
    }

    public int uniformInt(int min2, int max) {
        Preconditions.checkArgument(min2 <= max);
        return min2 + this.rand.nextInt(max - min2);
    }

    public int skewed(int maxLog) {
        int base = this.rand.nextInt(maxLog + 1);
        return this.rand.nextInt() & (1 << base) - 1;
    }

    public boolean oneIn(int n) {
        return this.rand.nextInt(n) == 0;
    }

    public Matrix getRandomFrame() {
        return this.getRandomFrameAt(this.getRandomPoint());
    }

    public Matrix getRandomFrameAt(S2Point z) {
        S2Point x = S2Point.normalize(S2Point.crossProd(z, this.getRandomPoint()));
        S2Point y = S2Point.normalize(S2Point.crossProd(z, x));
        return Matrix.fromCols(x, y, z);
    }

    public int random(int n) {
        if (n == 0) {
            return 0;
        }
        return this.rand.nextInt(n);
    }

    public S2Cap getRandomCap(double minArea, double maxArea) {
        double capArea = maxArea * Math.pow(minArea / maxArea, this.rand.nextDouble());
        Preconditions.checkState(capArea >= minArea && capArea <= maxArea);
        return S2Cap.fromAxisArea(this.getRandomPoint(), capArea);
    }

    public static S2Polygon concentricLoopsPolygon(S2Point center, int numLoops, int numVerticesPerLoop) {
        Matrix m3 = S2.getFrame(center);
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>(numLoops);
        for (int li = 0; li < numLoops; ++li) {
            ArrayList<S2Point> vertices = new ArrayList<S2Point>(numVerticesPerLoop);
            double radius = 0.005 * (double)(li + 1) / (double)numLoops;
            double radianStep = Math.PI * 2 / (double)numVerticesPerLoop;
            for (int vi = 0; vi < numVerticesPerLoop; ++vi) {
                double angle = (double)vi * radianStep;
                S2Point p = new S2Point(radius * Math.cos(angle), radius * Math.sin(angle), 1.0);
                vertices.add(S2.rotate(p, m3));
            }
            loops.add(new S2Loop(vertices));
        }
        return new S2Polygon(loops);
    }

    protected void addConcentricLoops(List<List<S2Point>> outputLoops, int numLoops, int minVertices) {
        Preconditions.checkArgument(numLoops <= 10);
        S2Point center = this.getRandomPoint();
        int numVertices = minVertices + this.uniform(10);
        for (int i = 0; i < numLoops; ++i) {
            S1Angle radius = S1Angle.degrees(80.0 * Math.pow(0.1, i));
            outputLoops.add(S2Loop.makeRegularVertices(center, radius, numVertices));
        }
    }

    public static List<S2Edge> ccwEdgesAbout(S2Point center, int num) {
        ArrayList<S2Edge> edges = new ArrayList<S2Edge>();
        for (int i = 0; i < num; ++i) {
            double angle = Math.PI * 2 / (double)num * (double)i;
            edges.add(new S2Edge(center, TestDataGenerator.latLngToPoint(Math.sin(angle), Math.cos(angle))));
        }
        return edges;
    }

    public static S2Point latLngToPoint(double lat, double lng) {
        return S2LatLng.fromRadians(lat, lng).toPoint();
    }

    public S2Point samplePoint(S2Cap cap) {
        S2Point z = cap.axis();
        S2Point x = S2.ortho(z);
        S2Point y = S2Point.crossProd(z, x);
        double h2 = this.rand.nextDouble() * cap.height();
        double theta = Math.PI * 2 * this.rand.nextDouble();
        double r = Math.sqrt(h2 * (2.0 - h2));
        return S2Point.normalize(S2Point.add(S2Point.add(S2Point.mul(x, Math.cos(theta) * r), S2Point.mul(y, Math.sin(theta) * r)), S2Point.mul(z, 1.0 - h2)));
    }

    public S2Point samplePoint(S2LatLngRect rect) {
        double sinLo = Math.sin(rect.lat().lo());
        double sinHi = Math.sin(rect.lat().hi());
        double lat = Math.asin(sinLo + this.rand.nextDouble() * (sinHi - sinLo));
        double lng = rect.lng().lo() + this.rand.nextDouble() * rect.lng().getLength();
        return S2LatLng.fromRadians(lat, lng).normalized().toPoint();
    }

    public S2Shape.MutableEdge sampleEdge(S2ShapeIndex index, int numIndexEdges) {
        int e = this.uniform(numIndexEdges);
        for (S2Shape shape : index.getShapes()) {
            if (shape == null) continue;
            if (e < shape.numEdges()) {
                S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                shape.getEdge(e, edge);
                return edge;
            }
            e -= shape.numEdges();
        }
        throw new IllegalStateException("Index with no edges?");
    }

    public S2CellId sampleCell(S2ShapeIndex index) {
        int numCells = 0;
        S2Iterator.ListIterator<S2ShapeIndex.Cell> iter = index.iterator();
        while (!iter.done()) {
            ++numCells;
            iter.next();
        }
        iter.restart();
        int i = this.uniform(numCells);
        while (--i >= 0) {
            iter.next();
        }
        return iter.id();
    }

    public S2Point sampleBoundary(S2Cap cap) {
        return S2EdgeUtil.getPointOnLine(cap.axis(), this.getRandomPoint(), cap.radius());
    }

    public R2Vector sampleBoundary(R2Rect rect) {
        double x;
        double y;
        if (this.oneIn(2)) {
            y = this.oneIn(2) ? rect.y().lo() : rect.y().hi();
            x = this.uniform(rect.x().lo(), rect.x().hi());
        } else {
            x = this.oneIn(2) ? rect.x().lo() : rect.x().hi();
            y = this.uniform(rect.y().lo(), rect.y().hi());
        }
        return new R2Vector(x, y);
    }

    @CanIgnoreReturnValue
    public static S2Loop indexLoop(S2Loop loop) {
        boolean unused = loop.contains(S2Cell.fromFace(0));
        Preconditions.checkState(loop.index.isFresh());
        return loop;
    }

    public static S2Loop makeFractal(int radiusDegrees, int numVertices) {
        S2FractalBuilder fractalBuilder = new S2FractalBuilder(new Random(1L));
        fractalBuilder.setLevelForApproxMaxEdges(numVertices);
        return fractalBuilder.makeLoop(S2.getFrame(S2Point.X_POS), S1Angle.degrees(radiusDegrees));
    }

    public S2Polygon makeRandomFractal(S2LatLng center, S1Angle radius, int edges) {
        S2FractalBuilder fractalBuilder = new S2FractalBuilder(this.rand);
        fractalBuilder.setLevelForApproxMaxEdges(edges);
        return new S2Polygon(fractalBuilder.makeLoop(TestDataGenerator.upFrameAt(center), radius));
    }

    public static Matrix upFrameAt(S2LatLng center) {
        S2Point z = center.toPoint();
        S2Point x = S2RobustCrossProd.robustCrossProd(z, S2Point.Z_POS).normalize();
        S2Point y = S2RobustCrossProd.robustCrossProd(z, x).normalize();
        return Matrix.fromCols(x, y, z);
    }

    public static S1Angle kmToAngle(double km3) {
        return TestDataGenerator.metersToAngle(1000.0 * km3);
    }

    public static S1Angle metersToAngle(double meters) {
        return S1Angle.radians(meters / 6371010.0);
    }

    public static List<S2Loop> makeNestedLoopPair(S1Angle outerRadius, double gapEdgeMultiple, int numVertices, S2Point p) {
        S1Angle incircleRadius = S1Angle.radians(outerRadius.radians() * Math.cos(Math.PI / (double)numVertices));
        S1Angle edgeLen = S1Angle.radians(outerRadius.radians() * (Math.PI * 2 / (double)numVertices));
        S1Angle innerRadius = S1Angle.radians(Math.max(incircleRadius.radians() - gapEdgeMultiple * edgeLen.radians(), 0.01 * incircleRadius.radians()));
        return Arrays.asList(S2Loop.makeRegularLoop(p, outerRadius, numVertices), S2Loop.makeRegularLoop(p, innerRadius, numVertices));
    }

    public List<S2Loop> makeCrossingLoopPair(S1Angle aRadius, S1Angle bRadius, int numVertices, S2Point aPoint, S2Point bPoint) {
        double incircleFactor;
        double maxRadius = Math.max(aRadius.radians(), bRadius.radians());
        double minRadius = Math.min(aRadius.radians(), bRadius.radians());
        Preconditions.checkState(minRadius * (incircleFactor = Math.cos(Math.PI / (double)numVertices)) > maxRadius * (1.0 - incircleFactor));
        double minDist = maxRadius - incircleFactor * minRadius;
        double maxDist = incircleFactor * (minRadius + maxRadius);
        S1Angle angle = S1Angle.radians(minDist + this.rand.nextDouble() * (maxDist - minDist));
        S2Point bCenter = S2EdgeUtil.getPointOnLine(aPoint, bPoint, angle);
        return Arrays.asList(S2Loop.makeRegularLoop(aPoint, aRadius, numVertices), S2Loop.makeRegularLoop(bCenter, bRadius, numVertices));
    }

    public List<S2Loop> makeCrossingLoopPairDefault(int numVertices, S2Point aPoint, S2Point bPoint) {
        S1Angle aRadius = DEFAULT_LOOP_RADIUS;
        S1Angle bRadius = S1Angle.radians(aRadius.radians() * 10.0);
        return this.makeCrossingLoopPair(aRadius, bRadius, numVertices, aPoint, bPoint);
    }

    public static List<S2Loop> makeDisjointLoopPair(S1Angle outerRadius, double gapEdgeMultiple, int numVertices, S2Point center) {
        int j;
        S1Angle outerInsideRadius = S1Angle.radians(0.9 * outerRadius.radians() * Math.cos(Math.PI * 2 / (double)numVertices));
        S1Angle edgeLen = S1Angle.radians(outerInsideRadius.radians() * (Math.PI / (double)numVertices));
        S1Angle incircleRadius = S1Angle.radians(outerInsideRadius.radians() * Math.cos(Math.PI * 2 / (double)numVertices));
        S1Angle innerRadius = S1Angle.radians(Math.max(incircleRadius.radians() - gapEdgeMultiple * edgeLen.radians(), 0.01 * incircleRadius.radians()));
        S2Loop outerOutside = S2Loop.makeRegularLoop(center, outerRadius, Math.max(4, numVertices / 2));
        S2Loop outerInside = S2Loop.makeRegularLoop(center, outerInsideRadius, Math.max(4, numVertices / 2));
        ArrayList<S2Point> vertices = Lists.newArrayListWithCapacity(outerInside.numVertices() + outerOutside.numVertices());
        for (j = outerInside.numVertices() - 1; j >= 0; --j) {
            vertices.add(outerInside.vertex(j));
        }
        for (j = 0; j < outerOutside.numVertices(); ++j) {
            vertices.add(outerOutside.vertex(j));
        }
        return Arrays.asList(new S2Loop(vertices), S2Loop.makeRegularLoop(center, innerRadius, numVertices));
    }

    public static S2CellId[] generateEvenlySpacedIds(int numIds) {
        S2CellId[] ids = new S2CellId[numIds];
        long start = S2CellId.begin(30).id();
        long end = S2CellId.end(30).id();
        long delta = UnsignedLongs.divide(end - start, numIds);
        for (int i = 0; i < numIds; ++i) {
            ids[i] = new S2CellId(start + (long)i * delta);
        }
        return ids;
    }

    public static void addPoints(S2PointIndex<Integer> index, List<S2Point> points) {
        for (int i = 0; i < points.size(); ++i) {
            index.add(points.get(i), i);
        }
    }

    public static S2Polygon index(S2Polygon polygon) {
        polygon.index().applyUpdates();
        return polygon;
    }

    public static S2Polygon getBoundingPolygon(S2Polygon polygon) {
        S2Cap cap = polygon.getCapBound();
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>(1);
        int numCapEdges = 8;
        loops.add(S2Loop.makeRegularLoop(cap.axis(), S1Angle.radians(cap.angle().radians() / Math.cos(Math.PI / (double)numCapEdges)), numCapEdges));
        return new S2Polygon(loops);
    }

    protected static void checkEdgeLength(S2Loop loop) {
        S1Angle minEdgeLength = TestDataGenerator.metersToAngle(0.001);
        for (int j = 0; j < loop.numVertices(); ++j) {
            Preconditions.checkState(new S1Angle(loop.vertex(j), loop.vertex(j + 1)).greaterThan(minEdgeLength));
        }
    }

    public static enum ShapeFactoryEnum {
        SINGLE_POINT{

            @Override
            public ShapeFactory getFactory(TestDataGenerator generator) {
                return generator.new PointShapeFactory();
            }
        }
        ,
        REGULAR_LOOP{

            @Override
            public ShapeFactory getFactory(TestDataGenerator generator) {
                return generator.new RegularLoopShapeFactory();
            }
        }
        ,
        FRACTAL_LOOP{

            @Override
            public ShapeFactory getFactory(TestDataGenerator generator) {
                return generator.new FractalLoopShapeFactory();
            }
        }
        ,
        POINT_CLOUD{

            @Override
            public ShapeFactory getFactory(TestDataGenerator generator) {
                return generator.new PointCloudShapeFactory();
            }
        };


        public abstract ShapeFactory getFactory(TestDataGenerator var1);

        public static ShapeFactoryEnum valueOf(int ordinal) {
            if (ordinal == SINGLE_POINT.ordinal()) {
                return SINGLE_POINT;
            }
            if (ordinal == REGULAR_LOOP.ordinal()) {
                return REGULAR_LOOP;
            }
            if (ordinal == FRACTAL_LOOP.ordinal()) {
                return FRACTAL_LOOP;
            }
            if (ordinal == POINT_CLOUD.ordinal()) {
                return POINT_CLOUD;
            }
            throw new IllegalArgumentException("Unknown ShapeFactoryEnum ordinal: " + ordinal);
        }
    }

    public class PointCloudShapeFactory
    implements ShapeFactory {
        @Override
        public S2ShapeIndex getShape(S2Cap shapeCap, int numPoints) {
            ArrayList<S2Point> points = new ArrayList<S2Point>();
            for (int i = 0; i < numPoints; ++i) {
                points.add(TestDataGenerator.this.samplePoint(shapeCap));
            }
            return S2ShapeIndex.fromShapes(S2Point.Shape.fromList(points));
        }
    }

    public class FractalLoopShapeFactory
    implements ShapeFactory {
        private final S2FractalBuilder fractalBuilder;

        public FractalLoopShapeFactory() {
            this.fractalBuilder = new S2FractalBuilder(TestDataGenerator.this.rand);
        }

        @Override
        public S2ShapeIndex getShape(S2Cap shapeCap, int numEdges) {
            this.fractalBuilder.setLevelForApproxMaxEdges(numEdges);
            return S2ShapeIndex.fromShapes(S2LaxPolygonShape.fromLoop(this.fractalBuilder.makeLoop(TestDataGenerator.this.getRandomFrameAt(shapeCap.axis()), shapeCap.angle()).vertices()));
        }
    }

    public class RegularLoopShapeFactory
    implements ShapeFactory {
        @Override
        public S2ShapeIndex getShape(S2Cap shapeCap, int numEdges) {
            return S2ShapeIndex.fromShapes(S2LaxPolygonShape.fromLoop(S2Loop.makeRegularLoop(shapeCap.axis(), shapeCap.angle(), numEdges).vertices()));
        }
    }

    public class PointShapeFactory
    implements ShapeFactory {
        @Override
        public S2ShapeIndex getShape(S2Cap shapeCap, int numEdges) {
            return S2ShapeIndex.fromShapes(S2Point.Shape.singleton(shapeCap.axis()));
        }
    }

    public static interface ShapeFactory {
        public S2ShapeIndex getShape(S2Cap var1, int var2);
    }

    public static enum PolygonFactory {
        CONCENTRIC_LOOPS{

            @Override
            public S2Polygon newPolygon(TestDataGenerator data, int numLoops, int totalNumVertices) {
                int numVerticesPerLoop = Math.max(3, totalNumVertices / numLoops);
                return TestDataGenerator.concentricLoopsPolygon(data.getRandomPoint(), numLoops, numVerticesPerLoop);
            }
        }
        ,
        NESTED_LOOPS{

            @Override
            public S2Polygon newPolygon(TestDataGenerator data, int numLoops, int totalNumVertices) {
                int numVerticesPerLoop = Math.max(3, totalNumVertices / numLoops);
                ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
                double scale = Math.cos(Math.PI / (double)numVerticesPerLoop) / 1.1;
                S2Point center = data.getRandomPoint();
                S1Angle radius = DEFAULT_LOOP_RADIUS;
                for (int i = 0; i < numLoops; ++i) {
                    S2Loop loop = S2Loop.makeRegularLoop(center, radius, numVerticesPerLoop);
                    TestDataGenerator.checkEdgeLength(loop);
                    loops.add(loop);
                    radius = S1Angle.radians(radius.radians() * scale);
                }
                return new S2Polygon(loops);
            }
        }
        ,
        NESTED_FRACTALS{

            @Override
            public S2Polygon newPolygon(TestDataGenerator data, int numLoops, int totalNumVertices) {
                int numVerticesPerLoop = Math.max(3, totalNumVertices / numLoops);
                ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
                S2FractalBuilder fractal = new S2FractalBuilder(data.rand);
                fractal.setFractalDimension(1.2);
                fractal.setLevelForApproxMaxEdges(numVerticesPerLoop);
                double scale = fractal.minRadiusFactor() / fractal.maxRadiusFactor() / 1.1;
                S2Point center = data.getRandomPoint();
                S1Angle radius = DEFAULT_LOOP_RADIUS;
                for (int i = 0; i < numLoops; ++i) {
                    S2Loop loop = fractal.makeLoop(S2.getFrame(center), radius);
                    TestDataGenerator.checkEdgeLength(loop);
                    loops.add(loop);
                    radius = S1Angle.radians(radius.radians() * scale);
                }
                return new S2Polygon(loops);
            }
        }
        ,
        LOOP_GRID{

            @Override
            public S2Polygon newPolygon(TestDataGenerator data, int numLoops, int totalNumVertices) {
                int numVerticesPerLoop = Math.max(3, totalNumVertices / numLoops);
                int sqrtNumLoops = (int)Math.ceil(Math.sqrt(numLoops));
                double spacingMultiplier = 1.1;
                double maxAngle = Math.min(0.7853981633974483, (double)sqrtNumLoops * spacingMultiplier * DEFAULT_LOOP_RADIUS.radians());
                double spacing = 2.0 * maxAngle / (double)sqrtNumLoops;
                double radius = 0.5 * spacing * Math.cos(maxAngle) / spacingMultiplier;
                int left = numLoops;
                ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
                for (int i = 0; i < sqrtNumLoops && left > 0; ++i) {
                    for (int j = 0; j < sqrtNumLoops && left > 0; ++j, --left) {
                        S2Point center = new S2Point(Math.tan(((double)i + 0.5) * spacing - maxAngle), Math.tan(((double)j + 0.5) * spacing - maxAngle), 1.0);
                        S2Loop loop = S2Loop.makeRegularLoop(center, S1Angle.radians(radius), numVerticesPerLoop);
                        TestDataGenerator.checkEdgeLength(loop);
                        loops.add(loop);
                    }
                }
                return new S2Polygon(loops);
            }
        };

        static final double LOOP_SEPARATION_FRACTION = 0.1;
        static final double LOOP_FRACTAL_DIMENSION = 1.2;

        public abstract S2Polygon newPolygon(TestDataGenerator var1, int var2, int var3);
    }

    public static enum PointFactory {
        CIRCLE{

            @Override
            public List<S2Point> createPoints(TestDataGenerator data, S2Cap queryCap, int numPoints) {
                return S2Loop.makeRegularVertices(queryCap.axis(), S1Angle.radians(0.5 * queryCap.angle().radians()), numPoints);
            }
        }
        ,
        FRACTAL{

            @Override
            public List<S2Point> createPoints(TestDataGenerator data, S2Cap queryCap, int numPoints) {
                S2FractalBuilder builder = new S2FractalBuilder(data.rand);
                builder.setLevelForApproxMaxEdges(numPoints);
                builder.setFractalDimension(1.5);
                return builder.makeVertices(data.getRandomFrameAt(queryCap.axis()), queryCap.angle());
            }
        }
        ,
        GRID{

            @Override
            public List<S2Point> createPoints(TestDataGenerator data, S2Cap queryCap, int numPoints) {
                int sqrtNumPoints = (int)Math.ceil(Math.sqrt(numPoints));
                Matrix frame = data.getRandomFrameAt(queryCap.axis());
                double radius = queryCap.angle().radians();
                double spacing = 2.0 * radius / (double)sqrtNumPoints;
                ArrayList<S2Point> points = Lists.newArrayList();
                for (int i = 0; i < sqrtNumPoints; ++i) {
                    for (int j = 0; j < sqrtNumPoints; ++j) {
                        S2Point q = new S2Point(Math.tan(((double)i + 0.5) * spacing - radius), Math.tan(((double)j + 0.5) * spacing - radius), 1.0).normalize();
                        points.add(S2.fromFrame(frame, q));
                    }
                }
                return points;
            }
        };


        public abstract List<S2Point> createPoints(TestDataGenerator var1, S2Cap var2, int var3);
    }
}

