/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2.primitives;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class DisjointSet<T> {
    private final Map<T, Integer> elementIndices;
    private final ArrayList<T> elements;
    private final IntVector parents;
    private final IntVector sizes;

    public DisjointSet() {
        this.elementIndices = new HashMap<T, Integer>();
        this.elements = new ArrayList();
        this.parents = new IntVector();
        this.sizes = new IntVector();
    }

    public DisjointSet(int capacity) {
        this.elementIndices = new HashMap<T, Integer>((int)Math.ceil((double)capacity / 0.75));
        this.elements = new ArrayList(capacity);
        this.parents = IntVector.ofCapacity(capacity);
        this.sizes = IntVector.ofCapacity(capacity);
    }

    public void reserve(int capacity) {
        this.elements.ensureCapacity(capacity);
        this.parents.ensureCapacity(capacity);
        this.sizes.ensureCapacity(capacity);
    }

    @CanIgnoreReturnValue
    public boolean add(T val) {
        if (this.elementIndices.containsKey(val)) {
            return false;
        }
        int elementIndex = this.elements.size();
        this.elements.add(val);
        this.elementIndices.put(val, elementIndex);
        this.parents.add(elementIndex);
        this.sizes.add(1);
        Preconditions.checkState(this.parents.get(elementIndex) == elementIndex);
        return true;
    }

    public T findRoot(T val) {
        if (!this.elementIndices.containsKey(val)) {
            return null;
        }
        return this.elements.get(this.findRootIndex(this.elementIndices.get(val)));
    }

    private int findRootIndex(int elementIndex) {
        int parentIndex = this.parents.get(elementIndex);
        if (parentIndex == elementIndex) {
            return parentIndex;
        }
        int rootIndex = this.findRootIndex(parentIndex);
        this.parents.set(elementIndex, rootIndex);
        return rootIndex;
    }

    @CanIgnoreReturnValue
    public boolean union(T a, T b) {
        int bRootIndex;
        if (!this.elementIndices.containsKey(a) || !this.elementIndices.containsKey(b)) {
            return false;
        }
        int aRootIndex = this.findRootIndex(this.elementIndices.get(a));
        if (aRootIndex == (bRootIndex = this.findRootIndex(this.elementIndices.get(b)))) {
            return true;
        }
        if (this.sizes.get(aRootIndex) < this.sizes.get(bRootIndex)) {
            this.parents.set(aRootIndex, bRootIndex);
            this.sizes.incrementAt(bRootIndex, this.sizes.get(aRootIndex));
        } else {
            this.parents.set(bRootIndex, aRootIndex);
            this.sizes.incrementAt(aRootIndex, this.sizes.get(bRootIndex));
        }
        return true;
    }

    public int size() {
        return this.elements.size();
    }

    public void clear() {
        this.elementIndices.clear();
        this.elements.clear();
        this.parents.clear();
        this.sizes.clear();
    }
}

