/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.twak.utils.Mathz;
import org.twak.utils.Pair;
import org.twak.utils.geom.DRectangle;

public class DicerMk2 {
    List<DRectangle> rects = new ArrayList<DRectangle>();
    Map<Double, RC> horiz = new LinkedHashMap<Double, RC>();
    Map<Double, RC> vert = new LinkedHashMap<Double, RC>();

    public DicerMk2(List<DRectangle> uiInput_) {
        Pt pt;
        int h2;
        Object vals;
        if (uiInput_.size() == 0) {
            return;
        }
        double TOL = 5.0;
        ArrayList xes = new ArrayList();
        ArrayList yes = new ArrayList();
        ArrayList<DRectangle> rectangles = new ArrayList<DRectangle>();
        for (DRectangle dr : uiInput_) {
            rectangles.add(new DRectangle(dr).toPositive());
        }
        for (DRectangle dr : rectangles) {
            for (Object[] oa : new Object[][]{{DRectangle.XMIN, xes}, {DRectangle.XMAX, xes}, {DRectangle.YMIN, yes}, {DRectangle.YMAX, yes}}) {
                vals = (List)oa[1];
                double val = dr.get((DRectangle.Bounds)((Object)oa[0]));
                int res = Collections.binarySearch(vals, val);
                if (res < 0 && vals.size() > 0) {
                    int index = -(res + 1);
                    double max = (Double)vals.get(Mathz.clamp(index, 0, vals.size() - 1));
                    double min2 = (Double)vals.get(Mathz.clamp(index - 1, 0, vals.size() - 1));
                    if (Math.abs(max - val) < 5.0) {
                        val = max;
                    } else if (Math.abs(val - min2) < 5.0) {
                        val = min2;
                    }
                }
                dr.set((DRectangle.Bounds)((Object)oa[0]), val, true);
                if (vals.contains(val)) continue;
                vals.add(val);
                Collections.sort(vals);
            }
        }
        for (DRectangle dr : rectangles) {
            if (dr.area() < 15.0) continue;
            this.addTo(this.horiz, dr.y, dr.x, dr.x + dr.width);
            this.addTo(this.horiz, dr.y + dr.height, dr.x, dr.x + dr.width);
            this.addTo(this.vert, dr.x, dr.y, dr.y + dr.height);
            this.addTo(this.vert, dr.x + dr.width, dr.y, dr.y + dr.height);
        }
        ArrayList<Double> hKeys = new ArrayList<Double>(this.horiz.keySet());
        ArrayList<Double> vKeys = new ArrayList<Double>(this.vert.keySet());
        Collections.sort(hKeys);
        Collections.sort(vKeys);
        Pt[][] pts = new Pt[this.horiz.keySet().size()][this.vert.keySet().size()];
        int h_ = 0;
        Iterator iterator = hKeys.iterator();
        while (iterator.hasNext()) {
            double h3 = (Double)iterator.next();
            int v_ = 0;
            vals = vKeys.iterator();
            while (vals.hasNext()) {
                double v = (Double)vals.next();
                RC rcH = this.horiz.get(h3);
                RC rcV = this.vert.get(v);
                Pair<FType, FType> hTypes = rcH.getPairsAt(v);
                Pair<FType, FType> vTypes = rcV.getPairsAt(h3);
                pts[h_][v_] = new Pt(v, h3, hTypes.first(), hTypes.second(), vTypes.first(), vTypes.second());
                ++v_;
            }
            ++h_;
        }
        for (h2 = 0; h2 < pts.length; ++h2) {
            int start = -1;
            boolean startWall = false;
            for (int v = 0; v < pts[0].length; ++v) {
                boolean isWall;
                pt = pts[h2][v];
                if (!pt.hasHard()) continue;
                boolean bl = isWall = pt.t == FType.HARD && pt.b == FType.HARD && pt.l != FType.HARD && pt.r != FType.HARD;
                if ((isWall || pt.l != FType.HARD && pt.r == FType.HARD) && isWall && startWall && start >= 0) {
                    pts[h2][start].r = FType.NONE;
                    pts[h2][v].l = FType.NONE;
                    for (int v2 = start + 1; v2 < v; ++v2) {
                        pts[h2][v2].r = FType.NONE;
                        pts[h2][v2].l = FType.NONE;
                    }
                }
                if (!isWall && (pt.l != FType.HARD || pt.r == FType.HARD)) continue;
                start = v;
                startWall = isWall;
            }
        }
        for (int v = 0; v < pts[0].length; ++v) {
            int start = -1;
            boolean startWall = false;
            for (int h4 = 0; h4 < pts.length; ++h4) {
                boolean isWall;
                pt = pts[h4][v];
                if (!pt.hasHard()) continue;
                boolean bl = isWall = pt.l == FType.HARD && pt.r == FType.HARD && pt.t != FType.HARD && pt.b != FType.HARD;
                if ((isWall || pt.t != FType.HARD && pt.b == FType.HARD) && isWall && startWall && start >= 0) {
                    pts[start][v].b = FType.NONE;
                    pts[h4][v].t = FType.NONE;
                    for (int h22 = start + 1; h22 < h4; ++h22) {
                        pts[h22][v].b = FType.NONE;
                        pts[h22][v].t = FType.NONE;
                    }
                }
                if (!isWall && (pt.t != FType.HARD || pt.b == FType.HARD)) continue;
                start = h4;
                startWall = isWall;
            }
        }
        for (h2 = 0; h2 < this.horiz.size(); ++h2) {
            block13: for (int v = 0; v < this.vert.size(); ++v) {
                if (!pts[h2][v].isTL()) continue;
                for (int v2 = v + 1; v2 < this.vert.size(); ++v2) {
                    if (!pts[h2][v2].isTR()) continue;
                    for (int h23 = h2 + 1; h23 < this.horiz.size(); ++h23) {
                        if (!pts[h23][v2].isBR()) continue;
                        Pt pt2 = pts[h23][v2];
                        Pt pt1 = pts[h2][v];
                        this.rects.add(new DRectangle(pt1.x, pt1.y, pt2.x - pt1.x, pt2.y - pt1.y));
                        continue block13;
                    }
                    continue block13;
                }
            }
        }
        Iterator<DRectangle> dit = this.rects.iterator();
        while (dit.hasNext()) {
            if (dit.next().area() != 0.0) continue;
            dit.remove();
        }
    }

    public List<DRectangle> getCopyOResults() {
        ArrayList<DRectangle> out = new ArrayList<DRectangle>();
        for (DRectangle dr : this.rects) {
            out.add(new DRectangle(dr));
        }
        return out;
    }

    private void addTo(Map<Double, RC> horiz, double index, double start, double end) {
        RC rc = horiz.get(index);
        if (rc == null) {
            rc = new RC(index);
            horiz.put(index, rc);
        }
        rc.add(start, end);
    }

    public static class RC {
        double val;
        List<Following> boundaries = new ArrayList<Following>();

        RC(double val) {
            this.val = val;
            this.boundaries.add(new Following(-1.7976931348623157E308, FType.SOFT));
        }

        public void add(double startIn, double endIn) {
            assert (startIn < endIn);
            Iterator<Following> fit = this.boundaries.iterator();
            while (fit.hasNext()) {
                Following next = fit.next();
                if (!(next.value >= startIn) || !(next.value <= endIn)) continue;
                fit.remove();
            }
            this.boundaries.add(new Following(startIn, FType.HARD));
            this.boundaries.add(new Following(endIn, FType.SOFT));
            Collections.sort(this.boundaries);
            fit = this.boundaries.iterator();
            Following last = this.boundaries.get(0);
            fit.next();
            while (fit.hasNext()) {
                Following current = fit.next();
                if (current.type == last.type) {
                    fit.remove();
                    if (current.type != FType.SOFT) continue;
                    last.value = current.value;
                    continue;
                }
                last = current;
            }
        }

        private Pair<FType, FType> getPairsAt(double v) {
            int res = Collections.binarySearch(this.boundaries, new Following(v, FType.NONE));
            if (res < 0) {
                FType out = -(res + 1) >= this.boundaries.size() ? this.boundaries.get((int)(this.boundaries.size() - 1)).type : this.boundaries.get((int)(-(res + 1) - 1)).type;
                return new Pair<FType, FType>(out, out);
            }
            assert (res != 0);
            return new Pair<FType, FType>(this.boundaries.get((int)(res - 1)).type, this.boundaries.get((int)res).type);
        }

        private void merge(RC other) {
            Following last = null;
            for (Following fw : other.boundaries) {
                if (last != null && last.type == FType.HARD && fw.type == FType.SOFT) {
                    this.add(last.value, fw.value);
                }
                last = fw;
            }
        }
    }

    public static class Following
    implements Comparable<Following> {
        double value;
        FType type = FType.NONE;

        Following(Double value, FType type) {
            this.type = type;
            this.value = value;
        }

        @Override
        public int compareTo(Following o) {
            return Double.compare(this.value, o.value);
        }
    }

    static enum FType {
        NONE,
        HARD,
        SOFT;


        FType union(FType two) {
            for (FType f : Arrays.asList(HARD, SOFT, NONE)) {
                if (this != f && two != f) continue;
                return f;
            }
            return null;
        }
    }

    static class Pt {
        List<DRectangle> out = new ArrayList<DRectangle>();
        FType l;
        FType r;
        FType b;
        FType t;
        double x;
        double y;

        Pt(double x, double y, FType l, FType r, FType t, FType b) {
            this.l = l;
            this.r = r;
            this.t = t;
            this.b = b;
            this.x = x;
            this.y = y;
        }

        public boolean isTL() {
            return this.r != FType.NONE && this.b != FType.NONE;
        }

        public boolean isTR() {
            return this.l != FType.NONE && this.b != FType.NONE;
        }

        public boolean isBR() {
            return this.t != FType.NONE && this.l != FType.NONE;
        }

        private boolean isCorner() {
            return this.t == FType.HARD && this.r == FType.HARD || this.r == FType.HARD && this.b == FType.HARD || this.b == FType.HARD && this.l == FType.HARD || this.l == FType.HARD && this.t == FType.HARD;
        }

        private boolean hasHard() {
            return this.t == FType.HARD || this.b == FType.HARD || this.l == FType.HARD || this.r == FType.HARD;
        }
    }
}

