/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.twak.utils.ui.ListDownLayout;
import org.twak.utils.ui.ListRightLayout;

public class ComponentList
extends JPanel {
    ListComponent selected;

    public ComponentList() {
        this(false);
    }

    public ComponentList(boolean right) {
        this.setLayout(right ? new ListRightLayout() : new ListDownLayout());
    }

    @Override
    public Component add(Component comp) {
        this.addListeners((JComponent)comp);
        return super.add(comp);
    }

    @Override
    public void remove(Component comp) {
        this.removeListeners((JComponent)comp);
        super.remove(comp);
    }

    void addListeners(JComponent c) {
        this.addListeners(c, c);
    }

    void addListeners(JComponent root, JComponent c) {
        c.addMouseListener(new ComponentMouseListener(root));
        for (Component j : c.getComponents()) {
            if (!(j instanceof JComponent)) continue;
            this.addListeners(root, (JComponent)j);
        }
    }

    void removeListeners(JComponent c) {
        for (MouseListener ml : c.getMouseListeners()) {
            if (!(ml instanceof ComponentMouseListener)) continue;
            c.removeMouseListener(ml);
        }
        for (Component j : c.getComponents()) {
            if (!(j instanceof JComponent)) continue;
            this.removeListeners((JComponent)j);
        }
    }

    public void select(Component c) {
        for (MouseListener ml : c.getMouseListeners()) {
            if (!(ml instanceof ComponentMouseListener)) continue;
            ((ComponentMouseListener)ml).doSelect();
        }
    }

    public class ComponentMouseListener
    extends MouseAdapter {
        JComponent src;

        public ComponentMouseListener(JComponent src) {
            this.src = src;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.doSelect();
        }

        public void doSelect() {
            if (!(this.src instanceof ListComponent)) {
                return;
            }
            ListComponent cl = (ListComponent)((Object)this.src);
            if (ComponentList.this.selected != null) {
                ComponentList.this.selected.deselected();
            }
            ComponentList.this.selected = cl;
            ComponentList.this.selected.selected();
        }
    }

    public static interface ListComponent {
        public void selected();

        public void deselected();

        public Object getObject();
    }
}

