/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.nv;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.nv.PhTreeVProxy;
import ch.ethz.globis.phtree.util.Bits;
import ch.ethz.globis.phtree.util.PhMapperKey;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import java.util.Iterator;
import java.util.List;

public abstract class PhTreeNV {
    public static PhTreeNV create(int dim) {
        return new PhTreeVProxy(dim);
    }

    public PhTreeNV() {
        this.debugCheck();
    }

    protected final void debugCheck() {
    }

    public abstract int size();

    public final void printQuality() {
        System.out.println("Tree quality");
        System.out.println("============");
        System.out.println(this.getQuality());
    }

    public abstract PhTreeStats getQuality();

    public void accept(PhTreeVisitor v) {
        v.visit(this);
    }

    protected final int align8(int n) {
        return (int)(8.0 * Math.ceil((double)n / 8.0));
    }

    public abstract boolean insert(long ... var1);

    public abstract boolean contains(long ... var1);

    protected final void printEntry(StringBuilderLn sb, long[] entry) {
        sb.appendLn(Bits.toBinary(entry, this.getDEPTH()));
    }

    public abstract boolean delete(long ... var1);

    public abstract String toStringPlain();

    public abstract String toStringTree();

    public abstract Iterator<long[]> queryExtent();

    public abstract PhIteratorNV query(long[] var1, long[] var2);

    public abstract int getDIM();

    public abstract int getDEPTH();

    public abstract PhTree.PhKnnQuery<long[]> nearestNeighbour(int var1, long ... var2);

    public abstract boolean update(long[] var1, long[] var2);

    public abstract List<PhEntry<Object>> queryAll(long[] var1, long[] var2);

    public abstract <R> List<R> queryAll(long[] var1, long[] var2, int var3, PhFilter var4, PhMapperKey<R> var5);

    public static interface PhIteratorNV
    extends Iterator<long[]> {
        public boolean hasNextKey();

        public long[] nextKey();
    }

    public static abstract class PhTreeVisitor {
        public abstract void visit(PhTreeNV var1);
    }
}

