/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.CombineShapeReader;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.sedona.shaded.guava.primitives.Longs;

public class ShapeInputFormat
extends CombineFileInputFormat<ShapeKey, PrimitiveShape> {
    private static final String DBF_SUFFIX = "dbf";
    private static final String SHP_SUFFIX = "shp";
    private static final String SHX_SUFFIX = "shx";

    public RecordReader<ShapeKey, PrimitiveShape> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new CombineShapeReader();
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return false;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        String parentpath = job.getConfiguration().get("mapred.input.dir");
        String[] childpaths = parentpath.split(",");
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (String childPath : childpaths) {
            job.getConfiguration().set("mapred.input.dir", childPath);
            CombineFileSplit combineChildPathFileSplit = (CombineFileSplit)super.getSplits(job).get(0);
            Path[] filePaths = combineChildPathFileSplit.getPaths();
            long[] fileSizes = combineChildPathFileSplit.getLengths();
            TreeMap<Path, Long> filePathSizePair = new TreeMap<Path, Long>();
            for (int i = 0; i < filePaths.length; ++i) {
                filePathSizePair.put(filePaths[i], fileSizes[i]);
            }
            ArrayList<Path> fileSplitPathParts = new ArrayList<Path>();
            ArrayList<Long> fileSplitSizeParts = new ArrayList<Long>();
            String prevfilename = "";
            for (Path filePath : filePathSizePair.keySet()) {
                String filename = FilenameUtils.removeExtension((String)filePath.getName()).toLowerCase();
                String suffix = FilenameUtils.getExtension((String)filePath.getName()).toLowerCase();
                if (!suffix.equals(SHX_SUFFIX) && !suffix.equals(DBF_SUFFIX) && !suffix.equals(SHP_SUFFIX)) continue;
                if (!prevfilename.isEmpty() && !prevfilename.equals(filename)) {
                    splits.add((InputSplit)new CombineFileSplit(fileSplitPathParts.toArray(new Path[0]), Longs.toArray(fileSplitSizeParts)));
                    fileSplitPathParts.clear();
                    fileSplitSizeParts.clear();
                }
                fileSplitPathParts.add(filePath);
                fileSplitSizeParts.add((Long)filePathSizePair.get(filePath));
                prevfilename = filename;
            }
            if (fileSplitPathParts.size() == 0) continue;
            splits.add((InputSplit)new CombineFileSplit(fileSplitPathParts.toArray(new Path[0]), Longs.toArray(fileSplitSizeParts)));
        }
        return splits;
    }
}

