/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.features.TagsResolver;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;
import org.apache.sedona.sql.datasources.osmpbf.model.Relation;
import org.apache.sedona.sql.datasources.osmpbf.model.RelationType;

public class RelationIterator
implements Iterator<OSMEntity> {
    int idx = 0;
    long relationCount = 0L;
    List<Osmformat.Relation> relations;
    Osmformat.StringTable stringTable;

    public RelationIterator(List<Osmformat.Relation> relations, Osmformat.StringTable stringTable) {
        this.relations = relations;
        this.stringTable = stringTable;
        if (relations != null) {
            this.relationCount = relations.size();
        }
    }

    @Override
    public boolean hasNext() {
        return (long)this.idx < this.relationCount;
    }

    @Override
    public OSMEntity next() {
        if ((long)this.idx < this.relationCount) {
            Relation relation = this.extract(this.idx);
            ++this.idx;
            return relation;
        }
        return null;
    }

    public Relation extract(int idx) {
        Osmformat.Relation relation = this.relations.get(idx);
        return this.parse(relation);
    }

    private Relation parse(Osmformat.Relation relation) {
        if (relation == null) {
            return null;
        }
        long[] refs = this.resolveMemberIds(relation);
        String[] refTypes = this.resolveTypes(relation);
        String[] roles = this.resolveRefRoles(relation);
        HashMap<String, String> tags = TagsResolver.resolveTags(relation.getKeysCount(), relation::getKeys, relation::getVals, this.stringTable);
        return new Relation((Long)relation.getId(), tags, refs, refTypes, roles);
    }

    private String[] resolveRefRoles(Osmformat.Relation relation) {
        String[] roles = new String[relation.getRolesSidCount()];
        for (int i = 0; i < relation.getRolesSidCount(); ++i) {
            int role = relation.getRolesSid(i);
            roles[i] = this.stringTable.getS(role).toStringUtf8();
        }
        return roles;
    }

    private long[] resolveMemberIds(Osmformat.Relation relation) {
        long[] memberIds = new long[relation.getMemidsCount()];
        if (relation.getMemidsCount() != 0) {
            long idValue;
            memberIds[0] = idValue = relation.getMemids(0);
            for (int i = 1; i < relation.getMemidsCount(); ++i) {
                memberIds[i] = idValue += relation.getMemids(i);
            }
        }
        return memberIds;
    }

    private String[] resolveTypes(Osmformat.Relation relation) {
        String[] types = new String[relation.getTypesCount()];
        for (int i = 0; i < relation.getTypesCount(); ++i) {
            Osmformat.Relation.MemberType memberType = relation.getTypes(i);
            types[i] = RelationType.fromValue(memberType.getNumber());
        }
        return types;
    }
}

