/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.sedona_sql.io.stac.StacExtension;
import org.apache.spark.sql.sedona_sql.io.stac.StacExtension$;
import org.apache.spark.sql.sedona_sql.io.stac.StacTable$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.locationtech.jts.geom.Envelope;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class StacUtils$ {
    public static final StacUtils$ MODULE$;
    private static final ObjectMapper objectMapper;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new StacUtils$();
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        objectMapper = var0;
    }

    private ObjectMapper objectMapper() {
        return objectMapper;
    }

    public String loadStacCollectionToJson(Map<String, String> opts) {
        String urlFull = this.getFullCollectionUrl(opts);
        Map<String, String> headers = this.parseHeaders(opts);
        return this.loadStacCollectionToJson(urlFull, headers, this.loadStacCollectionToJson$default$3());
    }

    public Map<String, String> parseHeaders(Map<String, String> opts) {
        Option option = opts.get((Object)"headers");
        if (option instanceof Some) {
            Map map;
            Some some = (Some)option;
            String headersJson = (String)some.value();
            try {
                map = (Map)this.objectMapper().readValue(headersJson, Map.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Failed to parse headers JSON: ").append(e.getMessage()).toString(), e);
            }
            return map;
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Map().empty();
        }
        throw new MatchError((Object)option);
    }

    public String getFullCollectionUrl(Map<String, String> opts) {
        String url = (String)opts.getOrElse((Object)"path", (Function0 & Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        String urlFinal = url.matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*") ? url : new StringBuilder(7).append("file://").append(url).toString();
        return urlFinal;
    }

    public String loadStacCollectionToJson(String url, Map<String, String> headers, int maxRetries) {
        int retries = 0;
        boolean success = false;
        String result = "";
        while (retries < maxRetries && !success) {
            try {
                String string;
                if (url.startsWith("s3://") || url.startsWith("s3a://")) {
                    string = Predef$.MODULE$.wrapRefArray((Object[])SparkSession$.MODULE$.active().read().textFile(url).collect()).mkString("\n");
                } else if (headers.isEmpty()) {
                    string = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                } else {
                    URLConnection connection = new URL(url).openConnection();
                    ObjectRef inputStream = ObjectRef.create(null);
                    ObjectRef source = ObjectRef.create(null);
                    try {
                        headers.foreach((Function1 & Serializable)x0$1 -> {
                            StacUtils$.$anonfun$loadStacCollectionToJson$1(connection, x0$1);
                            return BoxedUnit.UNIT;
                        });
                        inputStream.elem = connection.getInputStream();
                        source.elem = Source$.MODULE$.fromInputStream((InputStream)inputStream.elem, Codec$.MODULE$.fallbackSystemCodec());
                        string = ((Source)source.elem).mkString();
                    }
                    finally {
                        URLConnection uRLConnection;
                        if ((Source)source.elem != null) {
                            StacUtils$.liftedTree1$1(source);
                        }
                        if ((InputStream)inputStream.elem != null) {
                            StacUtils$.liftedTree2$1(inputStream);
                        }
                        if ((uRLConnection = connection) instanceof HttpURLConnection) {
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            StacUtils$.liftedTree3$1(httpURLConnection);
                        }
                    }
                }
                result = string;
                success = true;
            }
            catch (Exception e) {
                if (++retries < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(52).append("Failed to load STAC collection from ").append(url).append(" after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return result;
    }

    public String loadStacCollectionToJson(String url, int maxRetries) {
        return this.loadStacCollectionToJson(url, (Map<String, String>)Predef$.MODULE$.Map().empty(), maxRetries);
    }

    public Map<String, String> loadStacCollectionToJson$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public int loadStacCollectionToJson$default$3() {
        return 3;
    }

    public String getStacCollectionBasePath(Map<String, String> opts) {
        String ref = (String)opts.getOrElse((Object)"path", (Function0 & Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        return this.getStacCollectionBasePath(ref);
    }

    public String getStacCollectionBasePath(String collectionUrl) {
        Option option;
        Option option2;
        Regex urlPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(https?://[^/]+/|http://[^/]+/).*"));
        Regex filePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(file:///.*/|/.*/).*"));
        String string = collectionUrl;
        if (string != null && !(option2 = urlPattern.unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String baseUrl = (String)((LinearSeqOps)option2.get()).apply(0);
            return baseUrl;
        }
        if (string != null && !(option = filePattern.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String basePath = (String)((LinearSeqOps)option.get()).apply(0);
            if (basePath.startsWith("file://")) {
                return basePath;
            }
            return new StringBuilder(7).append("file://").append(basePath).toString();
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Invalid URL or file path: ").append(collectionUrl).toString());
    }

    public StructType inferStacSchema(Map<String, String> opts) {
        StructType structType;
        block5: {
            String stacVersion;
            String stacCollectionJsonString = this.loadStacCollectionToJson(opts);
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
            JsonNode collection = mapper.readTree(stacCollectionJsonString);
            String string = stacVersion = collection.get("stac_version").asText();
            switch (string == null ? 0 : string.hashCode()) {
                case 46670517: {
                    if (!"1.0.0".equals(string)) break;
                    structType = StacTable$.MODULE$.SCHEMA_V1_0_0();
                    break block5;
                }
            }
            if (string.matches("1\\.[1-9]\\d*\\.\\d*")) {
                structType = StacTable$.MODULE$.SCHEMA_V1_1_0();
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported STAC version: ").append(stacVersion).toString());
            }
        }
        StructType coreSchema = structType;
        StacExtension[] extensions = StacExtension$.MODULE$.getStacExtensionDefinitions();
        StructType schemaWithExtensions = this.addExtensionFieldsToSchema(coreSchema, extensions);
        return schemaWithExtensions;
    }

    public StructType addExtensionFieldsToSchema(StructType schema, StacExtension[] extensions) {
        Option propertiesFieldOpt = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StacUtils$.$anonfun$addExtensionFieldsToSchema$1(x$1)));
        if (propertiesFieldOpt.isEmpty()) {
            return schema;
        }
        StructField propertiesField = (StructField)propertiesFieldOpt.get();
        StructType propertiesStruct = (StructType)propertiesField.dataType();
        StructField[] extensionFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])extensions), (Function1 & Serializable)extension -> (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])extension.schema().fields()), (Function1 & Serializable)field -> new StructField(field.name(), field.dataType(), field.nullable(), new MetadataBuilder().withMetadata(field.metadata()).putString("stac_extension", extension.name()).build()), ClassTag$.MODULE$.apply(StructField.class)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(StructField.class));
        StructType updatedPropertiesStruct = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields()), (Object)extensionFields, ClassTag$.MODULE$.apply(StructField.class)));
        StructField updatedPropertiesField = new StructField(propertiesField.name(), (DataType)updatedPropertiesStruct, propertiesField.nullable(), propertiesField.metadata());
        StructField[] updatedFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            String string = structField.name();
            String string2 = "properties";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return updatedPropertiesField;
            }
            return structField;
        }, ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(updatedFields);
    }

    public InternalRow promotePropertiesToTop(InternalRow row, StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        InternalRow propertiesRow = row.getStruct(propertiesIndex, propertiesStruct.fields().length);
        Seq newValues = (Seq)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    StructField field = (StructField)tuple22._1();
                    String string = field.name();
                    String string2 = "properties";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (Seq)acc.$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields()))), (Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                StructField propField = (StructField)tuple2._1();
                                int propIndex = tuple2._2$mcI$sp();
                                return propertiesRow.get(propIndex, propField.dataType());
                            }
                            throw new MatchError((Object)tuple2);
                        }, ClassTag$.MODULE$.apply(Object.class))));
                    }
                }
            }
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple23 != null) {
                    int index = tuple23._2$mcI$sp();
                    return (Seq)acc.$colon$plus(row.get(index, schema.apply(index).dataType()));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return InternalRow$.MODULE$.fromSeq(newValues);
    }

    public StructType updatePropertiesPromotedSchema(StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        Seq newFields = (Seq)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String string;
                Seq acc = (Seq)tuple2._1();
                StructField structField = (StructField)tuple2._2();
                if (structField != null && "properties".equals(string = structField.name())) {
                    return (Seq)acc.$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])propertiesStruct.fields()));
                }
            }
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                StructField other = (StructField)tuple2._2();
                return (Seq)acc.$colon$plus((Object)other);
            }
            throw new MatchError((Object)tuple2);
        });
        return StructType$.MODULE$.apply(newFields);
    }

    public int getNumPartitions(int itemCount, int numPartitions, int maxPartitionItemFiles, int defaultParallelism) {
        if (numPartitions > 0) {
            return numPartitions;
        }
        int maxSplitFiles = maxPartitionItemFiles > 0 ? Math.min(maxPartitionItemFiles, (int)Math.ceil((double)itemCount / (double)defaultParallelism)) : (int)Math.ceil((double)itemCount / (double)defaultParallelism);
        return Math.max(1, (int)Math.ceil((double)itemCount / (double)maxSplitFiles));
    }

    public String getFilterBBox(GeoParquetSpatialFilter filter) {
        Envelope unionEnvelope = StacUtils$.calculateUnionBBox$1(filter);
        return new StringBuilder(14).append("bbox=").append(unionEnvelope.getMinX()).append("%2C").append(unionEnvelope.getMinY()).append("%2C").append(unionEnvelope.getMaxX()).append("%2C").append(unionEnvelope.getMaxY()).toString();
    }

    public String getFilterTemporal(TemporalFilter filter) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Tuple2 tuple2 = StacUtils$.calculateUnionTemporal$1(filter);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LocalDateTime start = (LocalDateTime)tuple2._1();
        LocalDateTime end = (LocalDateTime)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
        LocalDateTime start2 = (LocalDateTime)tuple22._1();
        LocalDateTime end2 = (LocalDateTime)tuple22._2();
        if (end2 == null) {
            return new StringBuilder(12).append("datetime=").append(StacUtils$.formatDateTime$1(start2, formatter)).append("/..").toString();
        }
        return new StringBuilder(10).append("datetime=").append(StacUtils$.formatDateTime$1(start2, formatter)).append("/").append(StacUtils$.formatDateTime$1(end2, formatter)).toString();
    }

    public String addFiltersToUrl(String baseUrl, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String temporalFilterStr;
        String spatialFilterStr = (String)spatialFilter.map((Function1 & Serializable)filter -> MODULE$.getFilterBBox((GeoParquetSpatialFilter)filter)).getOrElse((Function0 & Serializable)() -> "");
        String filters = ((IterableOnceOps)new .colon.colon((Object)spatialFilterStr, (List)new .colon.colon((Object)(temporalFilterStr = (String)temporalFilter.map((Function1 & Serializable)filter -> MODULE$.getFilterTemporal((TemporalFilter)filter)).getOrElse((Function0 & Serializable)() -> "")), (List)Nil$.MODULE$)).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))).mkString("&");
        String urlWithFilters = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(filters)) ? new StringBuilder(1).append("&").append(filters).toString() : "";
        return new StringBuilder(0).append(baseUrl).append(urlWithFilters).toString();
    }

    public static final /* synthetic */ void $anonfun$loadStacCollectionToJson$1(URLConnection connection$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            connection$1.setRequestProperty(key, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ void liftedTree1$1(ObjectRef source$1) {
        try {
            ((Source)source$1.elem).close();
        }
        catch (Throwable throwable) {}
    }

    private static final /* synthetic */ void liftedTree2$1(ObjectRef inputStream$1) {
        try {
            ((InputStream)inputStream$1.elem).close();
        }
        catch (Throwable throwable) {}
    }

    private static final /* synthetic */ void liftedTree3$1(HttpURLConnection x2$1) {
        try {
            x2$1.disconnect();
        }
        catch (Throwable throwable) {}
    }

    public static final /* synthetic */ boolean $anonfun$addExtensionFieldsToSchema$1(StructField x$1) {
        String string = x$1.name();
        String string2 = "properties";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Envelope calculateUnionBBox$1(GeoParquetSpatialFilter filter) {
        GeoParquetSpatialFilter geoParquetSpatialFilter = filter;
        if (geoParquetSpatialFilter instanceof GeoParquetSpatialFilter.AndFilter) {
            GeoParquetSpatialFilter.AndFilter andFilter = (GeoParquetSpatialFilter.AndFilter)geoParquetSpatialFilter;
            GeoParquetSpatialFilter left = andFilter.left();
            GeoParquetSpatialFilter right = andFilter.right();
            Envelope leftEnvelope = StacUtils$.calculateUnionBBox$1(left);
            Envelope rightEnvelope = StacUtils$.calculateUnionBBox$1(right);
            leftEnvelope.expandToInclude(rightEnvelope);
            return leftEnvelope;
        }
        if (geoParquetSpatialFilter instanceof GeoParquetSpatialFilter.OrFilter) {
            GeoParquetSpatialFilter.OrFilter orFilter = (GeoParquetSpatialFilter.OrFilter)geoParquetSpatialFilter;
            GeoParquetSpatialFilter left = orFilter.left();
            GeoParquetSpatialFilter right = orFilter.right();
            Envelope leftEnvelope = StacUtils$.calculateUnionBBox$1(left);
            Envelope rightEnvelope = StacUtils$.calculateUnionBBox$1(right);
            leftEnvelope.expandToInclude(rightEnvelope);
            return leftEnvelope;
        }
        if (geoParquetSpatialFilter instanceof GeoParquetSpatialFilter.LeafFilter) {
            GeoParquetSpatialFilter.LeafFilter leafFilter = (GeoParquetSpatialFilter.LeafFilter)geoParquetSpatialFilter;
            return leafFilter.queryWindow().getEnvelopeInternal();
        }
        throw new MatchError((Object)geoParquetSpatialFilter);
    }

    private static final String formatDateTime$1(LocalDateTime dateTime, DateTimeFormatter formatter$1) {
        if (dateTime == null) {
            return "..";
        }
        return dateTime.format(formatter$1);
    }

    private static final Tuple2 calculateUnionTemporal$1(TemporalFilter filter) {
        TemporalFilter temporalFilter = filter;
        if (temporalFilter instanceof TemporalFilter.AndFilter) {
            TemporalFilter.AndFilter andFilter = (TemporalFilter.AndFilter)temporalFilter;
            TemporalFilter left = andFilter.left();
            TemporalFilter right = andFilter.right();
            Tuple2 tuple2 = StacUtils$.calculateUnionTemporal$1(left);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LocalDateTime leftStart = (LocalDateTime)tuple2._1();
            LocalDateTime leftEnd = (LocalDateTime)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)leftStart, (Object)leftEnd);
            LocalDateTime leftStart2 = (LocalDateTime)tuple22._1();
            LocalDateTime leftEnd2 = (LocalDateTime)tuple22._2();
            Tuple2 tuple23 = StacUtils$.calculateUnionTemporal$1(right);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            LocalDateTime rightStart = (LocalDateTime)tuple23._1();
            LocalDateTime rightEnd = (LocalDateTime)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)rightStart, (Object)rightEnd);
            LocalDateTime rightStart2 = (LocalDateTime)tuple24._1();
            LocalDateTime rightEnd2 = (LocalDateTime)tuple24._2();
            LocalDateTime start = leftStart2 == null || rightStart2 != null && rightStart2.isBefore(leftStart2) ? rightStart2 : leftStart2;
            LocalDateTime end = leftEnd2 == null || rightEnd2 != null && rightEnd2.isAfter(leftEnd2) ? rightEnd2 : leftEnd2;
            return new Tuple2((Object)start, (Object)end);
        }
        if (temporalFilter instanceof TemporalFilter.OrFilter) {
            TemporalFilter.OrFilter orFilter = (TemporalFilter.OrFilter)temporalFilter;
            TemporalFilter left = orFilter.left();
            TemporalFilter right = orFilter.right();
            Tuple2 tuple2 = StacUtils$.calculateUnionTemporal$1(left);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LocalDateTime leftStart = (LocalDateTime)tuple2._1();
            LocalDateTime leftEnd = (LocalDateTime)tuple2._2();
            Tuple2 tuple25 = new Tuple2((Object)leftStart, (Object)leftEnd);
            LocalDateTime leftStart3 = (LocalDateTime)tuple25._1();
            LocalDateTime leftEnd3 = (LocalDateTime)tuple25._2();
            Tuple2 tuple26 = StacUtils$.calculateUnionTemporal$1(right);
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            LocalDateTime rightStart = (LocalDateTime)tuple26._1();
            LocalDateTime rightEnd = (LocalDateTime)tuple26._2();
            Tuple2 tuple27 = new Tuple2((Object)rightStart, (Object)rightEnd);
            LocalDateTime rightStart3 = (LocalDateTime)tuple27._1();
            LocalDateTime rightEnd3 = (LocalDateTime)tuple27._2();
            LocalDateTime start = leftStart3 == null || rightStart3 != null && rightStart3.isBefore(leftStart3) ? rightStart3 : leftStart3;
            LocalDateTime end = leftEnd3 == null || rightEnd3 != null && rightEnd3.isAfter(leftEnd3) ? rightEnd3 : leftEnd3;
            return new Tuple2((Object)start, (Object)end);
        }
        if (temporalFilter instanceof TemporalFilter.LessThanFilter) {
            TemporalFilter.LessThanFilter lessThanFilter = (TemporalFilter.LessThanFilter)temporalFilter;
            LocalDateTime value = lessThanFilter.value();
            return new Tuple2(null, (Object)value);
        }
        if (temporalFilter instanceof TemporalFilter.GreaterThanFilter) {
            TemporalFilter.GreaterThanFilter greaterThanFilter = (TemporalFilter.GreaterThanFilter)temporalFilter;
            LocalDateTime value = greaterThanFilter.value();
            return new Tuple2((Object)value, null);
        }
        if (temporalFilter instanceof TemporalFilter.EqualFilter) {
            TemporalFilter.EqualFilter equalFilter = (TemporalFilter.EqualFilter)temporalFilter;
            LocalDateTime value = equalFilter.value();
            return new Tuple2((Object)value, (Object)value);
        }
        throw new MatchError((Object)temporalFilter);
    }

    private StacUtils$() {
    }
}

