/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.critbit;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tinspin.index.critbit.BitTools;
import org.tinspin.index.critbit.CritBit1D;
import org.tinspin.index.critbit.CritBitKD;

public class CritBit<V>
implements CritBit1D<V>,
CritBitKD<V> {
    private final int DEPTH;
    private final int DIM;
    private Node<V> root;
    private long[] rootKey;
    private V rootVal;
    private int size;
    private static final int SINGLE_DIM = -1;
    private static final int BITS_LOG_64 = 6;
    private static final int BITS_MASK_6 = 63;

    private CritBit(int depth, int dim) {
        this.DEPTH = depth;
        this.DIM = dim;
    }

    public static <V> CritBit1D<V> create1D(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("Illegal bit width: " + width);
        }
        return new CritBit<V>(width, -1);
    }

    public static <V> CritBitKD<V> createKD(int width, int dim) {
        if (width < 1 || width > 64) {
            throw new IllegalArgumentException("Illegal bit width: " + width);
        }
        if (dim < 1) {
            throw new IllegalArgumentException("Illegal dimension count: " + dim);
        }
        return new CritBit<V>(width, dim);
    }

    @Override
    public V put(long[] key, V val) {
        this.checkDim0();
        return this.putNoCheck(key, val);
    }

    private V putNoCheck(long[] key, V val) {
        if (this.root == null) {
            if (this.rootKey == null) {
                this.rootKey = new long[key.length];
                System.arraycopy(key, 0, this.rootKey, 0, key.length);
                this.rootVal = val;
            } else {
                Node<V> n2 = this.createNode(key, val, this.rootKey, this.rootVal, 0);
                if (n2 == null) {
                    V prev = this.rootVal;
                    this.rootVal = val;
                    return prev;
                }
                this.root = n2;
                this.rootKey = null;
                this.rootVal = null;
            }
            ++this.size;
            return null;
        }
        Node<V> n = this.root;
        long[] currentPrefix = new long[key.length];
        while (true) {
            int posDiff;
            CritBit.readInfix(n, currentPrefix);
            if (n.infix != null && (posDiff = CritBit.compare(key, currentPrefix)) < n.posDiff && posDiff != -1) {
                long[] subInfix = CritBit.extractInfix(currentPrefix, posDiff + 1, n.posDiff - 1);
                Node newSub = new Node(posDiff + 1, n.loPost, n.loVal, n.hiPost, n.hiVal, subInfix, n.posDiff);
                newSub.hi = n.hi;
                newSub.lo = n.lo;
                if (BitTools.getAndCopyBit(key, posDiff, currentPrefix)) {
                    n.hi = null;
                    n.hiPost = this.createPostFix(key, posDiff);
                    n.hiVal = val;
                    n.lo = newSub;
                    n.loPost = null;
                    n.loVal = null;
                } else {
                    n.hi = newSub;
                    n.hiPost = null;
                    n.hiVal = null;
                    n.lo = null;
                    n.loPost = this.createPostFix(key, posDiff);
                    n.loVal = val;
                }
                n.infix = CritBit.extractInfix(currentPrefix, n.posFirstBit, posDiff - 1);
                n.posDiff = posDiff;
                ++this.size;
                return null;
            }
            if (BitTools.getAndCopyBit(key, n.posDiff, currentPrefix)) {
                if (n.hi != null) {
                    n = n.hi;
                    continue;
                }
                CritBit.readPostFix(n.hiPost, currentPrefix);
                Node<V> n2 = this.createNode(key, val, currentPrefix, n.hiVal, n.posDiff + 1);
                if (n2 == null) {
                    Object prev = n.hiVal;
                    n.hiVal = val;
                    return prev;
                }
                n.hi = n2;
                n.hiPost = null;
                n.hiVal = null;
                ++this.size;
                return null;
            }
            if (n.lo == null) break;
            n = n.lo;
        }
        CritBit.readPostFix(n.loPost, currentPrefix);
        Node<V> n2 = this.createNode(key, val, currentPrefix, n.loVal, n.posDiff + 1);
        if (n2 == null) {
            Object prev = n.loVal;
            n.loVal = val;
            return prev;
        }
        n.lo = n2;
        n.loPost = null;
        n.loVal = null;
        ++this.size;
        return null;
    }

    private void checkDim0() {
        if (this.DIM != -1) {
            throw new IllegalStateException("Please use ___KD() methods for k-dimensional data.");
        }
    }

    @Override
    public void printTree() {
        System.out.println("Tree: \n" + this.toString());
    }

    public String toString() {
        if (this.root == null) {
            if (this.rootKey != null) {
                return "-" + BitTools.toBinary(this.rootKey, 64) + " v=" + this.rootVal;
            }
            return "- -";
        }
        Node<V> n = this.root;
        StringBuilder s2 = new StringBuilder();
        this.printNode(n, s2, "", 0);
        return s2.toString();
    }

    private void printNode(Node<V> n, StringBuilder s2, String level, int currentDepth) {
        char NL = '\n';
        if (n.infix != null) {
            s2.append(level + "n: " + currentDepth + "/" + n.posDiff + " " + BitTools.toBinary(n.infix, 64) + NL);
        } else {
            s2.append(level + "n: " + currentDepth + "/" + n.posDiff + " i=0" + NL);
        }
        if (n.lo != null) {
            this.printNode(n.lo, s2, level + "-", n.posDiff + 1);
        } else {
            s2.append(level + " " + BitTools.toBinary(n.loPost, 64) + " v=" + n.loVal + NL);
        }
        if (n.hi != null) {
            this.printNode(n.hi, s2, level + "-", n.posDiff + 1);
        } else {
            s2.append(level + " " + BitTools.toBinary(n.hiPost, 64) + " v=" + n.hiVal + NL);
        }
    }

    public boolean checkTree() {
        if (this.root == null) {
            if (this.rootKey != null) {
                return true;
            }
            return true;
        }
        if (this.rootKey != null) {
            System.err.println("root node AND value != null");
            return false;
        }
        return this.checkNode(this.root, 0);
    }

    private boolean checkNode(Node<V> n, int firstBitOfNode) {
        if (n.posDiff == firstBitOfNode && n.infix != null) {
            System.err.println("infix with len=0 detected!");
            return false;
        }
        if (n.posFirstBit != firstBitOfNode) {
            System.err.println("infix inconsistency detected!");
            return false;
        }
        if (n.lo != null) {
            if (n.loPost != null) {
                System.err.println("lo: sub-node AND key != null");
                return false;
            }
            this.checkNode(n.lo, n.posDiff + 1);
        } else if (n.loPost == null) {
            System.err.println("lo: sub-node AND key == null");
            return false;
        }
        if (n.hi != null) {
            if (n.hiPost != null) {
                System.err.println("hi: sub-node AND key != null");
                return false;
            }
            this.checkNode(n.hi, n.posDiff + 1);
        } else if (n.hiPost == null) {
            System.err.println("hi: sub-node AND key == null");
            return false;
        }
        return true;
    }

    private long[] createPostFix(long[] val, int posDiff) {
        int preLen = posDiff + 1 >>> 6;
        long[] p = new long[val.length - preLen];
        System.arraycopy(val, preLen, p, 0, p.length);
        return p;
    }

    private static void readPostFix(long[] postVal, long[] currentPrefix) {
        int preLen = currentPrefix.length - postVal.length;
        System.arraycopy(postVal, 0, currentPrefix, preLen, postVal.length);
    }

    private Node<V> createNode(long[] k1, V val1, long[] k2, V val2, int posFirstBit) {
        int posDiff = CritBit.compare(k1, k2);
        if (posDiff == -1) {
            return null;
        }
        long[] infix = CritBit.extractInfix(k1, posFirstBit, posDiff - 1);
        long[] p1 = this.createPostFix(k1, posDiff);
        long[] p2 = this.createPostFix(k2, posDiff);
        if (BitTools.getBit(k2, posDiff)) {
            return new Node<V>(posFirstBit, p1, val1, p2, val2, infix, posDiff);
        }
        return new Node<V>(posFirstBit, p2, val2, p1, val1, infix, posDiff);
    }

    protected static <T> void readInfix(Node<T> n, long[] currentPrefix) {
        if (n.infix == null) {
            return;
        }
        int dst = n.posFirstBit >>> 6;
        System.arraycopy(n.infix, 0, currentPrefix, dst, n.infix.length);
    }

    private static long[] extractInfix(long[] v, int startPos, int endPos) {
        if (endPos < startPos) {
            return null;
        }
        int start = startPos >>> 6;
        int end = endPos >>> 6;
        long[] inf = new long[end - start + 1];
        System.arraycopy(v, start, inf, 0, inf.length);
        if ((endPos & 0x3F) < 63) {
            int n = inf.length - 1;
            inf[n] = inf[n] & (-1L >>> 1 + (endPos & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return inf;
    }

    private boolean doesInfixMatch(Node<V> n, long[] v, long[] currentVal) {
        if (n.infix == null) {
            return true;
        }
        int start = n.posFirstBit >>> 6;
        int end = n.posDiff - 1 >>> 6;
        for (int i = start; i < end; ++i) {
            if (v[i] == currentVal[i]) continue;
            return false;
        }
        int shift = 63 - (n.posDiff - 1 & 0x3F);
        return (v[end] ^ currentVal[end]) >>> shift == 0L;
    }

    private static int compare(long[] v1, long[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i] == v2[i]) continue;
            return i * 64 + Long.numberOfLeadingZeros(v1[i] ^ v2[i]);
        }
        return -1;
    }

    private static boolean isEqual(long[] v1, long[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i] == v2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(long[] key) {
        this.checkDim0();
        return this.containsNoCheck(key);
    }

    private boolean containsNoCheck(long[] val) {
        long[] currentPrefix;
        block5: {
            if (this.root == null) {
                return this.rootKey != null && CritBit.isEqual(val, this.rootKey);
            }
            Node<V> n = this.root;
            currentPrefix = new long[val.length];
            while (true) {
                CritBit.readInfix(n, currentPrefix);
                if (!this.doesInfixMatch(n, val, currentPrefix)) {
                    return false;
                }
                if (BitTools.getAndCopyBit(val, n.posDiff, currentPrefix)) {
                    if (n.hi != null) {
                        n = n.hi;
                        continue;
                    }
                    CritBit.readPostFix(n.hiPost, currentPrefix);
                    break block5;
                }
                if (n.lo == null) break;
                n = n.lo;
            }
            CritBit.readPostFix(n.loPost, currentPrefix);
        }
        return CritBit.isEqual(val, currentPrefix);
    }

    @Override
    public V get(long[] key) {
        this.checkDim0();
        return this.getNoCheck(key);
    }

    private V getNoCheck(long[] key) {
        block8: {
            if (this.root == null) {
                if (this.rootKey != null && CritBit.isEqual(key, this.rootKey)) {
                    return this.rootVal;
                }
                return null;
            }
            Node<V> n = this.root;
            long[] currentPrefix = new long[key.length];
            while (true) {
                CritBit.readInfix(n, currentPrefix);
                if (!this.doesInfixMatch(n, key, currentPrefix)) {
                    return null;
                }
                if (BitTools.getAndCopyBit(key, n.posDiff, currentPrefix)) {
                    if (n.hi != null) {
                        n = n.hi;
                        continue;
                    }
                    CritBit.readPostFix(n.hiPost, currentPrefix);
                    if (CritBit.isEqual(key, currentPrefix)) {
                        return n.hiVal;
                    }
                    break block8;
                }
                if (n.lo == null) break;
                n = n.lo;
            }
            CritBit.readPostFix(n.loPost, currentPrefix);
            if (CritBit.isEqual(key, currentPrefix)) {
                return n.loVal;
            }
        }
        return null;
    }

    private static long[] clone(long[] v) {
        long[] r = new long[v.length];
        System.arraycopy(v, 0, r, 0, v.length);
        return r;
    }

    @Override
    public V remove(long[] key) {
        this.checkDim0();
        return this.removeNoCheck(key);
    }

    private V removeNoCheck(long[] val2) {
        if (this.root == null) {
            if (this.rootKey != null && CritBit.isEqual(val2, this.rootKey)) {
                --this.size;
                this.rootKey = null;
                V prev = this.rootVal;
                this.rootVal = null;
                return prev;
            }
            return null;
        }
        Node<V> n = this.root;
        long[] currentPrefix = new long[val2.length];
        Node<V> parent = null;
        boolean isParentHigh = false;
        while (true) {
            CritBit.readInfix(n, currentPrefix);
            if (!this.doesInfixMatch(n, val2, currentPrefix)) {
                return null;
            }
            if (BitTools.getAndCopyBit(val2, n.posDiff, currentPrefix)) {
                if (n.hi != null) {
                    isParentHigh = true;
                    parent = n;
                    n = n.hi;
                    continue;
                }
                CritBit.readPostFix(n.hiPost, currentPrefix);
                if (!CritBit.isEqual(val2, currentPrefix)) {
                    return null;
                }
                long[] newPost = null;
                if (n.loPost != null) {
                    CritBit.readPostFix(n.loPost, currentPrefix);
                    newPost = currentPrefix;
                }
                BitTools.setBit(currentPrefix, n.posDiff, false);
                this.updateParentAfterRemove(parent, newPost, n.loVal, n.lo, isParentHigh, currentPrefix, n);
                return n.hiVal;
            }
            if (n.lo == null) break;
            isParentHigh = false;
            parent = n;
            n = n.lo;
        }
        CritBit.readPostFix(n.loPost, currentPrefix);
        if (!CritBit.isEqual(val2, currentPrefix)) {
            return null;
        }
        long[] newPost = null;
        if (n.hiPost != null) {
            CritBit.readPostFix(n.hiPost, currentPrefix);
            newPost = currentPrefix;
        }
        BitTools.setBit(currentPrefix, n.posDiff, true);
        this.updateParentAfterRemove(parent, newPost, n.hiVal, n.hi, isParentHigh, currentPrefix, n);
        return n.loVal;
    }

    private void updateParentAfterRemove(Node<V> parent, long[] newPost, V newVal, Node<V> newSub, boolean isParentHigh, long[] currentPrefix, Node<V> n) {
        if (newSub != null) {
            CritBit.readInfix(newSub, currentPrefix);
        }
        if (parent == null) {
            this.rootKey = newPost;
            this.rootVal = newVal;
            this.root = newSub;
        } else if (isParentHigh) {
            if (newSub == null) {
                parent.hiPost = this.createPostFix(currentPrefix, parent.posDiff);
                parent.hiVal = newVal;
            } else {
                parent.hiPost = null;
                parent.hiVal = null;
            }
            parent.hi = newSub;
        } else {
            if (newSub == null) {
                parent.loPost = this.createPostFix(currentPrefix, parent.posDiff);
                parent.loVal = newVal;
            } else {
                parent.loPost = null;
                parent.loVal = null;
            }
            parent.lo = newSub;
        }
        if (newSub != null) {
            newSub.posFirstBit = n.posFirstBit;
            newSub.infix = CritBit.extractInfix(currentPrefix, newSub.posFirstBit, newSub.posDiff - 1);
        }
        --this.size;
    }

    @Override
    public FullIterator<V> iterator() {
        this.checkDim0();
        return new FullIterator(this, this.DEPTH);
    }

    @Override
    public QueryIterator<V> query(long[] min2, long[] max) {
        this.checkDim0();
        return new QueryIterator(this, min2, max);
    }

    @Override
    public V putKD(long[] key, V val) {
        this.checkDIM(key);
        long[] vi = BitTools.mergeLong(this.DEPTH, key);
        return this.putNoCheck(vi, val);
    }

    @Override
    public boolean containsKD(long[] key) {
        this.checkDIM(key);
        long[] vi = BitTools.mergeLong(this.DEPTH, key);
        return this.containsNoCheck(vi);
    }

    @Override
    public V getKD(long[] key) {
        this.checkDIM(key);
        long[] vi = BitTools.mergeLong(this.DEPTH, key);
        return this.getNoCheck(vi);
    }

    @Override
    public V removeKD(long[] key) {
        this.checkDIM(key);
        long[] vi = BitTools.mergeLong(this.DEPTH, key);
        return this.removeNoCheck(vi);
    }

    private void checkDIM(long[] key) {
        if (key.length != this.DIM) {
            throw new IllegalArgumentException("Dimension mismatch: " + key.length + " vs " + this.DIM);
        }
    }

    @Override
    public QueryIteratorKD<V> queryKD(long[] min2, long[] max) {
        this.checkDIM(min2);
        this.checkDIM(max);
        return new QueryIteratorKD(this, min2, max, this.DIM, this.DEPTH);
    }

    public static class Entry<V> {
        private final long[] key;
        private final V value;

        Entry(long[] key, V value) {
            this.key = key;
            this.value = value;
        }

        public long[] key() {
            return this.key;
        }

        public V value() {
            return this.value;
        }
    }

    public static class QueryIteratorKD<V>
    implements Iterator<V> {
        private final long[] keyOrigTemplate;
        private final long[] minOrig;
        private final long[] maxOrig;
        private final int DIM;
        private final int DIM_INV_16;
        private final int DEPTH;
        private final int DEPTH_OFFS;
        private V nextValue = null;
        private long[] nextKey = null;
        private final Node<V>[] stack;
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext;
        private int stackTop = -1;

        public QueryIteratorKD(CritBit<V> cb, long[] minOrig, long[] maxOrig, int DIM, int DEPTH) {
            this.stack = new Node[DIM * DEPTH];
            this.readHigherNext = new byte[DIM * DEPTH];
            this.keyOrigTemplate = new long[DIM];
            this.minOrig = minOrig;
            this.maxOrig = maxOrig;
            this.DIM = DIM;
            this.DIM_INV_16 = 1 + 65537 / DIM;
            this.DEPTH = DEPTH;
            this.DEPTH_OFFS = 64 - DEPTH;
            if (cb.rootKey != null) {
                this.readPostFixAndSplit(cb.rootKey, 0, this.keyOrigTemplate);
                this.checkMatchOrigKDFullIntoNextVal(this.keyOrigTemplate, cb.rootVal);
                return;
            }
            if (cb.root == null) {
                return;
            }
            Node n = cb.root;
            this.readAndSplitInfix(n, this.keyOrigTemplate);
            if (n.posDiff > 0 && !this.checkMatchOrigKD(this.keyOrigTemplate, n.posDiff - 1)) {
                return;
            }
            this.stack[++this.stackTop] = cb.root;
            this.findNext();
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    this.unsetBitAfterSplit(this.keyOrigTemplate, n.posDiff);
                    if (this.checkMatchOrigKD(this.keyOrigTemplate, n.posDiff)) {
                        if (n.loPost != null) {
                            this.readPostFixAndSplit(n.loPost, n.posDiff + 1, this.keyOrigTemplate);
                            if (this.checkMatchOrigKDFullIntoNextVal(this.keyOrigTemplate, n.loVal)) {
                                return;
                            }
                        } else {
                            this.readAndSplitInfix(n.lo, this.keyOrigTemplate);
                            this.stack[++this.stackTop] = n.lo;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    this.setBitAfterSplit(this.keyOrigTemplate, n.posDiff);
                    if (this.checkMatchOrigKD(this.keyOrigTemplate, n.posDiff)) {
                        if (n.hiPost != null) {
                            this.readPostFixAndSplit(n.hiPost, n.posDiff + 1, this.keyOrigTemplate);
                            if (this.checkMatchOrigKDFullIntoNextVal(this.keyOrigTemplate, n.hiVal)) {
                                --this.stackTop;
                                return;
                            }
                        } else {
                            this.readAndSplitInfix(n.hi, this.keyOrigTemplate);
                            this.stack[++this.stackTop] = n.hi;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                --this.stackTop;
            }
            this.nextKey = null;
            this.nextValue = null;
        }

        private void setBitAfterSplit(long[] keyOrigTemplate, int posBitInt) {
            int k = posBitInt % this.DIM;
            long maskDst = Long.MIN_VALUE >>> posBitInt / this.DIM + this.DEPTH_OFFS;
            int n = k;
            keyOrigTemplate[n] = keyOrigTemplate[n] | maskDst;
        }

        private void unsetBitAfterSplit(long[] keyOrigTemplate, int posBitInt) {
            int k = posBitInt % this.DIM;
            long maskDst = Long.MIN_VALUE >>> posBitInt / this.DIM + this.DEPTH_OFFS;
            int n = k;
            keyOrigTemplate[n] = keyOrigTemplate[n] & (maskDst ^ 0xFFFFFFFFFFFFFFFFL);
        }

        private boolean checkMatchOrigKDFullIntoNextVal(long[] keyOrigTemplate, V value) {
            for (int k = 0; k < this.DIM; ++k) {
                if (this.minOrig[k] <= keyOrigTemplate[k] && keyOrigTemplate[k] <= this.maxOrig[k]) continue;
                return false;
            }
            this.nextKey = CritBit.clone(keyOrigTemplate);
            this.nextValue = value;
            return true;
        }

        private boolean checkMatchOrigKD(long[] keyOrigTemplate, int currentDepth) {
            int k;
            int commonBits = (currentDepth + 1) / this.DIM;
            int openBits = this.DEPTH - commonBits;
            long minMask = -1L << openBits;
            long maxMask = minMask ^ 0xFFFFFFFFFFFFFFFFL;
            int kLimit = currentDepth + 1 - this.DIM * commonBits;
            if (kLimit == 0) {
                for (int k2 = 0; k2 < this.DIM; ++k2) {
                    if (this.minOrig[k2] <= (keyOrigTemplate[k2] | maxMask) && (keyOrigTemplate[k2] & minMask) <= this.maxOrig[k2]) continue;
                    return false;
                }
                return true;
            }
            for (k = kLimit; k < this.DIM; ++k) {
                if (this.minOrig[k] <= (keyOrigTemplate[k] | maxMask) && (keyOrigTemplate[k] & minMask) <= this.maxOrig[k]) continue;
                return false;
            }
            minMask = (maxMask >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            for (k = 0; k < kLimit; ++k) {
                if (this.minOrig[k] <= (keyOrigTemplate[k] | maxMask) && (keyOrigTemplate[k] & minMask) <= this.maxOrig[k]) continue;
                return false;
            }
            return true;
        }

        private <T> void readAndSplitInfix(Node<T> n, long[] currentPrefixOrig) {
            if (n.infix == null) {
                return;
            }
            this.readAndSplit(n.infix, n.posFirstBit, n.posDiff, currentPrefixOrig);
        }

        private void readPostFixAndSplit(long[] postVal, int posFirstBit, long[] currentPrefixOrig) {
            int stopBit = this.DIM * this.DEPTH;
            this.readAndSplit(postVal, posFirstBit, stopBit, currentPrefixOrig);
        }

        private void readAndSplit(long[] srcVal, int posFirstBit, long stopBit, long[] dstVal) {
            long maskSrc = Long.MIN_VALUE >>> (posFirstBit & 0x3F);
            int k = posFirstBit % this.DIM;
            long maskDst = Long.MIN_VALUE >>> this.getDepthAcrossDims(posFirstBit) + this.DEPTH_OFFS;
            int src = 0;
            int i = posFirstBit;
            while ((long)i < stopBit) {
                if ((srcVal[src] & maskSrc) == 0L) {
                    int n = k;
                    dstVal[n] = dstVal[n] & (maskDst ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    int n = k;
                    dstVal[n] = dstVal[n] | maskDst;
                }
                if (++k >= this.DIM) {
                    k = 0;
                    maskDst >>>= 1;
                }
                if ((maskSrc >>>= 1) == 0L) {
                    ++src;
                    maskSrc = Long.MIN_VALUE;
                }
                ++i;
            }
        }

        private int getDepthAcrossDims(int posFirstBit) {
            int depthAcrossDims = posFirstBit * this.DIM_INV_16 >>> 16;
            return depthAcrossDims;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long[] nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CheckEmptyWithMask {
        private final CritBit<?> cb;
        private final long[] valIntTemplate;
        private long[] minOrig;
        private long[] maxOrig;
        private final Node<?>[] stack;
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext;
        private int stackTop = -1;
        private final long[] domMaskLo;
        private final long[] domMaskHi;
        private final long MAX_MASK;
        private boolean ignoreUpper;
        private boolean pointFound;

        public CheckEmptyWithMask(CritBit<?> cb, int dims) {
            this.cb = cb;
            this.stack = new Node[cb.DEPTH];
            this.readHigherNext = new byte[cb.DEPTH];
            int intArrayLen = cb.DEPTH + 63 >>> 6;
            this.valIntTemplate = new long[intArrayLen];
            this.domMaskLo = new long[intArrayLen];
            this.domMaskHi = new long[intArrayLen];
            this.MAX_MASK = -1L << dims ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public boolean isEmpty(long[] min2, long[] max, boolean ignoreUpper) {
            this.ignoreUpper = ignoreUpper;
            this.minOrig = min2;
            this.maxOrig = max;
            Arrays.fill(this.readHigherNext, (byte)0);
            this.pointFound = false;
            if (this.cb.rootKey != null) {
                return !this.checkMatchIntoNextVal(this.cb.rootKey, 0);
            }
            if (this.cb.root == null) {
                return true;
            }
            Node n = this.cb.root;
            CritBit.readInfix(n, this.valIntTemplate);
            if (!this.checkMatch(this.valIntTemplate, 0, n.posDiff - 1)) {
                return true;
            }
            return this.findNext();
        }

        private boolean findNext() {
            int stackTop = -1;
            this.stack[++stackTop] = this.cb.root;
            while (stackTop >= 0) {
                Node<?> n = this.stack[stackTop];
                if (this.readHigherNext[stackTop] == 0) {
                    this.readHigherNext[stackTop] = 1;
                    if (this.checkMatchANdSetSingleBit0(this.valIntTemplate, n.posDiff)) {
                        if (n.loPost != null) {
                            CritBit.readPostFix(n.loPost, this.valIntTemplate);
                            if (this.checkMatchIntoNextVal(this.valIntTemplate, n.posDiff + 1)) {
                                return false;
                            }
                        } else {
                            CritBit.readInfix(n.lo, this.valIntTemplate);
                            if (this.checkMatch(this.valIntTemplate, n.lo.posFirstBit, n.lo.posDiff - 1)) {
                                if (this.pointFound) {
                                    return false;
                                }
                                this.stack[++stackTop] = n.lo;
                                this.readHigherNext[stackTop] = 0;
                                continue;
                            }
                        }
                    }
                }
                if (this.readHigherNext[stackTop] == 1) {
                    this.readHigherNext[stackTop] = 2;
                    if (this.checkMatchAndSetSingleBit1(this.valIntTemplate, n.posDiff)) {
                        if (n.hiPost != null) {
                            CritBit.readPostFix(n.hiPost, this.valIntTemplate);
                            if (this.checkMatchIntoNextVal(this.valIntTemplate, n.posDiff + 1)) {
                                return false;
                            }
                        } else {
                            CritBit.readInfix(n.hi, this.valIntTemplate);
                            if (this.checkMatch(this.valIntTemplate, n.hi.posFirstBit, n.hi.posDiff - 1)) {
                                if (this.pointFound) {
                                    return false;
                                }
                                this.stack[++stackTop] = n.hi;
                                this.readHigherNext[stackTop] = 0;
                                continue;
                            }
                        }
                    }
                }
                --stackTop;
            }
            return true;
        }

        private boolean checkMatchIntoNextVal(long[] keyTemplate, int startBit) {
            long diffHi;
            int iStart = startBit >>> 6;
            long diffLo = iStart == 0 ? 0L : this.domMaskLo[iStart - 1];
            long l = diffHi = iStart == 0 ? 0L : this.domMaskHi[iStart - 1];
            if (diffLo == this.MAX_MASK && diffHi == this.MAX_MASK) {
                this.pointFound = true;
                return true;
            }
            if (startBit >= keyTemplate.length * 64) {
                if (this.ignoreUpper && diffHi == 0L && keyTemplate[keyTemplate.length - 1] == this.maxOrig[this.maxOrig.length - 1]) {
                    throw new IllegalStateException();
                }
                return true;
            }
            for (int i = iStart; i < keyTemplate.length; ++i) {
                long localDiffLo = keyTemplate[i] ^ this.minOrig[i];
                long localDiffHi = keyTemplate[i] ^ this.maxOrig[i];
                if (((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) != diffLo || ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) != diffHi) {
                    return false;
                }
                if (diffLo != this.MAX_MASK || diffHi != this.MAX_MASK) continue;
                this.pointFound = true;
                return true;
            }
            if (this.ignoreUpper && diffHi == 0L && keyTemplate[keyTemplate.length - 1] == this.maxOrig[this.maxOrig.length - 1]) {
                return false;
            }
            this.pointFound = true;
            return true;
        }

        private boolean checkMatch(long[] keyTemplate, int startBit, int currentDepth) {
            int i;
            long diffHi;
            if (currentDepth < startBit) {
                return true;
            }
            if (startBit == currentDepth) {
                return this.checkMatchSingleBit(BitTools.getBit(keyTemplate, startBit), currentDepth);
            }
            int iStart = startBit >>> 6;
            long diffLo = iStart == 0 ? 0L : this.domMaskLo[iStart - 1];
            long l = diffHi = iStart == 0 ? 0L : this.domMaskHi[iStart - 1];
            if (diffLo == this.MAX_MASK && diffHi == this.MAX_MASK) {
                this.pointFound = true;
                return true;
            }
            for (i = iStart; i < currentDepth + 1 >>> 6; ++i) {
                long localDiffLo = keyTemplate[i] ^ this.minOrig[i];
                long localDiffHi = keyTemplate[i] ^ this.maxOrig[i];
                if (((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) != diffLo || ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) != diffHi) {
                    return false;
                }
                this.domMaskLo[i] = diffLo;
                this.domMaskHi[i] = diffHi;
                if (diffLo != this.MAX_MASK || diffHi != this.MAX_MASK) continue;
                this.pointFound = true;
                return true;
            }
            int toCheck = currentDepth + 1 & 0x3F;
            if (toCheck != 0) {
                boolean r;
                long localDiffLo = keyTemplate[i] ^ this.minOrig[i];
                long localDiffHi = keyTemplate[i] ^ this.maxOrig[i];
                long mask = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
                boolean bl = r = ((((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) ^ diffLo | ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) ^ diffHi) & mask) == 0L;
                if (r) {
                    this.domMaskLo[i] = diffLo;
                    this.domMaskHi[i] = diffHi;
                }
                return r;
            }
            if (diffLo == this.MAX_MASK && diffHi == this.MAX_MASK) {
                throw new IllegalStateException();
            }
            return true;
        }

        private boolean checkMatchSingleBit(boolean bit, int currentDepth) {
            int i = currentDepth >>> 6;
            long diffLo = i == 0 ? 0L : this.domMaskLo[i - 1];
            long diffHi = i == 0 ? 0L : this.domMaskHi[i - 1];
            int toCheck = currentDepth & 0x3F;
            long mask = Long.MIN_VALUE >>> toCheck;
            long keyTemplate = bit ? mask : 0L;
            long localDiffLo = (keyTemplate ^ this.minOrig[i]) & mask;
            long localDiffHi = (keyTemplate ^ this.maxOrig[i]) & mask;
            if (((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) != diffLo || ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) != diffHi) {
                return false;
            }
            long maskFF00 = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
            this.domMaskLo[i] = diffLo | this.domMaskLo[i] & maskFF00;
            this.domMaskHi[i] = diffHi | this.domMaskHi[i] & maskFF00;
            return true;
        }

        private boolean checkMatchANdSetSingleBit0(long[] valTemplate, int currentDepth) {
            int toCheck;
            long mask;
            long localDiffLo;
            int i = currentDepth >>> 6;
            long diffLo = i == 0 ? 0L : this.domMaskLo[i - 1];
            if ((diffLo | (localDiffLo = this.minOrig[i] & (mask = Long.MIN_VALUE >>> (toCheck = currentDepth & 0x3F)))) != diffLo) {
                return false;
            }
            int n = i;
            valTemplate[n] = valTemplate[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            long localDiffHi = this.maxOrig[i] & mask;
            long diffHi = i == 0 ? 0L : this.domMaskHi[i - 1];
            long maskFF00 = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
            this.domMaskLo[i] = diffLo | this.domMaskLo[i] & maskFF00;
            this.domMaskHi[i] = (diffHi |= localDiffHi & this.maxOrig[i]) | this.domMaskHi[i] & maskFF00;
            return true;
        }

        private boolean checkMatchAndSetSingleBit1(long[] keyTemplate, int currentDepth) {
            int i;
            int toCheck;
            long mask;
            long localDiffHi;
            int iStart;
            long diffHi = iStart == 0 ? 0L : this.domMaskHi[iStart - 1];
            if ((diffHi | (localDiffHi = ((mask = Long.MIN_VALUE >>> (toCheck = currentDepth & 0x3F)) ^ this.maxOrig[i = (iStart = currentDepth >>> 6)]) & mask)) != diffHi) {
                return false;
            }
            int n = i;
            keyTemplate[n] = keyTemplate[n] | mask;
            long localDiffLo = (mask ^ this.minOrig[i]) & mask;
            long diffLo = iStart == 0 ? 0L : this.domMaskLo[iStart - 1];
            long maskFF00 = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
            this.domMaskLo[i] = (diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | this.domMaskLo[i] & maskFF00;
            this.domMaskHi[i] = diffHi | this.domMaskHi[i] & maskFF00;
            return true;
        }
    }

    public static class QueryIteratorWithMask<V>
    implements Iterator<V> {
        private final CritBit<V> cb;
        private final long[] valIntTemplate;
        private long[] minOrig;
        private long[] maxOrig;
        private long[] nextKey = null;
        private V nextValue = null;
        private final Node<V>[] stack;
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext;
        private int stackTop = -1;
        private final long[] domMaskLo;
        private final long[] domMaskHi;
        private final long MAX_MASK;

        public QueryIteratorWithMask(CritBit<V> cb, long[] minOrig, long[] maxOrig, int DIM) {
            this.cb = cb;
            this.stack = new Node[cb.DEPTH];
            this.readHigherNext = new byte[cb.DEPTH];
            int intArrayLen = cb.DEPTH + 63 >>> 6;
            this.valIntTemplate = new long[intArrayLen];
            this.domMaskLo = new long[intArrayLen];
            this.domMaskHi = new long[intArrayLen];
            this.MAX_MASK = -1L << DIM ^ 0xFFFFFFFFFFFFFFFFL;
            this.reset(minOrig, maxOrig);
        }

        public void reset(long[] min2, long[] max) {
            this.stackTop = -1;
            this.nextKey = null;
            this.minOrig = min2;
            this.maxOrig = max;
            Arrays.fill(this.readHigherNext, (byte)0);
            if (this.cb.rootKey != null) {
                this.checkMatchIntoNextVal(this.cb.rootKey, 0, this.cb.rootVal);
                return;
            }
            if (this.cb.root == null) {
                return;
            }
            Node n = this.cb.root;
            CritBit.readInfix(n, this.valIntTemplate);
            if (!this.checkMatch(this.valIntTemplate, 0, n.posDiff - 1)) {
                return;
            }
            this.stack[++this.stackTop] = this.cb.root;
            this.findNext();
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    if (this.checkMatchANdSetSingleBit0(this.valIntTemplate, n.posDiff)) {
                        if (n.loPost != null) {
                            CritBit.readPostFix(n.loPost, this.valIntTemplate);
                            if (this.checkMatchIntoNextVal(this.valIntTemplate, n.posDiff + 1, n.loVal)) {
                                return;
                            }
                        } else {
                            CritBit.readInfix(n.lo, this.valIntTemplate);
                            if (this.checkMatch(this.valIntTemplate, n.lo.posFirstBit, n.lo.posDiff - 1)) {
                                this.stack[++this.stackTop] = n.lo;
                                this.readHigherNext[this.stackTop] = 0;
                                continue;
                            }
                        }
                    }
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    if (this.checkMatchAndSetSingleBit1(this.valIntTemplate, n.posDiff)) {
                        if (n.hiPost != null) {
                            CritBit.readPostFix(n.hiPost, this.valIntTemplate);
                            if (this.checkMatchIntoNextVal(this.valIntTemplate, n.posDiff + 1, n.hiVal)) {
                                --this.stackTop;
                                return;
                            }
                        } else {
                            CritBit.readInfix(n.hi, this.valIntTemplate);
                            if (this.checkMatch(this.valIntTemplate, n.hi.posFirstBit, n.hi.posDiff - 1)) {
                                this.stack[++this.stackTop] = n.hi;
                                this.readHigherNext[this.stackTop] = 0;
                                continue;
                            }
                        }
                    }
                }
                --this.stackTop;
            }
            this.nextValue = null;
            this.nextKey = null;
        }

        private boolean checkMatchIntoNextVal(long[] keyTemplate, int startBit, V value) {
            if (startBit >= keyTemplate.length * 64) {
                return true;
            }
            int iStart = startBit >>> 6;
            long diffLo = iStart == 0 ? 0L : this.domMaskLo[iStart - 1];
            long diffHi = iStart == 0 ? 0L : this.domMaskHi[iStart - 1];
            for (int i = iStart; i < keyTemplate.length; ++i) {
                long localDiffLo = keyTemplate[i] ^ this.minOrig[i];
                long localDiffHi = keyTemplate[i] ^ this.maxOrig[i];
                if (((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) != diffLo || ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) != diffHi) {
                    return false;
                }
                if ((diffLo & this.MAX_MASK) == this.MAX_MASK && (diffHi & this.MAX_MASK) == this.MAX_MASK) break;
            }
            this.nextValue = value;
            this.nextKey = CritBit.clone(keyTemplate);
            return true;
        }

        private boolean checkMatch(long[] keyTemplate, int startBit, int currentDepth) {
            int i;
            if (currentDepth < startBit) {
                return true;
            }
            if (startBit == currentDepth) {
                return this.checkMatchSingleBit(BitTools.getBit(keyTemplate, startBit), currentDepth);
            }
            int iStart = startBit >>> 6;
            long diffLo = iStart == 0 ? 0L : this.domMaskLo[iStart - 1];
            long diffHi = iStart == 0 ? 0L : this.domMaskHi[iStart - 1];
            for (i = iStart; i < currentDepth + 1 >>> 6; ++i) {
                long localDiffLo = keyTemplate[i] ^ this.minOrig[i];
                long localDiffHi = keyTemplate[i] ^ this.maxOrig[i];
                if (((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) != diffLo || ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) != diffHi) {
                    return false;
                }
                this.domMaskLo[i] = diffLo;
                this.domMaskHi[i] = diffHi;
                if ((diffLo & this.MAX_MASK) != this.MAX_MASK || (diffHi & this.MAX_MASK) != this.MAX_MASK) continue;
                while (i < currentDepth + 1 >>> 6) {
                    this.domMaskLo[i] = diffLo;
                    this.domMaskHi[i] = diffHi;
                    ++i;
                }
                return true;
            }
            int toCheck = currentDepth + 1 & 0x3F;
            if (toCheck != 0) {
                boolean r;
                long localDiffLo = keyTemplate[i] ^ this.minOrig[i];
                long localDiffHi = keyTemplate[i] ^ this.maxOrig[i];
                long mask = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
                boolean bl = r = ((((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) ^ diffLo | ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) ^ diffHi) & mask) == 0L;
                if (r) {
                    this.domMaskLo[i] = diffLo & mask;
                    this.domMaskHi[i] = diffHi & mask;
                }
                return r;
            }
            return true;
        }

        private boolean checkMatchSingleBit(boolean bit, int currentDepth) {
            int i = currentDepth >>> 6;
            long diffLo = i == 0 ? 0L : this.domMaskLo[i - 1];
            long diffHi = i == 0 ? 0L : this.domMaskHi[i - 1];
            int toCheck = currentDepth & 0x3F;
            long mask = Long.MIN_VALUE >>> toCheck;
            long keyTemplate = bit ? mask : 0L;
            long localDiffLo = (keyTemplate ^ this.minOrig[i]) & mask;
            long localDiffHi = (keyTemplate ^ this.maxOrig[i]) & mask;
            if (((diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | localDiffLo) != diffLo || ((diffHi |= localDiffHi & this.maxOrig[i]) | localDiffHi) != diffHi) {
                return false;
            }
            long maskFF00 = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
            this.domMaskLo[i] = diffLo | this.domMaskLo[i] & maskFF00;
            this.domMaskHi[i] = diffHi | this.domMaskHi[i] & maskFF00;
            return true;
        }

        private boolean checkMatchANdSetSingleBit0(long[] valTemplate, int currentDepth) {
            int toCheck;
            long mask;
            long localDiffLo;
            int i = currentDepth >>> 6;
            long diffLo = i == 0 ? 0L : this.domMaskLo[i - 1];
            if ((diffLo | (localDiffLo = this.minOrig[i] & (mask = Long.MIN_VALUE >>> (toCheck = currentDepth & 0x3F)))) != diffLo) {
                return false;
            }
            int n = i;
            valTemplate[n] = valTemplate[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            long localDiffHi = this.maxOrig[i] & mask;
            long diffHi = i == 0 ? 0L : this.domMaskHi[i - 1];
            long maskFF00 = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
            this.domMaskLo[i] = diffLo | this.domMaskLo[i] & maskFF00;
            this.domMaskHi[i] = (diffHi |= localDiffHi & this.maxOrig[i]) | this.domMaskHi[i] & maskFF00;
            return true;
        }

        private boolean checkMatchAndSetSingleBit1(long[] keyTemplate, int currentDepth) {
            int i;
            int toCheck;
            long mask;
            long localDiffHi;
            int iStart;
            long diffHi = iStart == 0 ? 0L : this.domMaskHi[iStart - 1];
            if ((diffHi | (localDiffHi = ((mask = Long.MIN_VALUE >>> (toCheck = currentDepth & 0x3F)) ^ this.maxOrig[i = (iStart = currentDepth >>> 6)]) & mask)) != diffHi) {
                return false;
            }
            int n = i;
            keyTemplate[n] = keyTemplate[n] | mask;
            long localDiffLo = (mask ^ this.minOrig[i]) & mask;
            long diffLo = iStart == 0 ? 0L : this.domMaskLo[iStart - 1];
            long maskFF00 = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
            this.domMaskLo[i] = (diffLo |= localDiffLo & (this.minOrig[i] ^ 0xFFFFFFFFFFFFFFFFL)) | this.domMaskLo[i] & maskFF00;
            this.domMaskHi[i] = diffHi | this.domMaskHi[i] & maskFF00;
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long[] nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class QueryIterator<V>
    implements Iterator<V> {
        private final CritBit<V> cb;
        private final long[] valIntTemplate;
        private long[] minOrig;
        private long[] maxOrig;
        private long[] nextKey = null;
        private V nextValue = null;
        private final Node<V>[] stack;
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext;
        private int stackTop = -1;
        private final boolean[] loEnclosed;
        private final boolean[] hiEnclosed;

        QueryIterator(CritBit<V> cb, long[] minOrig, long[] maxOrig) {
            this.cb = cb;
            this.stack = new Node[cb.DEPTH];
            this.readHigherNext = new byte[cb.DEPTH];
            int intArrayLen = cb.DEPTH + 63 >>> 6;
            this.valIntTemplate = new long[intArrayLen];
            this.loEnclosed = new boolean[intArrayLen];
            this.hiEnclosed = new boolean[intArrayLen];
            this.reset(minOrig, maxOrig);
        }

        public void reset(long[] min2, long[] max) {
            this.stackTop = -1;
            this.nextKey = null;
            this.minOrig = min2;
            this.maxOrig = max;
            Arrays.fill(this.readHigherNext, (byte)0);
            if (this.cb.rootKey != null) {
                this.checkMatchIntoNextVal(this.cb.rootKey, 0, this.cb.rootVal);
                return;
            }
            if (this.cb.root == null) {
                return;
            }
            Node n = this.cb.root;
            CritBit.readInfix(n, this.valIntTemplate);
            if (!this.checkMatch(this.valIntTemplate, 0, n.posDiff - 1)) {
                return;
            }
            this.stack[++this.stackTop] = this.cb.root;
            this.findNext();
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    BitTools.setBit(this.valIntTemplate, n.posDiff, false);
                    if (this.checkMatch(this.valIntTemplate, n.posFirstBit, n.posDiff)) {
                        if (n.loPost != null) {
                            CritBit.readPostFix(n.loPost, this.valIntTemplate);
                            if (this.checkMatchIntoNextVal(this.valIntTemplate, n.posDiff + 1, n.loVal)) {
                                return;
                            }
                        } else {
                            CritBit.readInfix(n.lo, this.valIntTemplate);
                            this.stack[++this.stackTop] = n.lo;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    BitTools.setBit(this.valIntTemplate, n.posDiff, true);
                    if (this.checkMatch(this.valIntTemplate, n.posFirstBit, n.posDiff)) {
                        if (n.hiPost != null) {
                            CritBit.readPostFix(n.hiPost, this.valIntTemplate);
                            if (this.checkMatchIntoNextVal(this.valIntTemplate, n.posDiff + 1, n.hiVal)) {
                                --this.stackTop;
                                return;
                            }
                        } else {
                            CritBit.readInfix(n.hi, this.valIntTemplate);
                            this.stack[++this.stackTop] = n.hi;
                            this.readHigherNext[this.stackTop] = 0;
                            continue;
                        }
                    }
                }
                --this.stackTop;
            }
            this.nextValue = null;
            this.nextKey = null;
        }

        private boolean checkMatchIntoNextVal(long[] keyTemplate, int startBit, V value) {
            int iStart = startBit >>> 6;
            boolean loMatch = iStart == 0 ? false : this.loEnclosed[iStart - 1];
            boolean hiMatch = iStart == 0 ? false : this.hiEnclosed[iStart - 1];
            for (int i = iStart; i < keyTemplate.length; ++i) {
                if (!loMatch && this.minOrig[i] > keyTemplate[i] || !hiMatch && keyTemplate[i] > this.maxOrig[i]) {
                    return false;
                }
                if (this.minOrig[i] < keyTemplate[i] && (loMatch = true) && hiMatch) break;
                if (keyTemplate[i] >= this.maxOrig[i]) continue;
                hiMatch = true;
                if (loMatch && hiMatch) break;
            }
            this.nextValue = value;
            this.nextKey = CritBit.clone(keyTemplate);
            return true;
        }

        private boolean checkMatch(long[] keyTemplate, int startBit, int currentDepth) {
            int i;
            int iStart = startBit >>> 6;
            boolean loMatch = iStart == 0 ? false : this.loEnclosed[iStart - 1];
            boolean hiMatch = iStart == 0 ? false : this.hiEnclosed[iStart - 1];
            for (i = iStart; i < currentDepth + 1 >>> 6; ++i) {
                if (!loMatch && this.minOrig[i] > keyTemplate[i] || !hiMatch && keyTemplate[i] > this.maxOrig[i]) {
                    return false;
                }
                if (this.minOrig[i] < keyTemplate[i] && (loMatch = true) && hiMatch) break;
                if (keyTemplate[i] < this.maxOrig[i]) {
                    hiMatch = true;
                    if (loMatch && hiMatch) break;
                }
                this.loEnclosed[i] = loMatch;
                this.hiEnclosed[i] = hiMatch;
            }
            if (loMatch && hiMatch) {
                while (i < currentDepth + 1 >>> 6) {
                    this.loEnclosed[i] = loMatch;
                    this.hiEnclosed[i] = hiMatch;
                    ++i;
                }
                return true;
            }
            int toCheck = currentDepth + 1 & 0x3F;
            if (toCheck != 0) {
                long mask = -1L >>> toCheck ^ 0xFFFFFFFFFFFFFFFFL;
                if (!loMatch && (this.minOrig[i] & mask) > (keyTemplate[i] & mask)) {
                    return false;
                }
                if (!hiMatch && (keyTemplate[i] & mask) > (this.maxOrig[i] & mask)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long[] nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class FullIterator<V>
    implements Iterator<V> {
        private final long[] valIntTemplate;
        private long[] nextKey = null;
        private V nextValue = null;
        private final Node<V>[] stack;
        private static final byte READ_LOWER = 0;
        private static final byte READ_UPPER = 1;
        private static final byte RETURN_TO_PARENT = 2;
        private final byte[] readHigherNext;
        private int stackTop = -1;

        public FullIterator(CritBit<V> cb, int DEPTH) {
            this.stack = new Node[DEPTH];
            this.readHigherNext = new byte[DEPTH];
            int intArrayLen = DEPTH + 63 >>> 6;
            this.valIntTemplate = new long[intArrayLen];
            if (cb.rootKey != null) {
                this.readNextVal(cb.rootKey, cb.rootVal);
                return;
            }
            if (cb.root == null) {
                return;
            }
            Node n = cb.root;
            CritBit.readInfix(n, this.valIntTemplate);
            this.stack[++this.stackTop] = cb.root;
            this.findNext();
        }

        private void findNext() {
            while (this.stackTop >= 0) {
                Node<V> n = this.stack[this.stackTop];
                if (this.readHigherNext[this.stackTop] == 0) {
                    this.readHigherNext[this.stackTop] = 1;
                    BitTools.setBit(this.valIntTemplate, n.posDiff, false);
                    if (n.loPost != null) {
                        CritBit.readPostFix(n.loPost, this.valIntTemplate);
                        this.readNextVal(this.valIntTemplate, n.loVal);
                        return;
                    }
                    CritBit.readInfix(n.lo, this.valIntTemplate);
                    this.stack[++this.stackTop] = n.lo;
                    this.readHigherNext[this.stackTop] = 0;
                    continue;
                }
                if (this.readHigherNext[this.stackTop] == 1) {
                    this.readHigherNext[this.stackTop] = 2;
                    BitTools.setBit(this.valIntTemplate, n.posDiff, true);
                    if (n.hiPost != null) {
                        CritBit.readPostFix(n.hiPost, this.valIntTemplate);
                        this.readNextVal(this.valIntTemplate, n.hiVal);
                        --this.stackTop;
                        return;
                    }
                    CritBit.readInfix(n.hi, this.valIntTemplate);
                    this.stack[++this.stackTop] = n.hi;
                    this.readHigherNext[this.stackTop] = 0;
                    continue;
                }
                --this.stackTop;
            }
            this.nextValue = null;
            this.nextKey = null;
        }

        private void readNextVal(long[] keyTemplate, V value) {
            this.nextValue = value;
            this.nextKey = CritBit.clone(keyTemplate);
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            V ret = this.nextValue;
            this.findNext();
            return ret;
        }

        public long[] nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] ret = this.nextKey;
            this.findNext();
            return ret;
        }

        public Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry<V> ret = new Entry<V>(this.nextKey, this.nextValue);
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Node<V> {
        V loVal;
        V hiVal;
        Node<V> lo;
        Node<V> hi;
        long[] loPost;
        long[] hiPost;
        long[] infix;
        int posFirstBit;
        int posDiff;

        Node(int posFirstBit, long[] loPost, V loVal, long[] hiPost, V hiVal, long[] infix, int posDiff) {
            this.loPost = loPost;
            this.loVal = loVal;
            this.hiPost = hiPost;
            this.hiVal = hiVal;
            this.infix = infix;
            this.posFirstBit = posFirstBit;
            this.posDiff = posDiff;
        }
    }
}

