/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.twak.utils.collections.Loop;

public class AngleAccumulator {
    boolean targetPositive = true;
    double angle = 0.0;
    Point3d firstPoint = null;
    Point3d lastPoint = null;
    Vector3d firstVector;
    Vector3d lastVector = null;
    Vector3d normal = null;

    public AngleAccumulator(boolean positive, Vector3d normal) {
        this.normal = normal;
        this.targetPositive = positive;
    }

    public void add(Point3d pt) {
        if (this.lastPoint == null) {
            this.firstPoint = this.lastPoint = pt;
            return;
        }
        Vector3d v = new Vector3d(pt);
        v.sub(this.lastPoint);
        this.add(v);
        this.lastPoint = pt;
    }

    private void add(Vector3d v) {
        if (this.lastVector != null) {
            double dA = v.angle(this.lastVector);
            Vector3d cross = new Vector3d();
            cross.cross(this.lastVector, v);
            if (!(Math.abs(cross.length()) < 0.01) && cross.angle(this.normal) > 1.5707963267948966) {
                dA = -dA;
            }
            this.angle += dA;
        } else {
            this.firstVector = v;
        }
        this.lastVector = v;
    }

    public boolean correctAngle() {
        if (this.firstVector != null) {
            this.add(this.firstPoint);
            this.add(this.firstVector);
            this.firstVector = null;
        }
        if (this.targetPositive) {
            return Math.abs(this.angle - Math.PI * 2) < 0.1;
        }
        return Math.abs(this.angle + Math.PI * 2) < 0.1;
    }

    public static void main(String[] args) {
        AngleAccumulator aa = new AngleAccumulator(true, new Vector3d(0.0, 0.0, 1.0));
        aa.add(new Point3d(0.0, 0.0, 0.0));
        aa.add(new Point3d(5.0, -5.0, 0.0));
        aa.add(new Point3d(10.0, 0.0, 0.0));
        aa.add(new Point3d(10.0, 10.0, 0.0));
        aa.add(new Point3d(0.0, 10.0, 0.0));
        System.out.println(aa.correctAngle());
    }

    public static boolean sign(Loop<Point2d> loop) {
        AngleAccumulator aa = new AngleAccumulator(true, new Vector3d(0.0, 0.0, 1.0));
        for (Point2d p : loop) {
            aa.add(new Point3d(p.x, p.y, 0.0));
        }
        return aa.correctAngle();
    }
}

