/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v8;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.v8.Bits;
import ch.ethz.globis.phtree.v8.PhTree8;
import java.util.Iterator;
import org.zoodb.index.critbit.CritBit64;
import org.zoodb.index.critbit.CritBit64COW;

class Node<T> {
    private static final int REF_BITS = 32;
    static final int HC_BITS = 0;
    static final int PINN_HC_WIDTH = 1;
    private Node<T>[] subNRef;
    private T[] values;
    private int subCnt = 0;
    private int postCnt = 0;
    long[] ba = null;
    private byte isHC = 0;
    private byte postLen = 0;
    private byte infixLen = 0;
    private CritBit64<PhTree8.NodeEntry<T>> ind = null;

    private static final boolean NI_THRESHOLD(int subCnt, int postCnt) {
        return subCnt > 500 || postCnt > 50;
    }

    static final int PIK_WIDTH(int DIM) {
        return DIM;
    }

    static final int SIK_WIDTH(int DIM) {
        return DIM;
    }

    protected Node(Node<T> original, int dim) {
        if (original.subNRef != null) {
            int size = original.subNRef.length;
            this.subNRef = Refs.newArray(Node.class, size);
            System.arraycopy(original.subNRef, 0, this.subNRef, 0, size);
        }
        if (original.values != null) {
            this.values = (Object[])original.values.clone();
        }
        if (original.ba != null) {
            this.ba = new long[original.ba.length];
            System.arraycopy(original.ba, 0, this.ba, 0, original.ba.length);
        }
        this.subCnt = original.subCnt;
        this.postCnt = original.postCnt;
        this.infixLen = original.infixLen;
        this.isHC = original.isHC;
        this.postLen = original.postLen;
        this.infixLen = original.infixLen;
        if (original.ind != null) {
            this.ind = ((CritBit64COW)original.ind).copy();
        }
        if (original.ba != null) {
            int nrBits = original.isPostNI() ? this.calcArraySizeTotalBitsNI(dim) : this.calcArraySizeTotalBits(original.getPostCount(), dim);
            this.ba = Bits.arrayCreate(nrBits);
            System.arraycopy(original.ba, 0, this.ba, 0, original.ba.length);
        }
    }

    protected Node(int infixLen, int postLen, int estimatedPostCount, PhTree8<T> tree) {
        this.infixLen = (byte)infixLen;
        this.postLen = (byte)postLen;
        tree.increaseNrNodes();
        if (estimatedPostCount >= 0) {
            int size = this.calcArraySizeTotalBits(estimatedPostCount, tree.getDim());
            this.ba = Bits.arrayCreate(size);
        }
    }

    static <T> Node<T> createNode(PhTree8<T> tree, int infixLen, int postLen, int estimatedPostCount) {
        return new Node<T>(infixLen, postLen, estimatedPostCount, tree);
    }

    static <T> Node<T> createNode(Node<T> original, int dim) {
        return new Node<T>(original, dim);
    }

    PhTree8.NodeEntry<T> createNodeEntry(Node<T> sub) {
        return new PhTree8.NodeEntry<T>(sub, this.getClass() != Node.class);
    }

    PhTree8.NodeEntry<T> createNodeEntry(long[] key, T value) {
        return new PhTree8.NodeEntry<T>(key, value, this.getClass() != Node.class);
    }

    boolean hasInfixes() {
        return this.infixLen > 0;
    }

    int calcArraySizeTotalBits(int bufPostCnt, int DIM) {
        int nBits = this.getBitPos_PostIndex(DIM);
        nBits = this.isPostHC() ? (nBits += (1 + DIM * this.postLen) * (1 << DIM)) : (this.isPostNI() ? (nBits += 0) : (nBits += bufPostCnt * (Node.PIK_WIDTH(DIM) + DIM * this.postLen)));
        return nBits;
    }

    private int calcArraySizeTotalBitsNI(int DIM) {
        return this.getBitPos_PostIndex(DIM);
    }

    long getInfix(int dim) {
        return Bits.readArray(this.ba, this.getBitPos_Infix() + dim * this.infixLen, this.infixLen) << this.postLen + 1;
    }

    void getInfix(long[] val) {
        if (!this.hasInfixes()) {
            return;
        }
        int maskLen = this.postLen + 1 + this.infixLen;
        long mask = -1L << maskLen;
        for (int i = 0; i < val.length; ++i) {
            int n = i;
            val[n] = val[n] & mask;
            int n2 = i;
            val[n2] = val[n2] | this.getInfix(i);
        }
    }

    void getInfixNoOverwrite(long[] val) {
        if (!this.hasInfixes()) {
            return;
        }
        for (int i = 0; i < val.length; ++i) {
            int n = i;
            val[n] = val[n] | this.getInfix(i);
        }
    }

    void writeInfix(long[] key) {
        int pos = this.getBitPos_Infix();
        int shift = this.postLen + 1;
        for (long k : key) {
            Bits.writeArray(this.ba, pos, this.infixLen, k >>> shift);
            pos += this.infixLen;
        }
    }

    long getInfixBit(int infId, int infixInternalOffset) {
        int startBitTotal = infId * this.infixLen + infixInternalOffset;
        return Bits.getBit01(this.ba, this.getBitPos_Infix() + startBitTotal);
    }

    PhTree8.NodeEntry<T> getChildNI(long pos) {
        return this.niGet(pos);
    }

    Node<T> getSubNode(long pos, int DIM) {
        if (this.ind != null) {
            PhTree8.NodeEntry<T> e = this.niGet(pos);
            if (e == null) {
                return null;
            }
            return e.node;
        }
        if (this.subNRef == null) {
            return null;
        }
        if (this.isSubHC()) {
            return this.subNRef[(int)pos];
        }
        int subOffsBits = this.getBitPos_SubNodeIndex(DIM);
        int p2 = Bits.binarySearch(this.ba, subOffsBits, this.getSubCount(), pos, Node.SIK_WIDTH(DIM), 0);
        if (p2 < 0) {
            return null;
        }
        return this.subNRef[p2];
    }

    Node<T> getSubNodeWithPos(long posHC, int posLHC) {
        if (this.isSubNI()) {
            return this.niGet((long)posHC).node;
        }
        Node<T> ret = this.isSubHC() ? this.subNRef[(int)posHC] : this.subNRef[posLHC];
        return ret;
    }

    void addSubNode(long pos, Node<T> sub, int DIM) {
        int bufSubCount = this.getSubCount();
        int bufPostCount = this.getPostCount();
        if (!this.isSubNI() && Node.NI_THRESHOLD(bufSubCount, bufPostCount)) {
            this.niBuild(bufSubCount, bufPostCount, DIM);
        }
        if (this.isSubNI()) {
            this.niPut(pos, sub);
            this.setSubCount(bufSubCount + 1);
            return;
        }
        if (this.subNRef == null) {
            this.subNRef = Refs.newArray(Node.class, 2);
        }
        if (this.isSubHC()) {
            this.subNRef[(int)pos] = sub;
            this.setSubCount(bufSubCount + 1);
            return;
        }
        int subOffsBits = this.getBitPos_SubNodeIndex(DIM);
        if (DIM <= 31 && (long)(32 + Node.SIK_WIDTH(DIM)) * ((long)this.subNRef.length + 1L) >= 32L * (1L << DIM)) {
            Node[] na = Refs.newArray(Node.class, 1 << DIM);
            for (int i = 0; i < bufSubCount; ++i) {
                int posOld = (int)Bits.readArray(this.ba, subOffsBits + i * Node.SIK_WIDTH(DIM), Node.SIK_WIDTH(DIM));
                na[posOld] = this.subNRef[i];
            }
            this.subNRef = na;
            Bits.removeBits(this.ba, subOffsBits, bufSubCount * Node.SIK_WIDTH(DIM));
            this.setSubHC(true);
            this.subNRef[(int)pos] = sub;
            this.setSubCount(bufSubCount + 1);
            int reqSize = this.calcArraySizeTotalBits(bufPostCount, DIM);
            this.ba = Bits.arrayTrim(this.ba, reqSize);
            return;
        }
        int p2 = Bits.binarySearch(this.ba, subOffsBits, bufSubCount, pos, Node.SIK_WIDTH(DIM), 0);
        this.setSubCount(bufSubCount + 1);
        int start = -(p2 + 1);
        int len = bufSubCount + 1 - start - 1;
        if (this.subNRef.length < bufSubCount + 1) {
            int newLen = bufSubCount + 1;
            newLen = (newLen & 1) == 0 ? newLen : newLen + 1;
            Node[] na2 = Refs.newArray(Node.class, newLen);
            System.arraycopy(this.subNRef, 0, na2, 0, start);
            System.arraycopy(this.subNRef, start, na2, start + 1, len);
            this.subNRef = na2;
        } else {
            System.arraycopy(this.subNRef, start, this.subNRef, start + 1, len);
        }
        this.subNRef[start] = sub;
        this.ba = Bits.arrayEnsureSize(this.ba, this.calcArraySizeTotalBits(bufPostCount, DIM));
        Bits.insertBits(this.ba, subOffsBits + start * Node.SIK_WIDTH(DIM), Node.SIK_WIDTH(DIM));
        Bits.writeArray(this.ba, subOffsBits + start * Node.SIK_WIDTH(DIM), Node.SIK_WIDTH(DIM), pos);
    }

    public void replacePost(int pob, long pos, long[] newKey, T value) {
        if (this.isPostNI()) {
            this.niPut(pos, newKey, value);
            return;
        }
        long[] ia = this.ba;
        int offs = pob;
        for (long key : newKey) {
            Bits.writeArray(ia, offs, this.postLen, key);
            offs += this.postLen;
        }
    }

    void replaceSub(long pos, Node<T> newSub, int DIM) {
        if (this.isSubNI()) {
            this.niPut(pos, newSub);
            return;
        }
        if (this.isSubHC()) {
            this.subNRef[(int)pos] = newSub;
        } else {
            int subOffsBits = this.getBitPos_SubNodeIndex(DIM);
            int p2 = Bits.binarySearch(this.ba, subOffsBits, this.getSubCount(), pos, Node.SIK_WIDTH(DIM), 0);
            this.subNRef[p2] = newSub;
        }
    }

    void removeSub(long pos, int DIM) {
        int bufPostCnt;
        int bufSubCnt = this.getSubCount();
        if (this.isSubNI() && !Node.NI_THRESHOLD(bufSubCnt, bufPostCnt = this.getPostCount())) {
            this.niDeconstruct(DIM, pos, true);
            return;
        }
        if (this.isSubNI()) {
            this.niRemove(pos);
            this.setSubCount(bufSubCnt - 1);
            return;
        }
        bufPostCnt = this.getPostCount();
        long sizeHC = 32L * (1L << DIM);
        long sizeLin = (long)(32 + Node.SIK_WIDTH(DIM)) * ((long)this.subNRef.length - 1L);
        if (this.isSubHC() && sizeLin < sizeHC) {
            int prePostBits_SubHC = this.getBitPos_PostIndex(DIM);
            this.setSubHC(false);
            this.setSubCount(--bufSubCnt);
            int prePostBits_SubLHC = this.getBitPos_PostIndex(DIM);
            int bia2Size = this.calcArraySizeTotalBits(bufPostCnt, DIM);
            long[] bia2 = Bits.arrayCreate(bia2Size);
            Node[] sa2 = Refs.newArray(Node.class, bufSubCnt);
            int preSubBits = this.getBitPos_SubNodeIndex(DIM);
            Bits.copyBitsLeft(this.ba, 0, bia2, 0, preSubBits);
            int n = 0;
            int i = 0;
            while ((long)i < 1L << DIM) {
                if ((long)i != pos && this.subNRef[i] != null) {
                    sa2[n] = this.subNRef[i];
                    Bits.writeArray(bia2, preSubBits + n * Node.SIK_WIDTH(DIM), Node.SIK_WIDTH(DIM), i);
                    ++n;
                }
                ++i;
            }
            Bits.copyBitsLeft(this.ba, prePostBits_SubHC, bia2, prePostBits_SubLHC, bia2Size - prePostBits_SubLHC);
            this.ba = bia2;
            this.subNRef = sa2;
            return;
        }
        if (this.isSubHC()) {
            this.setSubCount(bufSubCnt - 1);
            this.subNRef[(int)pos] = null;
        } else {
            int subOffsBits = this.getBitPos_SubNodeIndex(DIM);
            int p2 = Bits.binarySearch(this.ba, subOffsBits, bufSubCnt, pos, Node.SIK_WIDTH(DIM), 0);
            this.setSubCount(bufSubCnt - 1);
            int len = bufSubCnt - p2 - 1;
            if (this.subNRef.length > bufSubCnt) {
                int newLen = bufSubCnt - 1;
                int n = newLen = (newLen & 1) == 0 ? newLen : newLen + 1;
                if (newLen > 0) {
                    Node[] na2 = Refs.newArray(Node.class, newLen);
                    System.arraycopy(this.subNRef, 0, na2, 0, p2);
                    System.arraycopy(this.subNRef, p2 + 1, na2, p2, len);
                    this.subNRef = na2;
                } else {
                    this.subNRef = null;
                }
            } else if (p2 + 1 < this.subNRef.length) {
                System.arraycopy(this.subNRef, p2 + 1, this.subNRef, p2, len);
            }
            int offsKey = this.getBitPos_SubNodeIndex(DIM) + Node.SIK_WIDTH(DIM) * p2;
            Bits.removeBits(this.ba, offsKey, Node.SIK_WIDTH(DIM));
            this.ba = Bits.arrayTrim(this.ba, this.calcArraySizeTotalBits(bufPostCnt, DIM));
        }
    }

    boolean postEqualsPOB(int offsPostKey, long hcPos, long[] key) {
        if (this.isPostNI()) {
            PhTree8.NodeEntry<T> e = this.niGet(hcPos);
            if (e == null) {
                return false;
            }
            long[] post = e.getKey();
            long mask = -1L << this.postLen ^ 0xFFFFFFFFFFFFFFFFL;
            for (int i = 0; i < key.length; ++i) {
                if (((post[i] ^ key[i]) & mask) == 0L) continue;
                return false;
            }
            return true;
        }
        long[] ia = this.ba;
        int offs = offsPostKey;
        long mask = -1L << this.postLen ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = 0; i < key.length; ++i) {
            long l = Bits.readArray(ia, offs + i * this.postLen, this.postLen);
            if (l == (key[i] & mask)) continue;
            return false;
        }
        return true;
    }

    boolean niContains(long hcPos) {
        return this.ind.contains(hcPos);
    }

    PhTree8.NodeEntry<T> niGet(long hcPos) {
        return this.ind.get(hcPos);
    }

    PhTree8.NodeEntry<T> niPut(long hcPos, long[] key, T value) {
        long[] copy = new long[key.length];
        System.arraycopy(key, 0, copy, 0, key.length);
        return this.ind.put(hcPos, this.createNodeEntry(copy, value));
    }

    PhTree8.NodeEntry<T> niPutNoCopy(long hcPos, long[] key, T value) {
        return this.ind.put(hcPos, this.createNodeEntry(key, value));
    }

    PhTree8.NodeEntry<T> niPut(long hcPos, Node<T> subNode) {
        return this.ind.put(hcPos, this.createNodeEntry(subNode));
    }

    PhTree8.NodeEntry<T> niRemove(long hcPos) {
        return this.ind.remove(hcPos);
    }

    boolean postEquals(long[] key1, long[] key2) {
        long mask = -1L << this.postLen ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = 0; i < key1.length; ++i) {
            if (((key1[i] ^ key2[i]) & mask) == 0L) continue;
            return false;
        }
        return true;
    }

    void addPost(long pos, long[] key, T value) {
        int DIM = key.length;
        if (this.isPostNI()) {
            this.addPostPOB(pos, -1, key, value);
            return;
        }
        int offsKey = this.getPostOffsetBits(pos, DIM);
        this.addPostPOB(pos, offsKey, key, value);
    }

    void addPostPOB(long pos, int offsPostKey, long[] key, T value) {
        int DIM = key.length;
        int bufSubCnt = this.getSubCount();
        int bufPostCnt = this.getPostCount();
        if (!this.isPostNI() && Node.NI_THRESHOLD(bufSubCnt, bufPostCnt)) {
            this.niBuild(bufSubCnt, bufPostCnt, DIM);
        }
        if (this.isPostNI()) {
            this.niPut(pos, key, value);
            this.setPostCount(bufPostCnt + 1);
            return;
        }
        if (this.values == null) {
            this.values = Refs.arrayCreate(1);
        }
        long sizeHC = (long)(DIM * this.postLen + 1) * (1L << DIM);
        long sizeLin = (long)(DIM * this.postLen + Node.PIK_WIDTH(DIM)) * ((long)bufPostCnt + 1L);
        if (!this.isPostHC() && DIM <= 31 && sizeLin >= sizeHC) {
            int prePostBits = this.getBitPos_PostIndex(DIM);
            this.setPostHC(true);
            long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(bufPostCnt + 1, DIM));
            T[] v2 = Refs.arrayCreate(1 << DIM);
            Bits.copyBitsLeft(this.ba, 0, bia2, 0, prePostBits);
            int postLenTotal = DIM * this.postLen;
            for (int i = 0; i < bufPostCnt; ++i) {
                int entryPosLHC = prePostBits + i * (Node.PIK_WIDTH(DIM) + postLenTotal);
                int p2 = (int)Bits.readArray(this.ba, entryPosLHC, Node.PIK_WIDTH(DIM));
                Bits.setBit(bia2, prePostBits + 1 * p2, true);
                Bits.copyBitsLeft(this.ba, entryPosLHC + Node.PIK_WIDTH(DIM), bia2, prePostBits + (1 << DIM) * 1 + postLenTotal * p2, postLenTotal);
                v2[p2] = this.values[i];
            }
            this.ba = bia2;
            this.values = v2;
            offsPostKey = this.getPostOffsetBits(pos, DIM);
        }
        offsPostKey = -(offsPostKey + 1);
        this.setPostCount(bufPostCnt + 1);
        if (this.isPostHC()) {
            for (int i = 0; i < key.length; ++i) {
                Bits.writeArray(this.ba, offsPostKey + this.postLen * i, this.postLen, key[i]);
            }
            int offsNN = this.getBitPos_PostIndex(DIM);
            Bits.setBit(this.ba, (int)((long)offsNN + 1L * pos), true);
            this.values[(int)pos] = value;
        } else if (!this.isPostNI()) {
            long[] ia = this.ba = Bits.arrayEnsureSize(this.ba, this.calcArraySizeTotalBits(bufPostCnt + 1, DIM));
            int offs = offsPostKey;
            Bits.insertBits(ia, offs - Node.PIK_WIDTH(DIM), Node.PIK_WIDTH(DIM) + DIM * this.postLen);
            Bits.writeArray(ia, offs - Node.PIK_WIDTH(DIM), Node.PIK_WIDTH(DIM), pos);
            for (int i = 0; i < DIM; ++i) {
                Bits.writeArray(ia, offs + this.postLen * i, this.postLen, key[i]);
            }
            this.values = Refs.arrayEnsureSize(this.values, bufPostCnt + 1);
            Refs.insertAtPos(this.values, this.offs2ValPos(offs, pos, DIM), value);
        } else {
            throw new IllegalStateException();
        }
    }

    long[] postToNI(int startBit, int postLen, int DIM) {
        long[] key = new long[DIM];
        int d = 0;
        while (d < key.length) {
            int n = d++;
            key[n] = key[n] | Bits.readArray(this.ba, startBit, postLen);
            startBit += postLen;
        }
        return key;
    }

    void postFromNI(long[] ia, int startBit, long[] key, int postLen) {
        for (int d = 0; d < key.length; ++d) {
            Bits.writeArray(ia, startBit + postLen * d, postLen, key[d]);
        }
    }

    CritBit64<PhTree8.NodeEntry<T>> createNiIndex() {
        return CritBit64.create();
    }

    void niBuild(int bufSubCnt, int bufPostCnt, int DIM) {
        long[] key;
        if (this.ind != null || this.isPostNI() || this.isSubNI()) {
            throw new IllegalStateException();
        }
        this.ind = this.createNiIndex();
        if (this.isPostHC()) {
            int prePostBitsKey = this.getBitPos_PostIndex(DIM);
            int prePostBitsVal = prePostBitsKey + (1 << DIM) * 1;
            int postLenTotal = DIM * this.postLen;
            int i = 0;
            while ((long)i < 1L << DIM) {
                if (Bits.getBit(this.ba, prePostBitsKey + 1 * i)) {
                    int postPosLHC = prePostBitsVal + i * postLenTotal;
                    key = this.postToNI(postPosLHC, this.postLen, DIM);
                    postPosLHC += DIM * this.postLen;
                    this.niPutNoCopy(i, key, this.values[i]);
                }
                ++i;
            }
        } else {
            int prePostBits;
            int postPosLHC = prePostBits = this.getBitPos_PostIndex(DIM);
            for (int i = 0; i < bufPostCnt; ++i) {
                long p2 = Bits.readArray(this.ba, postPosLHC, Node.PIK_WIDTH(DIM));
                key = this.postToNI(postPosLHC += Node.PIK_WIDTH(DIM), this.postLen, DIM);
                postPosLHC += DIM * this.postLen;
                this.niPutNoCopy(p2, key, this.values[i]);
            }
        }
        if (this.isSubHC()) {
            int i = 0;
            while ((long)i < 1L << DIM) {
                if (this.subNRef[i] != null) {
                    this.niPut(i, this.subNRef[i]);
                }
                ++i;
            }
        } else {
            int subOffsBits = this.getBitPos_SubNodeIndex(DIM);
            for (int i = 0; i < bufSubCnt; ++i) {
                long posOld = Bits.readArray(this.ba, subOffsBits, Node.SIK_WIDTH(DIM));
                subOffsBits += Node.SIK_WIDTH(DIM);
                this.niPut(posOld, this.subNRef[i]);
            }
        }
        this.setPostHC(false);
        this.setSubHC(false);
        this.setPostNI(true);
        this.setSubNI(true);
        this.ba = Bits.arrayTrim(this.ba, this.calcArraySizeTotalBitsNI(DIM));
        this.subNRef = null;
        this.values = null;
    }

    T niDeconstruct(int DIM, long posToRemove, boolean removeSub) {
        Iterator it;
        int newPostCnt;
        int newSubCnt;
        if (this.ind == null || !this.isPostNI() || !this.isSubNI()) {
            throw new IllegalStateException();
        }
        this.setPostNI(false);
        this.setSubNI(false);
        if (removeSub) {
            newSubCnt = this.getSubCount() - 1;
            newPostCnt = this.getPostCount();
            this.setSubCount(newSubCnt);
        } else {
            newSubCnt = this.getSubCount();
            newPostCnt = this.getPostCount() - 1;
            this.setPostCount(newPostCnt);
        }
        long sizePostHC = (long)(DIM * this.postLen + 1) * (1L << DIM);
        long sizePostLin = (DIM * this.postLen + Node.PIK_WIDTH(DIM)) * newPostCnt;
        boolean isPostHC = DIM <= 31 && sizePostLin >= sizePostHC;
        this.setPostHC(isPostHC);
        if (DIM <= 31 && (long)((32 + Node.SIK_WIDTH(DIM)) * newSubCnt) >= 32L * (1L << DIM)) {
            Node[] na = Refs.newArray(Node.class, 1 << DIM);
            Iterator it2 = this.ind.iterator();
            while (((CritBit64.CBIterator)it2).hasNext()) {
                CritBit64.Entry e = ((CritBit64.CBIterator)it2).nextEntry();
                if (((PhTree8.NodeEntry)e.value()).node == null || e.key() == posToRemove) continue;
                na[(int)e.key()] = ((PhTree8.NodeEntry)e.value()).node;
            }
            this.subNRef = na;
            this.setSubHC(true);
        } else {
            this.setSubHC(false);
            int bia2Size = this.calcArraySizeTotalBits(newPostCnt, DIM);
            long[] bia2 = Bits.arrayCreate(bia2Size);
            Node[] sa2 = Refs.newArray(Node.class, newSubCnt);
            int preSubBits = this.getBitPos_SubNodeIndex(DIM);
            Bits.copyBitsLeft(this.ba, 0, bia2, 0, preSubBits);
            int n = 0;
            Iterator it3 = this.ind.iterator();
            while (((CritBit64.CBIterator)it3).hasNext()) {
                long pos;
                CritBit64.Entry e = ((CritBit64.CBIterator)it3).nextEntry();
                if (((PhTree8.NodeEntry)e.value()).node == null || (pos = e.key()) == posToRemove) continue;
                sa2[n] = ((PhTree8.NodeEntry)e.value()).node;
                Bits.writeArray(bia2, preSubBits + n * Node.SIK_WIDTH(DIM), Node.SIK_WIDTH(DIM), pos);
                ++n;
            }
            this.ba = bia2;
            this.subNRef = sa2;
        }
        T oldValue = null;
        int prePostBits = this.getBitPos_PostIndex(DIM);
        long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(newPostCnt, DIM));
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, prePostBits);
        int postLenTotal = DIM * this.postLen;
        if (isPostHC) {
            T[] v2 = Refs.arrayCreate(1 << DIM);
            int startBitBase = prePostBits + (1 << DIM) * 1;
            it = this.ind.iterator();
            while (((CritBit64.CBIterator)it).hasNext()) {
                CritBit64.Entry e = ((CritBit64.CBIterator)it).nextEntry();
                if (((PhTree8.NodeEntry)e.value()).getKey() == null) continue;
                if (e.key() == posToRemove) {
                    oldValue = ((PhTree8.NodeEntry)e.value()).getValue();
                    continue;
                }
                int p2 = (int)e.key();
                Bits.setBit(bia2, prePostBits + 1 * p2, true);
                int startBit = startBitBase + postLenTotal * p2;
                this.postFromNI(bia2, startBit, ((PhTree8.NodeEntry)e.value()).getKey(), this.postLen);
                v2[p2] = ((PhTree8.NodeEntry)e.value()).getValue();
            }
            this.ba = bia2;
            this.values = v2;
        } else {
            T[] v2 = Refs.arrayCreate(newPostCnt);
            int n = 0;
            it = this.ind.iterator();
            int entryPosLHC = prePostBits;
            while (((CritBit64.CBIterator)it).hasNext()) {
                CritBit64.Entry e = ((CritBit64.CBIterator)it).nextEntry();
                long pos = e.key();
                if (((PhTree8.NodeEntry)e.value()).getKey() == null) continue;
                if (pos == posToRemove) {
                    oldValue = ((PhTree8.NodeEntry)e.value()).getValue();
                    continue;
                }
                v2[n] = ((PhTree8.NodeEntry)e.value()).getValue();
                Bits.writeArray(bia2, entryPosLHC, Node.PIK_WIDTH(DIM), pos);
                this.postFromNI(bia2, entryPosLHC += Node.PIK_WIDTH(DIM), ((PhTree8.NodeEntry)e.value()).getKey(), this.postLen);
                entryPosLHC += postLenTotal;
                ++n;
            }
            this.ba = bia2;
            this.values = v2;
        }
        if (newPostCnt == 0) {
            this.values = null;
        }
        this.ind = null;
        return oldValue;
    }

    T getPostPOB(int offsPostKey, long pos, long[] key) {
        if (this.isPostNI()) {
            long mask = -1L << this.postLen;
            PhTree8.NodeEntry<T> e = this.niGet(pos);
            long[] eKey = e.getKey();
            for (int i = 0; i < key.length; ++i) {
                int n = i;
                key[n] = key[n] & mask;
                int n2 = i;
                key[n2] = key[n2] | eKey[i];
            }
            return e.getValue();
        }
        long[] ia = this.ba;
        int offs = offsPostKey;
        int valPos = this.offs2ValPos(offs, pos, key.length);
        long mask = -1L << this.postLen;
        int i = 0;
        while (i < key.length) {
            int n = i;
            key[n] = key[n] & mask;
            int n3 = i++;
            key[n3] = key[n3] | Bits.readArray(ia, offs, this.postLen);
            offs += this.postLen;
        }
        return this.values[valPos];
    }

    PhTree8.NodeEntry<T> getPostPOB(int offsPostKey, long hcPos, long[] key, long[] rangeMin, long[] rangeMax) {
        long[] ia = this.ba;
        int offs = offsPostKey;
        long mask = -1L << this.postLen;
        for (int i = 0; i < key.length; ++i) {
            int n = i;
            key[n] = key[n] & mask;
            int n2 = i;
            key[n2] = key[n2] | Bits.readArray(ia, offs, this.postLen);
            if (key[i] < rangeMin[i] || key[i] > rangeMax[i]) {
                return null;
            }
            offs += this.postLen;
        }
        int valPos = this.offs2ValPos(offsPostKey, hcPos, key.length);
        return this.createNodeEntry(key, this.values[valPos]);
    }

    boolean getPostPOB(int offsPostKey, long hcPos, PhEntry<T> e, long[] rangeMin, long[] rangeMax) {
        long[] ia = this.ba;
        int offs = offsPostKey;
        long[] key = e.getKey();
        long mask = -1L << this.postLen;
        for (int i = 0; i < key.length; ++i) {
            int n = i;
            key[n] = key[n] & mask;
            int n2 = i;
            key[n2] = key[n2] | Bits.readArray(ia, offs, this.postLen);
            if (key[i] < rangeMin[i] || key[i] > rangeMax[i]) {
                return false;
            }
            offs += this.postLen;
        }
        int valPos = this.offs2ValPos(offsPostKey, hcPos, key.length);
        e.setValue(this.values[valPos]);
        return true;
    }

    PhTree8.NodeEntry<T> getPostPOB_E(int offsPostKey, long hcPos, long[] key) {
        long[] ia = this.ba;
        int offs = offsPostKey;
        long mask = -1L << this.postLen;
        int i = 0;
        while (i < key.length) {
            int n = i;
            key[n] = key[n] & mask;
            int n2 = i++;
            key[n2] = key[n2] | Bits.readArray(ia, offs, this.postLen);
            offs += this.postLen;
        }
        int valPos = this.offs2ValPos(offsPostKey, hcPos, key.length);
        return this.createNodeEntry(key, this.values[valPos]);
    }

    PhEntry<T> getPostPOB(int offsPostKey, long hcPos, int DIM, long[] valTemplate, long[] rangeMin, long[] rangeMax, int[] minToCheck, int[] maxToCheck) {
        int i;
        int n;
        long[] ia = this.ba;
        int valPos = this.offs2ValPos(offsPostKey, hcPos, DIM);
        T val = this.values[valPos];
        if (val instanceof PhEntry) {
            long[] key = ((PhEntry)val).getKey();
            for (int i2 : minToCheck) {
                if (key[i2] >= rangeMin[i2]) continue;
                return null;
            }
            for (int i2 : maxToCheck) {
                if (key[i2] <= rangeMax[i2]) continue;
                return null;
            }
            return (PhEntry)val;
        }
        long[] key = new long[DIM];
        System.arraycopy(valTemplate, 0, key, 0, DIM);
        PhTreeHelper.applyHcPos(hcPos, this.postLen, key);
        long mask = -1L << this.postLen;
        int[] nArray = minToCheck;
        int i3 = nArray.length;
        for (n = 0; n < i3; ++n) {
            int n2 = i = nArray[n];
            key[n2] = key[n2] & mask;
            int n3 = i;
            key[n3] = key[n3] | Bits.readArray(ia, offsPostKey + i * this.postLen, this.postLen);
            if (key[i] >= rangeMin[i]) continue;
            return null;
        }
        nArray = maxToCheck;
        i3 = nArray.length;
        for (n = 0; n < i3; ++n) {
            int n4 = i = nArray[n];
            key[n4] = key[n4] & mask;
            int n5 = i;
            key[n5] = key[n5] | Bits.readArray(ia, offsPostKey + i * this.postLen, this.postLen);
            if (key[i] <= rangeMax[i]) continue;
            return null;
        }
        int offs = offsPostKey;
        i3 = 0;
        while (i3 < key.length) {
            int n6 = i3;
            key[n6] = key[n6] & mask;
            int n7 = i3++;
            key[n7] = key[n7] | Bits.readArray(ia, offs, this.postLen);
            offs += this.postLen;
        }
        return this.createNodeEntry(key, val);
    }

    PhEntry<T> getPostPOBNoCheck(int offsPostKey, long hcPos, int DIM, long[] valTemplate, long[] rangeMin, long[] rangeMax) {
        int valPos = this.offs2ValPos(offsPostKey, hcPos, DIM);
        T val = this.values[valPos];
        if (val instanceof PhEntry) {
            return (PhEntry)val;
        }
        long[] key = new long[DIM];
        System.arraycopy(valTemplate, 0, key, 0, DIM);
        PhTreeHelper.applyHcPos(hcPos, this.postLen, key);
        long[] ia = this.ba;
        int offs = offsPostKey;
        long mask = -1L << this.postLen;
        int i = 0;
        while (i < key.length) {
            int n = i;
            key[n] = key[n] & mask;
            int n2 = i++;
            key[n2] = key[n2] | Bits.readArray(ia, offs, this.postLen);
            offs += this.postLen;
        }
        return new PhEntry<T>(key, val);
    }

    T getPostValuePOB(int offs, long pos, int DIM) {
        if (!this.isPostNI()) {
            int valPos = this.offs2ValPos(offs, pos, DIM);
            return this.values[valPos];
        }
        return this.niGet(pos).getValue();
    }

    T updatePostValuePOB(int offs, long pos, long[] key, int DIM, T value) {
        if (!this.isPostNI()) {
            int valPos = this.offs2ValPos(offs, pos, DIM);
            T old = this.values[valPos];
            this.values[valPos] = value;
            return old;
        }
        PhTree8.NodeEntry<T> e = this.niPutNoCopy(pos, key, value);
        return e == null ? null : (T)e.getValue();
    }

    T getPostValue(long pos, int DIM) {
        if (this.isPostHC()) {
            return this.getPostValuePOB(-1, pos, -1);
        }
        int offs = this.getPostOffsetBits(pos, DIM);
        return this.getPostValuePOB(offs, pos, DIM);
    }

    T getPost(long pos, long[] key) {
        if (this.isPostNI()) {
            return this.getPostPOB(-1, pos, key);
        }
        int DIM = key.length;
        int offs = this.getPostOffsetBits(pos, DIM);
        return this.getPostPOB(offs, pos, key);
    }

    T removePostPOB(long pos, int offsPostKey, int DIM) {
        int bufPostCnt = this.getPostCount();
        int bufSubCnt = this.getSubCount();
        if (this.isPostNI() && !Node.NI_THRESHOLD(bufSubCnt, bufPostCnt)) {
            T v = this.niDeconstruct(DIM, pos, false);
            return v;
        }
        if (this.isPostNI()) {
            this.setPostCount(bufPostCnt - 1);
            return this.niRemove(pos).getValue();
        }
        T oldVal = null;
        long sizeHC = (long)(DIM * this.postLen + 1) * (1L << DIM);
        long sizeLin = (long)(DIM * this.postLen + Node.PIK_WIDTH(DIM)) * ((long)bufPostCnt - 1L);
        if (this.isPostHC() && sizeLin < sizeHC) {
            this.setPostHC(false);
            long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(bufPostCnt - 1, DIM));
            T[] v2 = Refs.arrayCreate(bufPostCnt);
            int prePostBits = this.getBitPos_PostIndex(DIM);
            int prePostBitsVal = prePostBits + (1 << DIM) * 1;
            Bits.copyBitsLeft(this.ba, 0, bia2, 0, prePostBits);
            int postLenTotal = DIM * this.postLen;
            int n = 0;
            int i = 0;
            while ((long)i < 1L << DIM) {
                if ((long)i == pos) {
                    oldVal = this.values[i];
                } else if (Bits.getBit(this.ba, prePostBits + 1 * i)) {
                    int entryPosLHC = prePostBits + n * (Node.PIK_WIDTH(DIM) + postLenTotal);
                    Bits.writeArray(bia2, entryPosLHC, Node.PIK_WIDTH(DIM), i);
                    Bits.copyBitsLeft(this.ba, prePostBitsVal + postLenTotal * i, bia2, entryPosLHC + Node.PIK_WIDTH(DIM), postLenTotal);
                    v2[n] = this.values[i];
                    ++n;
                }
                ++i;
            }
            this.ba = bia2;
            this.values = v2;
            this.setPostCount(bufPostCnt - 1);
            if (bufPostCnt - 1 == 0) {
                this.values = null;
            }
            return oldVal;
        }
        this.setPostCount(bufPostCnt - 1);
        if (this.isPostHC()) {
            int offsNN = this.getBitPos_PostIndex(DIM);
            Bits.setBit(this.ba, (int)((long)offsNN + 1L * pos), false);
            oldVal = this.values[(int)pos];
            this.values[(int)pos] = null;
        } else if (!this.isPostNI()) {
            Bits.removeBits(this.ba, offsPostKey - Node.PIK_WIDTH(DIM), Node.PIK_WIDTH(DIM) + DIM * this.postLen);
            this.ba = Bits.arrayTrim(this.ba, this.calcArraySizeTotalBits(bufPostCnt - 1, DIM));
            int valPos = this.offs2ValPos(offsPostKey, pos, DIM);
            oldVal = this.values[valPos];
            Refs.removeAtPos(this.values, valPos);
            this.values = Refs.arrayTrim(this.values, bufPostCnt - 1);
        } else {
            throw new IllegalStateException();
        }
        if (bufPostCnt - 1 == 0) {
            this.values = null;
        }
        return oldVal;
    }

    boolean isPostHC() {
        return (this.isHC & 2) != 0;
    }

    void setPostHC(boolean b) {
        this.isHC = (byte)(b ? this.isHC | 2 : this.isHC & 0xFFFFFFFD);
    }

    boolean isSubHC() {
        return (this.isHC & 1) != 0;
    }

    void setSubHC(boolean b) {
        this.isHC = (byte)(b ? this.isHC | 1 : this.isHC & 0xFFFFFFFE);
    }

    boolean isSubLHC() {
        return (this.isHC & 5) == 0;
    }

    boolean isPostLHC() {
        return (this.isHC & 6) == 0;
    }

    boolean isPostNI() {
        return (this.isHC & 4) != 0;
    }

    void setPostNI(boolean b) {
        this.isHC = (byte)(b ? this.isHC | 4 : this.isHC & 0xFFFFFFFB);
    }

    boolean isSubNI() {
        return this.isPostNI();
    }

    void setSubNI(boolean b) {
        this.setPostNI(b);
    }

    int getPostCount() {
        return this.postCnt;
    }

    void setPostCount(int cnt) {
        this.postCnt = cnt;
    }

    int getSubCount() {
        return this.subCnt;
    }

    void setSubCount(int cnt) {
        this.subCnt = cnt;
    }

    int getBitPos_PostIndex(int DIM) {
        int offsOfSubs = 0;
        if (this.isSubLHC()) {
            offsOfSubs = this.getSubCount() * Node.SIK_WIDTH(DIM);
        }
        return this.getBitPos_SubNodeIndex(DIM) + offsOfSubs;
    }

    int getBitPos_SubNodeIndex(int DIM) {
        return this.getBitPos_Infix() + this.infixLen * DIM;
    }

    int getBitPos_Infix() {
        return 0;
    }

    private int offs2ValPos(int offs, long pos, int DIM) {
        if (this.isPostHC()) {
            return (int)pos;
        }
        int offsInd = this.getBitPos_PostIndex(DIM);
        int valPos = (offs - Node.PIK_WIDTH(DIM) - offsInd) / (this.postLen * DIM + Node.PIK_WIDTH(DIM));
        return valPos;
    }

    int getPostOffsetBits(long pos, int DIM) {
        int offsInd = this.getBitPos_PostIndex(DIM);
        if (this.isPostHC()) {
            int posInt = (int)pos;
            boolean notNull = Bits.getBit(this.ba, offsInd + 1 * posInt);
            offsInd += 1 * (1 << DIM);
            if (!notNull) {
                return -(posInt * this.postLen * DIM + offsInd) - 1;
            }
            return posInt * this.postLen * DIM + offsInd;
        }
        if (!this.isPostNI()) {
            int p2 = Bits.binarySearch(this.ba, offsInd, this.getPostCount(), pos, Node.PIK_WIDTH(DIM), DIM * this.postLen);
            if (p2 < 0) {
                p2 = -(p2 + 1);
                p2 *= Node.PIK_WIDTH(DIM) + this.postLen * DIM;
                return -((p2 += Node.PIK_WIDTH(DIM)) + offsInd) - 1;
            }
            return p2 * (Node.PIK_WIDTH(DIM) + this.postLen * DIM) + offsInd + Node.PIK_WIDTH(DIM);
        }
        return Integer.MAX_VALUE;
    }

    boolean hasPostFix(long pos, int DIM) {
        if (!this.isPostNI()) {
            return this.getPostOffsetBits(pos, DIM) >= 0;
        }
        PhTree8.NodeEntry<T> e = this.niGet(pos);
        return e != null && e.getKey() != null;
    }

    public void adjustInfix(long[] prefix, int infixLenOfParent, int postLenOfParent, long hcPos) {
        PhTreeHelper.applyHcPos(hcPos, postLenOfParent, prefix);
        this.getInfixNoOverwrite(prefix);
        int DIM = prefix.length;
        int infOffs = this.getBitPos_Infix();
        int newInfixLen = infixLenOfParent + 1 + this.getInfixLen();
        this.setInfixLen(newInfixLen);
        this.ba = Bits.arrayEnsureSize(this.ba, this.calcArraySizeTotalBits(this.getPostCount(), DIM));
        Bits.insertBits(this.ba, infOffs, DIM * (infixLenOfParent + 1));
        this.writeInfix(prefix);
    }

    int getInfixLen() {
        return this.infixLen;
    }

    void setInfixLen(int newInfLen) {
        this.infixLen = (byte)newInfLen;
    }

    int getPostLen() {
        return this.postLen;
    }

    Node<T> subNRef(int pos) {
        return this.subNRef[pos];
    }

    CritBit64<PhTree8.NodeEntry<T>> ind() {
        return this.ind;
    }

    CritBit64.CBIterator<PhTree8.NodeEntry<T>> niIterator() {
        return this.ind.iterator();
    }

    Node<T>[] subNRef() {
        return this.subNRef;
    }

    boolean isRemoved() {
        throw new UnsupportedOperationException();
    }

    void setRemoved(boolean removed) {
    }
}

