/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v8;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceL;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhFilterDistance;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeConfig;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import ch.ethz.globis.phtree.v8.Bits;
import ch.ethz.globis.phtree.v8.Node;
import ch.ethz.globis.phtree.v8.NodeIteratorListReuse;
import ch.ethz.globis.phtree.v8.PhIteratorFullNoGC;
import ch.ethz.globis.phtree.v8.PhIteratorNoGC;
import ch.ethz.globis.phtree.v8.PhOperations;
import ch.ethz.globis.phtree.v8.PhOperationsSimple;
import ch.ethz.globis.phtree.v8.PhQueryKnnMbbPP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class PhTree8<T>
implements PhTree<T> {
    static final boolean HCI_ENABLED = true;
    static final int DEPTH_64 = 64;
    private final int DIM;
    private final AtomicInteger nEntries = new AtomicInteger();
    private final AtomicInteger nNodes = new AtomicInteger();
    static final int UNKNOWN = -1;
    private PhOperations<T> operations = new PhOperationsSimple(this);
    final long[] MIN;
    private final long[] MAX;
    private Node<T> root = null;

    Node<T> getRoot() {
        return this.root;
    }

    void changeRoot(Node<T> newRoot) {
        this.root = newRoot;
    }

    public PhTree8(int dim) {
        this.DIM = dim;
        this.MIN = new long[this.DIM];
        Arrays.fill(this.MIN, Long.MIN_VALUE);
        this.MAX = new long[this.DIM];
        Arrays.fill(this.MAX, Long.MAX_VALUE);
        PhTreeHelper.debugCheck();
    }

    public PhTree8(PhTreeConfig cnf) {
        this.DIM = cnf.getDimActual();
        this.MIN = new long[this.DIM];
        this.MAX = new long[this.DIM];
        Arrays.fill(this.MAX, Long.MAX_VALUE);
        Arrays.fill(this.MIN, Long.MIN_VALUE);
        PhTreeHelper.debugCheck();
    }

    void increaseNrNodes() {
        this.nNodes.incrementAndGet();
    }

    void decreaseNrNodes() {
        this.nNodes.decrementAndGet();
    }

    void increaseNrEntries() {
        this.nEntries.incrementAndGet();
    }

    void decreaseNrEntries() {
        this.nEntries.decrementAndGet();
    }

    @Override
    public int size() {
        return this.nEntries.get();
    }

    @Override
    public PhTreeStats getStats() {
        if (this.getRoot() == null) {
            return new PhTreeStats(64);
        }
        return this.getQuality(0, this.getRoot(), new PhTreeStats(64));
    }

    private PhTreeStats getQuality(int currentDepth, Node<T> node, PhTreeStats stats) {
        ++stats.nNodes;
        if (node.isPostHC()) {
            ++stats.nAHC;
        }
        if (node.isSubHC()) {
            ++stats.nNtNodes;
        }
        if (node.isPostNI()) {
            ++stats.nNT;
        }
        int n = node.getInfixLen();
        stats.infixHist[n] = stats.infixHist[n] + 1;
        int n2 = currentDepth;
        stats.nodeDepthHist[n2] = stats.nodeDepthHist[n2] + 1;
        int size = node.getPostCount() + node.getSubCount();
        int n3 = 32 - Integer.numberOfLeadingZeros(size);
        stats.nodeSizeLogHist[n3] = stats.nodeSizeLogHist[n3] + 1;
        stats.q_totalDepth += (currentDepth += node.getInfixLen());
        if (node.subNRef() != null) {
            for (Node<T> sub : node.subNRef()) {
                if (sub == null) continue;
                this.getQuality(currentDepth + 1, sub, stats);
            }
        } else if (node.ind() != null) {
            for (NodeEntry nodeEntry : node.ind()) {
                if (nodeEntry.node == null) continue;
                this.getQuality(currentDepth + 1, nodeEntry.node, stats);
            }
        }
        int n4 = currentDepth;
        stats.q_nPostFixN[n4] = stats.q_nPostFixN[n4] + node.getPostCount();
        return stats;
    }

    @Override
    public T put(long[] key, T value) {
        return this.operations.put(key, value);
    }

    void insertRoot(long[] key, T value) {
        this.root = this.operations.createNode(this, 0, 63, 1);
        long pos = PhTreeHelper.posInArray(key, this.root.getPostLen());
        this.root.addPost(pos, key, value);
        this.increaseNrEntries();
    }

    @Override
    public boolean contains(long ... key) {
        if (this.getRoot() == null) {
            return false;
        }
        return this.contains(key, this.getRoot());
    }

    private boolean contains(long[] key, Node<T> node) {
        if (node.getInfixLen() > 0) {
            long mask = -1L << node.getInfixLen() ^ 0xFFFFFFFFFFFFFFFFL;
            int shiftMask = node.getPostLen() + 1;
            mask = shiftMask == 64 ? 0L : mask << shiftMask;
            for (int i = 0; i < key.length; ++i) {
                if (((key[i] ^ node.getInfix(i)) & mask) == 0L) continue;
                return false;
            }
        }
        long pos = PhTreeHelper.posInArray(key, node.getPostLen());
        if (node.isPostNI()) {
            NodeEntry<T> e = node.getChildNI(pos);
            if (e == null) {
                return false;
            }
            if (e.node != null) {
                return this.contains(key, e.node);
            }
            return node.postEquals(e.getKey(), key);
        }
        Node<T> sub = node.getSubNode(pos, this.DIM);
        if (sub != null) {
            return this.contains(key, sub);
        }
        int pob = node.getPostOffsetBits(pos, this.DIM);
        if (pob >= 0) {
            return node.postEqualsPOB(pob, pos, key);
        }
        return false;
    }

    @Override
    public T get(long ... key) {
        if (this.getRoot() == null) {
            return null;
        }
        return this.get(key, this.getRoot());
    }

    private T get(long[] key, Node<T> node) {
        long pos;
        Node<T> sub;
        if (node.getInfixLen() > 0) {
            long mask = (1L << node.getInfixLen()) - 1L;
            int shiftMask = node.getPostLen() + 1;
            mask = shiftMask == 64 ? 0L : mask << shiftMask;
            for (int i = 0; i < key.length; ++i) {
                if (((key[i] ^ node.getInfix(i)) & mask) == 0L) continue;
                return null;
            }
        }
        if ((sub = node.getSubNode(pos = PhTreeHelper.posInArray(key, node.getPostLen()), this.DIM)) != null) {
            return this.get(key, sub);
        }
        int pob = node.getPostOffsetBits(pos, this.DIM);
        if (pob >= 0 && node.postEqualsPOB(pob, pos, key)) {
            return node.getPostValuePOB(pob, pos, this.DIM);
        }
        return null;
    }

    @Override
    public T remove(long ... key) {
        return this.operations.remove(key);
    }

    int getConflictingInfixBits(long[] key, long[] infix, Node<T> node) {
        if (node.getInfixLen() == 0) {
            return 0;
        }
        long mask = (1L << node.getInfixLen()) - 1L;
        int maskOffset = node.getPostLen() + 1;
        mask = maskOffset == 64 ? 0L : mask << maskOffset;
        return PhTreeHelper.getMaxConflictingBitsWithMask(key, infix, mask);
    }

    long posInArrayFromInfixes(Node<T> node, int infixInternalOffset) {
        long pos = 0L;
        for (int i = 0; i < this.DIM; ++i) {
            pos <<= 1;
            pos |= node.getInfixBit(i, infixInternalOffset);
        }
        return pos;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " HCI-on=" + true + " DEBUG=" + false;
    }

    @Override
    public String toStringPlain() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringPlain(sb, this.getRoot(), new long[this.DIM]);
        }
        return sb.toString();
    }

    private void toStringPlain(StringBuilderLn sb, Node<T> node, long[] key) {
        node.getInfix(key);
        int i = 0;
        while ((long)i < 1L << this.DIM) {
            PhTreeHelper.applyHcPos(i, node.getPostLen(), key);
            Node<T> sub = node.getSubNode(i, this.DIM);
            if (sub != null) {
                this.toStringPlain(sb, sub, key);
            }
            if (node.hasPostFix(i, this.DIM)) {
                node.getPost(i, key);
                sb.append(Bits.toBinary(key, 64));
                sb.appendLn("  v=" + node.getPostValue(i, this.DIM));
            }
            ++i;
        }
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringTree(sb, 0, this.getRoot(), new long[this.DIM], true);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, int currentDepth, Node<T> node, long[] key, boolean printValue) {
        int i;
        String ind = "*";
        for (i = 0; i < currentDepth; ++i) {
            ind = ind + "-";
        }
        sb.append(ind + "il=" + node.getInfixLen() + " io=" + (node.getPostLen() + 1) + " sc=" + node.getSubCount() + " pc=" + node.getPostCount() + " inf=[");
        node.getInfix(key);
        if (node.getInfixLen() > 0) {
            long[] inf = new long[this.DIM];
            node.getInfix(inf);
            sb.append(Bits.toBinary(inf, 64));
            currentDepth += node.getInfixLen();
        }
        sb.appendLn("]");
        i = 0;
        while ((long)i < 1L << this.DIM) {
            PhTreeHelper.applyHcPos(i, node.getPostLen(), key);
            Node<T> sub = node.getSubNode(i, this.DIM);
            if (sub != null) {
                sb.appendLn(ind + "# " + i + "  +");
                this.toStringTree(sb, currentDepth + 1, sub, key, printValue);
            }
            if (node.hasPostFix(i, this.DIM)) {
                T v = node.getPost(i, key);
                sb.append(ind + Bits.toBinary(key, 64));
                if (printValue) {
                    sb.append("  v=" + v);
                }
                sb.appendLn("");
            }
            ++i;
        }
    }

    @Override
    public PhTree.PhExtent<T> queryExtent() {
        return new PhIteratorFullNoGC(this, null).reset();
    }

    @Override
    public PhTree.PhQuery<T> query(long[] min2, long[] max) {
        if (min2.length != this.DIM || max.length != this.DIM) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min2.length + " / " + max.length + "  DIM=" + this.DIM);
        }
        PhIteratorNoGC q = new PhIteratorNoGC(this, null);
        q.reset(min2, max);
        return q;
    }

    @Override
    public List<PhEntry<T>> queryAll(long[] min2, long[] max) {
        return this.queryAll(min2, max, Integer.MAX_VALUE, null, PhMapper.PVENTRY());
    }

    @Override
    public <R> List<R> queryAll(long[] min2, long[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        if (min2.length != this.DIM || max.length != this.DIM) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min2.length + " / " + max.length + "  DIM=" + this.DIM);
        }
        if (this.getRoot() == null) {
            return new ArrayList();
        }
        ArrayList<R> list = NodeIteratorListReuse.query(this.root, min2, max, this.DIM, maxResults, filter, mapper);
        return list;
    }

    static final <T> boolean checkAndApplyInfix(Node<T> node, long[] valTemplate, long[] rangeMin, long[] rangeMax) {
        int infixLen = node.getInfixLen();
        if (infixLen > 0) {
            int postLen = node.getPostLen();
            long maskClean = -1L << postLen + infixLen;
            maskClean <<= 1;
            long compMask = -1L << postLen + 1;
            for (int dim = 0; dim < valTemplate.length; ++dim) {
                long in = node.getInfix(dim);
                valTemplate[dim] = valTemplate[dim] & maskClean | in;
                if (valTemplate[dim] <= rangeMax[dim] && valTemplate[dim] >= (rangeMin[dim] & compMask)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getDim() {
        return this.DIM;
    }

    @Override
    public int getBitDepth() {
        return 64;
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, long ... v) {
        return new PhQueryKnnMbbPP(this).reset(nMin, PhDistanceL.THIS, v);
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, PhDistance dist, PhFilter dimsFilter, long ... center) {
        return new PhQueryKnnMbbPP(this).reset(nMin, dist, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, long ... center) {
        return this.rangeQuery(dist, null, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, PhDistance optionalDist, long ... center) {
        PhFilterDistance filter = new PhFilterDistance();
        if (optionalDist == null) {
            optionalDist = PhDistanceL.THIS;
        }
        filter.set(center, optionalDist, dist);
        PhIteratorNoGC q = new PhIteratorNoGC(this, filter);
        PhRangeQuery qr = new PhRangeQuery(q, this, optionalDist, filter);
        qr.reset(dist, center);
        return qr;
    }

    @Override
    public T update(long[] oldKey, long[] newKey) {
        return this.operations.update(oldKey, newKey);
    }

    @Override
    public void clear() {
        this.root = null;
        this.nEntries.set(0);
        this.nNodes.set(0);
    }

    void adjustCounts(int deletedPosts, int deletedNodes) {
        this.nEntries.addAndGet(-deletedPosts);
        this.nNodes.addAndGet(-deletedNodes);
    }

    static long inc(long v, long min2, long max) {
        long r = v | max ^ 0xFFFFFFFFFFFFFFFFL;
        return ++r & max | min2;
    }

    static final class NodeEntry<T>
    extends PhEntry<T> {
        transient ReentrantLock lock;
        Node<T> node;

        NodeEntry(long[] key, T value, boolean useLock) {
            super(key, value);
            this.node = null;
            this.lock = useLock ? new ReentrantLock() : null;
        }

        NodeEntry(Node<T> node, boolean useLock) {
            super(null, null);
            this.node = node;
            this.lock = useLock ? new ReentrantLock() : null;
        }

        void setNode(Node<T> node) {
            this.set(null, null);
            this.node = node;
        }

        void setPost(long[] key, T val) {
            this.set(key, val);
            this.node = null;
        }
    }
}

