/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRddTool;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.sedona.core.enums.IndexType;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.STRtree;

public final class IndexBuilder<T extends Geometry>
implements FlatMapFunction<Iterator<T>, SpatialIndex> {
    IndexType indexType;

    public IndexBuilder(IndexType indexType) {
        this.indexType = indexType;
    }

    public Iterator<SpatialIndex> call(Iterator<T> objectIterator) throws Exception {
        Serializable spatialIndex = this.indexType == IndexType.RTREE ? new STRtree() : new Quadtree();
        while (objectIterator.hasNext()) {
            Geometry spatialObject = (Geometry)objectIterator.next();
            spatialIndex.insert(spatialObject.getEnvelopeInternal(), spatialObject);
        }
        HashSet<Serializable> result = new HashSet<Serializable>();
        spatialIndex.query(new Envelope(0.0, 0.0, 0.0, 0.0));
        result.add(spatialIndex);
        return result.iterator();
    }
}

