/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.R2Edge;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2IndexCellData;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Predicates;
import org.apache.sedona.shaded.s2.S2Projections;
import org.apache.sedona.shaded.s2.S2RobustCrossProd;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.UVEdgeClipper;
import org.apache.sedona.shaded.s2.primitives.PooledList;
import org.jspecify.annotations.Nullable;

public final class S2RobustCellClipper {
    public static final double MAX_ERROR = 6.106226635438361E-16 + S2EdgeUtil.FACE_CLIP_ERROR_UV_COORD;
    private final Options options;
    private S2Cell cell = null;
    private final S2Shape.MutableEdge[] boundaries = new S2Shape.MutableEdge[]{new S2Shape.MutableEdge(), new S2Shape.MutableEdge(), new S2Shape.MutableEdge(), new S2Shape.MutableEdge()};
    private final double[] uvcoords = new double[4];
    private final S2Point[] normals = new S2Point[4];
    private S2Point cellCenter;
    private S2Point outside;
    private final UVEdgeClipper clipper = new UVEdgeClipper();
    private final PooledList<Crossing> crossings = new PooledList<Crossing>(Crossing::new);
    private boolean needSorting = false;
    private final List<S2Shape.MutableEdge> crossingEdges = new ArrayList<S2Shape.MutableEdge>();
    private final List<S2Shape.MutableEdge> containedEdges = new ArrayList<S2Shape.MutableEdge>();

    public S2RobustCellClipper() {
        this.options = new Options();
    }

    public S2RobustCellClipper(Options options) {
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public void startCell(S2Cell cell) {
        this.cell = cell;
        this.cellCenter = cell.getCenter();
        this.outside = this.cellCenter.ortho();
        this.clipper.init(cell);
        this.reset();
        for (int k = 0; k < 4; ++k) {
            this.boundaries[k].set(cell.getVertex(k), cell.getVertex(k + 1));
            this.uvcoords[k] = cell.getUVCoordOfBoundary(S2Cell.Boundary.fromValue(k));
            this.normals[k] = cell.getEdgeRaw(k);
        }
    }

    public @Nullable S2Cell cell() {
        return this.cell;
    }

    @CanIgnoreReturnValue
    public RobustClipResult clipEdge(S2Point v0, S2Point v1, boolean connected) {
        return this.clipEdge(S2Shape.MutableEdge.of(v0, v1), connected);
    }

    @CanIgnoreReturnValue
    public RobustClipResult clipEdge(S2Point v0, S2Point v1) {
        return this.clipEdge(S2Shape.MutableEdge.of(v0, v1), false);
    }

    @CanIgnoreReturnValue
    public RobustClipResult clipEdge(S2Shape.MutableEdge edge, boolean connected) {
        boolean hit = this.clipper.clipEdge(edge.a, edge.b, connected);
        if (!hit && this.clipper.missedFace()) {
            return RobustClipResult.MISS;
        }
        if (this.withinUvErrorMargin(this.clipper.faceUvEdge(), this.clipper.uvError())) {
            return this.clipEdgeExactly(edge, this.clipper.faceUvEdge());
        }
        if (hit) {
            byte out0 = this.clipper.outcode(0);
            byte out1 = this.clipper.outcode(1);
            if (out0 == 0 && out1 == 0) {
                this.containedEdges.add(edge);
                return RobustClipResult.HIT_BOTH;
            }
            boolean tooClose = false;
            tooClose |= this.tooCloseToCorner(this.clipper.clippedUvEdge().v0, out0, this.clipper.clipError());
            if (tooClose |= this.tooCloseToCorner(this.clipper.clippedUvEdge().v1, out1, this.clipper.clipError())) {
                return this.clipEdgeExactly(edge, this.clipper.faceUvEdge());
            }
            if (this.options().enableCrossings()) {
                this.addCrossing(edge, this.clipper.clippedUvEdge().v0, out0);
                this.addCrossing(edge, this.clipper.clippedUvEdge().v1, out1);
            }
            return RobustClipResult.hit(out0, out1);
        }
        return this.clipEdgeExactly(edge, this.clipper.faceUvEdge());
    }

    @CanIgnoreReturnValue
    public RobustClipResult clipEdge(S2Shape.MutableEdge edge) {
        return this.clipEdge(edge, false);
    }

    public RobustClipResult clipEdge(S2IndexCellData.EdgeAndIdChain edge) {
        S2Shape.MutableEdge e = new S2Shape.MutableEdge();
        e.set(edge.start(), edge.end());
        return this.clipEdge(e, false);
    }

    public void reset() {
        this.crossings.clear();
        this.crossingEdges.clear();
        this.containedEdges.clear();
    }

    public PooledList<Crossing> getCrossings() {
        if (this.needSorting) {
            this.sortCrossings();
        }
        return this.crossings;
    }

    public boolean isBoundaryContained(boolean containsCenter) {
        Preconditions.checkState(this.crossings.isEmpty());
        if (this.containedEdges.isEmpty()) {
            return containsCenter;
        }
        boolean inside = containsCenter;
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(this.cellCenter, this.outside);
        for (S2Shape.MutableEdge edge : this.containedEdges) {
            if (!crosser.edgeOrVertexCrossing(edge.a, edge.b)) continue;
            inside = !inside;
        }
        return inside;
    }

    private double projectToBoundary(int k, S2Point p) {
        R2Vector uvp = new R2Vector();
        S2Projections.validFaceXyzToUv(this.clipper.clipFace(), p, uvp);
        return this.getCoordByBoundary(k, uvp);
    }

    private void addCrossing(S2Shape.MutableEdge edge, S2Cell.Boundary boundary, double intercept, CrossingType crossingType) {
        if (crossingType == CrossingType.UNKNOWN) {
            S2Shape.MutableEdge cellEdge = this.boundaries[boundary.value];
            int sign = S2Predicates.sign(cellEdge.a, cellEdge.b, edge.a);
            assert (sign != 0);
            crossingType = sign > 0 ? CrossingType.OUTGOING : CrossingType.INCOMING;
        }
        int edgeIndex = this.crossingEdges.size();
        this.crossingEdges.add(edge);
        this.addCrossing(boundary, crossingType, this.uvcoords[boundary.value], intercept, edgeIndex);
    }

    private void addCrossing(S2Shape.MutableEdge edge, S2Cell.Boundary boundary, double intercept) {
        this.addCrossing(edge, boundary, intercept, CrossingType.UNKNOWN);
    }

    private void addCrossing(S2Shape.MutableEdge edge, R2Vector uv, int outcode) {
        if (outcode == 0 || outcode == -1) {
            return;
        }
        switch (outcode) {
            case 1: {
                this.addCrossing(edge, S2Cell.Boundary.BOTTOM_EDGE, uv.x);
                break;
            }
            case 2: {
                this.addCrossing(edge, S2Cell.Boundary.RIGHT_EDGE, uv.y);
                break;
            }
            case 4: {
                this.addCrossing(edge, S2Cell.Boundary.TOP_EDGE, uv.x);
                break;
            }
            case 8: {
                this.addCrossing(edge, S2Cell.Boundary.LEFT_EDGE, uv.y);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown outcode: " + outcode);
            }
        }
    }

    private void addCrossing(S2Cell.Boundary boundary, CrossingType crossingType, double uvcoord, double intercept, int edgeIndex) {
        this.crossings.add().set(boundary, crossingType, uvcoord, intercept, edgeIndex);
        this.needSorting = true;
    }

    private boolean tooCloseToCorner(R2Vector uv, int outcode, double maxError) {
        if (outcode == 0 || outcode == -1) {
            return false;
        }
        boolean tooClose = false;
        if (outcode == 1 || outcode == 4) {
            double intercept = uv.x();
            tooClose |= intercept - maxError <= this.uvcoords[3];
            tooClose |= intercept + maxError >= this.uvcoords[1];
        } else {
            double intercept = uv.y();
            tooClose |= intercept - maxError <= this.uvcoords[0];
            tooClose |= intercept + maxError >= this.uvcoords[2];
        }
        return tooClose;
    }

    @VisibleForTesting
    boolean withinUvErrorMargin(R2Edge uvEdge, double maxError) {
        double[] coord0 = new double[]{uvEdge.v0.y(), uvEdge.v0.x(), uvEdge.v0.y(), uvEdge.v0.x()};
        double[] coord1 = new double[]{uvEdge.v1.y(), uvEdge.v1.x(), uvEdge.v1.y(), uvEdge.v1.x()};
        boolean inMargin = false;
        for (int i = 0; i < 4; ++i) {
            inMargin |= Math.abs(coord0[i] - this.uvcoords[i]) <= maxError;
            inMargin |= Math.abs(coord1[i] - this.uvcoords[i]) <= maxError;
        }
        return inMargin;
    }

    private RobustClipResult clipEdgeExactly(S2Shape.MutableEdge edge, R2Edge uvEdge) {
        boolean allGreaterThan00 = true;
        boolean allGreaterThan01 = true;
        byte[] sign0 = new byte[4];
        byte[] sign1 = new byte[4];
        for (int k = 0; k < 4; ++k) {
            sign0[k] = (byte)this.boundarySign(k, edge.a);
            sign1[k] = (byte)this.boundarySign(k, edge.b);
            if (sign0[k] < 0 && sign1[k] < 0) {
                return RobustClipResult.MISS;
            }
            allGreaterThan00 &= sign0[k] > 0;
            allGreaterThan01 &= sign1[k] > 0;
        }
        if (allGreaterThan00 && allGreaterThan01) {
            this.containedEdges.add(edge);
            return RobustClipResult.HIT_BOTH;
        }
        RobustClipResult result = RobustClipResult.MISS;
        for (int k = 0; k < 4; ++k) {
            int kNext = (k + 1) % 4;
            int kPrev = (k + 3) % 4;
            if (sign0[k] != sign1[k]) {
                int signNext = S2Predicates.circleEdgeIntersectionSign(edge.a, edge.b, this.normals[k], this.normals[kNext]);
                int signPrev = S2Predicates.circleEdgeIntersectionSign(edge.a, edge.b, this.normals[k], this.normals[kPrev]);
                if (signNext >= 0 && signPrev >= 0 || signNext <= 0 && signPrev <= 0) {
                    if (this.options().enableCrossings()) {
                        double intercept;
                        if (uvEdge.v0.x() != uvEdge.v1.x() && uvEdge.v0.y() != uvEdge.v1.y()) {
                            R2Vector uvEdgeClipResult = new R2Vector();
                            this.clipper.r2Clipper.clip(uvEdge, (byte)(1 << k), uvEdgeClipResult);
                            intercept = this.getCoordByBoundary(k, uvEdgeClipResult);
                        } else {
                            S2Point intersection = S2RobustCrossProd.robustCrossProd(S2RobustCrossProd.robustCrossProd(edge.a, edge.b).normalize(), this.normals[k].normalize()).normalize();
                            if (sign0[k] < 0) {
                                intersection = intersection.neg();
                            }
                            intercept = this.projectToBoundary(k, intersection);
                        }
                        S2Cell.Boundary boundary = S2Cell.Boundary.fromValue(k);
                        if (sign0[k] > sign1[k]) {
                            this.addCrossing(edge, boundary, intercept, CrossingType.OUTGOING);
                        } else {
                            this.addCrossing(edge, boundary, intercept, CrossingType.INCOMING);
                        }
                    }
                    result = RobustClipResult.hit(allGreaterThan00, allGreaterThan01);
                }
            }
            assert (sign0[k] != 0 && sign1[k] != 0);
        }
        return result;
    }

    private double getCoordByBoundary(int boundary, R2Vector p) {
        if (boundary % 2 == 0) {
            return p.x();
        }
        return p.y();
    }

    private int boundarySign(int k, S2Point p) {
        assert (p.norm2() <= 2.0);
        S2Point normal = this.normals[k % 4];
        int sign = S2Predicates.signDotProd(normal, p);
        if (sign == 0) {
            for (int i = 0; i < 3; ++i) {
                if (normal.get(i) == 0.0) continue;
                return normal.get(i) > 0.0 ? 1 : -1;
            }
        }
        return sign;
    }

    private void sortCrossings() {
        this.needSorting = false;
        ExactCrossingComparator crossingComparator = new ExactCrossingComparator();
        this.crossings.sort(crossingComparator);
        for (int i = 0; i < this.crossings.size() - 1; ++i) {
            if (crossingComparator.compare(this.crossings.get(i), this.crossings.get(i + 1)) != 0) continue;
            this.crossings.remove(i + 1);
            this.crossings.remove(i);
            --i;
        }
    }

    private class ExactCrossingComparator
    implements Comparator<Crossing> {
        private ExactCrossingComparator() {
        }

        @Override
        public int compare(Crossing a, Crossing b) {
            if (a.boundary.value < b.boundary.value) {
                return -1;
            }
            if (a.boundary.value > b.boundary.value) {
                return 1;
            }
            if (Math.abs(a.intercept - b.intercept) > 2.0 * MAX_ERROR) {
                switch (a.boundary) {
                    case BOTTOM_EDGE: 
                    case RIGHT_EDGE: {
                        return a.intercept < b.intercept ? -1 : 1;
                    }
                    case TOP_EDGE: 
                    case LEFT_EDGE: {
                        return a.intercept > b.intercept ? -1 : 1;
                    }
                }
                throw new IllegalStateException("Invalid boundary: " + a.boundary);
            }
            int k = a.boundary.value;
            S2Point norm = S2RobustCellClipper.this.normals[k];
            S2Point prev = S2RobustCellClipper.this.normals[(k + 3) % 4];
            S2Shape.MutableEdge edgeA = S2RobustCellClipper.this.crossingEdges.get(a.edgeIndex);
            S2Shape.MutableEdge edgeB = S2RobustCellClipper.this.crossingEdges.get(b.edgeIndex);
            if (a.crossingType == CrossingType.INCOMING) {
                edgeA = S2Shape.MutableEdge.of(edgeA.b, edgeA.a);
            }
            if (b.crossingType == CrossingType.INCOMING) {
                edgeB = S2Shape.MutableEdge.of(edgeB.b, edgeB.a);
            }
            return S2Predicates.circleEdgeIntersectionOrdering(edgeA.a, edgeA.b, edgeB.a, edgeB.b, norm, prev);
        }
    }

    public static class Options {
        private boolean enableCrossings = true;

        @CanIgnoreReturnValue
        public Options setEnableCrossings(boolean flag) {
            this.enableCrossings = flag;
            return this;
        }

        public boolean enableCrossings() {
            return this.enableCrossings;
        }
    }

    public static class Crossing {
        public double intercept;
        public double coord;
        public S2Cell.Boundary boundary;
        public CrossingType crossingType;
        public int edgeIndex;

        public void set(S2Cell.Boundary boundary, CrossingType crossingType, double coord, double intercept, int edgeIndex) {
            this.intercept = intercept;
            this.coord = coord;
            this.boundary = boundary;
            this.crossingType = crossingType;
            this.edgeIndex = edgeIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.crossingType == CrossingType.OUTGOING) {
                sb.append("Outgoing");
            }
            if (this.crossingType == CrossingType.INCOMING) {
                sb.append("Incoming");
            }
            sb.append(" on boundary ").append((Object)this.boundary).append(" -- ");
            sb.append(this.intercept).append("@").append(this.coord);
            sb.append(" ").append("(edge ").append(this.edgeIndex).append(")");
            return sb.toString();
        }

        public boolean isEqualTo(Crossing other) {
            return this.crossingType == other.crossingType && this.intercept == other.intercept && this.boundary == other.boundary && this.coord == other.coord;
        }
    }

    public static enum CrossingType {
        UNKNOWN,
        INCOMING,
        OUTGOING;

    }

    public static enum RobustClipResult {
        MISS(0),
        HIT_NONE(4),
        HIT_V0(5),
        HIT_V1(6),
        HIT_BOTH(7);

        private final int clipCode;

        private RobustClipResult(int clipCode) {
            this.clipCode = clipCode;
        }

        public static RobustClipResult hit(boolean v0Contained, boolean v1Contained) {
            return v1Contained ? (v0Contained ? HIT_BOTH : HIT_V1) : (v0Contained ? HIT_V0 : HIT_NONE);
        }

        public static RobustClipResult hit(byte out0, byte out1) {
            return RobustClipResult.hit(out0 == 0, out1 == 0);
        }

        public boolean hit() {
            return this != MISS;
        }

        public boolean v0Inside() {
            return (this.clipCode & 1) != 0;
        }

        public boolean v1Inside() {
            return (this.clipCode & 2) != 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.hit()) {
                sb.append("Hit ");
                if (this.v0Inside() && this.v1Inside()) {
                    sb.append("(Both)");
                } else {
                    sb.append("(v0: ").append(this.v0Inside()).append(", v1: ").append(this.v1Inside()).append(")");
                }
            } else {
                sb.append("Miss");
            }
            return sb.toString();
        }
    }
}

