/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.twak.utils.Mathz;
import org.twak.utils.geom.DRectangle;

public class PanMouseAdaptor
extends MouseAdapter
implements Cloneable {
    int zoomInt = 0;
    double cenX;
    double cenY;
    public double zoom = 1.0;
    Integer startX;
    Integer startY;
    public Component comp;
    public int button = 2;
    public List<RangeListener> listeners = new ArrayList<RangeListener>();

    public PanMouseAdaptor(Point2d center, double v) {
        this.cenX = center.x;
        this.cenY = center.y;
        this.zoom = v * 2.0;
    }

    public static PanMouseAdaptor buildFixedMA(Component comp, double x, double y, double width, double height, double outWidth) {
        PanMouseAdaptor out = new PanMouseAdaptor();
        out.comp = comp;
        out.cenX = x + width / 2.0;
        out.cenY = y + height / 2.0;
        out.zoom = outWidth / width;
        return out;
    }

    public PanMouseAdaptor() {
    }

    public int compGetWidth() {
        return this.comp.getWidth();
    }

    public int compGetHeight() {
        return this.comp.getHeight();
    }

    public PanMouseAdaptor(final Component comp) {
        this.comp = comp;
        comp.addMouseListener(this);
        comp.addMouseWheelListener(this);
        comp.addMouseMotionListener(this);
        comp.addKeyListener(new PanKeyListener());
        comp.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (comp != null) {
                    PanMouseAdaptor.this.comp.repaint();
                }
                PanMouseAdaptor.this.fireListeners();
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.comp != null) {
            this.comp.requestFocus();
        }
        if (e.getButton() == this.button) {
            this.startX = e.getPoint().x;
            this.startY = e.getPoint().y;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startX != null) {
            int endX = e.getPoint().x;
            int endY = e.getPoint().y;
            this.cenX -= (double)(endX - this.startX) / this.zoom;
            this.cenY -= (double)(endY - this.startY) / this.zoom;
            this.startX = endX;
            this.startY = endY;
            if (this.comp != null) {
                this.comp.repaint();
            }
            this.fireListeners();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.startX = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.setZoom(-e.getWheelRotation());
        if (e.getWheelRotation() < 0) {
            Point2d pt = this.from(e);
            this.center(pt);
        }
    }

    public void resetView() {
        this.center(new Point2d());
        this.zoomInt = 0;
        this.setZoom(0);
    }

    public void resetView(PanMouseAdaptor ma) {
        this.cenX = ma.cenX;
        this.cenY = ma.cenY;
        this.zoom = ma.zoom;
        this.zoomInt = ma.zoomInt;
    }

    public void setZoom(int direction) {
        this.zoomInt += direction;
        this.zoomInt = Mathz.clamp(this.zoomInt, -100, 100);
        this.zoom = PanMouseAdaptor.zoomIntToZoom(this.zoomInt);
        if (this.comp != null) {
            this.comp.repaint();
        }
        this.fireListeners();
    }

    private static double zoomIntToZoom(double zI) {
        return Math.exp(zI / 4.0);
    }

    private static int zoomToZoomInt(double zI) {
        return (int)(Math.log(zI) * 4.0);
    }

    public double getZoom() {
        return this.zoom;
    }

    public double fromX(int val) {
        return (double)(val - this.compGetWidth() / 2) / this.zoom + this.cenX;
    }

    public double fromY(int val) {
        return (double)(val - this.compGetHeight() / 2) / this.zoom + this.cenY;
    }

    public double fromZoom(double width) {
        return width / this.zoom;
    }

    public int toX(double val) {
        return (int)((val - this.cenX) * this.zoom + (double)(this.compGetWidth() / 2));
    }

    public int toY(double val) {
        return (int)((val - this.cenY) * this.zoom + (double)(this.compGetHeight() / 2));
    }

    public int toZoom(double width) {
        return (int)(width * this.zoom);
    }

    public Point to(Point2d end) {
        return new Point(this.toX(end.x), this.toY(end.y));
    }

    public Point2d from(Point point) {
        return new Point2d(this.fromX(point.x), this.fromY(point.y));
    }

    public void center(Point2d point2d) {
        this.cenX = point2d.x;
        this.cenY = point2d.y;
    }

    public Point2d getCenter() {
        return new Point2d(this.cenX, this.cenY);
    }

    public double getMaxRange() {
        return this.fromZoom(Math.max(this.compGetWidth(), this.compGetHeight()));
    }

    public Point2d from(MouseEvent e) {
        return new Point2d(this.fromX(e.getX()), this.fromY(e.getY()));
    }

    public Rectangle to(DRectangle r) {
        return new Rectangle(this.toX(r.x), this.toY(r.y), this.toZoom(r.width), this.toZoom(r.height));
    }

    public DRectangle toD(DRectangle r) {
        return new DRectangle(this.toX(r.x), this.toY(r.y), this.toZoom(r.width), this.toZoom(r.height));
    }

    public double viewLeft() {
        return this.cenX - this.viewWidth() / 2.0;
    }

    public double viewWidth() {
        return this.fromZoom(this.compGetWidth());
    }

    public double viewTop() {
        return this.cenY - this.viewHeight() / 2.0;
    }

    public double viewHeight() {
        return this.fromZoom(this.compGetHeight());
    }

    public boolean isDragging() {
        return this.startX != null;
    }

    public void addListener(RangeListener ra) {
        this.listeners.add(ra);
    }

    public void drawImage(Graphics g2, Image im, double x, double y) {
        g2.drawImage(im, this.toX(x), this.toY(y), this.toZoom(im.getWidth(null)), this.toZoom(im.getHeight(null)), null);
    }

    public AffineTransform getAffineTransform(AffineTransform current) {
        AffineTransform at = new AffineTransform();
        at.translate(this.compGetWidth() / 2, this.compGetHeight() / 2);
        at.scale(this.zoom, this.zoom);
        at.translate(-this.cenX, -this.cenY);
        current.concatenate(at);
        return current;
    }

    private void fireListeners() {
        for (RangeListener ra : this.listeners) {
            ra.changed(this);
        }
    }

    public double toXD(double val) {
        return (val - this.cenX) * this.zoom + (double)(this.compGetWidth() / 2);
    }

    public double toYD(double val) {
        return (val - this.cenY) * this.zoom + (double)(this.compGetHeight() / 2);
    }

    public double toZoomD(double width) {
        return width * this.zoom;
    }

    public double fromXD(double val) {
        return (val - (double)(this.compGetWidth() / 2)) / this.zoom + this.cenX;
    }

    public double fromYD(double val) {
        return (val - (double)(this.compGetHeight() / 2)) / this.zoom + this.cenY;
    }

    public Point2d toD(Point2d end) {
        return new Point2d(this.toX(end.x), this.toY(end.y));
    }

    public PanMouseAdaptor clone() {
        PanMouseAdaptor out = new PanMouseAdaptor();
        out.cenX = this.cenX;
        out.cenY = this.cenY;
        out.zoom = this.zoom;
        return out;
    }

    public boolean sameLocation(PanMouseAdaptor o) {
        return o.cenX == this.cenX && o.cenY == this.cenY && o.zoom == this.zoom;
    }

    public void view(DRectangle bounds) {
        this.center(bounds.getCenter());
        this.zoomInt = 0;
        this.zoomFromWidth(bounds.width == 0.0 ? bounds.height : bounds.width);
    }

    public void zoomFromWidth(double width) {
        int cw = this.compGetWidth();
        if (cw == 0 || width == 0.0) {
            return;
        }
        this.zoom = (double)cw / width;
        this.zoomInt = PanMouseAdaptor.zoomToZoomInt(this.zoom * 0.8);
        this.setZoom(0);
    }

    public void viewOnSetSize(final DRectangle bounds) {
        ComponentAdapter ca = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PanMouseAdaptor.this.view(bounds);
                if (PanMouseAdaptor.this.comp != null) {
                    PanMouseAdaptor.this.comp.removeComponentListener(this);
                }
            }
        };
        if (this.comp != null) {
            this.comp.addComponentListener(ca);
        }
    }

    public static abstract class RangeListener {
        public abstract void changed(PanMouseAdaptor var1);
    }

    private class PanKeyListener
    implements KeyListener {
        final float speed = 6.0f;

        private PanKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 37: {
                    PanMouseAdaptor.this.cenX -= (double)PanMouseAdaptor.this.compGetWidth() / (6.0 * PanMouseAdaptor.this.zoom);
                    break;
                }
                case 39: {
                    PanMouseAdaptor.this.cenX += (double)PanMouseAdaptor.this.compGetWidth() / (6.0 * PanMouseAdaptor.this.zoom);
                    break;
                }
                case 38: {
                    PanMouseAdaptor.this.cenY -= (double)PanMouseAdaptor.this.compGetHeight() / (6.0 * PanMouseAdaptor.this.zoom);
                    break;
                }
                case 40: {
                    PanMouseAdaptor.this.cenY += (double)PanMouseAdaptor.this.compGetHeight() / (6.0 * PanMouseAdaptor.this.zoom);
                    break;
                }
                case 33: {
                    e.consume();
                    PanMouseAdaptor.this.setZoom(1);
                    return;
                }
                case 34: {
                    e.consume();
                    PanMouseAdaptor.this.setZoom(-1);
                    return;
                }
                default: {
                    return;
                }
            }
            e.consume();
            if (PanMouseAdaptor.this.comp != null) {
                PanMouseAdaptor.this.comp.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }
}

