/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.twak.utils.IdentityHashSet;
import org.twak.utils.Line;
import org.twak.utils.Mathz;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.collections.Loopz;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.geom.DRectangle;
import org.twak.utils.geom.Graph2D;
import org.twak.utils.geom.UnionWalker;

public class HalfMesh2
implements Iterable<HalfFace> {
    public List<HalfFace> faces = new ArrayList<HalfFace>();

    public void apply(AffineTransform af) {
        IdentityHashMap<Point2d, Point2d> seen = new IdentityHashMap<Point2d, Point2d>();
        for (HalfFace hf : this.faces) {
            for (HalfEdge e : hf.edges()) {
                for (Point2d pt : new Point2d[]{e.start, e.end}) {
                    if (seen.containsKey(pt)) continue;
                    seen.put(pt, pt);
                    HalfMesh2.transform(pt, af);
                }
            }
        }
    }

    public DRectangle bb() {
        DRectangle.Enveloper out = new DRectangle.Enveloper();
        for (HalfFace hf : this) {
            for (HalfEdge e : hf) {
                out.envelop(e.start);
            }
        }
        return out;
    }

    private static void transform(Point2d a, AffineTransform at) {
        double[] coords = new double[2];
        a.get(coords);
        System.out.println("in " + coords[0] + " " + coords[1]);
        at.transform(coords, 0, coords, 0, 1);
        a.set(coords);
        System.out.println("out " + coords[0] + " " + coords[1]);
    }

    private static HalfEdge createEdge(Class klass, Point2d s2, Point2d e, HalfEdge parent) {
        try {
            return (HalfEdge)klass.getConstructor(Point2d.class, Point2d.class, HalfEdge.class).newInstance(s2, e, parent);
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    private static HalfFace createFace(Class<? extends HalfFace> klazz, HalfEdge e) {
        try {
            return klazz.getConstructor(HalfEdge.class).newInstance(e);
        }
        catch (Throwable f) {
            f.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterator<HalfFace> iterator() {
        return this.faces.iterator();
    }

    public DRectangle getBounds() {
        DRectangle.Enveloper out = new DRectangle.Enveloper();
        for (HalfFace f : this) {
            for (HalfEdge e : f) {
                out.envelop(e.start);
            }
        }
        return out;
    }

    public void add(HalfFace hf) {
        this.faces.add(hf);
    }

    public static class EdgeIterator
    implements Iterator<HalfEdge> {
        HalfEdge start;
        HalfEdge current;
        Set<HalfEdge> seen = new IdentityHashSet<HalfEdge>();

        public EdgeIterator(HalfEdge first) {
            this.start = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.start;
        }

        @Override
        public HalfEdge next() {
            if (!this.hasNext()) {
                throw new Error();
            }
            if (this.current == null) {
                this.current = this.start.next;
                if (this.seen.contains(this.start)) {
                    throw new Error("infinite loop!");
                }
                this.seen.add(this.start);
                return this.start;
            }
            HalfEdge out = this.current;
            this.current = this.current.next;
            if (this.current == null) {
                this.start = this.current;
            }
            if (this.seen.contains(out)) {
                throw new Error("infinite loop!");
            }
            this.seen.add(out);
            return out;
        }
    }

    public static class HalfFace
    implements Iterable<HalfEdge> {
        public HalfEdge e;

        public HalfFace() {
        }

        public HalfFace(HalfEdge e) {
            this.e = e;
        }

        public void insert(HalfEdge he) {
            he.face = this;
            for (HalfEdge f : this) {
                if (f.next != this.e) continue;
                f.next = he;
            }
            he.next = this.e;
            this.e = he;
        }

        public Iterable<HalfEdge> edges() {
            return new Iterable(){

                public Iterator<HalfEdge> iterator() {
                    return new EdgeIterator(e);
                }
            };
        }

        public List<HalfEdge> edgeList() {
            ArrayList<HalfEdge> out = new ArrayList<HalfEdge>();
            for (HalfEdge e : this.edges()) {
                out.add(e);
            }
            return out;
        }

        public LoopL<HalfEdge> findHoles() {
            final Graph2D g2 = new Graph2D();
            for (Object e : this) {
                class L2
                extends Line {
                    HalfEdge edge;

                    public L2(HalfEdge e) {
                        super(e.start, e.end);
                        this.edge = e;
                    }
                }
                g2.add(new L2((HalfEdge)e));
            }
            g2.removeInnerEdges();
            UnionWalker uw = new UnionWalker();
            for (Point2d a : g2.map.keySet()) {
                for (Line l : g2.get(a)) {
                    uw.addEdge(l.start, l.end);
                }
            }
            LoopL<Point2d> pointLoop = uw.findAll();
            if (pointLoop.isEmpty()) {
                return new LoopL<HalfEdge>();
            }
            int outer = -1;
            double bestArea = -1.7976931348623157E308;
            for (int i = 0; i < pointLoop.size(); ++i) {
                double area = Math.abs(Loopz.area((Loop)pointLoop.get(i)));
                if (!(area > bestArea)) continue;
                outer = i;
                bestArea = area;
            }
            pointLoop.add(0, (Point2d)((Object)((Loop)pointLoop.remove(outer))));
            LoopL<Point2d> loopL = pointLoop;
            Objects.requireNonNull(loopL);
            LoopL<HalfEdge> out = new LoopL.Map<HalfEdge>(loopL){

                @Override
                public HalfEdge map(Loopable<Point2d> input) {
                    for (Line l : (List)g2.map.get(input.get())) {
                        if (!l.end.equals((Tuple2d)input.next.get())) continue;
                        return ((L2)l).edge;
                    }
                    throw new Error();
                }
            }.run();
            return out;
        }

        public Set<HalfFace> getNeighbours() {
            HashSet<HalfFace> out = new HashSet<HalfFace>();
            for (HalfEdge e : this) {
                if (e.over == null) continue;
                out.add(e.over.face);
            }
            return out;
        }

        public HalfEdge fracture(Point2d origin, Vector2d dir, HalfEdge ... ignore) {
            double bestDist = Double.MAX_VALUE;
            Point2d bestPt = null;
            HalfEdge bestEdge = null;
            block0: for (HalfEdge e : this.edges()) {
                double dist;
                Point2d p;
                for (HalfEdge e2 : ignore) {
                    if (e2 == e) continue block0;
                }
                Line el = e.line();
                if (!el.isOnLeft(origin) || (p = el.intersects(origin, dir)) == null || !((dist = p.distanceSquared(origin)) < bestDist)) continue;
                bestDist = dist;
                bestPt = p;
                bestEdge = e;
            }
            if (bestEdge == null) {
                return null;
            }
            return bestEdge.split(bestPt);
        }

        public HalfEdge split(HalfMesh2 m3, HalfEdge prev1, HalfEdge prev2) {
            m3.faces.remove(this);
            HalfEdge e12 = HalfMesh2.createEdge(prev1.getClass(), prev1.end, prev2.end, null);
            HalfEdge e21 = HalfMesh2.createEdge(prev1.getClass(), prev2.end, prev1.end, null);
            HalfFace left = HalfMesh2.createFace(this.getClass(), e12);
            HalfFace right = HalfMesh2.createFace(this.getClass(), e21);
            m3.faces.add(left);
            m3.faces.add(right);
            m3.faces.remove(this);
            e12.face = left;
            e21.face = right;
            HalfFace.setFace(prev1.next, prev2, right);
            HalfFace.setFace(prev2.next, prev1, left);
            e12.over = e21;
            e21.over = e12;
            e12.next = prev2.next;
            e21.next = prev1.next;
            prev1.next = e12;
            prev2.next = e21;
            return e12;
        }

        private static void setFace(HalfEdge from, HalfEdge to, HalfFace face) {
            HalfEdge current = from;
            current.face = face;
            do {
                current = current.next;
                current.face = face;
            } while (current != to);
        }

        public boolean contains(Point2d pt) {
            Vector2d left = new Vector2d(-1.0, 0.0);
            int count = 0;
            for (HalfEdge e : this.edges()) {
                if (e.line().intersects(pt, left) == null) continue;
                ++count;
            }
            return count % 2 == 1;
        }

        public void remove(HalfMesh2 mesh) {
            mesh.faces.remove(this);
            for (HalfEdge e : this.edges()) {
                if (e.over == null) continue;
                e.over.over = null;
            }
        }

        @Override
        public Iterator<HalfEdge> iterator() {
            return this.edges().iterator();
        }

        public int edgeCount() {
            int i = 0;
            for (HalfEdge e : this) {
                ++i;
            }
            return i;
        }

        public List<List<HalfEdge>> parallelFaces(double d) {
            ArrayList<List<HalfEdge>> out = new ArrayList<List<HalfEdge>>();
            HalfEdge s2 = this.e;
            while (s2.line().absAngle(s2.next.line()) < d) {
                s2 = s2.next;
            }
            HalfEdge c = s2 = s2.next;
            ArrayList<HalfEdge> ce = new ArrayList<HalfEdge>();
            do {
                ce.add(c);
                if (!(c.line().absAngle(c.next.line()) >= d)) continue;
                if (!ce.isEmpty()) {
                    out.add(ce);
                }
                ce = new ArrayList();
            } while ((c = c.next) != s2);
            if (!ce.isEmpty()) {
                out.add(ce);
            }
            return out;
        }

        public double area() {
            Point2d origin = this.e.start;
            double area = 0.0;
            for (HalfEdge e : this) {
                area += Mathz.area(origin, e.start, e.end);
            }
            return area;
        }

        public void merge(HalfMesh2 mesh, HalfFace togo) {
            for (HalfEdge e : this) {
                if (e.over == null || e.over.face != togo) continue;
                e.dissolve(mesh);
                break;
            }
        }

        public Loop<Point2d> toLoop() {
            Loop<Point2d> out = new Loop<Point2d>();
            for (HalfEdge e : this) {
                out.append((Point2d[])new Point2d[]{e.end});
            }
            return out;
        }

        public DRectangle bb() {
            DRectangle.Enveloper out = new DRectangle.Enveloper();
            for (HalfEdge e : this) {
                out.envelop(e.start);
            }
            return out;
        }
    }

    public static class HalfEdge {
        public HalfEdge over;
        public HalfEdge next;
        public HalfFace face;
        public Point2d start;
        public Point2d end;

        public HalfEdge() {
        }

        public HalfEdge(Point2d s2, Point2d e) {
            this.start = s2;
            this.end = e;
        }

        public HalfEdge(Point2d s2, Point2d e, HalfEdge parent) {
            this.start = s2;
            this.end = e;
        }

        public double length() {
            return this.start.distance(this.end);
        }

        public HalfEdge split(Point2d pt) {
            HalfEdge ourSide = HalfMesh2.createEdge(this.getClass(), pt, this.end, this);
            ourSide.face = this.face;
            ourSide.next = this.next;
            this.end = pt;
            if (this.over != null) {
                HalfEdge otherSide = HalfMesh2.createEdge(this.getClass(), pt, this.start, this.over);
                this.over.end = pt;
                otherSide.face = this.over.face;
                otherSide.over = this;
                otherSide.next = this.over.next;
                this.over.next = otherSide;
                this.over.over = ourSide;
                ourSide.over = this.over;
                this.over = otherSide;
            }
            this.next = ourSide;
            return this;
        }

        public Line line() {
            return new Line(this.start, this.end);
        }

        public String toString() {
            return "(" + String.valueOf(this.start) + ", " + String.valueOf(this.end) + ")";
        }

        public void dissolve(HalfMesh2 mesh) {
            if (this.next == this.over && this.over.next == this) {
                if (this.face.e == this || this.face.e == this.over) {
                    // empty if block
                }
                return;
            }
            if (this.next == this.over) {
                this.findBefore().next = this.over.next;
                if (this.face.e == this || this.face.e == this.over) {
                    this.face.e = this.over.next;
                }
            } else if (this.over.next == this) {
                this.over.findBefore().next = this.next;
                if (this.face.e == this || this.face.e == this.over) {
                    this.face.e = this.next;
                }
            } else {
                HalfEdge ob = this.over.findBefore();
                this.findBefore().next = this.over.next;
                ob.next = this.next;
                if (this.face.e == this) {
                    this.face.e = this.next;
                }
                for (HalfEdge e : this.face.edges()) {
                    e.face = this.face;
                }
            }
            if (this.over.face != this.face) {
                mesh.faces.remove(this.over.face);
            }
        }

        public boolean replaceByPoint(HalfMesh2 mesh, Point2d pt) {
            HalfEdge[] halfEdgeArray = new HalfEdge[]{this, this.over};
            int n = halfEdgeArray.length;
            for (int i = 0; i < n; ++i) {
                HalfEdge start;
                HalfEdge n2 = start = halfEdgeArray[i];
                while (n2 != null && n2.next != start.over) {
                    n2 = n2.next;
                    n2.start = pt;
                    if (n2.over != null) {
                        n2.over.end = pt;
                    }
                    n2 = n2.over;
                }
            }
            HalfEdge before = this.findBefore();
            if (this.over != null) {
                this.over.findBefore().next = this.over.next;
                if (this.over.face.e == this.over) {
                    this.over.face.e = this.over.next;
                }
            } else {
                before.end = pt;
            }
            before.next = this.next;
            if (this.face.e == this) {
                this.face.e = this.next;
            }
            if (this.face.e.next.next == this.face.e) {
                this.face.remove(mesh);
                return true;
            }
            return false;
        }

        public HalfEdge findBefore() {
            HalfEdge last = this.next;
            HashSet<HalfEdge> seen = new HashSet<HalfEdge>();
            do {
                HalfEdge n;
                if ((n = last.next) == this) {
                    return last;
                }
                last = n;
                if (seen.contains(n)) {
                    throw new Error("loop detected");
                }
                seen.add(n);
            } while (last != this);
            return null;
        }

        public void mergeWithNext(HalfMesh2 hm) {
            HalfEdge oo = this.next.over;
            if (oo == null ^ this.over == null) {
                throw new Error("not implemented");
            }
            if (oo != null) {
                if (oo.face != this.over.face) {
                    throw new Error("not implemented");
                }
                oo.end = oo.next.end;
                if (oo.face.e == oo.next) {
                    oo.face.e = oo;
                }
                oo.next = oo.next.next;
                oo.over = this;
            }
            this.end = this.next.end;
            if (this.face.e == this.next) {
                this.face.e = this;
            }
            this.next = this.next.next;
            this.over = oo;
        }

        public List<HalfEdge> collectAroundEnd() {
            ArrayList<HalfEdge> out = new ArrayList<HalfEdge>();
            out.add(this);
            HalfEdge c = this;
            do {
                out.add(c);
                c = c.next;
                out.add(c);
            } while ((c = c.over) != null && c != this);
            if (c == this) {
                return out;
            }
            c = this.next;
            do {
                if (c != this.next) {
                    out.add(c);
                }
                if ((c = c.findBefore()) == this) continue;
                out.add(c);
            } while ((c = c.over) != null);
            return out;
        }
    }

    public static class Builder {
        MultiMap<Point2d, HalfEdge> local = new MultiMap();
        public HalfMesh2 mesh = new HalfMesh2();
        Point2d last;
        Point2d first;
        HalfEdge lastEdge;
        HalfEdge firstEdge;
        Class edgeClass = HalfEdge.class;
        Class faceClass = HalfFace.class;

        public Builder() {
        }

        public Builder(Class edgeClass, Class faceClass) {
            this.edgeClass = edgeClass;
            this.faceClass = faceClass;
        }

        public void setMesh(HalfMesh2 mesh) {
            this.mesh = mesh;
        }

        public HalfEdge newPoint(Point2d pt) {
            if (this.first == null) {
                this.first = pt;
            }
            HalfEdge out = null;
            if (this.last != null) {
                out = this.newEdge(this.last, pt);
            }
            this.last = pt;
            return out;
        }

        public HalfFace newFace() {
            HalfFace face = null;
            if (this.last != null) {
                HalfEdge edge;
                this.lastEdge.next = edge = HalfMesh2.createEdge(this.edgeClass, this.last, this.first, null);
                edge.next = this.firstEdge;
                face = HalfMesh2.createFace(this.faceClass, edge);
                for (HalfEdge e : face.edges()) {
                    e.face = face;
                }
                this.mesh.faces.add(face);
            }
            this.last = null;
            this.first = null;
            this.lastEdge = null;
            this.firstEdge = null;
            return face;
        }

        private HalfEdge newEdge(Point2d s2, Point2d e) {
            HalfEdge edge = HalfMesh2.createEdge(this.edgeClass, s2, e, null);
            if (this.lastEdge != null) {
                this.lastEdge.next = edge;
            }
            for (HalfEdge e2 : this.local.get(s2)) {
                if (e2.start != edge.end || edge.start != e2.end) continue;
                edge.over = e2;
            }
            this.local.put(edge.start, edge);
            this.local.put(edge.end, edge);
            if (this.firstEdge == null) {
                this.firstEdge = edge;
            }
            this.lastEdge = edge;
            return this.lastEdge;
        }

        public HalfMesh2 done() {
            return this.mesh;
        }
    }
}

