/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceF;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhEntryDistF;
import ch.ethz.globis.phtree.PhEntryF;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.pre.PreProcessorPointF;
import ch.ethz.globis.phtree.util.MutableInt;
import ch.ethz.globis.phtree.util.MutableRef;
import ch.ethz.globis.phtree.util.PhIteratorBase;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhMapperK;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.unsynced.ObjectPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PhTreeMultiMapF2<T> {
    public static final int DEFAULT_SIZE = 2;
    private final PhTree<Object> pht;
    private final PreProcessorPointF pre;
    private final ObjectPool<ArrayList<T>> pool = ObjectPool.create(10, () -> new ArrayList(2));
    private int size = 0;

    protected PhTreeMultiMapF2(int dim, PreProcessorPointF pre) {
        this.pht = PhTree.create(dim);
        this.pre = pre;
    }

    protected PhTreeMultiMapF2(PhTree<Object> tree) {
        this.pht = tree;
        this.pre = new PreProcessorPointF.IEEE();
    }

    public static <T> PhTreeMultiMapF2<T> create(int dim) {
        return new PhTreeMultiMapF2<T>(dim, new PreProcessorPointF.IEEE());
    }

    public static <T> PhTreeMultiMapF2<T> create(int dim, PreProcessorPointF pre) {
        return new PhTreeMultiMapF2<T>(dim, pre);
    }

    public int size() {
        return this.size;
    }

    public boolean put(double[] key, T value) {
        this.pht.compute(this.pre(key), (keyInternal, entry) -> {
            ArrayList<T> list;
            if (entry == null) {
                return value;
            }
            if (entry instanceof ArrayList) {
                list = this.asList(entry);
            } else {
                list = this.newList();
                list.add(this.asT(entry));
            }
            list.add(value);
            return list;
        });
        ++this.size;
        return true;
    }

    public boolean contains(double[] key, T value) {
        Object v = this.pht.get(this.pre(key));
        if (v != null) {
            if (v instanceof ArrayList) {
                return this.asList(v).contains(value);
            }
            return Objects.equals(value, v);
        }
        return false;
    }

    public Iterable<T> get(double[] key) {
        Object v = this.pht.get(this.pre(key));
        if (v instanceof ArrayList) {
            return (Iterable)v;
        }
        if (v == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(this.asT(v));
        return list;
    }

    public Iterable<T> remove(double[] key) {
        Object v = this.pht.remove(this.pre(key));
        if (v instanceof ArrayList) {
            ArrayList<T> list = this.asList(v);
            this.size -= list.size();
            return list;
        }
        if (v == null) {
            return Collections.emptyList();
        }
        --this.size;
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(this.asT(v));
        return list;
    }

    public boolean remove(double[] key, T value) {
        MutableInt i = new MutableInt(0);
        this.pht.computeIfPresent(this.pre(key), (keyInternal, entry) -> {
            if (entry == null) {
                return null;
            }
            if (entry instanceof ArrayList) {
                ArrayList<T> list = this.asList(entry);
                if (list.remove(value)) {
                    i.inc();
                }
                if (list.size() == 1) {
                    T v = list.get(0);
                    list.clear();
                    this.pool.offer(list);
                    return v;
                }
                return list;
            }
            if (Objects.equals(value, entry)) {
                i.inc();
                return null;
            }
            return entry;
        });
        this.size -= i.get();
        return i.get() > 0;
    }

    public PhExtentF<T> queryExtent() {
        return new PhExtentF(this.pht.queryExtent(), this.pht.getDim(), this.pre);
    }

    public PhQueryF<T> query(double[] min2, double[] max) {
        long[] lMin = new long[min2.length];
        long[] lMax = new long[max.length];
        this.pre.pre(min2, lMin);
        this.pre.pre(max, lMax);
        return new PhQueryF(this.pht.query(lMin, lMax), this.pht.getDim(), this.pre);
    }

    public PhRangeQueryF<T> rangeQuery(double dist, double ... center) {
        return this.rangeQuery(dist, PhDistanceF.THIS, center);
    }

    public PhRangeQueryF<T> rangeQuery(double dist, PhDistance optionalDist, double ... center) {
        if (optionalDist == null) {
            optionalDist = PhDistanceF.THIS;
        }
        long[] lKey = new long[center.length];
        this.pre.pre(center, lKey);
        PhRangeQuery<Object> iter = this.pht.rangeQuery(dist, optionalDist, lKey);
        return new PhRangeQueryF(iter, this.pht, this.pre);
    }

    public int getDim() {
        return this.pht.getDim();
    }

    public PhKnnQueryF<T> nearestNeighbour(int nMin, double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        PhTree.PhKnnQuery<Object> iter = this.pht.nearestNeighbour(nMin, PhDistanceF.THIS, null, lKey);
        return new PhKnnQueryF(iter, this.pht.getDim(), this.pre);
    }

    public PhKnnQueryF<T> nearestNeighbour(int nMin, PhDistance dist, double ... key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        PhTree.PhKnnQuery<Object> iter = this.pht.nearestNeighbour(nMin, dist, null, lKey);
        return new PhKnnQueryF(iter, this.pht.getDim(), this.pre);
    }

    public boolean update(double[] oldKey, T value, double[] newKey) {
        if (this.remove(oldKey, value)) {
            this.put(newKey, value);
            return true;
        }
        return false;
    }

    public List<PhEntryF<T>> queryAll(double[] min2, double[] max) {
        return this.queryAll(min2, max, Integer.MAX_VALUE, null, e -> new PhEntryF(PhMapperK.toDouble(e.getKey()), e.getValue()));
    }

    public <R> List<R> queryAll(double[] min2, double[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        long[] lUpp = new long[min2.length];
        long[] lLow = new long[max.length];
        this.pre.pre(min2, lLow);
        this.pre.pre(max, lUpp);
        ArrayList list = new ArrayList();
        this.pht.queryAll(lLow, lUpp, maxResults, filter, (PhEntry<T> e2) -> e2).forEach(entry -> {
            if (filter.isValid(entry.getKey())) {
                if (entry.getValue() instanceof ArrayList) {
                    ArrayList<T> eList = this.asList(entry.getValue());
                    eList.forEach(t -> list.add(mapper.map(new PhEntry<Object>(entry.getKey(), t))));
                } else {
                    list.add(mapper.map(new PhEntry<T>(entry.getKey(), this.asT(entry.getValue()))));
                }
            }
        });
        return list;
    }

    public void clear() {
        this.pht.clear();
    }

    public PhTree<Object> getInternalTree() {
        return this.pht;
    }

    public PreProcessorPointF getPreprocessor() {
        return this.pre;
    }

    public String toStringTree() {
        return this.pht.toStringTree();
    }

    public String toString() {
        return this.pht.toString();
    }

    public PhTreeStats getStats() {
        return this.pht.getStats();
    }

    public T putIfAbsent(double[] key, T value) {
        MutableRef ref = new MutableRef();
        this.compute(key, value, (k, v) -> v == null ? value : ref.set(v).get());
        return ref.get();
    }

    public boolean replace(double[] key, T oldValue, T newValue) {
        return this.computeIfPresent(key, oldValue, (doubles, t) -> newValue) != null;
    }

    public T computeIfAbsent(double[] key, T value, Function<double[], ? extends T> mappingFunction) {
        MutableRef ref = new MutableRef();
        this.compute(key, value, (k, v) -> v == null ? ref.set(mappingFunction.apply((double[])k)).get() : v);
        return ref.get();
    }

    public T computeIfPresent(double[] key, T value, BiFunction<double[], ? super T, ? extends T> remappingFunction) {
        return (T)this.compute(key, value, (k, v) -> v == null ? null : remappingFunction.apply((double[])k, (Object)v));
    }

    public T compute(double[] key, T value, BiFunction<double[], ? super T, ? extends T> remappingFunction) {
        MutableRef ref = new MutableRef();
        MutableInt delta = new MutableInt(0);
        this.pht.compute(this.pre(key), (keyInternal, entry) -> {
            if (entry instanceof ArrayList) {
                ArrayList<T> list = this.asList(entry);
                ListIterator<T> it = list.listIterator();
                while (it.hasNext()) {
                    T valueOld = it.next();
                    if (!Objects.equals(value, valueOld)) continue;
                    Object valueNew = remappingFunction.apply(key, (T)valueOld);
                    if (valueNew != null) {
                        it.set(valueNew);
                        ref.set(valueNew);
                        return list;
                    }
                    it.remove();
                    delta.dec();
                    if (list.size() == 1) {
                        T v = list.get(0);
                        list.clear();
                        this.pool.offer(list);
                        return v;
                    }
                    return list;
                }
                Object valueNew = remappingFunction.apply(key, null);
                if (valueNew != null) {
                    list.add(valueNew);
                    ref.set(valueNew);
                    delta.inc();
                }
                return list.isEmpty() ? null : list;
            }
            Object arg1 = Objects.equals(value, entry) ? (Object)this.asT(entry) : null;
            ref.set(remappingFunction.apply(key, (T)arg1));
            if (ref.get() != null) {
                delta.inc();
                ArrayList<T> list = this.newList();
                list.add(this.asT(entry));
                list.add(ref.get());
                return list;
            }
            return ref.get();
        });
        this.size += delta.get();
        return ref.get();
    }

    private long[] pre(double[] key) {
        long[] lKey = new long[key.length];
        this.pre.pre(key, lKey);
        return lKey;
    }

    private ArrayList<T> asList(Object obj) {
        return (ArrayList)obj;
    }

    private T asT(Object obj) {
        return (T)obj;
    }

    private ArrayList<T> newList() {
        return this.pool.get();
    }

    public static class PhRangeQueryF<T>
    extends PhIteratorF<T> {
        private final long[] lCenter;
        private final PhRangeQuery<Object> q;

        protected PhRangeQueryF(PhRangeQuery<Object> iter, PhTree<Object> tree, PreProcessorPointF pre) {
            super(iter, tree.getDim(), pre);
            this.q = iter;
            this.lCenter = new long[tree.getDim()];
        }

        public PhRangeQueryF<T> reset(double range, double ... center) {
            this.pre.pre(center, this.lCenter);
            this.q.reset(range, this.lCenter);
            super.reset();
            return this;
        }
    }

    public static class PhKnnQueryF<T>
    implements PhIteratorBase<T, PhEntryDistF<T>> {
        private final PreProcessorPointF pre;
        private final PhTree.PhKnnQuery<Object> iter;
        private final PhEntryDistF<T> buffer;
        private final ArrayList<T> bufferList = new ArrayList();
        private PhEntryDist<Object> internalEntry;
        private ArrayList<T> currentList;
        private int pos = Integer.MAX_VALUE;

        protected PhKnnQueryF(PhTree.PhKnnQuery<Object> iter, int dims, PreProcessorPointF pre) {
            this.iter = iter;
            this.pre = pre;
            this.buffer = new PhEntryDistF<Object>(new double[dims], null, Double.NaN);
            this.bufferList.add(null);
            this.findNextInternal();
        }

        private void findNextKnn() {
            if (this.pos < this.currentList.size()) {
                return;
            }
            this.findNextInternal();
        }

        private void findNextInternal() {
            if (this.iter.hasNext()) {
                this.internalEntry = (PhEntryDist)this.iter.nextEntryReuse();
                this.pos = 0;
                if (this.internalEntry.getValue() instanceof ArrayList) {
                    this.currentList = (ArrayList)this.internalEntry.getValue();
                } else {
                    this.bufferList.set(0, this.internalEntry.getValue());
                    this.currentList = this.bufferList;
                }
                return;
            }
            this.pos = Integer.MAX_VALUE;
        }

        private T getNextValue() {
            return this.currentList.get(this.pos++);
        }

        @Override
        public boolean hasNext() {
            return this.pos < Integer.MAX_VALUE;
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public PhEntryDistF<T> nextEntry() {
            this.checkNextKnn();
            this.pre.post(this.internalEntry.getKey(), this.buffer.getKey());
            this.buffer.setDist(this.internalEntry.dist());
            this.buffer.setValue(this.getNextValue());
            PhEntryDistF ret = new PhEntryDistF((double[])this.buffer.getKey().clone(), this.buffer.getValue(), this.buffer.dist());
            this.findNextKnn();
            return ret;
        }

        @Override
        public PhEntryDistF<T> nextEntryReuse() {
            this.checkNextKnn();
            this.pre.post(this.internalEntry.getKey(), this.buffer.getKey());
            this.buffer.setDist(this.internalEntry.dist());
            this.buffer.setValue(this.getNextValue());
            this.findNextKnn();
            return this.buffer;
        }

        @Override
        public T nextValue() {
            this.checkNextKnn();
            T value = this.getNextValue();
            this.findNextKnn();
            return value;
        }

        private void checkNextKnn() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }

        public PhKnnQueryF<T> reset(int nMin, PhDistance dist, double[] center) {
            this.pos = Integer.MAX_VALUE;
            long[] lCenter = new long[center.length];
            this.pre.pre(center, lCenter);
            this.iter.reset(nMin, dist, lCenter);
            this.findNextInternal();
            return this;
        }
    }

    public static class PhQueryF<T>
    extends PhIteratorF<T> {
        private final long[] lMin;
        private final long[] lMax;
        private final PhTree.PhQuery<Object> q;

        protected PhQueryF(PhTree.PhQuery<Object> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.q = iter;
            this.lMin = new long[dims];
            this.lMax = new long[dims];
        }

        public void reset(double[] lower, double[] upper) {
            this.pre.pre(lower, this.lMin);
            this.pre.pre(upper, this.lMax);
            this.q.reset(this.lMin, this.lMax);
            super.reset();
        }
    }

    public static class PhExtentF<T>
    extends PhIteratorF<T> {
        private final PhTree.PhExtent<Object> iter;

        protected PhExtentF(PhTree.PhExtent<Object> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.iter = iter;
        }

        @Override
        public PhExtentF<T> reset() {
            this.iter.reset();
            super.reset();
            return this;
        }
    }

    public static class PhIteratorF<T>
    implements PhIteratorBase<T, PhEntryF<T>> {
        protected final PreProcessorPointF pre;
        private final PhIteratorBase<Object, ? extends PhEntry<Object>> iter;
        private final PhEntryF<T> buffer;
        private final ArrayList<T> bufferList = new ArrayList();
        private PhEntry<Object> internalEntry;
        private ArrayList<T> currentList;
        private int pos = Integer.MAX_VALUE;

        protected PhIteratorF(PhIteratorBase<Object, ? extends PhEntry<Object>> iter, int dims, PreProcessorPointF pre) {
            this.iter = iter;
            this.pre = pre;
            this.buffer = new PhEntryF<Object>(new double[dims], null);
            this.bufferList.add(null);
            this.findNextInternal();
        }

        private void findNext() {
            if (this.pos < this.currentList.size()) {
                return;
            }
            this.findNextInternal();
        }

        private void findNextInternal() {
            if (this.iter.hasNext()) {
                this.internalEntry = this.iter.nextEntryReuse();
                this.pos = 0;
                if (this.internalEntry.getValue() instanceof ArrayList) {
                    this.currentList = (ArrayList)this.internalEntry.getValue();
                } else {
                    this.bufferList.set(0, this.internalEntry.getValue());
                    this.currentList = this.bufferList;
                }
                return;
            }
            this.pos = Integer.MAX_VALUE;
        }

        private T getNextValue() {
            return this.currentList.get(this.pos++);
        }

        @Override
        public boolean hasNext() {
            return this.pos < Integer.MAX_VALUE;
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public PhEntryF<T> nextEntry() {
            this.checkNext();
            this.pre.post(this.internalEntry.getKey(), this.buffer.getKey());
            this.buffer.setValue(this.getNextValue());
            PhEntryF<T> ret = new PhEntryF<T>((double[])this.buffer.getKey().clone(), this.buffer.getValue());
            this.findNext();
            return ret;
        }

        @Override
        public PhEntryF<T> nextEntryReuse() {
            this.checkNext();
            this.pre.post(this.internalEntry.getKey(), this.buffer.getKey());
            this.buffer.setValue(this.getNextValue());
            this.findNext();
            return this.buffer;
        }

        @Override
        public T nextValue() {
            this.checkNext();
            T value = this.getNextValue();
            this.findNext();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected PhIteratorF<T> reset() {
            this.pos = Integer.MAX_VALUE;
            this.findNextInternal();
            return this;
        }

        private void checkNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }
    }
}

