/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13SynchedPool.nt;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import ch.ethz.globis.phtree.v13SynchedPool.nt.Bits;
import ch.ethz.globis.phtree.v13SynchedPool.nt.NodeTreeV13;
import ch.ethz.globis.phtree.v13SynchedPool.nt.NtNode;

public class NtNodeIteratorMask<T> {
    private static final long FINISHED = Long.MAX_VALUE;
    private static final long START = -1L;
    private boolean isHC;
    private long next;
    private NtNode<T> nextSubNode;
    private NtNode<T> node;
    private int currentOffsetKey;
    private int nMaxEntry;
    private int nFound = 0;
    private int postEntryLenLHC;
    private long prefix;
    private long maskLower;
    private long maskUpper;
    private long globalMinMask;
    private long globalMaxMask;
    private boolean useHcIncrementer;

    private void reinit(NtNode<T> node, long prefix) {
        int logNPost;
        this.prefix = prefix;
        this.next = -1L;
        this.nextSubNode = null;
        this.currentOffsetKey = 0;
        this.nFound = 0;
        this.node = node;
        this.isHC = node.isAHC();
        this.nMaxEntry = node.getEntryCount();
        this.currentOffsetKey = node.getBitPosIndex();
        if (!this.isHC) {
            this.postEntryLenLHC = NtNode.IK_WIDTH(8) + 8 * node.getPostLen();
        }
        this.useHcIncrementer = false;
        long maxHcAddr = 255L;
        int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
        long nPossibleMatch = 1L << 8 - nSetFilterBits;
        this.useHcIncrementer = this.isHC ? nPossibleMatch < maxHcAddr : (double)this.nMaxEntry > (double)nPossibleMatch * (double)(logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxEntry) + 1);
    }

    boolean increment(MaxKTreeI.NtEntry<T> result) {
        this.getNext(result);
        return this.next != Long.MAX_VALUE;
    }

    boolean isNextSub() {
        return this.nextSubNode != null;
    }

    private boolean readValue(int pin, long pos, MaxKTreeI.NtEntry<T> result) {
        Object v = this.node.getValueByPIN(pin);
        if (v == null) {
            return false;
        }
        this.prefix = this.node.localReadAndApplyReadPostfixAndHc(pin, pos, this.prefix);
        if (v instanceof NtNode) {
            NtNode sub = (NtNode)v;
            long mask = -1L << (sub.getPostLen() + 1) * 8;
            if (((this.prefix | this.globalMinMask) & this.globalMaxMask & mask) != (this.prefix & mask)) {
                return false;
            }
            this.nextSubNode = sub;
        } else {
            if (((this.prefix | this.globalMinMask) & this.globalMaxMask) != this.prefix) {
                return false;
            }
            this.nextSubNode = null;
            this.node.getKdKeyByPIN(pin, result.getKdKey());
            result.setValue(v == NodeTreeV13.NT_NULL ? null : v);
        }
        result.setKey(this.prefix);
        return true;
    }

    private long getNextHCI(MaxKTreeI.NtEntry<T> result) {
        int pin;
        long currentPos = this.next;
        do {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
                continue;
            }
            if ((currentPos = NodeTreeV13.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower) continue;
            return Long.MAX_VALUE;
        } while ((pin = this.node.getPosition(currentPos, 8)) < 0 || !this.readValue(pin, currentPos, result));
        return currentPos;
    }

    private void getNext(MaxKTreeI.NtEntry<T> result) {
        if (this.useHcIncrementer) {
            this.next = this.getNextHCI(result);
        } else if (this.isHC) {
            this.getNextAHC(result);
        } else {
            this.getNextLHC(result);
        }
    }

    private void getNextAHC(MaxKTreeI.NtEntry<T> result) {
        long currentPos;
        long l = currentPos = this.next == -1L ? this.maskLower : this.next + 1L;
        while (currentPos <= this.maskUpper) {
            if (this.checkHcPos(currentPos) && this.readValue((int)currentPos, currentPos, result)) {
                this.next = currentPos;
                return;
            }
            ++currentPos;
        }
        this.next = Long.MAX_VALUE;
    }

    private void getNextLHC(MaxKTreeI.NtEntry<T> result) {
        while (++this.nFound <= this.nMaxEntry) {
            long currentPos = Bits.readArray(this.node.ba, this.currentOffsetKey, NtNode.IK_WIDTH(8));
            this.currentOffsetKey += this.postEntryLenLHC;
            if (this.checkHcPos(currentPos)) {
                if (!this.readValue(this.nFound - 1, currentPos, result)) continue;
                this.next = currentPos;
                return;
            }
            if (currentPos <= this.maskUpper) continue;
            break;
        }
        this.next = Long.MAX_VALUE;
    }

    private boolean checkHcPos(long pos) {
        return ((pos | this.maskLower) & this.maskUpper) == pos;
    }

    public NtNode<T> getCurrentSubNode() {
        return this.nextSubNode;
    }

    public NtNode<T> node() {
        return this.node;
    }

    private void calcLimits(long globalMinMask, long globalMaxMask) {
        int postLen = this.node.getPostLen();
        this.maskLower = NtNode.pos2LocalPos(globalMinMask, postLen);
        this.maskUpper = NtNode.pos2LocalPos(globalMaxMask, postLen);
        this.globalMinMask = globalMinMask;
        this.globalMaxMask = globalMaxMask;
    }

    boolean adjustMinMax(long globalMinMask, long globalMaxMask) {
        this.calcLimits(globalMinMask, globalMaxMask);
        if (this.next >= this.maskUpper) {
            return false;
        }
        if (this.next < this.maskLower) {
            this.next = -1L;
            return true;
        }
        if (this.useHcIncrementer && !this.checkHcPos(this.next)) {
            long pos;
            for (pos = this.next - 1L; !this.checkHcPos(pos) && pos > -1L; --pos) {
            }
            this.next = pos;
        }
        return true;
    }

    void init(long globalMinMask, long globalMaxMask, long valTemplate, NtNode<T> node) {
        this.node = node;
        this.calcLimits(globalMinMask, globalMaxMask);
        this.reinit(node, valTemplate);
    }

    boolean verifyMinMax(long globalMinMask, long globalMaxMask) {
        long mask = -1L << this.node.getPostLen() + 1;
        return (this.prefix | mask ^ 0xFFFFFFFFFFFFFFFFL) >= globalMinMask && (this.prefix & mask) <= globalMaxMask;
    }

    public long getPrefix() {
        return this.prefix;
    }
}

