/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;
import org.tinspin.index.PointMap;
import org.tinspin.index.PointMultimap;
import org.tinspin.index.Stats;
import org.tinspin.index.qtplain.QIteratorKnn;
import org.tinspin.index.qtplain.QNode;
import org.tinspin.index.qtplain.QUtil;
import org.tinspin.index.util.StringBuilderLn;

public class QuadTreeKD0<T>
implements PointMap<T>,
PointMultimap<T> {
    private static final int MAX_DEPTH = 50;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    public static final boolean DEBUG = false;
    private final int dims;
    private final int maxNodeSize;
    private QNode<T> root = null;
    private int size = 0;

    private QuadTreeKD0(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeKD0<T> create(int dims) {
        return new QuadTreeKD0<T>(dims, 10);
    }

    public static <T> QuadTreeKD0<T> create(int dims, int maxNodeSize) {
        return new QuadTreeKD0<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeKD0<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeKD0<T> t = new QuadTreeKD0<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] key, T value) {
        ++this.size;
        Index.PointEntry<T> e = new Index.PointEntry<T>(key, value);
        if (this.root == null) {
            this.initializeRoot(key);
        }
        this.ensureCoverage(e);
        int depth = 0;
        for (QNode<T> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
        }
    }

    private void initializeRoot(double[] key) {
        double lo = Double.MAX_VALUE;
        double hi = -1.7976931348623157E308;
        for (int d = 0; d < this.dims; ++d) {
            lo = Math.min(lo, key[d]);
            hi = Math.max(hi, key[d]);
        }
        if (lo == 0.0 && hi == 0.0) {
            hi = 1.0;
        }
        double maxDistOrigin = Math.abs(hi) > Math.abs(lo) ? hi : lo;
        maxDistOrigin = Math.abs(maxDistOrigin);
        maxDistOrigin *= 1.0000000020000002;
        double[] center = new double[this.dims];
        for (int d = 0; d < this.dims; ++d) {
            center[d] = key[d] > 0.0 ? maxDistOrigin : -maxDistOrigin;
        }
        this.root = new QNode(center, maxDistOrigin);
    }

    @Override
    @Deprecated
    public boolean contains(double[] key) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(key, entry -> true) != null;
    }

    @Override
    public T queryExact(double[] key) {
        if (this.root == null) {
            return null;
        }
        Index.PointEntry<T> e = this.root.getExact(key, entry -> true);
        return e == null ? null : (T)e.value();
    }

    @Override
    public boolean contains(double[] key, T value) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(key, e -> Objects.equals(value, e.value())) != null;
    }

    @Override
    public T remove(double[] key) {
        if (this.root == null) {
            return null;
        }
        Index.PointEntry<T> e = this.root.remove(null, key, this.maxNodeSize, x -> true);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public boolean remove(double[] key, T value) {
        return this.removeIf(key, e -> Objects.equals(e.value(), value));
    }

    @Override
    public boolean removeIf(double[] key, Predicate<Index.PointEntry<T>> condition) {
        if (this.root == null) {
            return false;
        }
        Index.PointEntry<T> e = this.root.remove(null, key, this.maxNodeSize, condition);
        if (e == null) {
            return false;
        }
        --this.size;
        return true;
    }

    @Override
    public T update(double[] oldKey, double[] newKey) {
        return this.updateIf(oldKey, newKey, e -> true);
    }

    @Override
    public boolean update(double[] oldKey, double[] newKey, T value) {
        return this.updateIf(oldKey, newKey, e -> Objects.equals(e.value(), value)) != null;
    }

    public T updateIf(double[] oldKey, double[] newKey, Predicate<Index.PointEntry<T>> condition) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        Index.PointEntry<T> e = this.root.update(null, oldKey, newKey, this.maxNodeSize, requiresReinsert, 0, 50, condition);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            int depth = 0;
            for (QNode<T> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
            }
        }
        return e.value();
    }

    private void ensureCoverage(Index.PointEntry<T> e) {
        double[] p = e.point();
        while (!QUtil.fitsIntoNode(e.point(), this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            for (int d = 0; d < center.length; ++d) {
                center2[d] = p[d] < center[d] - radius ? center[d] - radius : center[d] + radius;
            }
            this.root = new QNode<T>(center2, radius2, this.root);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public Index.PointIterator<T> queryExactPoint(double[] point) {
        return this.query(point, point);
    }

    @Override
    public QIterator<T> query(double[] min2, double[] max) {
        return new QIterator(this, min2, max);
    }

    @Override
    public Index.PointEntryKnn<T> query1nn(double[] center) {
        return new QIteratorKnn<T>(this.root, 1, center, PointDistance.L2, (e, d) -> true).next();
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k, PointDistance dist) {
        return new QIteratorKnn<T>(this.root, k, center, dist, (e, d) -> true);
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, QNode<T> node, int depth, int posInParent) {
        Iterator<?> it = node.getChildIterator();
        Object prefix = ".".repeat(depth);
        sb.append((String)prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.appendLn("/" + node.getRadius());
        prefix = (String)prefix + " ";
        int pos = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof QNode) {
                QNode sub = (QNode)o;
                this.toStringTree(sb, sub, depth + 1, pos);
            } else if (o instanceof Index.PointEntry) {
                Index.PointEntry e = (Index.PointEntry)o;
                sb.append((String)prefix + Arrays.toString(e.point()));
                sb.appendLn(" v=" + e.value());
            }
            ++pos;
        }
    }

    public String toString() {
        return "QuadTreeKD0;maxNodeSize=" + this.maxNodeSize + ";maxDepth=50;DEBUG=false;center/radius=" + (String)(this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius());
    }

    @Override
    public QStats getStats() {
        QStats s2 = new QStats();
        if (this.root != null) {
            this.root.checkNode(s2, null, 0);
        }
        return s2;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public Index.PointIterator<T> iterator() {
        if (this.root == null) {
            return this.query(new double[this.dims], new double[this.dims]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k) {
        return this.queryKnn(center, k, PointDistance.L2);
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    public static class QStats
    extends Stats {
        protected QStats() {
            super(0L, 0L, 0L);
        }
    }

    public static class QIterator<T>
    implements Index.PointIterator<T> {
        private final QuadTreeKD0<T> tree;
        private final ArrayDeque<Iterator<?>> stack = new ArrayDeque();
        private Index.PointEntry<T> next = null;
        private double[] min;
        private double[] max;

        QIterator(QuadTreeKD0<T> tree, double[] min2, double[] max) {
            this.tree = tree;
            this.reset(min2, max);
        }

        private void findNext() {
            while (!this.stack.isEmpty()) {
                Iterator<?> it = this.stack.peek();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof QNode) {
                        QNode node = (QNode)o;
                        if (!QUtil.overlap(this.min, this.max, node.getCenter(), node.getRadius())) continue;
                        it = node.getChildIterator();
                        this.stack.push(it);
                        continue;
                    }
                    Index.PointEntry e = (Index.PointEntry)o;
                    if (!QUtil.isPointEnclosed(e.point(), this.min, this.max)) continue;
                    this.next = e;
                    return;
                }
                this.stack.pop();
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Index.PointEntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Index.PointEntry<T> ret = this.next;
            this.findNext();
            return ret;
        }

        @Override
        public Index.PointIterator<T> reset(double[] min2, double[] max) {
            this.stack.clear();
            this.min = min2;
            this.max = max;
            this.next = null;
            if (this.tree.root != null) {
                this.stack.push(this.tree.root.getChildIterator());
                this.findNext();
            }
            return this;
        }
    }
}

