/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import org.tinspin.index.Index;
import org.tinspin.index.rtree.RTreeEntry;
import org.tinspin.index.rtree.RTreeNodeDir;

abstract class RTreeNode<T>
extends RTreeEntry<T> {
    private RTreeNodeDir<T> parent;

    RTreeNode(int dim) {
        super(new double[dim], new double[dim], null);
    }

    abstract void addEntry(RTreeEntry<T> var1);

    abstract ArrayList<RTreeEntry<T>> getEntries();

    double calcOverlapEnlarged(RTreeEntry<T> enlargement, RTreeNode<T> otherNode) {
        double area = 1.0;
        for (int i = 0; i < this.min().length; ++i) {
            double d = Math.min(Math.max(this.max()[i], enlargement.max()[i]), otherNode.max()[i]) - Math.max(Math.min(this.min()[i], enlargement.min()[i]), otherNode.min()[i]);
            if (d <= 0.0) {
                return 0.0;
            }
            area *= d;
        }
        return area;
    }

    public double calcAreaEnlarged(RTreeEntry<T> e) {
        double area = 1.0;
        for (int i = 0; i < this.min().length; ++i) {
            double d = Math.max(this.max()[i], e.max()[i]) - Math.min(this.min()[i], e.min()[i]);
            area *= d;
        }
        return area;
    }

    protected void setMBB(RTreeEntry<T> e) {
        for (int i = 0; i < this.min().length; ++i) {
            this.min()[i] = e.min()[i];
            this.max()[i] = e.max()[i];
        }
    }

    protected void extendMBB(RTreeEntry<T> e) {
        for (int i = 0; i < this.min().length; ++i) {
            if (this.min()[i] > e.min()[i]) {
                this.min()[i] = e.min()[i];
            }
            if (!(this.max()[i] < e.max()[i])) continue;
            this.max()[i] = e.max()[i];
        }
    }

    public boolean recalcMBB() {
        double[] minOld = (double[])this.min().clone();
        double[] maxOld = (double[])this.max().clone();
        this.resetMBB();
        ArrayList<RTreeEntry<T>> entries = this.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Index.BoxEntry e = entries.get(i);
            for (int d = 0; d < this.min().length; ++d) {
                if (this.min()[d] > e.min()[d]) {
                    this.min()[d] = e.min()[d];
                }
                if (!(this.max()[d] < e.max()[d])) continue;
                this.max()[d] = e.max()[d];
            }
        }
        return !Arrays.equals(this.min(), minOld) || !Arrays.equals(this.max(), maxOld);
    }

    protected void resetMBB() {
        Arrays.fill(this.min(), Double.POSITIVE_INFINITY);
        Arrays.fill(this.max(), Double.NEGATIVE_INFINITY);
    }

    public abstract void clear();

    public void setParent(RTreeNodeDir<T> parent) {
        this.parent = parent;
    }

    public RTreeNodeDir<T> getParent() {
        return this.parent;
    }

    public void extendParentMBB() {
        for (RTreeNodeDir<T> current = this.parent; current != null; current = current.getParent()) {
            current.extendMBB(this);
        }
    }

    public void recalcParentMBB() {
        for (RTreeNodeDir<T> current = this.parent; current != null && current.recalcMBB(); current = current.getParent()) {
        }
    }

    public void recalcRecursiveMBB() {
        if (this.recalcMBB()) {
            this.recalcParentMBB();
        }
    }

    public abstract boolean hasSpace();

    public abstract boolean isUnderfull();

    public void removeEntry(int i) {
        this.getEntries().remove(i);
        this.recalcRecursiveMBB();
    }
}

