/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Skeleton;
import org.twak.camp.Tag;
import org.twak.utils.Cache;
import org.twak.utils.IdentityLookup;
import org.twak.utils.Triple;
import org.twak.utils.collections.ConsecutiveTriples;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.geom.AngleAccumulator;
import org.twak.utils.geom.GraphMap;

public class Output {
    public static Tag isCreatedHorizontal = new Tag("horizontal");
    public Map<Corner, Face> faces = new LinkedHashMap<Corner, Face>();
    public List<LoopNormal> nonSkelFaces = new ArrayList<LoopNormal>();
    public List<LoopNormal> nonSkelFaces2 = new ArrayList<LoopNormal>();
    public IdentityLookup<SharedEdge> edges = new IdentityLookup();
    public Skeleton skeleton;

    public Output(Skeleton skel) {
        this.skeleton = skel;
    }

    public void newEdge(Edge e, Corner aParentLeadingCorner, Set<Tag> profileFeatures) {
        Face face = new Face();
        face.edge = e;
        if (profileFeatures != null) {
            face.profile = profileFeatures;
        }
        if (aParentLeadingCorner != null) {
            Face parentFace = this.faces.get(aParentLeadingCorner);
            assert (parentFace != null);
            face.parent = parentFace;
            this.skeleton.parent(face, parentFace);
        }
        assert (this.faces.get(e.start) == null);
        e.start.nextL = e;
        e.end.prevL = e;
        this.faces.put(e.start, face);
    }

    public void newDefiningSegment(Corner leadingCorner) {
        Face face = this.faces.get(leadingCorner.nextL.start);
        SharedEdge se = this.createEdge(leadingCorner, leadingCorner.nextC);
        face.definingSE.add(se);
        se.setLeft(leadingCorner, null, face);
        face.results.add(se.start, se.end);
        se.features.add(isCreatedHorizontal);
        face.definingCorners.add(leadingCorner);
    }

    public void addOutputSideTo(Tuple3d a, Tuple3d b, Edge ... edges) {
        this.addOutputSideTo(false, a, b, edges);
    }

    public void addOutputSideTo(boolean isTop, Tuple3d a, Tuple3d b, Edge ... edges) {
        for (Edge edge : edges) {
            Corner c = edge.start;
            Face f = this.faces.get(c);
            assert (f != null);
            if (isTop) {
                f.topSE.add(this.createEdge(a, b));
            }
            f.results.add(new Point3d(a), new Point3d(b));
        }
    }

    public void addNonSkeletonOutputFace(LoopL<? extends Point3d> points, Vector3d norm) {
        this.nonSkelFaces.add(new LoopNormal(points, norm));
    }

    public void addNonSkeletonSharedEdges(Tag ... profileTags) {
        for (LoopNormal ln : this.nonSkelFaces) {
            for (Loop loop : ln.loopl) {
                Face f = new Face();
                for (Tag t : profileTags) {
                    f.profile.add(t);
                }
                Loop<SharedEdge> seloop = new Loop<SharedEdge>();
                f.edges.add((SharedEdge)((Object)seloop));
                f.points = new LoopL();
                Loop<Point3d> fLoop = new Loop<Point3d>();
                f.points.add((Point3d)((Object)fLoop));
                for (Loopable loopable : loop.loopableIterator()) {
                    SharedEdge e = this.createEdge((Tuple3d)loopable.get(), (Tuple3d)loopable.getNext().get());
                    fLoop.append((Point3d)loopable.get());
                    if (f.definingSE.isEmpty()) {
                        f.definingSE.add(e);
                        f.edge = new Edge(new Corner((Tuple3d)e.start), new Corner((Tuple3d)e.end));
                        Vector3d dir = f.edge.direction();
                        dir.normalize();
                        f.edge.uphill = new Vector3d(-dir.y, dir.x, 0.0);
                        this.faces.put(new Corner((Tuple3d)loopable.get()), f);
                    }
                    e.setLeft((Point3d)loopable.get(), seloop.append(e), f);
                }
            }
        }
    }

    public void addNonSkeletonOutputFace2(LoopL<Point3d> points, Vector3d norm) {
        this.nonSkelFaces2.add(new LoopNormal(points, norm));
    }

    public void setParent(Corner neu, Corner old) {
        Face nF = this.faces.get(neu);
        Face oF = this.faces.get(old);
        this.skeleton.parent(nF, oF);
        nF.parent = oF;
    }

    public void calculate(Skeleton skel) {
        block2: for (Face face : this.faces.values()) {
            LinkedHashSet notVisited = new LinkedHashSet(face.results.map.keySet());
            LoopL<Loop<Point3d>> faceWithHoles = new LoopL<Loop<Point3d>>();
            face.points = faceWithHoles;
            try {
                Point3d edgeStart = face.definingSE.iterator().next().getStart(face);
                block3: while (!notVisited.isEmpty()) {
                    Point3d start;
                    Loop<Point3d> poly = new Loop<Point3d>();
                    boolean isOuter = notVisited.contains(edgeStart);
                    Point3d pos = start = isOuter ? edgeStart : (Point3d)notVisited.iterator().next();
                    Point3d last = face.results.get(start).get(0);
                    Point3d first = null;
                    Point3d lastAdded = null;
                    AngleAccumulator ac = new AngleAccumulator(isOuter, face.edge.getPlaneNormal());
                    int count = 0;
                    block4: while (true) {
                        List<Point3d> choice = face.results.get(pos);
                        assert (choice != null);
                        for (Point3d c : choice) {
                            if (count++ > 1000) continue block2;
                            if (last.equals(c) || pos.equals(c)) continue;
                            if (first == null) {
                                first = c;
                            }
                            notVisited.remove(c);
                            if ((lastAdded == null || lastAdded.distance(c) > 0.01) && (first == c || first.distance(c) > 0.01)) {
                                poly.append(c);
                                ac.add(c);
                                lastAdded = c;
                            }
                            last = pos;
                            pos = c;
                            if (pos != start) continue block4;
                        }
                        continue block2;
                        break;
                    }
                    {
                        if (!ac.correctAngle()) {
                            poly.reverse();
                        }
                        this.removeStraights(poly);
                        if (poly.count() < 3) continue block3;
                        faceWithHoles.add(poly);
                        continue block3;
                        break;
                    }
                }
            }
            catch (Throwable e) {
            }
        }
        ArrayList<Face> nullFaces = new ArrayList<Face>();
        for (Face f : this.faces.values()) {
            if (f.points.size() > 0) continue;
            nullFaces.add(f);
        }
        for (Face f : this.faces.values()) {
            f.findSharedEdges();
        }
    }

    void merge(Corner toKeep, Corner toGo) {
        Face toGoFace = this.faces.get(toGo.nextL.start);
        Face toKeepFace = this.faces.get(toKeep.nextL.start);
        if (toGoFace == null) {
            System.err.println("three consecutive parallel edges in input?");
            return;
        }
        toKeepFace.definingSE.addAll(toGoFace.definingSE);
        toKeepFace.results.addEntriesFrom(toGoFace.results);
        toKeepFace.definingCorners.addAll(toGoFace.definingCorners);
        this.faces.put(toGo, toKeepFace);
    }

    private SharedEdge createEdge(Tuple3d start, Tuple3d end) {
        SharedEdge newEdge = new SharedEdge(new Point3d(start), new Point3d(end));
        newEdge = this.edges.get(newEdge);
        return newEdge;
    }

    public Cache<Corner, Collection<Corner>> getSegmentOriginator() {
        return new Cache<Corner, Collection<Corner>>(){

            @Override
            public List<Corner> get(Corner aCorner) {
                Face f = Output.this.faces.get(aCorner.nextL.start);
                while (f.parent != null) {
                    f = f.parent;
                }
                return new ArrayList<Corner>(f.definingCorners);
            }

            @Override
            public List<Corner> create(Corner i) {
                throw new UnsupportedOperationException("Have overridden get(), shouldn't end up here!");
            }
        };
    }

    public Face getGreatestGrandParent(Face f) {
        if (f == null) {
            return null;
        }
        while (f.parent != null) {
            f = f.parent;
        }
        return f;
    }

    private void removeStraights(Loop<Point3d> poly) {
        if (poly.count() < 3) {
            return;
        }
        HashSet<Loopable<Point3d>> togo = new HashSet<Loopable<Point3d>>();
        for (Triple<Loopable<Point3d>, Loopable<Point3d>, Loopable<Point3d>> triple : new ConsecutiveTriples<Loopable<Point3d>>(poly.loopableIterator(), true)) {
            double small;
            Loopable<Point3d> a = triple.first();
            Loopable<Point3d> b = triple.second();
            Loopable<Point3d> c = triple.third();
            Vector3d ab = new Vector3d(b.get());
            Vector3d bc = new Vector3d(c.get());
            ab.sub(a.get());
            bc.sub(b.get());
            double angle = ab.angle(bc);
            if (!(angle < (small = 0.001)) && !(angle > Math.PI - small)) continue;
            togo.add(b);
        }
        for (Loopable loopable : togo) {
            poly.remove(loopable);
        }
    }

    public Output dupeEdgesOnly() {
        Output out = new Output(null);
        Cache<Face, Face> fCache = new Cache<Face, Face>(){

            @Override
            public Face create(Face old) {
                Face face = new Face();
                GraphMap outGM = new GraphMap();
                outGM.addEntriesFrom(old.results);
                face.results = outGM;
                face.parent = old.parent == null ? null : (Face)this.get(old.parent);
                face.edge = new Edge(old.edge.start, old.edge.end);
                face.definingSE = new HashSet<SharedEdge>();
                for (SharedEdge se : old.definingSE) {
                    SharedEdge neu = new SharedEdge(se.start, se.end);
                    neu.setLeft(se.start, null, face);
                    face.definingSE.add(neu);
                }
                return face;
            }
        };
        for (Corner c : this.faces.keySet()) {
            out.faces.put(c, (Face)fCache.get(this.faces.get(c)));
        }
        return out;
    }

    public static class SharedEdge {
        public Point3d start;
        public Point3d end;
        public Face left;
        public Face right;
        public Loopable<SharedEdge> cLeft;
        public Loopable<SharedEdge> cRight;
        Set<Tag> features = new HashSet<Tag>();

        public SharedEdge(Point3d start, Point3d end) {
            this.start = start;
            this.end = end;
        }

        public Point3d getStart(Face ref) {
            if (ref == this.left) {
                return this.end;
            }
            if (ref == this.right) {
                return this.start;
            }
            return null;
        }

        public Point3d getEnd(Face ref) {
            if (ref == this.left) {
                return this.start;
            }
            if (ref == this.right) {
                return this.end;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SharedEdge) {
                SharedEdge o = (SharedEdge)obj;
                if (o.start.equals(this.start)) {
                    return o.end.equals(this.end);
                }
                if (o.end.equals(this.start)) {
                    return o.start.equals(this.end);
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash += 71 * (this.start != null ? this.start.hashCode() : 0);
            return hash += 71 * (this.end != null ? this.end.hashCode() : 0);
        }

        public Face getOther(Face ref) {
            if (ref == this.left) {
                return this.right;
            }
            if (ref == this.right) {
                return this.left;
            }
            return null;
        }

        private void setLeft(Point3d start, Loopable<SharedEdge> ctxLeft, Face left) {
            if (this.start.equals(start)) {
                this.left = left;
                this.cLeft = ctxLeft;
            } else if (this.end.equals(start)) {
                this.right = left;
                this.cRight = ctxLeft;
            } else {
                throw new Error();
            }
        }

        public String toString() {
            return "{" + String.valueOf(this.start) + " to " + String.valueOf(this.end) + "}";
        }

        public SharedEdge getAdjEdge(Face f, boolean next) {
            if (f == this.left) {
                if (this.cLeft == null) {
                    return null;
                }
                return next ? this.cLeft.getNext().get() : this.cLeft.getPrev().get();
            }
            if (this.cRight == null) {
                return null;
            }
            return next ? this.cRight.getNext().get() : this.cRight.getPrev().get();
        }

        public Vector3d dir(Face f) {
            Point3d p = this.getEnd(f);
            Point3d ps = this.getStart(f);
            if (p == null || ps == null) {
                return null;
            }
            Vector3d out = new Vector3d(p);
            out.sub(ps);
            return out;
        }

        public Face leftFromStart(Point3d x) {
            if (x.equals(this.start)) {
                return this.left;
            }
            if (x.equals(this.end)) {
                return this.right;
            }
            return null;
        }
    }

    public class Face {
        public LoopL<Point3d> points = null;
        public Set<Tag> plan = new HashSet<Tag>();
        public Set<Tag> profile = new HashSet<Tag>();
        public Set<SharedEdge> definingSE = new LinkedHashSet<SharedEdge>();
        public Set<SharedEdge> topSE = new LinkedHashSet<SharedEdge>();
        public Face parent;
        public GraphMap<Point3d> results = new GraphMap();
        public Edge edge;
        public Set<Corner> definingCorners = new LinkedHashSet<Corner>();
        public LoopL<SharedEdge> edges = new LoopL();

        public LoopL<Point3d> getLoopL() {
            return this.points;
        }

        public int pointCount() {
            return this.points.count();
        }

        public boolean isTop(SharedEdge edge) {
            return this.topSE.contains(edge);
        }

        public boolean isBottom(SharedEdge edge) {
            return this.definingSE.contains(edge);
        }

        public boolean isSide(SharedEdge edge) {
            return !this.isTop(edge) && !this.isBottom(edge);
        }

        public int getParentCount() {
            int count = -1;
            Face f = this;
            while (f != null) {
                ++count;
                f = f.parent;
            }
            return count;
        }

        private void findSharedEdges() {
            this.edges = new LoopL();
            for (Loop loop : this.points) {
                Loop<SharedEdge> loop2 = new Loop<SharedEdge>();
                this.edges.add((SharedEdge)((Object)loop2));
                for (Loopable loopable : loop.loopableIterator()) {
                    SharedEdge e = Output.this.createEdge((Tuple3d)loopable.get(), (Tuple3d)loopable.getNext().get());
                    e.setLeft((Point3d)loopable.get(), loop2.append(e), this);
                }
            }
        }
    }

    public static class LoopNormal {
        public LoopL<? extends Point3d> loopl;
        public Vector3d norm;

        public LoopNormal(LoopL<? extends Point3d> loopl, Vector3d norm) {
            this.loopl = loopl;
            this.norm = norm;
        }
    }
}

