/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphMap<E> {
    public Map<E, List<E>> map = new LinkedHashMap<E, List<E>>();

    public void add(E a, E b) {
        this.addEntry(a, b);
        this.addEntry(b, a);
    }

    private void addEntry(E a, E b) {
        List<E> res = this.map.get(a);
        if (res == null) {
            res = new ArrayList();
            this.map.put(a, res);
        }
        if (!res.contains(b)) {
            res.add(b);
        }
    }

    public List<E> get(E a) {
        return this.map.get(a);
    }

    public void clear() {
        this.map.clear();
    }

    public void addEntriesFrom(GraphMap otherMap) {
        if (otherMap == this) {
            return;
        }
        Iterator<Map.Entry<E, List<E>>> iterator = otherMap.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<E, List<E>> e;
            Map.Entry<E, List<E>> entry = e = iterator.next();
            for (E dest : entry.getValue()) {
                this.addEntry(entry.getKey(), dest);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (E e : this.map.keySet()) {
            sb.append(String.valueOf(e) + " |||   ");
            for (E ee : this.map.get(e)) {
                sb.append(String.valueOf(ee) + ",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void remove(E a, E b) {
        this.remove_(a, b);
        this.remove_(b, a);
    }

    void remove_(E a, E b) {
        List<E> e = this.get(a);
        if (e == null) {
            return;
        }
        e.remove(b);
        if (e.isEmpty()) {
            this.map.remove(a);
        }
    }

    public Set<E> values() {
        HashSet<E> out = new HashSet<E>();
        for (List<E> le : this.map.values()) {
            out.addAll(le);
        }
        return out;
    }
}

