/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.twak.utils.Line;

public class LinearForm
implements Serializable {
    public double x;
    public double y;
    public double c;

    public LinearForm() {
    }

    public LinearForm(Line in) {
        this.x = in.start.y - in.end.y;
        this.y = in.end.x - in.start.x;
        this.findC(in.start);
    }

    public LinearForm(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public LinearForm(LinearForm l) {
        this.y = l.y;
        this.x = l.x;
        this.c = l.c;
    }

    public LinearForm(double x, double y, double c) {
        this.y = y;
        this.x = x;
        this.c = c;
    }

    public LinearForm(Vector2d dir) {
        this.x = -dir.y;
        this.y = dir.x;
    }

    public LinearForm(Point2d a, Point2d b) {
        this.x = b.y - a.y;
        this.y = a.x - b.x;
        this.findC(a);
    }

    public LinearForm findC(Tuple2d goesThrough) {
        this.findC(goesThrough.x, goesThrough.y);
        return this;
    }

    public LinearForm findC(double x1, double y1) {
        this.c = this.x * x1 + this.y * y1;
        return this;
    }

    public double intersectsP(Point2d start, Vector2d dir) {
        LinearForm lf = new LinearForm(-dir.y, dir.x);
        lf.findC(start);
        Point2d p2 = this.intersect(lf);
        if (p2 == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (dir.x > dir.y) {
            return (p2.x - start.x) / dir.x;
        }
        return (p2.y - start.y) / dir.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.c + ")";
    }

    public boolean isParallel(LinearForm other) {
        return this.x * other.y - other.x * this.y == 0.0;
    }

    public boolean isAlmostParallel(LinearForm other) {
        return Math.abs(this.x * other.y - other.x * this.y) <= 1.0E-4;
    }

    public void perpendicular() {
        double tmp = this.x;
        this.x = -this.y;
        this.y = tmp;
    }

    public Vector2d unitVector() {
        Vector2d out = new Vector2d(-this.y, this.x);
        out.normalize();
        return out;
    }

    public double gradient() {
        if (this.y == 0.0) {
            return this.x > 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return -this.x / this.y;
    }

    public Point2d intersect(LinearForm o) {
        double det = this.x * o.y - o.x * this.y;
        if (det == 0.0) {
            return null;
        }
        double x_ = (o.y * this.c - this.y * o.c) / det;
        double y_ = (this.x * o.c - o.x * this.c) / det;
        return new Point2d(x_, y_);
    }

    public boolean sameOrientation(LinearForm o) {
        return Math.abs(this.x - o.x) < 0.001 && Math.abs(this.y - o.y) < 0.001;
    }

    public Line toLine(double start, double end) {
        return new Line(this.boxBound(start), this.boxBound(end));
    }

    public Point2d pointOnLine() {
        if (Math.abs(this.x) < Math.abs(this.y)) {
            return new Point2d(0.0, this.c / this.y);
        }
        return new Point2d(this.c / this.x, 0.0);
    }

    private Point2d boxBound(double v) {
        if (Math.abs(this.x) < Math.abs(this.y)) {
            return new Point2d(v, (this.c - this.x * v) / this.y);
        }
        return new Point2d((this.c - this.y * v) / this.x, v);
    }

    public double xAtY(double _y) {
        if (this.x == 0.0) {
            throw new Error("can't do that");
        }
        return (this.c - _y * this.y) / this.x;
    }

    public double yAtX(double _x) {
        if (this.y == 0.0) {
            throw new Error("can't do that");
        }
        return (this.c - _x * this.x) / this.y;
    }

    public double distance(Point2d pt) {
        return Math.abs(this.x * pt.x + this.y * pt.y - this.c) / Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double angle(LinearForm other) {
        return new Vector2d(this.x, this.y).angle(new Vector2d(other.x, other.y));
    }

    public Point2d project(Point2d pt) {
        double denom = -this.x * this.x - this.y * this.y;
        return new Point2d((this.x * -this.c + this.y * (-this.y * pt.x + this.x * pt.y)) / denom, (this.y * -this.c + this.x * this.y * pt.x - this.x * this.x * pt.y) / denom);
    }

    public boolean isInFront(Point2d pt) {
        return this.x * pt.x + this.y * pt.y - this.c > 0.0;
    }

    public double findPParam(Point2d pt_) {
        Point2d origin = this.project(new Point2d());
        Vector2d dir = this.unitVector();
        Point2d pt = this.project(pt_);
        pt.sub(origin);
        if (Math.abs(dir.x) > Math.abs(dir.y)) {
            return pt.x / dir.x;
        }
        return pt.y / dir.y;
    }

    public Point2d fromPParam(double p) {
        Point2d origin = this.project(new Point2d());
        Point2d dir = new Point2d(this.unitVector());
        dir.scale(p);
        dir.add(origin);
        return dir;
    }

    public double angleFromNorth() {
        return Math.atan2(this.y, this.x);
    }

    public int compareAngle(LinearForm other) {
        return Double.compare(this.angleFromNorth(), other.angleFromNorth());
    }

    public int comparePPram(Point2d a, Point2d b) {
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        double ap = this.findPParam(a);
        double bp = this.findPParam(b);
        return Double.compare(ap, bp);
    }

    public double getOffset(LinearForm other) {
        return other.c - this.c;
    }
}

