/*
 * Decompiled with CFR 0.152.
 */
package org.zoodb.index.critbit;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.zoodb.index.critbit.BitTools;
import org.zoodb.index.critbit.CritBit64;

public class CritBit64COW<V>
extends CritBit64<V>
implements Iterable<V> {
    private final Lock writeLock = new ReentrantLock();

    private CritBit64COW() {
    }

    public static <V> CritBit64COW<V> create() {
        return new CritBit64COW<V>();
    }

    public CritBit64COW<V> copy() {
        CritBit64COW<V> critBitCopy = CritBit64COW.create();
        critBitCopy.info = this.info.copy();
        return critBitCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(long key, V val) {
        try {
            this.writeLock.lock();
            CritBit64.AtomicInfo newInfo = this.info.copy();
            V ret = this.doPut(key, val, newInfo);
            this.info = newInfo;
            V v = ret;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private V doPut(long key, V val, CritBit64.AtomicInfo<V> newInfo) {
        CritBit64.AtomicInfo currentInfo = this.info;
        int size = currentInfo.size;
        if (size == 0) {
            newInfo.rootKey = key;
            newInfo.rootVal = val;
            ++newInfo.size;
            return null;
        }
        if (size == 1) {
            CritBit64.Node<V> n2 = this.createNode(key, val, this.info.rootKey, this.info.rootVal);
            if (n2 == null) {
                Object prev = currentInfo.rootVal;
                newInfo.rootVal = val;
                return prev;
            }
            newInfo.root = n2;
            newInfo.rootKey = CritBit64COW.extractPrefix(key, n2.posDiff - 1);
            newInfo.rootVal = null;
            ++newInfo.size;
            return null;
        }
        CritBit64.Node n = newInfo.root;
        int parentPosDiff = -1;
        long prefix = newInfo.rootKey;
        CritBit64.Node parent = null;
        boolean isCurrentChildLo = false;
        while (true) {
            block23: {
                int posDiff;
                n = new CritBit64.Node(n);
                if (parent != null) {
                    if (isCurrentChildLo) {
                        parent.lo = n;
                    } else {
                        parent.hi = n;
                    }
                } else {
                    newInfo.root = n;
                }
                if (parentPosDiff + 1 != n.posDiff && (posDiff = CritBit64COW.compare(key, prefix)) < n.posDiff && posDiff != -1) {
                    CritBit64.Node<Object> newSub;
                    long subPrefix = CritBit64COW.extractPrefix(prefix, posDiff - 1);
                    if (BitTools.getBit(key, posDiff)) {
                        newSub = new CritBit64.Node<Object>(prefix, null, key, val, posDiff);
                        newSub.lo = n;
                    } else {
                        newSub = new CritBit64.Node<Object>(key, val, prefix, null, posDiff);
                        newSub.hi = n;
                    }
                    if (parent == null) {
                        newInfo.rootKey = subPrefix;
                        newInfo.root = newSub;
                    } else if (isCurrentChildLo) {
                        parent.loPost = subPrefix;
                        parent.lo = newSub;
                    } else {
                        parent.hiPost = subPrefix;
                        parent.hi = newSub;
                    }
                    ++newInfo.size;
                    return null;
                }
                if (BitTools.getBit(key, (int)n.posDiff)) {
                    if (n.hi != null) {
                        prefix = n.hiPost;
                        parent = n;
                        n = n.hi;
                        isCurrentChildLo = false;
                        break block23;
                    } else {
                        CritBit64.Node<V> n2 = this.createNode(key, val, n.hiPost, n.hiVal);
                        if (n2 == null) {
                            Object prev = n.hiVal;
                            n.hiVal = val;
                            return prev;
                        }
                        n.hi = n2;
                        n.hiPost = CritBit64COW.extractPrefix(key, n2.posDiff - 1);
                        n.hiVal = null;
                        ++newInfo.size;
                        return null;
                    }
                }
                if (n.lo != null) {
                    prefix = n.loPost;
                    parent = n;
                    n = n.lo;
                    isCurrentChildLo = true;
                } else {
                    CritBit64.Node<V> n2 = this.createNode(key, val, n.loPost, n.loVal);
                    if (n2 == null) {
                        Object prev = n.loVal;
                        n.loVal = val;
                        return prev;
                    }
                    n.lo = n2;
                    n.loPost = CritBit64COW.extractPrefix(key, n2.posDiff - 1);
                    n.loVal = null;
                    ++newInfo.size;
                    return null;
                }
            }
            parentPosDiff = n.posDiff;
        }
    }

    @Override
    public void printTree() {
        System.out.println("Tree: \n" + this.toString());
    }

    @Override
    public String toString() {
        CritBit64.AtomicInfo info = this.info;
        if (info.size == 0) {
            return "- -";
        }
        if (info.root == null) {
            return "-" + BitTools.toBinary(info.rootKey, 64) + " v=" + info.rootVal;
        }
        CritBit64.Node n = info.root;
        StringBuilder s2 = new StringBuilder();
        this.printNode(n, s2, "", 0, info.rootKey);
        return s2.toString();
    }

    private void printNode(CritBit64.Node<V> n, StringBuilder s2, String level, int currentDepth, long infix) {
        char NL = '\n';
        if (currentDepth != n.posDiff) {
            s2.append(level + "n: " + currentDepth + "/" + n.posDiff + " " + BitTools.toBinary(infix, 64) + NL);
        } else {
            s2.append(level + "n: " + currentDepth + "/" + n.posDiff + " i=0" + NL);
        }
        if (n.lo != null) {
            this.printNode(n.lo, s2, level + "-", n.posDiff + 1, n.loPost);
        } else {
            s2.append(level + " " + BitTools.toBinary(n.loPost, 64) + " v=" + n.loVal + NL);
        }
        if (n.hi != null) {
            this.printNode(n.hi, s2, level + "-", n.posDiff + 1, n.hiPost);
        } else {
            s2.append(level + " " + BitTools.toBinary(n.hiPost, 64) + " v=" + n.hiVal + NL);
        }
    }

    @Override
    public boolean checkTree() {
        CritBit64.AtomicInfo info = this.info;
        if (info.root == null) {
            if (info.size > 1) {
                System.err.println("root node = null AND size = " + info.size);
                return false;
            }
            return true;
        }
        return this.checkNode(info.root, 0, info.rootKey);
    }

    private boolean checkNode(CritBit64.Node<V> n, int firstBitOfNode, long prefix) {
        if (n.posDiff < firstBitOfNode) {
            System.err.println("prefix with len=0 detected!");
            return false;
        }
        if (n.lo != null) {
            if (!this.doesPrefixMatch(n.posDiff - 1, n.loPost, prefix)) {
                System.err.println("lo: prefix mismatch");
                return false;
            }
            this.checkNode(n.lo, n.posDiff + 1, n.loPost);
        }
        if (n.hi != null) {
            if (!this.doesPrefixMatch(n.posDiff - 1, n.hiPost, prefix)) {
                System.err.println("hi: prefix mismatch");
                return false;
            }
            this.checkNode(n.hi, n.posDiff + 1, n.hiPost);
        }
        return true;
    }

    private CritBit64.Node<V> createNode(long k1, V val1, long k2, V val2) {
        int posDiff = CritBit64COW.compare(k1, k2);
        if (posDiff == -1) {
            return null;
        }
        if (BitTools.getBit(k2, posDiff)) {
            return new CritBit64.Node<V>(k1, val1, k2, val2, posDiff);
        }
        return new CritBit64.Node<V>(k2, val2, k1, val1, posDiff);
    }

    private static long extractPrefix(long v, int endPos) {
        long inf = v;
        if (endPos < 63) {
            inf &= -1L >>> 1 + endPos ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return inf;
    }

    private boolean doesPrefixMatch(int posDiff, long v, long prefix) {
        if (posDiff > 0) {
            return (v ^ prefix) >>> 64 - posDiff == 0L;
        }
        return true;
    }

    private static int compare(long v1, long v2) {
        return v1 == v2 ? -1 : Long.numberOfLeadingZeros(v1 ^ v2);
    }

    @Override
    public int size() {
        return this.info.size;
    }

    @Override
    public boolean contains(long key) {
        CritBit64.AtomicInfo info = this.info;
        int size = info.size;
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            return key == info.rootKey;
        }
        CritBit64.Node n = info.root;
        long prefix = info.rootKey;
        while (this.doesPrefixMatch(n.posDiff, key, prefix)) {
            if (BitTools.getBit(key, (int)n.posDiff)) {
                if (n.hi != null) {
                    prefix = n.hiPost;
                    n = n.hi;
                    continue;
                }
                return key == n.hiPost;
            }
            if (n.lo != null) {
                prefix = n.loPost;
                n = n.lo;
                continue;
            }
            return key == n.loPost;
        }
        return false;
    }

    @Override
    public V get(long key) {
        CritBit64.AtomicInfo info = this.info;
        if (info.size == 0) {
            return null;
        }
        if (info.size == 1) {
            return key == info.rootKey ? (V)info.rootVal : null;
        }
        CritBit64.Node n = info.root;
        long prefix = info.rootKey;
        while (this.doesPrefixMatch(n.posDiff, key, prefix)) {
            if (BitTools.getBit(key, (int)n.posDiff)) {
                if (n.hi != null) {
                    prefix = n.hiPost;
                    n = n.hi;
                    continue;
                }
                return key == n.hiPost ? (V)n.hiVal : null;
            }
            if (n.lo != null) {
                prefix = n.loPost;
                n = n.lo;
                continue;
            }
            return key == n.loPost ? (V)n.loVal : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(long key) {
        try {
            this.writeLock.lock();
            if (this.contains(key)) {
                CritBit64.AtomicInfo newInfo = this.info.copy();
                Object ret = this.doRemove(key, newInfo);
                this.info = newInfo;
                Object v = ret;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private V doRemove(long key, CritBit64.AtomicInfo<V> newInfo) {
        CritBit64.AtomicInfo info = this.info;
        if (info.size == 0) {
            return null;
        }
        if (info.size == 1) {
            if (key == info.rootKey) {
                --newInfo.size;
                newInfo.rootKey = 0L;
                Object prev = info.rootVal;
                info.rootVal = null;
                return prev;
            }
            return null;
        }
        CritBit64.Node n = info.root;
        CritBit64.Node parent = null;
        boolean isParentHigh = false;
        long prefix = info.rootKey;
        while (this.doesPrefixMatch(n.posDiff, key, prefix)) {
            n = new CritBit64.Node(n);
            if (parent != null) {
                if (!isParentHigh) {
                    parent.lo = n;
                } else {
                    parent.hi = n;
                }
            } else {
                newInfo.root = n;
            }
            if (BitTools.getBit(key, (int)n.posDiff)) {
                if (n.hi != null) {
                    isParentHigh = true;
                    prefix = n.hiPost;
                    parent = n;
                    n = n.hi;
                    continue;
                }
                if (key != n.hiPost) {
                    return null;
                }
                this.updateParentAfterRemove(newInfo, parent, n.loPost, n.loVal, n.lo, isParentHigh);
                return n.hiVal;
            }
            if (n.lo != null) {
                isParentHigh = false;
                prefix = n.loPost;
                parent = n;
                n = n.lo;
                continue;
            }
            if (key != n.loPost) {
                return null;
            }
            this.updateParentAfterRemove(newInfo, parent, n.hiPost, n.hiVal, n.hi, isParentHigh);
            return n.loVal;
        }
        return null;
    }

    private void updateParentAfterRemove(CritBit64.AtomicInfo<V> newInfo, CritBit64.Node<V> parent, long newPost, V newVal, CritBit64.Node<V> newSub, boolean isParentHigh) {
        long l = newPost = newSub == null ? newPost : CritBit64COW.extractPrefix(newPost, newSub.posDiff - 1);
        if (parent == null) {
            newInfo.rootKey = newPost;
            newInfo.rootVal = newVal;
            newInfo.root = newSub;
        } else if (isParentHigh) {
            parent.hiPost = newPost;
            parent.hiVal = newVal;
            parent.hi = newSub;
        } else {
            parent.loPost = newPost;
            parent.loVal = newVal;
            parent.lo = newSub;
        }
        --newInfo.size;
    }
}

