/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceSF;
import ch.ethz.globis.phtree.PhDistanceSFEdgeDist;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.pre.PreProcessorRangeF;
import ch.ethz.globis.phtree.util.PhIteratorBase;
import ch.ethz.globis.phtree.util.PhMapper;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;

public class PhTreeSolidF<T>
implements Iterable<T> {
    private final int dims;
    private final PhTree<T> pht;
    private final PreProcessorRangeF pre;
    private final PhDistanceSF dist;
    private final double[] qMIN;
    private final double[] qMAX;

    protected PhTreeSolidF(int dim) {
        this(PhTree.create(dim * 2));
    }

    public PhTreeSolidF(PhTree<T> tree) {
        this(tree, new PreProcessorRangeF.IEEE(tree.getDim()));
    }

    public PhTreeSolidF(PhTree<T> tree, PreProcessorRangeF pre) {
        this.dims = tree.getDim() / 2;
        if (this.dims * 2 != tree.getDim()) {
            throw new IllegalArgumentException("The backing tree's DIM must be a multiple of 2");
        }
        this.pht = tree;
        this.pre = pre;
        this.dist = new PhDistanceSFEdgeDist(pre, this.dims);
        this.qMIN = new double[this.dims];
        Arrays.fill(this.qMIN, Double.NEGATIVE_INFINITY);
        this.qMAX = new double[this.dims];
        Arrays.fill(this.qMAX, Double.POSITIVE_INFINITY);
    }

    public static <T> PhTreeSolidF<T> wrap(PhTree<T> tree) {
        return new PhTreeSolidF<T>(tree, new PreProcessorRangeF.IEEE(tree.getDim()));
    }

    public static <T> PhTreeSolidF<T> create(int dim) {
        return new PhTreeSolidF<T>(dim);
    }

    public static <T> PhTreeSolidF<T> create(int dim, PreProcessorRangeF pre) {
        return new PhTreeSolidF(PhTree.create(dim * 2), pre);
    }

    public T put(double[] lower, double[] upper, T value) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.put(lVal, value);
    }

    public T remove(double[] lower, double[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.remove(lVal);
    }

    public boolean contains(double[] lower, double[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.contains(lVal);
    }

    public T put(PhEntrySF<T> e) {
        return this.put(e.lower(), e.upper(), e.value());
    }

    public T remove(PhEntrySF<T> e) {
        return this.remove(e.lower(), e.upper());
    }

    public boolean contains(PhEntrySF<T> e) {
        return this.contains(e.lower(), e.upper());
    }

    public PhQuerySF<T> queryInclude(PhEntrySF<T> e) {
        return this.queryInclude(e.lower(), e.upper());
    }

    public PhQuerySF<T> queryIntersect(PhEntrySF<T> e) {
        return this.queryIntersect(e.lower(), e.upper());
    }

    public PhQuerySF<T> queryInclude(double[] lower, double[] upper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(lower, lower, lLow);
        this.pre.pre(upper, upper, lUpp);
        return new PhQuerySF<T>(this.pht.query(lLow, lUpp), this.dims, this.pre, false);
    }

    public PhQuerySF<T> queryIntersect(double[] lower, double[] upper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(this.qMIN, lower, lLow);
        this.pre.pre(upper, this.qMAX, lUpp);
        return new PhQuerySF<T>(this.pht.query(lLow, lUpp), this.dims, this.pre, true);
    }

    public PhKnnQuerySF<T> nearestNeighbour(int nMin, PhDistanceSF distanceFunction, double ... center) {
        long[] lCenter = new long[2 * this.dims];
        this.pre.pre(center, center, lCenter);
        PhDistanceSF df = distanceFunction == null ? this.dist : distanceFunction;
        return new PhKnnQuerySF<T>(this.pht.nearestNeighbour(nMin, df, null, lCenter), this.dims, this.pre);
    }

    @Override
    public PhIteratorSF<T> iterator() {
        return new PhIteratorSF(this.pht.queryExtent(), this.dims, this.pre);
    }

    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        long[] pOld = new long[lo1.length << 1];
        long[] pNew = new long[lo1.length << 1];
        this.pre.pre(lo1, up1, pOld);
        this.pre.pre(lo2, up2, pNew);
        return this.pht.update(pOld, pNew);
    }

    public List<PhEntrySF<T>> queryIntersectAll(double[] lower, double[] upper) {
        return this.queryIntersectAll(lower, upper, Integer.MAX_VALUE, null, e -> {
            double[] lo = new double[lower.length];
            double[] up = new double[lower.length];
            this.pre.post(e.getKey(), lo, up);
            return new PhEntrySF(lo, up, e.getValue());
        });
    }

    public <R> List<R> queryIntersectAll(double[] lower, double[] upper, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(this.qMIN, lower, lLow);
        this.pre.pre(upper, this.qMAX, lUpp);
        return this.pht.queryAll(lLow, lUpp, maxResults, filter, mapper);
    }

    public int size() {
        return this.pht.size();
    }

    public T get(double[] lower, double[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.get(lVal);
    }

    public void clear() {
        this.pht.clear();
    }

    public PhTree<T> getInternalTree() {
        return this.pht;
    }

    public PreProcessorRangeF getPreProcessor() {
        return this.pre;
    }

    public String toString() {
        return this.pht.toString();
    }

    public int getDims() {
        return this.dims;
    }

    public T getOrDefault(double[] lower, double[] upper, T defaultValue) {
        T t = this.get(lower, upper);
        return t == null ? defaultValue : t;
    }

    public T putIfAbsent(double[] lower, double[] upper, T value) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.putIfAbsent(key, value);
    }

    public boolean remove(double[] lower, double[] upper, T value) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.remove(key, value);
    }

    public boolean replace(double[] lower, double[] upper, T oldValue, T newValue) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.replace(key, oldValue, newValue);
    }

    public T replace(double[] lower, double[] upper, T value) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.replace(key, value);
    }

    public T computeIfAbsent(double[] lower, double[] upper, BiFunction<double[], double[], ? extends T> mappingFunction) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return (T)this.pht.computeIfAbsent(key, longs -> mappingFunction.apply(lower, upper));
    }

    public T computeIfPresent(double[] lower, double[] upper, SolidBiFunction<double[], ? super T, ? extends T> remappingFunction) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return (T)this.pht.computeIfPresent(key, (longs, value) -> remappingFunction.apply(lower, upper, (Object)value));
    }

    public T compute(double[] lower, double[] upper, SolidBiFunction<double[], ? super T, ? extends T> remappingFunction) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return (T)this.pht.compute(key, (longs, value) -> remappingFunction.apply(lower, upper, (Object)value));
    }

    public static class PhEntryDistSF<T>
    extends PhEntrySF<T> {
        private double dist;

        public PhEntryDistSF(double[] lower, double[] upper, T value, double dist) {
            super(lower, upper, value);
            this.dist = dist;
        }

        void setValueDist(T value, double dist) {
            this.setValue(value);
            this.dist = dist;
        }

        public double dist() {
            return this.dist;
        }

        @Override
        public String toString() {
            return super.toString() + " dist=" + this.dist;
        }
    }

    public static class PhEntrySF<T> {
        private final double[] lower;
        private final double[] upper;
        private T value;

        public PhEntrySF(double[] lower, double[] upper, T value) {
            this.lower = lower;
            this.upper = upper;
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        public double[] lower() {
            return this.lower;
        }

        public double[] upper() {
            return this.upper;
        }

        void setValue(T value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PhEntrySF)) {
                return false;
            }
            PhEntrySF e = (PhEntrySF)obj;
            return Arrays.equals(this.lower, e.lower) && Arrays.equals(this.upper, e.upper);
        }

        public int hashCode() {
            return Arrays.hashCode(this.lower) ^ Arrays.hashCode(this.upper);
        }

        public String toString() {
            return "{" + Arrays.toString(this.lower) + "," + Arrays.toString(this.upper) + "} => " + this.value;
        }
    }

    public static class PhKnnQuerySF<T>
    extends PhIteratorSF<T> {
        private final long[] lCenterBuffer;
        private final PhTree.PhKnnQuery<T> q;
        private final double[] qMIN;
        private final double[] qMAX;
        private final int dims;
        protected final PreProcessorRangeF pre;
        private final PhEntryDistSF<T> buffer;

        protected PhKnnQuerySF(PhTree.PhKnnQuery<T> iter, int dims, PreProcessorRangeF pre) {
            super(iter, dims, pre);
            this.q = iter;
            this.qMIN = new double[dims];
            Arrays.fill(this.qMIN, Double.NEGATIVE_INFINITY);
            this.qMAX = new double[dims];
            Arrays.fill(this.qMAX, Double.POSITIVE_INFINITY);
            this.lCenterBuffer = new long[dims * 2];
            this.dims = dims;
            this.pre = pre;
            this.buffer = new PhEntryDistSF<Object>(new double[dims], new double[dims], null, Double.NaN);
        }

        public PhKnnQuerySF<T> reset(int nMin, PhDistance newDist, double[] center) {
            this.pre.pre(center, center, this.lCenterBuffer);
            this.q.reset(nMin, newDist, this.lCenterBuffer);
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public T nextValue() {
            return (T)this.iter.nextValue();
        }

        @Override
        public PhEntryDistSF<T> nextEntry() {
            double[] lower = new double[this.dims];
            double[] upper = new double[this.dims];
            PhEntryDist pvEntry = (PhEntryDist)this.q.nextEntryReuse();
            this.pre.post(pvEntry.getKey(), lower, upper);
            return new PhEntryDistSF(lower, upper, pvEntry.getValue(), pvEntry.dist());
        }

        @Override
        public PhEntryDistSF<T> nextEntryReuse() {
            PhEntryDist pvEntry = (PhEntryDist)this.q.nextEntryReuse();
            this.pre.post(pvEntry.getKey(), this.buffer.lower(), this.buffer.upper());
            this.buffer.setValueDist(pvEntry.getValue(), pvEntry.dist());
            return this.buffer;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    public static class PhQuerySF<T>
    extends PhIteratorSF<T> {
        private final long[] lLow;
        private final long[] lUpp;
        private final PhTree.PhQuery<T> q;
        private final double[] qMIN;
        private final double[] qMAX;
        private final boolean intersect;

        protected PhQuerySF(PhTree.PhQuery<T> iter, int dims, PreProcessorRangeF pre, boolean intersect) {
            super(iter, dims, pre);
            this.q = iter;
            this.qMIN = new double[dims];
            Arrays.fill(this.qMIN, Double.NEGATIVE_INFINITY);
            this.qMAX = new double[dims];
            Arrays.fill(this.qMAX, Double.POSITIVE_INFINITY);
            this.intersect = intersect;
            this.lLow = new long[dims * 2];
            this.lUpp = new long[dims * 2];
        }

        public PhQuerySF<T> reset(double[] lower, double[] upper) {
            if (this.intersect) {
                this.pre.pre(this.qMIN, lower, this.lLow);
                this.pre.pre(upper, this.qMAX, this.lUpp);
            } else {
                this.pre.pre(lower, lower, this.lLow);
                this.pre.pre(upper, upper, this.lUpp);
            }
            this.q.reset(this.lLow, this.lUpp);
            return this;
        }
    }

    public static class PhIteratorSF<T>
    implements PhIteratorBase<T, PhEntrySF<T>> {
        protected final PhIteratorBase<T, ? extends PhEntry<T>> iter;
        private final int dims;
        protected final PreProcessorRangeF pre;
        private final PhEntrySF<T> buffer;

        protected PhIteratorSF(PhIteratorBase<T, ? extends PhEntry<T>> iter, int dims, PreProcessorRangeF pre) {
            this.iter = iter;
            this.dims = dims;
            this.pre = pre;
            this.buffer = new PhEntrySF<Object>(new double[dims], new double[dims], null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public T nextValue() {
            return this.iter.nextValue();
        }

        @Override
        public PhEntrySF<T> nextEntry() {
            double[] lower = new double[this.dims];
            double[] upper = new double[this.dims];
            PhEntry<T> pvEntry = this.iter.nextEntryReuse();
            this.pre.post(pvEntry.getKey(), lower, upper);
            return new PhEntrySF<T>(lower, upper, pvEntry.getValue());
        }

        @Override
        public PhEntrySF<T> nextEntryReuse() {
            PhEntry<T> pvEntry = this.iter.nextEntryReuse();
            this.pre.post(pvEntry.getKey(), ((PhEntrySF)this.buffer).lower, ((PhEntrySF)this.buffer).upper);
            this.buffer.setValue(pvEntry.getValue());
            return this.buffer;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    @FunctionalInterface
    public static interface SolidBiFunction<T, U, R> {
        public R apply(T var1, T var2, U var3);
    }
}

