/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.FormatMethod;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.sedona.shaded.s2.Real;
import org.apache.sedona.shaded.s2.S2Point;

public final class Platform {
    private Platform() {
    }

    public static double IEEEremainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    static Logger getLoggerForClass(Class<?> clazz) {
        return Logger.getLogger(clazz.getCanonicalName());
    }

    public static void assertStringEquals(String expectedJava, String expectedJ2cl, String actual) {
        if (!expectedJava.contentEquals(actual)) {
            throw new AssertionError((Object)("Expected '" + expectedJava + "' to equal '" + actual + "'"));
        }
    }

    public static void printf(PrintStream stream, String format, Object ... params) {
        stream.printf(format, params);
    }

    @FormatMethod
    public static String formatString(String format, Object ... params) {
        return String.format(format, params);
    }

    public static String formatDouble(double d) {
        StringBuilder out = new StringBuilder();
        if (d == 0.0) {
            return "0";
        }
        out.append(String.format(Locale.US, "%.15g", d));
        if (out.length() >= 5 && out.charAt(out.length() - 4) == 'e') {
            while (out.length() >= 5 && out.charAt(out.length() - 5) == '0') {
                out.deleteCharAt(out.length() - 5);
            }
            if (out.charAt(out.length() - 5) == '.') {
                out.deleteCharAt(out.length() - 5);
            }
        } else {
            while (out.length() > 0 && out.charAt(out.length() - 1) == '0') {
                out.setLength(out.length() - 1);
            }
            if (out.length() > 0 && out.charAt(out.length() - 1) == '.') {
                out.setLength(out.length() - 1);
            }
        }
        return out.toString();
    }

    public static long doubleHash(double value) {
        return Double.doubleToLongBits(value);
    }

    public static int sign(S2Point a, S2Point b, S2Point c) {
        try {
            Real bycz = Real.strictMul(b.y, c.z);
            Real bzcy = Real.strictMul(b.z, c.y);
            Real bzcx = Real.strictMul(b.z, c.x);
            Real bxcz = Real.strictMul(b.x, c.z);
            Real bxcy = Real.strictMul(b.x, c.y);
            Real bycx = Real.strictMul(b.y, c.x);
            Real bcx = bycz.sub(bzcy);
            Real bcy = bzcx.sub(bxcz);
            Real bcz = bxcy.sub(bycx);
            Real x = bcx.strictMul(a.x);
            Real y = bcy.strictMul(a.y);
            Real z = bcz.strictMul(a.z);
            return x.add(y).add(z).signum();
        }
        catch (ArithmeticException unused) {
            return 0;
        }
    }

    public static double ulp(double x) {
        return Math.ulp(x);
    }

    public static double nextAfter(double x, double dir) {
        return Math.nextAfter(x, dir);
    }

    static BigDecimal newBigDecimal(double x) {
        return new BigDecimal(x);
    }
}

