/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.awt.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ColorFactory {
    private static final int PARSE_COMPONENT = 0;
    private static final int PARSE_PERCENT = 1;
    private static final int PARSE_ANGLE = 2;
    private static final int PARSE_ALPHA = 3;
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color ALICEBLUE = new Color(0.9411765f, 0.972549f, 1.0f);
    public static final Color ANTIQUEWHITE = new Color(0.98039216f, 0.92156863f, 0.84313726f);
    public static final Color AQUA = new Color(0.0f, 1.0f, 1.0f);
    public static final Color AQUAMARINE = new Color(0.49803922f, 1.0f, 0.83137256f);
    public static final Color AZURE = new Color(0.9411765f, 1.0f, 1.0f);
    public static final Color BEIGE = new Color(0.9607843f, 0.9607843f, 0.8627451f);
    public static final Color BISQUE = new Color(1.0f, 0.89411765f, 0.76862746f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f);
    public static final Color BLANCHEDALMOND = new Color(1.0f, 0.92156863f, 0.8039216f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f);
    public static final Color BLUEVIOLET = new Color(0.5411765f, 0.16862746f, 0.8862745f);
    public static final Color BROWN = new Color(0.64705884f, 0.16470589f, 0.16470589f);
    public static final Color BURLYWOOD = new Color(0.87058824f, 0.72156864f, 0.5294118f);
    public static final Color CADETBLUE = new Color(0.37254903f, 0.61960787f, 0.627451f);
    public static final Color CHARTREUSE = new Color(0.49803922f, 1.0f, 0.0f);
    public static final Color CHOCOLATE = new Color(0.8235294f, 0.4117647f, 0.11764706f);
    public static final Color CORAL = new Color(1.0f, 0.49803922f, 0.3137255f);
    public static final Color CORNFLOWERBLUE = new Color(0.39215687f, 0.58431375f, 0.92941177f);
    public static final Color CORNSILK = new Color(1.0f, 0.972549f, 0.8627451f);
    public static final Color CRIMSON = new Color(0.8627451f, 0.078431375f, 0.23529412f);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f);
    public static final Color DARKBLUE = new Color(0.0f, 0.0f, 0.54509807f);
    public static final Color DARKCYAN = new Color(0.0f, 0.54509807f, 0.54509807f);
    public static final Color DARKGOLDENROD = new Color(0.72156864f, 0.5254902f, 0.043137256f);
    public static final Color DARKGRAY = new Color(0.6627451f, 0.6627451f, 0.6627451f);
    public static final Color DARKGREEN = new Color(0.0f, 0.39215687f, 0.0f);
    public static final Color DARKGREY = DARKGRAY;
    public static final Color DARKKHAKI = new Color(0.7411765f, 0.7176471f, 0.41960785f);
    public static final Color DARKMAGENTA = new Color(0.54509807f, 0.0f, 0.54509807f);
    public static final Color DARKOLIVEGREEN = new Color(0.33333334f, 0.41960785f, 0.18431373f);
    public static final Color DARKORANGE = new Color(1.0f, 0.54901963f, 0.0f);
    public static final Color DARKORCHID = new Color(0.6f, 0.19607843f, 0.8f);
    public static final Color DARKRED = new Color(0.54509807f, 0.0f, 0.0f);
    public static final Color DARKSALMON = new Color(0.9137255f, 0.5882353f, 0.47843137f);
    public static final Color DARKSEAGREEN = new Color(0.56078434f, 0.7372549f, 0.56078434f);
    public static final Color DARKSLATEBLUE = new Color(0.28235295f, 0.23921569f, 0.54509807f);
    public static final Color DARKSLATEGRAY;
    public static final Color DARKSLATEGREY;
    public static final Color DARKTURQUOISE;
    public static final Color DARKVIOLET;
    public static final Color DEEPPINK;
    public static final Color DEEPSKYBLUE;
    public static final Color DIMGRAY;
    public static final Color DIMGREY;
    public static final Color DODGERBLUE;
    public static final Color FIREBRICK;
    public static final Color FLORALWHITE;
    public static final Color FORESTGREEN;
    public static final Color FUCHSIA;
    public static final Color GAINSBORO;
    public static final Color GHOSTWHITE;
    public static final Color GOLD;
    public static final Color GOLDENROD;
    public static final Color GRAY;
    public static final Color GREEN;
    public static final Color GREENYELLOW;
    public static final Color GREY;
    public static final Color HONEYDEW;
    public static final Color HOTPINK;
    public static final Color INDIANRED;
    public static final Color INDIGO;
    public static final Color IVORY;
    public static final Color KHAKI;
    public static final Color LAVENDER;
    public static final Color LAVENDERBLUSH;
    public static final Color LAWNGREEN;
    public static final Color LEMONCHIFFON;
    public static final Color LIGHTBLUE;
    public static final Color LIGHTCORAL;
    public static final Color LIGHTCYAN;
    public static final Color LIGHTGOLDENRODYELLOW;
    public static final Color LIGHTGRAY;
    public static final Color LIGHTGREEN;
    public static final Color LIGHTGREY;
    public static final Color LIGHTPINK;
    public static final Color LIGHTSALMON;
    public static final Color LIGHTSEAGREEN;
    public static final Color LIGHTSKYBLUE;
    public static final Color LIGHTSLATEGRAY;
    public static final Color LIGHTSLATEGREY;
    public static final Color LIGHTSTEELBLUE;
    public static final Color LIGHTYELLOW;
    public static final Color LIME;
    public static final Color LIMEGREEN;
    public static final Color LINEN;
    public static final Color MAGENTA;
    public static final Color MAROON;
    public static final Color MEDIUMAQUAMARINE;
    public static final Color MEDIUMBLUE;
    public static final Color MEDIUMORCHID;
    public static final Color MEDIUMPURPLE;
    public static final Color MEDIUMSEAGREEN;
    public static final Color MEDIUMSLATEBLUE;
    public static final Color MEDIUMSPRINGGREEN;
    public static final Color MEDIUMTURQUOISE;
    public static final Color MEDIUMVIOLETRED;
    public static final Color MIDNIGHTBLUE;
    public static final Color MINTCREAM;
    public static final Color MISTYROSE;
    public static final Color MOCCASIN;
    public static final Color NAVAJOWHITE;
    public static final Color NAVY;
    public static final Color OLDLACE;
    public static final Color OLIVE;
    public static final Color OLIVEDRAB;
    public static final Color ORANGE;
    public static final Color ORANGERED;
    public static final Color ORCHID;
    public static final Color PALEGOLDENROD;
    public static final Color PALEGREEN;
    public static final Color PALETURQUOISE;
    public static final Color PALEVIOLETRED;
    public static final Color PAPAYAWHIP;
    public static final Color PEACHPUFF;
    public static final Color PERU;
    public static final Color PINK;
    public static final Color PLUM;
    public static final Color POWDERBLUE;
    public static final Color PURPLE;
    public static final Color RED;
    public static final Color ROSYBROWN;
    public static final Color ROYALBLUE;
    public static final Color SADDLEBROWN;
    public static final Color SALMON;
    public static final Color SANDYBROWN;
    public static final Color SEAGREEN;
    public static final Color SEASHELL;
    public static final Color SIENNA;
    public static final Color SILVER;
    public static final Color SKYBLUE;
    public static final Color SLATEBLUE;
    public static final Color SLATEGRAY;
    public static final Color SLATEGREY;
    public static final Color SNOW;
    public static final Color SPRINGGREEN;
    public static final Color STEELBLUE;
    public static final Color TAN;
    public static final Color TEAL;
    public static final Color THISTLE;
    public static final Color TOMATO;
    public static final Color TURQUOISE;
    public static final Color VIOLET;
    public static final Color WHEAT;
    public static final Color WHITE;
    public static final Color WHITESMOKE;
    public static final Color YELLOW;
    public static final Color YELLOWGREEN;

    public static Color hsb(double hue, double saturation, double brightness, double opacity) {
        ColorFactory.checkSB(saturation, brightness);
        double[] rgb = ColorFactory.HSBtoRGB(hue, saturation, brightness);
        Color result = new Color((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)opacity);
        return result;
    }

    public static Color hsb(double hue, double saturation, double brightness) {
        return ColorFactory.hsb(hue, saturation, brightness, 1.0);
    }

    private static void checkSB(double saturation, double brightness) {
        if (saturation < 0.0 || saturation > 1.0) {
            throw new IllegalArgumentException("Color.hsb's saturation parameter (" + saturation + ") expects values 0.0-1.0");
        }
        if (brightness < 0.0 || brightness > 1.0) {
            throw new IllegalArgumentException("Color.hsb's brightness parameter (" + brightness + ") expects values 0.0-1.0");
        }
    }

    public static Color web(String colorString, double opacity) {
        if (colorString == null) {
            throw new NullPointerException("The color components or name must be specified");
        }
        if (colorString.isEmpty()) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        String color = colorString.toLowerCase(Locale.ROOT);
        if (color.startsWith("#")) {
            color = color.substring(1);
        } else if (color.startsWith("0x")) {
            color = color.substring(2);
        } else if (color.startsWith("rgb")) {
            if (color.startsWith("(", 3)) {
                return ColorFactory.parseRGBColor(color, 4, false, opacity);
            }
            if (color.startsWith("a(", 3)) {
                return ColorFactory.parseRGBColor(color, 5, true, opacity);
            }
        } else if (color.startsWith("hsl")) {
            if (color.startsWith("(", 3)) {
                return ColorFactory.parseHSLColor(color, 4, false, opacity);
            }
            if (color.startsWith("a(", 3)) {
                return ColorFactory.parseHSLColor(color, 5, true, opacity);
            }
        } else {
            Color col = NamedColors.get(color);
            if (col != null) {
                if (opacity == 1.0) {
                    return col;
                }
                return new Color(col.getRed(), col.getGreen(), col.getBlue(), (int)(255.0 * opacity + 0.5));
            }
        }
        int len = color.length();
        try {
            if (len == 3) {
                int r = Integer.parseInt(color.substring(0, 1), 16);
                int g2 = Integer.parseInt(color.substring(1, 2), 16);
                int b = Integer.parseInt(color.substring(2, 3), 16);
                return new Color((float)r / 15.0f, (float)g2 / 15.0f, (float)b / 15.0f, (float)opacity);
            }
            if (len == 4) {
                int r = Integer.parseInt(color.substring(0, 1), 16);
                int g3 = Integer.parseInt(color.substring(1, 2), 16);
                int b = Integer.parseInt(color.substring(2, 3), 16);
                int a = Integer.parseInt(color.substring(3, 4), 16);
                return new Color((float)r / 15.0f, (float)g3 / 15.0f, (float)b / 15.0f, (float)(opacity * (double)a / 15.0));
            }
            if (len == 6) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g4 = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                return new Color(r, g4, b, (int)(opacity * 255.0 + 0.5));
            }
            if (len == 8) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g5 = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                int a = Integer.parseInt(color.substring(6, 8), 16);
                return new Color((float)r, (float)g5, (float)b, (float)(opacity * (double)a / 255.0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static Color parseRGBColor(String color, int roff, boolean hasAlpha, double a) {
        try {
            int aend;
            int bend;
            int gend;
            int rend = color.indexOf(44, roff);
            int n = gend = rend < 0 ? -1 : color.indexOf(44, rend + 1);
            int n2 = gend < 0 ? -1 : (bend = color.indexOf(hasAlpha ? 44 : 41, gend + 1));
            int n3 = hasAlpha ? (bend < 0 ? -1 : color.indexOf(41, bend + 1)) : (aend = bend);
            if (aend >= 0) {
                double r = ColorFactory.parseComponent(color, roff, rend, 0);
                double g2 = ColorFactory.parseComponent(color, rend + 1, gend, 0);
                double b = ColorFactory.parseComponent(color, gend + 1, bend, 0);
                if (hasAlpha) {
                    a *= ColorFactory.parseComponent(color, bend + 1, aend, 3);
                }
                return new Color((float)r, (float)g2, (float)b, (float)a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static Color parseHSLColor(String color, int hoff, boolean hasAlpha, double a) {
        try {
            int aend;
            int lend;
            int send;
            int hend = color.indexOf(44, hoff);
            int n = send = hend < 0 ? -1 : color.indexOf(44, hend + 1);
            int n2 = send < 0 ? -1 : (lend = color.indexOf(hasAlpha ? 44 : 41, send + 1));
            int n3 = hasAlpha ? (lend < 0 ? -1 : color.indexOf(41, lend + 1)) : (aend = lend);
            if (aend >= 0) {
                double h2 = ColorFactory.parseComponent(color, hoff, hend, 2);
                double s2 = ColorFactory.parseComponent(color, hend + 1, send, 1);
                double l = ColorFactory.parseComponent(color, send + 1, lend, 1);
                if (hasAlpha) {
                    a *= ColorFactory.parseComponent(color, lend + 1, aend, 3);
                }
                return ColorFactory.hsb(h2, s2, l, a);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static double parseComponent(String color, int off, int end, int type) {
        if ((color = color.substring(off, end).trim()).endsWith("%")) {
            if (type > 1) {
                throw new IllegalArgumentException("Invalid color specification");
            }
            type = 1;
            color = color.substring(0, color.length() - 1).trim();
        } else if (type == 1) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        double c = type == 0 ? (double)Integer.parseInt(color) : Double.parseDouble(color);
        switch (type) {
            case 3: {
                return c < 0.0 ? 0.0 : (c > 1.0 ? 1.0 : c);
            }
            case 1: {
                return c <= 0.0 ? 0.0 : (c >= 100.0 ? 1.0 : c / 100.0);
            }
            case 0: {
                return c <= 0.0 ? 0.0 : (c >= 255.0 ? 1.0 : c / 255.0);
            }
            case 2: {
                return c < 0.0 ? c % 360.0 + 360.0 : (c > 360.0 ? c % 360.0 : c);
            }
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    public static Color web(String colorString) {
        return ColorFactory.web(colorString, 1.0);
    }

    public static Color valueOf(String value) {
        if (value == null) {
            throw new NullPointerException("color must be specified");
        }
        return ColorFactory.web(value);
    }

    private static int to32BitInteger(int red, int green, int blue, int alpha) {
        int i = red;
        i <<= 8;
        i |= green;
        i <<= 8;
        i |= blue;
        i <<= 8;
        return i |= alpha;
    }

    public static double[] HSBtoRGB(double hue, double saturation, double brightness) {
        double normalizedHue = (hue % 360.0 + 360.0) % 360.0;
        hue = normalizedHue / 360.0;
        double r = 0.0;
        double g2 = 0.0;
        double b = 0.0;
        if (saturation == 0.0) {
            g2 = b = brightness;
            r = b;
        } else {
            double h2 = (hue - Math.floor(hue)) * 6.0;
            double f = h2 - Math.floor(h2);
            double p = brightness * (1.0 - saturation);
            double q = brightness * (1.0 - saturation * f);
            double t = brightness * (1.0 - saturation * (1.0 - f));
            switch ((int)h2) {
                case 0: {
                    r = brightness;
                    g2 = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g2 = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g2 = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g2 = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g2 = p;
                    b = brightness;
                    break;
                }
                case 5: {
                    r = brightness;
                    g2 = p;
                    b = q;
                }
            }
        }
        double[] f = new double[]{r, g2, b};
        return f;
    }

    public static double[] RGBtoHSB(double r, double g2, double b) {
        double hue;
        double cmin;
        double cmax;
        double[] hsbvals = new double[3];
        double d = cmax = r > g2 ? r : g2;
        if (b > cmax) {
            cmax = b;
        }
        double d2 = cmin = r < g2 ? r : g2;
        if (b < cmin) {
            cmin = b;
        }
        double brightness = cmax;
        double saturation = cmax != 0.0 ? (cmax - cmin) / cmax : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            double redc = (cmax - r) / (cmax - cmin);
            double greenc = (cmax - g2) / (cmax - cmin);
            double bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g2 == cmax ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        hsbvals[0] = hue * 360.0;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    static {
        DARKSLATEGREY = DARKSLATEGRAY = new Color(0.18431373f, 0.30980393f, 0.30980393f);
        DARKTURQUOISE = new Color(0.0f, 0.80784315f, 0.81960785f);
        DARKVIOLET = new Color(0.5803922f, 0.0f, 0.827451f);
        DEEPPINK = new Color(1.0f, 0.078431375f, 0.5764706f);
        DEEPSKYBLUE = new Color(0.0f, 0.7490196f, 1.0f);
        DIMGREY = DIMGRAY = new Color(0.4117647f, 0.4117647f, 0.4117647f);
        DODGERBLUE = new Color(0.11764706f, 0.5647059f, 1.0f);
        FIREBRICK = new Color(0.69803923f, 0.13333334f, 0.13333334f);
        FLORALWHITE = new Color(1.0f, 0.98039216f, 0.9411765f);
        FORESTGREEN = new Color(0.13333334f, 0.54509807f, 0.13333334f);
        FUCHSIA = new Color(1.0f, 0.0f, 1.0f);
        GAINSBORO = new Color(0.8627451f, 0.8627451f, 0.8627451f);
        GHOSTWHITE = new Color(0.972549f, 0.972549f, 1.0f);
        GOLD = new Color(1.0f, 0.84313726f, 0.0f);
        GOLDENROD = new Color(0.85490197f, 0.64705884f, 0.1254902f);
        GRAY = new Color(0.5019608f, 0.5019608f, 0.5019608f);
        GREEN = new Color(0.0f, 0.5019608f, 0.0f);
        GREENYELLOW = new Color(0.6784314f, 1.0f, 0.18431373f);
        GREY = GRAY;
        HONEYDEW = new Color(0.9411765f, 1.0f, 0.9411765f);
        HOTPINK = new Color(1.0f, 0.4117647f, 0.7058824f);
        INDIANRED = new Color(0.8039216f, 0.36078432f, 0.36078432f);
        INDIGO = new Color(0.29411766f, 0.0f, 0.50980395f);
        IVORY = new Color(1.0f, 1.0f, 0.9411765f);
        KHAKI = new Color(0.9411765f, 0.9019608f, 0.54901963f);
        LAVENDER = new Color(0.9019608f, 0.9019608f, 0.98039216f);
        LAVENDERBLUSH = new Color(1.0f, 0.9411765f, 0.9607843f);
        LAWNGREEN = new Color(0.4862745f, 0.9882353f, 0.0f);
        LEMONCHIFFON = new Color(1.0f, 0.98039216f, 0.8039216f);
        LIGHTBLUE = new Color(0.6784314f, 0.84705883f, 0.9019608f);
        LIGHTCORAL = new Color(0.9411765f, 0.5019608f, 0.5019608f);
        LIGHTCYAN = new Color(0.8784314f, 1.0f, 1.0f);
        LIGHTGOLDENRODYELLOW = new Color(0.98039216f, 0.98039216f, 0.8235294f);
        LIGHTGRAY = new Color(0.827451f, 0.827451f, 0.827451f);
        LIGHTGREEN = new Color(0.5647059f, 0.93333334f, 0.5647059f);
        LIGHTGREY = LIGHTGRAY;
        LIGHTPINK = new Color(1.0f, 0.7137255f, 0.75686276f);
        LIGHTSALMON = new Color(1.0f, 0.627451f, 0.47843137f);
        LIGHTSEAGREEN = new Color(0.1254902f, 0.69803923f, 0.6666667f);
        LIGHTSKYBLUE = new Color(0.5294118f, 0.80784315f, 0.98039216f);
        LIGHTSLATEGREY = LIGHTSLATEGRAY = new Color(0.46666667f, 0.53333336f, 0.6f);
        LIGHTSTEELBLUE = new Color(0.6901961f, 0.76862746f, 0.87058824f);
        LIGHTYELLOW = new Color(1.0f, 1.0f, 0.8784314f);
        LIME = new Color(0.0f, 1.0f, 0.0f);
        LIMEGREEN = new Color(0.19607843f, 0.8039216f, 0.19607843f);
        LINEN = new Color(0.98039216f, 0.9411765f, 0.9019608f);
        MAGENTA = new Color(1.0f, 0.0f, 1.0f);
        MAROON = new Color(0.5019608f, 0.0f, 0.0f);
        MEDIUMAQUAMARINE = new Color(0.4f, 0.8039216f, 0.6666667f);
        MEDIUMBLUE = new Color(0.0f, 0.0f, 0.8039216f);
        MEDIUMORCHID = new Color(0.7294118f, 0.33333334f, 0.827451f);
        MEDIUMPURPLE = new Color(0.5764706f, 0.4392157f, 0.85882354f);
        MEDIUMSEAGREEN = new Color(0.23529412f, 0.7019608f, 0.44313726f);
        MEDIUMSLATEBLUE = new Color(0.48235294f, 0.40784314f, 0.93333334f);
        MEDIUMSPRINGGREEN = new Color(0.0f, 0.98039216f, 0.6039216f);
        MEDIUMTURQUOISE = new Color(0.28235295f, 0.81960785f, 0.8f);
        MEDIUMVIOLETRED = new Color(0.78039217f, 0.08235294f, 0.52156866f);
        MIDNIGHTBLUE = new Color(0.09803922f, 0.09803922f, 0.4392157f);
        MINTCREAM = new Color(0.9607843f, 1.0f, 0.98039216f);
        MISTYROSE = new Color(1.0f, 0.89411765f, 0.88235295f);
        MOCCASIN = new Color(1.0f, 0.89411765f, 0.70980394f);
        NAVAJOWHITE = new Color(1.0f, 0.87058824f, 0.6784314f);
        NAVY = new Color(0.0f, 0.0f, 0.5019608f);
        OLDLACE = new Color(0.99215686f, 0.9607843f, 0.9019608f);
        OLIVE = new Color(0.5019608f, 0.5019608f, 0.0f);
        OLIVEDRAB = new Color(0.41960785f, 0.5568628f, 0.13725491f);
        ORANGE = new Color(1.0f, 0.64705884f, 0.0f);
        ORANGERED = new Color(1.0f, 0.27058825f, 0.0f);
        ORCHID = new Color(0.85490197f, 0.4392157f, 0.8392157f);
        PALEGOLDENROD = new Color(0.93333334f, 0.9098039f, 0.6666667f);
        PALEGREEN = new Color(0.59607846f, 0.9843137f, 0.59607846f);
        PALETURQUOISE = new Color(0.6862745f, 0.93333334f, 0.93333334f);
        PALEVIOLETRED = new Color(0.85882354f, 0.4392157f, 0.5764706f);
        PAPAYAWHIP = new Color(1.0f, 0.9372549f, 0.8352941f);
        PEACHPUFF = new Color(1.0f, 0.85490197f, 0.7254902f);
        PERU = new Color(0.8039216f, 0.52156866f, 0.24705882f);
        PINK = new Color(1.0f, 0.7529412f, 0.79607844f);
        PLUM = new Color(0.8666667f, 0.627451f, 0.8666667f);
        POWDERBLUE = new Color(0.6901961f, 0.8784314f, 0.9019608f);
        PURPLE = new Color(0.5019608f, 0.0f, 0.5019608f);
        RED = new Color(1.0f, 0.0f, 0.0f);
        ROSYBROWN = new Color(0.7372549f, 0.56078434f, 0.56078434f);
        ROYALBLUE = new Color(0.25490198f, 0.4117647f, 0.88235295f);
        SADDLEBROWN = new Color(0.54509807f, 0.27058825f, 0.07450981f);
        SALMON = new Color(0.98039216f, 0.5019608f, 0.44705883f);
        SANDYBROWN = new Color(0.95686275f, 0.6431373f, 0.3764706f);
        SEAGREEN = new Color(0.18039216f, 0.54509807f, 0.34117648f);
        SEASHELL = new Color(1.0f, 0.9607843f, 0.93333334f);
        SIENNA = new Color(0.627451f, 0.32156864f, 0.1764706f);
        SILVER = new Color(0.7529412f, 0.7529412f, 0.7529412f);
        SKYBLUE = new Color(0.5294118f, 0.80784315f, 0.92156863f);
        SLATEBLUE = new Color(0.41568628f, 0.3529412f, 0.8039216f);
        SLATEGREY = SLATEGRAY = new Color(0.4392157f, 0.5019608f, 0.5647059f);
        SNOW = new Color(1.0f, 0.98039216f, 0.98039216f);
        SPRINGGREEN = new Color(0.0f, 1.0f, 0.49803922f);
        STEELBLUE = new Color(0.27450982f, 0.50980395f, 0.7058824f);
        TAN = new Color(0.8235294f, 0.7058824f, 0.54901963f);
        TEAL = new Color(0.0f, 0.5019608f, 0.5019608f);
        THISTLE = new Color(0.84705883f, 0.7490196f, 0.84705883f);
        TOMATO = new Color(1.0f, 0.3882353f, 0.2784314f);
        TURQUOISE = new Color(0.2509804f, 0.8784314f, 0.8156863f);
        VIOLET = new Color(0.93333334f, 0.50980395f, 0.93333334f);
        WHEAT = new Color(0.9607843f, 0.87058824f, 0.7019608f);
        WHITE = new Color(1.0f, 1.0f, 1.0f);
        WHITESMOKE = new Color(0.9607843f, 0.9607843f, 0.9607843f);
        YELLOW = new Color(1.0f, 1.0f, 0.0f);
        YELLOWGREEN = new Color(0.6039216f, 0.8039216f, 0.19607843f);
    }

    private static final class NamedColors {
        private static final Map<String, Color> namedColors = NamedColors.createNamedColors();

        private NamedColors() {
        }

        private static Color get(String name) {
            return namedColors.get(name);
        }

        private static Map<String, Color> createNamedColors() {
            HashMap<String, Color> colors = new HashMap<String, Color>(256);
            colors.put("aliceblue", ALICEBLUE);
            colors.put("antiquewhite", ANTIQUEWHITE);
            colors.put("aqua", AQUA);
            colors.put("aquamarine", AQUAMARINE);
            colors.put("azure", AZURE);
            colors.put("beige", BEIGE);
            colors.put("bisque", BISQUE);
            colors.put("black", BLACK);
            colors.put("blanchedalmond", BLANCHEDALMOND);
            colors.put("blue", BLUE);
            colors.put("blueviolet", BLUEVIOLET);
            colors.put("brown", BROWN);
            colors.put("burlywood", BURLYWOOD);
            colors.put("cadetblue", CADETBLUE);
            colors.put("chartreuse", CHARTREUSE);
            colors.put("chocolate", CHOCOLATE);
            colors.put("coral", CORAL);
            colors.put("cornflowerblue", CORNFLOWERBLUE);
            colors.put("cornsilk", CORNSILK);
            colors.put("crimson", CRIMSON);
            colors.put("cyan", CYAN);
            colors.put("darkblue", DARKBLUE);
            colors.put("darkcyan", DARKCYAN);
            colors.put("darkgoldenrod", DARKGOLDENROD);
            colors.put("darkgray", DARKGRAY);
            colors.put("darkgreen", DARKGREEN);
            colors.put("darkgrey", DARKGREY);
            colors.put("darkkhaki", DARKKHAKI);
            colors.put("darkmagenta", DARKMAGENTA);
            colors.put("darkolivegreen", DARKOLIVEGREEN);
            colors.put("darkorange", DARKORANGE);
            colors.put("darkorchid", DARKORCHID);
            colors.put("darkred", DARKRED);
            colors.put("darksalmon", DARKSALMON);
            colors.put("darkseagreen", DARKSEAGREEN);
            colors.put("darkslateblue", DARKSLATEBLUE);
            colors.put("darkslategray", DARKSLATEGRAY);
            colors.put("darkslategrey", DARKSLATEGREY);
            colors.put("darkturquoise", DARKTURQUOISE);
            colors.put("darkviolet", DARKVIOLET);
            colors.put("deeppink", DEEPPINK);
            colors.put("deepskyblue", DEEPSKYBLUE);
            colors.put("dimgray", DIMGRAY);
            colors.put("dimgrey", DIMGREY);
            colors.put("dodgerblue", DODGERBLUE);
            colors.put("firebrick", FIREBRICK);
            colors.put("floralwhite", FLORALWHITE);
            colors.put("forestgreen", FORESTGREEN);
            colors.put("fuchsia", FUCHSIA);
            colors.put("gainsboro", GAINSBORO);
            colors.put("ghostwhite", GHOSTWHITE);
            colors.put("gold", GOLD);
            colors.put("goldenrod", GOLDENROD);
            colors.put("gray", GRAY);
            colors.put("green", GREEN);
            colors.put("greenyellow", GREENYELLOW);
            colors.put("grey", GREY);
            colors.put("honeydew", HONEYDEW);
            colors.put("hotpink", HOTPINK);
            colors.put("indianred", INDIANRED);
            colors.put("indigo", INDIGO);
            colors.put("ivory", IVORY);
            colors.put("khaki", KHAKI);
            colors.put("lavender", LAVENDER);
            colors.put("lavenderblush", LAVENDERBLUSH);
            colors.put("lawngreen", LAWNGREEN);
            colors.put("lemonchiffon", LEMONCHIFFON);
            colors.put("lightblue", LIGHTBLUE);
            colors.put("lightcoral", LIGHTCORAL);
            colors.put("lightcyan", LIGHTCYAN);
            colors.put("lightgoldenrodyellow", LIGHTGOLDENRODYELLOW);
            colors.put("lightgray", LIGHTGRAY);
            colors.put("lightgreen", LIGHTGREEN);
            colors.put("lightgrey", LIGHTGREY);
            colors.put("lightpink", LIGHTPINK);
            colors.put("lightsalmon", LIGHTSALMON);
            colors.put("lightseagreen", LIGHTSEAGREEN);
            colors.put("lightskyblue", LIGHTSKYBLUE);
            colors.put("lightslategray", LIGHTSLATEGRAY);
            colors.put("lightslategrey", LIGHTSLATEGREY);
            colors.put("lightsteelblue", LIGHTSTEELBLUE);
            colors.put("lightyellow", LIGHTYELLOW);
            colors.put("lime", LIME);
            colors.put("limegreen", LIMEGREEN);
            colors.put("linen", LINEN);
            colors.put("magenta", MAGENTA);
            colors.put("maroon", MAROON);
            colors.put("mediumaquamarine", MEDIUMAQUAMARINE);
            colors.put("mediumblue", MEDIUMBLUE);
            colors.put("mediumorchid", MEDIUMORCHID);
            colors.put("mediumpurple", MEDIUMPURPLE);
            colors.put("mediumseagreen", MEDIUMSEAGREEN);
            colors.put("mediumslateblue", MEDIUMSLATEBLUE);
            colors.put("mediumspringgreen", MEDIUMSPRINGGREEN);
            colors.put("mediumturquoise", MEDIUMTURQUOISE);
            colors.put("mediumvioletred", MEDIUMVIOLETRED);
            colors.put("midnightblue", MIDNIGHTBLUE);
            colors.put("mintcream", MINTCREAM);
            colors.put("mistyrose", MISTYROSE);
            colors.put("moccasin", MOCCASIN);
            colors.put("navajowhite", NAVAJOWHITE);
            colors.put("navy", NAVY);
            colors.put("oldlace", OLDLACE);
            colors.put("olive", OLIVE);
            colors.put("olivedrab", OLIVEDRAB);
            colors.put("orange", ORANGE);
            colors.put("orangered", ORANGERED);
            colors.put("orchid", ORCHID);
            colors.put("palegoldenrod", PALEGOLDENROD);
            colors.put("palegreen", PALEGREEN);
            colors.put("paleturquoise", PALETURQUOISE);
            colors.put("palevioletred", PALEVIOLETRED);
            colors.put("papayawhip", PAPAYAWHIP);
            colors.put("peachpuff", PEACHPUFF);
            colors.put("peru", PERU);
            colors.put("pink", PINK);
            colors.put("plum", PLUM);
            colors.put("powderblue", POWDERBLUE);
            colors.put("purple", PURPLE);
            colors.put("red", RED);
            colors.put("rosybrown", ROSYBROWN);
            colors.put("royalblue", ROYALBLUE);
            colors.put("saddlebrown", SADDLEBROWN);
            colors.put("salmon", SALMON);
            colors.put("sandybrown", SANDYBROWN);
            colors.put("seagreen", SEAGREEN);
            colors.put("seashell", SEASHELL);
            colors.put("sienna", SIENNA);
            colors.put("silver", SILVER);
            colors.put("skyblue", SKYBLUE);
            colors.put("slateblue", SLATEBLUE);
            colors.put("slategray", SLATEGRAY);
            colors.put("slategrey", SLATEGREY);
            colors.put("snow", SNOW);
            colors.put("springgreen", SPRINGGREEN);
            colors.put("steelblue", STEELBLUE);
            colors.put("tan", TAN);
            colors.put("teal", TEAL);
            colors.put("thistle", THISTLE);
            colors.put("tomato", TOMATO);
            colors.put("transparent", TRANSPARENT);
            colors.put("turquoise", TURQUOISE);
            colors.put("violet", VIOLET);
            colors.put("wheat", WHEAT);
            colors.put("white", WHITE);
            colors.put("whitesmoke", WHITESMOKE);
            colors.put("yellow", YELLOW);
            colors.put("yellowgreen", YELLOWGREEN);
            return colors;
        }
    }
}

