/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.ui;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.twak.camp.Edge;
import org.twak.camp.Tag;
import org.twak.camp.ui.Mould;
import org.twak.camp.ui.NaiveMould;
import org.twak.utils.Cache;
import org.twak.utils.Line;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;

public class Bar {
    public Point2d start;
    public Point2d end;
    public Set<Tag> tags = new LinkedHashSet<Tag>();
    public Mould mould = new NaiveMould();

    public Bar(Point2d start, Point2d end) {
        this.start = start;
        this.end = end;
    }

    public double distance(Point2d p) {
        Line l = new Line(this.start, this.end);
        Point2d location = l.project(p, true);
        return location.distance(p);
    }

    public double lengthSquared() {
        return Math.pow(this.end.x - this.start.x, 2.0) + Math.pow(this.end.y - this.start.y, 2.0);
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public Point2d project(Point2d pt) {
        return this.toLine().project(pt, true);
    }

    public Line toLine() {
        return new Line(this.start, this.end);
    }

    public String toString() {
        return "{" + String.valueOf(this.start) + ", " + String.valueOf(this.end) + "}";
    }

    public static LoopL<Bar> clone(LoopL<Bar> in, AffineTransform at) {
        LoopL<Bar> out = new LoopL<Bar>();
        for (Loop loop : in) {
            out.add((Bar)((Object)Bar.clone(loop, at)));
        }
        return out;
    }

    public static Loop<Bar> clone(Loop<Bar> in, AffineTransform at) {
        Point2d start = new Point2d(((Bar)in.start.get()).start);
        if (at != null) {
            Point2D.Double dest = new Point2D.Double();
            at.transform(new Point2D.Double(start.x, start.y), dest);
            start = new Point2d(((Point2D)dest).getX(), ((Point2D)dest).getY());
        }
        Loop<Bar> out = new Loop<Bar>();
        for (Bar bar : in) {
            Point2d end = new Point2d(bar.end);
            if (at != null) {
                Point2D.Double dest = new Point2D.Double();
                at.transform(new Point2D.Double(end.x, end.y), dest);
                end = new Point2d(((Point2D)dest).getX(), ((Point2D)dest).getY());
            }
            assert (start != null);
            assert (end != null);
            Bar newBar = new Bar(start, end);
            newBar.mould = bar.mould;
            newBar.tags = new LinkedHashSet<Tag>(bar.tags);
            out.append((Bar[])new Bar[]{newBar});
            start = end;
        }
        if (((Bar)in.start.getPrev().get()).end == ((Bar)in.start.get()).start) {
            ((Bar)out.start.getPrev().get()).end = ((Bar)out.start.get()).start;
        }
        return out;
    }

    public static LoopL<Bar> fromEdges(LoopL<Edge> outside) {
        LoopL<Bar> loopl = new LoopL<Bar>();
        Cache<Point3d, Point2d> cache = new Cache<Point3d, Point2d>(){

            @Override
            public Point2d create(Point3d i) {
                return new Point2d(i.x, i.y);
            }
        };
        for (Loop loop : outside) {
            Loop<Bar> loop2 = new Loop<Bar>();
            loopl.add((Bar)((Object)loop2));
            for (Edge edge : loop) {
                loop2.append(new Bar((Point2d)cache.get(edge.start), (Point2d)cache.get(edge.end)));
            }
        }
        return loopl;
    }

    public static LoopL<Bar> dupe(LoopL<Bar> ribbon) {
        LoopL<Bar> loopl = new LoopL<Bar>();
        Cache<Point2d, Point2d> cache = new Cache<Point2d, Point2d>(){

            @Override
            public Point2d create(Point2d i) {
                return new Point2d(i.x, i.y);
            }
        };
        for (Loop loop : ribbon) {
            Loop<Bar> loop2 = new Loop<Bar>();
            loopl.add((Bar)((Object)loop2));
            for (Bar bar : loop) {
                loop2.append(new Bar((Point2d)cache.get(bar.start), (Point2d)cache.get(bar.end)));
            }
        }
        return loopl;
    }

    public static void reverse(LoopL<Bar> loopl) {
        for (Bar bar : loopl.eIterator()) {
            Point2d tmp = bar.start;
            bar.start = bar.end;
            bar.end = tmp;
        }
        for (Loop loop : loopl) {
            loop.reverse();
        }
    }
}

