/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import org.twak.camp.Edge;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.Marker;
import org.twak.utils.Cache;
import org.twak.utils.LContext;
import org.twak.utils.Line;
import org.twak.utils.Pair;
import org.twak.utils.PanMouseAdaptor;
import org.twak.utils.collections.ConsecutivePairs;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;

public class PointEditor
extends JComponent {
    public LoopL<Bar> edges = new LoopL();
    public List<Point2d> handles = new ArrayList<Point2d>();
    public LContext<Bar> currentBar = null;
    public PanMouseAdaptor ma;
    boolean paintGrid = false;
    double gridSize = 1.0;
    protected LContext<Bar> dragged = null;
    Loop<Bar> draggedBarSet = null;
    Point2d dragStartPoint = new Point2d();
    public BarSelected barSelected = new BarSelected(){

        @Override
        public void barSelected(LContext<Bar> ctx) {
        }
    };
    Cache<Bar, Set<Marker>> barMarkerCache = new Cache<Bar, Set<Marker>>(){

        @Override
        public Set<Marker> create(Bar i) {
            return new LinkedHashSet<Marker>();
        }
    };

    public PointEditor() {
        this.setBackground(Color.white);
    }

    public PointEditor(BarSelected es) {
        this.barSelected = es;
    }

    protected void createInitial() {
        Loop<Bar> loop = new Loop<Bar>();
        this.edges.add((Bar)((Object)loop));
        for (Pair<Point2d, Point2d> pair : new ConsecutivePairs<Point2d>(Arrays.asList(new Point2d(250.0, 100.0), new Point2d(350.0, 100.0), new Point2d(350.0, 250.0), new Point2d(500.0, 250.0), new Point2d(500.0, 350.0), new Point2d(350.0, 350.0), new Point2d(350.0, 500.0), new Point2d(250.0, 500.0), new Point2d(250.0, 350.0), new Point2d(100.0, 350.0), new Point2d(100.0, 250.0), new Point2d(250.0, 250.0)), true)) {
            loop.append(new Bar(pair.first(), pair.second()));
        }
    }

    private void viewCenter() {
        Point2d mean = new Point2d();
        int count = 0;
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        for (Loop loop : this.edges) {
            for (Bar e : loop) {
                mean.x += e.start.x;
                mean.y += e.start.y;
                maxX = Math.max(maxX, e.start.x);
                minX = Math.min(minX, e.start.x);
                ++count;
            }
        }
        if (count > 0) {
            mean.scale(1.0 / (double)count);
            this.centerView(new Point((int)mean.x, (int)mean.y));
        }
    }

    public void centerView(Point o) {
        this.ma.center(new Point2d(o.x, o.y));
    }

    public void setup() {
        EditorMouseAdapter ap = new EditorMouseAdapter();
        this.ma = new PanMouseAdaptor(this);
        this.createInitial();
        this.addMouseListener(ap);
        this.addMouseMotionListener(ap);
        this.addMouseWheelListener(ap);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
            }
        });
        this.viewCenter();
    }

    protected boolean allowRemove(LContext<Bar> ctx, Point2d corner) {
        return true;
    }

    protected boolean allowDrag(Loop<Bar> loop) {
        return false;
    }

    protected boolean allowDrag(Point2d dragged) {
        return true;
    }

    public void remove(LContext<Bar> ctx, Point2d dragged) {
        if (!this.allowRemove(ctx, dragged)) {
            return;
        }
        if (this.handles.remove(dragged)) {
            this.repaint();
            return;
        }
        Bar bar = ctx.get();
        Loopable loopable = ctx.loopable;
        ctx.loop.remove(loopable);
        if (bar.start == dragged) {
            if (((Bar)loopable.getPrev().get()).end == dragged) {
                ((Bar)loopable.getPrev().get()).end = ((Bar)loopable.get()).end;
            }
        } else if (bar.end == dragged) {
            if (((Bar)loopable.getNext().get()).start == dragged) {
                ((Bar)loopable.getNext().get()).start = ((Bar)loopable.get()).start;
            }
        } else {
            throw new Error("something fishy going on here");
        }
        for (Bar b : this.edges.eIterator()) {
            this.refreshMarkersOn(b);
        }
        this.repaint();
    }

    protected void edgeAdded(LContext<Bar> ctx) {
    }

    public void addBetween(LContext<Bar> ctx, Point l) {
        Point2d n = new Point2d(l.x, l.y);
        Loopable<Bar> loopable = ctx.loop.addAfter(ctx.loopable, new Bar(n, ctx.get().end));
        ctx.get().end = n;
        this.dragged = new LContext<Bar>(loopable, ctx.loop);
        this.dragged.hook = n;
        loopable.get().tags.addAll(ctx.get().tags);
        this.edgeAdded(this.dragged);
        for (Bar b : ctx.loop) {
            this.refreshMarkersOn(b);
        }
    }

    public void moveLoop(Loop<Bar> draggedLoop, Tuple2d offset) {
        if (draggedLoop == null) {
            return;
        }
        for (Bar b : draggedLoop) {
            b.start.add(offset);
        }
        for (Bar b : draggedLoop) {
            this.refreshMarkersOn(b);
        }
    }

    public void painting(Point2d location, Point2d offset, MouseEvent evt) {
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setColor(this.getBackground());
        g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        AffineTransform at = g22.getTransform();
        AffineTransform old = new AffineTransform(at);
        g22.setTransform(at);
        this.paintPointEditor(g22);
        g22.setTransform(old);
        this.paintChildren(g2);
    }

    public void paintPointEditor(Graphics2D g2) {
        g2.setColor(Color.red);
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                g2.drawLine(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y), this.ma.toX(bar.end.x), this.ma.toY(bar.end.y));
            }
        }
        g2.setColor(Color.orange);
        for (Bar bar : this.edges.eIterator()) {
            this.drawPixel((Graphics)g2, bar.start);
        }
    }

    public void showMenu(LContext<Bar> dragged, MouseEvent evt) {
    }

    public void setGridSize(double gridSize) {
        this.gridSize = gridSize;
        this.repaint();
    }

    private Point2d doSnap(LContext<Bar> ctx, Point2d pt, Point2d loc) {
        return new Point2d((double)Math.round(loc.x / this.gridSize) * this.gridSize, (double)Math.round(loc.y / this.gridSize) * this.gridSize);
    }

    protected void drawGrid(Graphics2D g2) {
        if (this.gridSize <= 0.0) {
            return;
        }
        g2.setColor(Color.green);
        int xOff = this.ma.toX(Math.floor(this.ma.fromX(0) / this.gridSize) * this.gridSize);
        int xCount = (int)Math.ceil(this.ma.fromZoom(this.getWidth()) / this.gridSize);
        if (xCount > 300) {
            return;
        }
        for (int x = 0; x < xCount; ++x) {
            int xc = (int)((double)x * this.gridSize * this.ma.getZoom()) + xOff;
            g2.drawLine(xc, 0, xc, this.getHeight());
        }
        int yOff = this.ma.toY(Math.floor(this.ma.fromY(0) / this.gridSize) * this.gridSize);
        int yCount = (int)Math.ceil(this.ma.fromZoom(this.getHeight()) / this.gridSize);
        for (int y = 0; y < yCount; ++y) {
            int yc = (int)((double)y * this.gridSize * this.ma.getZoom()) + yOff;
            g2.drawLine(0, yc, this.getWidth(), yc);
        }
    }

    public void createSection(Point loc, boolean inside) {
    }

    public void movePoint(LContext<Bar> ctx, Point2d pt, Point2d location, MouseEvent evt) {
        pt.x = location.x;
        pt.y = location.y;
    }

    public boolean doSnap() {
        return true;
    }

    public void releasePoint(Point2d pt, LContext<Bar> ctx, MouseEvent evt) {
    }

    protected void drawPixel(Graphics g2, double i, double j) {
        g2.fillRect(this.ma.toX(i) - 2, this.ma.toY(j) - 2, 5, 5);
    }

    protected void drawPixel(Graphics g2, Point p) {
        this.drawPixel(g2, p.x, p.y);
    }

    protected void drawPixel(Graphics g2, Point3d p) {
        this.drawPixel(g2, p.x, p.y);
    }

    protected void drawPixel(Graphics g2, Point2d p) {
        this.drawPixel(g2, p.x, p.y);
    }

    protected void drawLine(Graphics g2, Line line) {
        g2.drawLine(this.ma.toX(line.start.x), this.ma.toY(line.start.y), this.ma.toX(line.end.x), this.ma.toY(line.end.y));
    }

    protected void drawLine(Graphics g2, double x, double y, double x2, double y2) {
        g2.drawLine(this.ma.toX(x), this.ma.toY(y), this.ma.toX(x2), this.ma.toY(y2));
    }

    protected void drawLine(Graphics g2, Point2d start, Point2d end) {
        g2.drawLine(this.ma.toX(start.x), this.ma.toY(start.y), this.ma.toX(end.x), this.ma.toY(end.y));
    }

    protected void drawLine(Graphics g2, Point3d start, Point3d end) {
        g2.drawLine(this.ma.toX(start.x), this.ma.toY(start.y), this.ma.toX(end.x), this.ma.toY(end.y));
    }

    protected void drawPoly(Graphics g2, int[] xes, int[] yes) {
        g2.fillPolygon(xes, yes, xes.length);
    }

    public void createCircularPoints(int count, int x, int y, int rad) {
        this.createCircularPoints(count, x, y, rad, false);
    }

    public void createCircularPoints(int count, int x, int y, int rad, boolean backwards) {
        double delta = Math.PI * 2 / (double)count;
        if (backwards) {
            delta = -delta;
        }
        Loop<Bar> circularEdges = new Loop<Bar>();
        Point2d prev = null;
        for (int i = 0; i < count; ++i) {
            Point2d c = new Point2d(x + (int)(Math.cos((double)i * delta) * (double)rad), y + (int)(Math.sin((double)i * delta) * (double)rad));
            if (prev != null) {
                Bar e = new Bar(prev, c);
                this.edgeAdded(new LContext<Bar>(circularEdges.append(e), circularEdges));
            }
            prev = c;
        }
        Bar e = new Bar(prev, ((Bar)circularEdges.start.get()).start);
        this.edgeAdded(new LContext<Bar>(circularEdges.append(e), circularEdges));
        this.edges.add((Bar)((Object)circularEdges));
    }

    public LContext<Bar> getNearest(Point destination, double max) {
        return this.getNearest(new Point2d(destination.x, destination.y), max);
    }

    public LContext<Bar> getNearest(Point2d destination, double max) {
        Iterator<LContext<Bar>> it = this.edges.getCIterator();
        LContext<Bar> out = null;
        double best = max;
        while (it.hasNext()) {
            LContext<Bar> ctx = it.next();
            double dist = ctx.get().distance(destination);
            if (!(dist < best)) continue;
            out = ctx;
            best = dist;
        }
        return out;
    }

    public boolean isDragging() {
        return this.dragged != null;
    }

    protected void barSelected(LContext<Bar> selected) {
        this.currentBar = selected;
        this.barSelected.barSelected(this.currentBar);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.ma.fromX(event.getX()) + "," + this.ma.fromY(event.getY());
    }

    public boolean containsLoop(LoopL<Bar> loop, Point2d ept) {
        return PointEditor.contains(loop, ept);
    }

    private static boolean contains(LoopL<Bar> loop, Point2d ept) {
        for (Loop loop2 : loop) {
            if (!PointEditor.contains(loop2, ept)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Loop<Bar> loop, Point2d ept) {
        boolean in = false;
        Line l = new Line(ept, new Point2d(ept.x + 10000.0, ept.y));
        for (Bar b : loop) {
            Line bl = new Line(b.start, b.end);
            if (l.intersects(bl) == null) continue;
            in = !in;
        }
        return in;
    }

    public void refreshMarkersOn(Bar b) {
        HashSet<Marker> sm = new HashSet<Marker>((Collection)this.barMarkerCache.get(b));
        this.barMarkerCache.cache.remove(b);
        this.handles.removeAll(sm);
        sm.clear();
        sm.addAll(b.mould.getAnchorsForEditing(b, b.start, b.end, new Point2d[0]));
        this.handles.addAll(sm);
        this.barMarkerCache.put(b, sm);
    }

    public void removeMarkersFromBar(Bar bar) {
        Set<Marker> sm = this.barMarkerCache.get(bar);
        this.handles.removeAll(sm);
        sm.clear();
        this.barMarkerCache.cache.remove(bar);
    }

    public boolean canExport() {
        return false;
    }

    public boolean canImport() {
        return false;
    }

    public void exportt(File f) {
        JOptionPane.showMessageDialog(this, "Cannot export from this editor", "Editor not configured for export", 0);
    }

    public void importt(File f) {
        JOptionPane.showMessageDialog(this, "Cannot import from this editor", "Editor not configured for import", 0);
    }

    public static interface BarSelected {
        public void barSelected(LContext<Bar> var1);
    }

    private class EditorMouseAdapter
    extends MouseAdapter {
        private EditorMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == PointEditor.this.ma.button) {
                return;
            }
            this.mousePressed_(e);
            PointEditor.this.repaint();
        }

        public void mousePressed_(MouseEvent e) {
            PointEditor.this.dragged = null;
            PointEditor.this.draggedBarSet = null;
            Point loc = new Point((int)PointEditor.this.ma.fromX(e.getPoint().x), (int)PointEditor.this.ma.fromY(e.getPoint().y));
            Point2d ept = new Point2d(PointEditor.this.ma.fromX(e.getPoint().x), PointEditor.this.ma.fromY(e.getPoint().y));
            for (Point2d point : PointEditor.this.handles) {
                double dist;
                if (!PointEditor.this.allowDrag(point) || !((dist = PointEditor.this.ma.to(point).distanceSq(e.getPoint())) < 200.0) || PointEditor.this.dragged != null && dist > ((Point2d)PointEditor.this.dragged.hook).distance(ept)) continue;
                PointEditor.this.dragged = new LContext(null, null);
                PointEditor.this.dragged.hook = point;
            }
            Iterator<LContext<Bar>> bit = PointEditor.this.edges.getCIterator();
            while (bit.hasNext()) {
                LContext<Bar> ctx = bit.next();
                Bar b = ctx.get();
                ArrayList<Point2d> arrayList = new ArrayList<Point2d>(Arrays.asList(b.start, b.end));
                arrayList.addAll(b.mould.getAnchorsForEditing(b, b.start, b.end, new Point2d[0]));
                for (Point2d point : arrayList) {
                    double dist;
                    if (!PointEditor.this.allowDrag(point) || !((dist = PointEditor.this.ma.to(point).distanceSq(e.getPoint())) < 100.0) || PointEditor.this.dragged != null && dist > ((Point2d)PointEditor.this.dragged.hook).distance(ept)) continue;
                    PointEditor.this.dragged = ctx;
                    PointEditor.this.dragged.hook = point;
                }
            }
            if (PointEditor.this.dragged != null) {
                if ((e.getModifiersEx() & 0x40) > 0) {
                    PointEditor.this.remove(PointEditor.this.dragged, (Point2d)PointEditor.this.dragged.hook);
                    PointEditor.this.dragged = null;
                } else {
                    if (e.getClickCount() == 2) {
                        PointEditor.this.showMenu(PointEditor.this.dragged, e);
                        return;
                    }
                    this.repeat(ept, e);
                }
                return;
            }
            LContext<Bar> selected = null;
            selected = PointEditor.this.getNearest(ept, PointEditor.this.ma.fromZoom(10.0));
            if (selected != null) {
                if (e.getClickCount() == 2) {
                    PointEditor.this.showMenu(selected, e);
                    return;
                }
                if ((e.getModifiersEx() & 0x80) > 0) {
                    PointEditor.this.addBetween(selected, loc);
                    return;
                }
                if ((e.getModifiersEx() & 0x40) > 0) {
                    PointEditor.this.remove(selected, ept);
                } else {
                    PointEditor.this.barSelected(selected);
                }
            }
            PointEditor.this.dragStartPoint.set(ept);
            PointEditor.this.draggedBarSet = null;
            for (Loop loop : PointEditor.this.edges) {
                if (!PointEditor.this.allowDrag(loop) || !PointEditor.contains(loop, ept)) continue;
                PointEditor.this.draggedBarSet = loop;
            }
            if (PointEditor.this.draggedBarSet != null) {
                return;
            }
            if (e.getButton() == 1 && e.isControlDown()) {
                PointEditor.this.createSection(loc, PointEditor.contains(PointEditor.this.edges, ept));
                PointEditor.this.repaint();
                return;
            }
            if (e.getClickCount() == 2) {
                PointEditor.this.showMenu(null, e);
                return;
            }
            PointEditor.this.painting(ept, new Point2d(0.0, 0.0), e);
        }

        public void repeat(Point2d e, MouseEvent evt) {
            if (PointEditor.this.dragged != null) {
                if (PointEditor.this.doSnap() && (evt.getModifiersEx() & 0x200) > 0) {
                    e = PointEditor.this.doSnap(PointEditor.this.dragged, (Point2d)PointEditor.this.dragged.hook, e);
                }
                PointEditor.this.movePoint(PointEditor.this.dragged, (Point2d)PointEditor.this.dragged.hook, e, evt);
                PointEditor.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getButton() == PointEditor.this.ma.button) {
                return;
            }
            Point2d loc = PointEditor.this.ma.from(e.getPoint());
            if (PointEditor.this.dragged == null) {
                Point2d l2 = new Point2d(loc);
                l2.sub(PointEditor.this.dragStartPoint);
                if (PointEditor.this.draggedBarSet != null) {
                    PointEditor.this.moveLoop(PointEditor.this.draggedBarSet, l2);
                } else {
                    PointEditor.this.painting(loc, l2, e);
                }
                PointEditor.this.dragStartPoint.set(loc);
            }
            this.repeat(loc, e);
            PointEditor.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PointEditor.this.painting(null, null, e);
            if (e.getButton() == PointEditor.this.ma.button) {
                return;
            }
            if (PointEditor.this.dragged != null) {
                PointEditor.this.releasePoint((Point2d)PointEditor.this.dragged.hook, PointEditor.this.dragged, e);
            }
            if (PointEditor.this.draggedBarSet != null) {
                PointEditor.this.moveLoop(null, null);
            }
            PointEditor.this.draggedBarSet = null;
            PointEditor.this.dragged = null;
        }
    }

    public class Handle
    extends Point {
        public Edge edge;

        public Handle(Edge edge) {
            this.edge = edge;
        }
    }
}

