/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiMap<A, B> {
    public Map<A, List<B>> map = new LinkedHashMap<A, List<B>>();

    public MultiMap() {
    }

    public MultiMap(A a, B ... bs) {
        for (B b : bs) {
            this.put(a, b);
        }
    }

    public MultiMap(MultiMap<A, B> other) {
        for (A a : other.map.keySet()) {
            for (B b : other.map.get(a)) {
                this.put(a, b);
            }
        }
    }

    public void addEmpty(A a) {
        if (!this.map.containsKey(a)) {
            this.map.put(a, new ArrayList());
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<B> get(A key) {
        List<B> out = this.map.get(key);
        if (out == null) {
            return new ArrayList();
        }
        return out;
    }

    public List<B> getMulti(A ... keys) {
        ArrayList<B> out = new ArrayList<B>();
        for (A a : keys) {
            List<B> query = this.map.get(a);
            if (query == null) continue;
            out.addAll(query);
        }
        return out;
    }

    public List<B> getOrAdd(A key) {
        List<B> out = this.map.get(key);
        if (out == null) {
            ArrayList b = new ArrayList();
            this.map.put(key, b);
            return b;
        }
        return out;
    }

    public boolean remove(A key, B value) {
        List<B> out = this.map.get(key);
        if (out == null) {
            return false;
        }
        boolean res = out.remove(value);
        if (out.isEmpty()) {
            this.map.remove(key);
        }
        return res;
    }

    public void put(A key, B value) {
        List<B> out = this.map.get(key);
        if (out == null) {
            out = new ArrayList<B>();
            this.map.put(key, out);
        }
        out.add(value);
    }

    public void put(A key, B value, boolean dupeCheck) {
        List<B> out = this.map.get(key);
        if (out == null) {
            out = new ArrayList<B>();
            this.map.put(key, out);
        }
        if (!dupeCheck || !out.contains(value)) {
            out.add(value);
        }
    }

    public List<B> remove(A key) {
        return this.map.remove(key);
    }

    public void putAll(MultiMap<? extends A, ? extends B> m3) {
        for (A a : m3.map.keySet()) {
            for (B b : m3.map.get(a)) {
                this.put(a, b);
            }
        }
    }

    public void putAll(Map<? extends A, ? extends B> m3) {
        for (Map.Entry<A, B> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<A> keySet() {
        return this.map.keySet();
    }

    public List<B> valueList() {
        return this.map.values().stream().flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    public Collection<List<B>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<A, List<B>>> entrySet() {
        return this.map.entrySet();
    }

    public void putAll(A a, Iterable<B> bs, boolean dupeCheck) {
        for (B b : bs) {
            this.put(a, b, dupeCheck);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[\n");
        for (A a : this.map.keySet()) {
            sb.append(a.toString() + " || ");
            for (B b : this.map.get(a)) {
                sb.append(String.valueOf(b) + ", ");
            }
            sb.append("\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public void removeAll(A ... a) {
        for (A aa : a) {
            this.remove(aa);
        }
    }

    public boolean contains(A a, B b) {
        for (B b2 : this.get(a)) {
            if (!b.equals(b2)) continue;
            return true;
        }
        return false;
    }

    public long countValue() {
        return this.map.values().stream().flatMap(e -> e.stream()).count();
    }

    public int minListSize() {
        if (this.map.isEmpty()) {
            return 0;
        }
        return this.values().stream().mapToInt(m3 -> m3.size()).min().getAsInt();
    }

    public void putAll(A a, Iterable<B> bs) {
        for (B b : bs) {
            this.put(a, b);
        }
    }
}

