/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import Jama.Matrix;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.utils.geom.Ray3d;
import org.twak.utils.results.LineOnPlane;
import org.twak.utils.results.OOB;

public class LinearForm3D
implements Cloneable {
    public double A;
    public double B;
    public double C;
    public double D;

    public LinearForm3D(LinearForm3D l) {
        this.A = l.A;
        this.B = l.B;
        this.C = l.C;
        this.D = l.D;
    }

    public LinearForm3D(Vector3d normal, Tuple3d offset) {
        this.A = normal.x;
        this.B = normal.y;
        this.C = normal.z;
        this.D = -normal.dot(new Vector3d(offset));
    }

    public LinearForm3D(double A2, double B, double C2, double D) {
        this.A = A2;
        this.B = B;
        this.C = C2;
        this.D = D;
    }

    public LinearForm3D(double A2, double B, double C2) {
        this.A = A2;
        this.B = B;
        this.C = C2;
    }

    public void findD(Tuple3d offset) {
        this.D = -this.normal().dot(new Vector3d(offset));
    }

    public double pointDistance(Tuple3d point) {
        double den = Math.sqrt(this.A * this.A + this.B * this.B + this.C * this.C);
        if (den == 0.0) {
            throw new Error("I'm not a plane " + String.valueOf(this) + "!");
        }
        double num = this.A * point.x + this.B * point.y + this.C * point.z + this.D;
        return num / den;
    }

    public Point3d project(Tuple3d pt) {
        Point3d out = new Point3d(pt);
        Vector3d dir = this.normal();
        dir.scale(-this.pointDistance(pt) / dir.length());
        out.add(dir);
        return out;
    }

    public Point3d collide(Tuple3d rayOrigin, Tuple3d rayDirection) {
        return this.collide(rayOrigin, rayDirection, null);
    }

    public Point3d collide(Tuple3d rayOrigin, Tuple3d rayDirection, Double distance) {
        Vector3d direction = new Vector3d(rayDirection);
        double den = this.A * direction.x + this.B * direction.y + this.C * direction.z;
        if (den == 0.0) {
            if (this.pointDistance(rayOrigin) < 1.0E-4) {
                LineOnPlane out = new LineOnPlane(rayOrigin, rayDirection, distance == null ? 0.0 : distance);
                return out;
            }
            return null;
        }
        double num = -this.D - this.A * rayOrigin.x - this.B * rayOrigin.y - this.C * rayOrigin.z;
        double n = num / den;
        direction.scale(n);
        direction.add(rayOrigin);
        if (n < 0.0) {
            return new OOB(direction);
        }
        if (distance != null && distance != Double.POSITIVE_INFINITY && distance < n) {
            return new OOB(direction);
        }
        return new Point3d(direction);
    }

    public Vector3d collideToVector(LinearForm3D other) {
        Vector3d n = this.createNormalVector();
        n.cross(n, other.createNormalVector());
        return n;
    }

    public Ray3d collide(LinearForm3D other) {
        Vector3d spec = new Vector3d();
        spec.cross(this.createNormalVector(), other.createNormalVector());
        if (spec.length() == 0.0) {
            return null;
        }
        Matrix matrixA = new Matrix(new double[][]{{this.A, this.B, this.C}, {other.A, other.B, other.C}, {spec.x, spec.y, spec.z}});
        Matrix matrixB = new Matrix(new double[][]{{-this.D}, {-other.D}, {0.0}});
        Matrix res = matrixA.solve(matrixB);
        return new Ray3d(new Point3d(res.get(0, 0), res.get(1, 0), res.get(2, 0)), spec);
    }

    public Tuple3d collide(LinearForm3D b, LinearForm3D c) {
        LinearForm3D a = this;
        if (a.hasNaN() || b.hasNaN() || c.hasNaN()) {
            throw new Error();
        }
        double det = a.A * (b.B * c.C - b.C * c.B) - a.B * (b.A * c.C - b.C * c.A) + a.C * (b.A * c.B - b.B * c.A);
        if (det == 0.0) {
            throw new Error("Planes do not intersect at a single point.");
        }
        double x = (-a.D * (b.B * c.C - b.C * c.B) + -b.D * (c.B * a.C - c.C * a.B) + -c.D * (a.B * b.C - a.C * b.B)) / det;
        double y = (-a.D * (c.A * b.C - b.A * c.C) + -b.D * (a.A * c.C - c.A * a.C) + -c.D * (b.A * a.C - a.A * b.C)) / det;
        double z = (-a.D * (b.A * c.B - c.A * b.B) + -b.D * (c.A * a.B - a.A * c.B) + -c.D * (a.A * b.B - b.A * a.B)) / det;
        return new Point3d(x, y, z);
    }

    public Vector3d createNormalVector() {
        Vector3d out = new Vector3d(this.A, this.B, this.C);
        out.normalize();
        return out;
    }

    public String toString() {
        return this.A + "," + this.B + "," + this.C + "," + this.D;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinearForm3D)) {
            return false;
        }
        LinearForm3D other = (LinearForm3D)obj;
        return this.A == other.A && this.B == other.B && this.C == other.C && this.D == other.D;
    }

    public Vector3d normal() {
        return new Vector3d(this.A, this.B, this.C);
    }

    public void flipNormal() {
        this.A = -this.A;
        this.B = -this.B;
        this.C = -this.C;
        this.D = -this.D;
    }

    public LinearForm3D clone() {
        return new LinearForm3D(this.A, this.B, this.C, this.D);
    }

    public boolean inFront(Tuple3d p) {
        return this.A * p.x + this.B * p.y + this.C * p.z + this.D > 0.0;
    }

    public boolean hasNaN() {
        return Double.isNaN(this.A) || Double.isNaN(this.B) || Double.isNaN(this.C) || Double.isNaN(this.D);
    }

    public static LinearForm3D linePerp(Point3d s2, Point3d e) {
        Vector3d dir = new Vector3d(e);
        dir.sub(s2);
        dir.normalize();
        return new LinearForm3D(dir, e);
    }
}

