/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFrame;

public abstract class SimpleFileChooser {
    static File currentFolder = new File(".");

    public SimpleFileChooser(JFrame root) {
        this(root, false, "please select file");
    }

    public SimpleFileChooser(JFrame root, boolean saveBehavour, String description) {
        this(root, saveBehavour, description, currentFolder, null);
    }

    public SimpleFileChooser(JFrame root, boolean saveBehavour, String description, File startFolder, final String extension) {
        FileDialog fd = new FileDialog((Frame)root, description);
        fd.setMode(saveBehavour ? 1 : 0);
        if (startFolder != null) {
            fd.setDirectory(startFolder.getAbsolutePath());
            if (startFolder.isFile()) {
                fd.setFile(startFolder.getName());
            }
        }
        if (extension != null) {
            fd.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(extension);
                }
            });
        }
        fd.setVisible(true);
        fd.toFront();
        if (fd.getDirectory() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        if (f.getParentFile() != null && startFolder == currentFolder) {
            currentFolder = f.getParentFile();
        }
        if (saveBehavour && !f.getName().toLowerCase().endsWith(extension)) {
            f = new File(f.getParentFile(), f.getName() + "." + extension);
        }
        try {
            this.heresTheFile(f);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public abstract void heresTheFile(File var1) throws Throwable;
}

