/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.adapter;

import java.util.List;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.adapter.EnvAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvAdapterManager
extends RegisterManager<String, EnvAdapter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvAdapterManager.class);
    private static final List<EnvAdapter> ENV_ADAPTERS = SPIServiceUtils.getSortedService(EnvAdapter.class);
    private static final String NAME = "service env adapter";
    public static final EnvAdapterManager INSTANCE = new EnvAdapterManager();

    private EnvAdapterManager() {
        super(NAME);
        ENV_ADAPTERS.forEach(envAdapter -> {
            if (envAdapter.enabled()) {
                this.getObjMap().putIfAbsent(envAdapter.getEnvName(), envAdapter);
            }
        });
    }

    public void processMicroserviceWithAdapters(Microservice microservice) {
        this.getObjMap().forEach((name, adapter) -> {
            LOGGER.info("Start process microservice with adapter {}", name);
            adapter.beforeRegisterService(microservice);
        });
    }

    public void processSchemaWithAdapters(String schemaId, String content) {
        this.getObjMap().forEach((name, adapter) -> {
            LOGGER.info("Start process schema with adapter {}", name);
            adapter.beforeRegisterSchema(schemaId, content);
        });
    }

    public void processInstanceWithAdapters(MicroserviceInstance instance) {
        this.getObjMap().forEach((name, adapter) -> {
            LOGGER.info("Start process instance with adapter {}", name);
            adapter.beforeRegisterInstance(instance);
        });
    }
}

