/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MetricsBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsBootstrap.class);
    private final MetricsBootstrapConfig config;
    private MeterRegistry meterRegistry;
    private EventBus eventBus;
    private ScheduledExecutorService executorService;
    private List<MetricsInitializer> metricsInitializers;

    @Autowired
    public MetricsBootstrap(MetricsBootstrapConfig config) {
        this.config = config;
    }

    @Autowired
    public void setMetricsInitializers(List<MetricsInitializer> metricsInitializers) {
        this.metricsInitializers = metricsInitializers;
    }

    @Autowired
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void start(EventBus eventBus) {
        this.eventBus = eventBus;
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("metrics-poller-%d").build());
        this.metricsInitializers.forEach(initializer -> initializer.init(this.meterRegistry, eventBus, this.config));
        this.startPoll();
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        Collections.reverse(this.metricsInitializers);
        this.metricsInitializers.forEach(MetricsInitializer::destroy);
    }

    protected void startPoll() {
        this.executorService.scheduleAtFixedRate(this::pollMeters, this.config.getMsPollInterval(), this.config.getMsPollInterval(), TimeUnit.MILLISECONDS);
    }

    public synchronized void pollMeters() {
        this.metricsInitializers.forEach(initializer -> {
            if (initializer instanceof PeriodMeter) {
                ((PeriodMeter)((Object)initializer)).poll(System.currentTimeMillis(), this.config.getMsPollInterval());
            }
        });
        try {
            PolledEvent polledEvent = new PolledEvent(this.meterRegistry.getMeters());
            this.eventBus.post((Object)polledEvent);
        }
        catch (Throwable e) {
            LOGGER.error("poll meters error. ", e);
        }
    }
}

