/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class SPIServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPIServiceUtils.class);
    private static final Object LOCK = new Object();
    private static final Map<Class<?>, List<Object>> cache = new ConcurrentHashMap();

    private SPIServiceUtils() {
    }

    public static <T> List<T> loadSortedService(Class<T> serviceType) {
        ArrayList serviceEntries = new ArrayList();
        ServiceLoader<Object> serviceLoader = ServiceLoader.load(serviceType);
        serviceLoader.forEach(service -> {
            int serviceOrder = 0;
            Method getOrder = ReflectionUtils.findMethod(service.getClass(), (String)"getOrder");
            if (getOrder != null) {
                serviceOrder = (Integer)ReflectionUtils.invokeMethod((Method)getOrder, (Object)service);
            }
            AbstractMap.SimpleEntry<Integer, Object> entry = new AbstractMap.SimpleEntry<Integer, Object>(serviceOrder, service);
            serviceEntries.add(entry);
        });
        List services = serviceEntries.stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
        StringBuilder info = new StringBuilder();
        for (int idx = 0; idx < services.size(); ++idx) {
            Object service2 = services.get(idx);
            info.append("{").append(idx).append(",").append(service2.getClass().getSimpleName()).append("}");
        }
        LOGGER.info("Found SPI service {}, services={}.", (Object)serviceType.getSimpleName(), (Object)info);
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getOrLoadSortedService(Class<T> serviceType) {
        List<Object> services = cache.get(serviceType);
        if (services == null) {
            Object object = LOCK;
            synchronized (object) {
                services = cache.get(serviceType);
                if (services == null) {
                    services = SPIServiceUtils.loadSortedService(serviceType);
                    cache.put(serviceType, services);
                }
            }
        }
        return services;
    }

    public static <T> T getTargetService(Class<T> serviceType) {
        List<T> services = SPIServiceUtils.getOrLoadSortedService(serviceType);
        if (services.isEmpty()) {
            LOGGER.info("Can not find SPI service for {}", (Object)serviceType.getName());
            return null;
        }
        return services.get(0);
    }

    public static <T> List<T> getAllService(Class<T> serviceType) {
        return SPIServiceUtils.getOrLoadSortedService(serviceType);
    }

    public static <T> List<T> getSortedService(Class<T> serviceType) {
        return SPIServiceUtils.getOrLoadSortedService(serviceType);
    }

    public static <T> T getPriorityHighestService(Class<T> serviceType) {
        List<T> services = SPIServiceUtils.getOrLoadSortedService(serviceType);
        if (services.isEmpty()) {
            LOGGER.info("Can not find SPI service for {}", (Object)serviceType.getName());
            return null;
        }
        return services.get(0);
    }

    public static <T> Collection<T> getPriorityHighestServices(Function<T, String> keyFunc, Class<T> serviceType) {
        List<Object> services = SPIServiceUtils.getOrLoadSortedService(serviceType);
        if (services.isEmpty()) {
            LOGGER.info("Can not find SPI service for {}", (Object)serviceType.getName());
            return null;
        }
        HashMap map = new HashMap();
        services.forEach(instance -> map.putIfAbsent((String)keyFunc.apply(instance), instance));
        return map.values();
    }

    public static <T, IMPL> IMPL getTargetService(Class<T> serviceType, Class<IMPL> implType) {
        List<T> services = SPIServiceUtils.getOrLoadSortedService(serviceType);
        return services.stream().filter(service -> service.getClass().equals(implType)).findFirst().orElse(null);
    }
}

