/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.reflect.TypeToken;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.inject.PlaceholderResolver;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.OperationGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;

public abstract class AbstractOperationGenerator
implements OperationGenerator {
    protected AbstractSwaggerGenerator swaggerGenerator;
    protected OpenAPI swagger;
    protected Class<?> clazz;
    protected Method method;
    protected String httpMethod;
    protected List<ParameterGenerator> parameterGenerators = new ArrayList<ParameterGenerator>();
    protected String path;
    protected Operation swaggerOperation;
    protected OperationGeneratorContext operationGeneratorContext;

    public AbstractOperationGenerator(AbstractSwaggerGenerator swaggerGenerator, Method method) {
        this.swaggerGenerator = swaggerGenerator;
        this.swagger = swaggerGenerator.getOpenAPI();
        this.clazz = swaggerGenerator.getClazz();
        this.method = method;
        this.httpMethod = swaggerGenerator.getHttpMethod();
        this.operationGeneratorContext = new OperationGeneratorContext(swaggerGenerator.getSwaggerGeneratorContext());
        this.swaggerOperation = new Operation();
    }

    @Override
    public OperationGeneratorContext getOperationGeneratorContext() {
        return this.operationGeneratorContext;
    }

    @Override
    public void setHttpMethod(String httpMethod) {
        if (StringUtils.isEmpty((CharSequence)httpMethod)) {
            return;
        }
        this.httpMethod = httpMethod.toUpperCase(Locale.US);
    }

    @Override
    public OpenAPI getSwagger() {
        return this.swagger;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Operation getOperation() {
        return this.swaggerOperation;
    }

    public String getOperationId() {
        return this.swaggerOperation.getOperationId();
    }

    @Override
    public void setPath(String path) {
        if (!((String)(path = new PlaceholderResolver().replaceFirst((String)path))).startsWith("/")) {
            path = "/" + (String)path;
        }
        this.path = path;
    }

    public void generate() {
        this.scanMethodAnnotation();
        this.scanMethodParameters();
        this.scanResponse();
        this.correctOperation();
    }

    protected void scanMethodAnnotation() {
        for (Annotation annotation : Arrays.stream(this.method.getAnnotations()).sorted(Comparator.comparing(a -> a.annotationType().getSimpleName())).collect(Collectors.toList())) {
            MethodAnnotationProcessor<Annotation> processor = SwaggerGeneratorUtils.findMethodAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(this.swaggerGenerator, this, annotation);
        }
        if (StringUtils.isEmpty((CharSequence)this.swaggerOperation.getOperationId())) {
            this.swaggerOperation.setOperationId(MethodUtils.findSwaggerMethodName(this.method));
        }
    }

    protected void scanMethodParameters() {
        this.initParameterGenerators();
        HashSet<String> names = new HashSet<String>();
        int bodyCount = 0;
        for (ParameterGenerator parameterGenerator : this.parameterGenerators) {
            this.scanMethodParameter(parameterGenerator);
            if (!names.add(parameterGenerator.getParameterGeneratorContext().getParameterName())) {
                throw new IllegalArgumentException(String.format("not support duplicated parameter, name=%s.", parameterGenerator.getParameterGeneratorContext().getParameterName()));
            }
            if (parameterGenerator.getHttpParameterType() != HttpParameterType.BODY) continue;
            if (bodyCount > 0) {
                throw new IllegalArgumentException(String.format("Defined %d body parameter.", bodyCount));
            }
            ++bodyCount;
        }
        for (ParameterGenerator parameterGenerator : this.parameterGenerators) {
            parameterGenerator.generate();
        }
    }

    protected void initParameterGenerators() {
        Map<String, List<Annotation>> methodAnnotationMap = this.initMethodAnnotationByParameterName();
        this.initMethodParameterGenerators(methodAnnotationMap);
        this.initRemainMethodAnnotationsParameterGenerators(methodAnnotationMap);
    }

    protected void initMethodParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        for (Parameter methodParameter : this.method.getParameters()) {
            Type genericType = TypeToken.of(this.clazz).resolveType(methodParameter.getParameterizedType()).getType();
            ParameterGenerator parameterGenerator = new ParameterGenerator(this, methodAnnotationMap, methodParameter, TypeFactory.defaultInstance().constructType(genericType));
            this.validateParameter(parameterGenerator.getGenericType());
            if (SwaggerGeneratorUtils.isContextParameter(parameterGenerator.getGenericType())) continue;
            if (this.isAggregatedParameter(parameterGenerator, methodParameter)) {
                this.extractAggregatedParameterGenerators(methodAnnotationMap, methodParameter);
                continue;
            }
            this.parameterGenerators.add(parameterGenerator);
        }
    }

    protected boolean isAggregatedParameter(ParameterGenerator parameterGenerator, Parameter methodParameter) {
        return false;
    }

    protected void extractAggregatedParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap, Parameter methodParameter) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(methodParameter.getParameterizedType());
        BeanDescription beanDescription = Json.mapper().getSerializationConfig().introspect(javaType);
        for (BeanPropertyDefinition propertyDefinition : beanDescription.findProperties()) {
            if (!propertyDefinition.couldSerialize()) continue;
            Annotation[] annotations = SwaggerGeneratorUtils.collectAnnotations(propertyDefinition);
            ParameterGenerator propertyParameterGenerator = new ParameterGenerator(this, methodAnnotationMap, propertyDefinition.getName(), annotations, propertyDefinition.getPrimaryType());
            this.parameterGenerators.add(propertyParameterGenerator);
        }
    }

    protected void initRemainMethodAnnotationsParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        for (Map.Entry<String, List<Annotation>> entry : methodAnnotationMap.entrySet()) {
            ParameterGenerator parameterGenerator = new ParameterGenerator((OperationGenerator)this, entry.getKey(), entry.getValue());
            this.parameterGenerators.add(parameterGenerator);
        }
    }

    private Map<String, List<Annotation>> initMethodAnnotationByParameterName() {
        LinkedHashMap<String, List<Annotation>> methodAnnotations = new LinkedHashMap<String, List<Annotation>>();
        for (Annotation annotation : this.method.getAnnotations()) {
            if (annotation instanceof Parameters) {
                for (io.swagger.v3.oas.annotations.Parameter apiImplicitParam : ((Parameters)annotation).value()) {
                    this.addMethodAnnotationByParameterName(methodAnnotations, apiImplicitParam.name(), (Annotation)apiImplicitParam);
                }
                continue;
            }
            if (!(annotation instanceof io.swagger.v3.oas.annotations.Parameter)) continue;
            this.addMethodAnnotationByParameterName(methodAnnotations, ((io.swagger.v3.oas.annotations.Parameter)annotation).name(), annotation);
        }
        return methodAnnotations;
    }

    private void addMethodAnnotationByParameterName(Map<String, List<Annotation>> methodAnnotations, String name, Annotation annotation) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalStateException(String.format("%s.name should not be empty. method=%s:%s", annotation.annotationType().getSimpleName(), this.method.getDeclaringClass().getName(), this.method.getName()));
        }
        methodAnnotations.computeIfAbsent(name, n -> new ArrayList()).add(annotation);
    }

    protected void validateParameter(JavaType type) {
        if (type.isTypeOrSubTypeOf(HttpServletResponse.class)) {
            throw new IllegalStateException("all input/output of ServiceComb operation are models, not allow to use HttpServletResponse.");
        }
    }

    protected void scanMethodParameter(ParameterGenerator parameterGenerator) {
        Object processor;
        for (Annotation annotation : parameterGenerator.getAnnotations()) {
            processor = SwaggerGeneratorUtils.findParameterAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(this.swaggerGenerator, this, parameterGenerator, (Annotation)annotation);
        }
        Schema<?> schema = parameterGenerator.getParameterGeneratorContext().getSchema();
        if (schema == null) {
            JavaType parameterType = parameterGenerator.getGenericType();
            processor = SwaggerGeneratorUtils.findParameterTypeProcessor((Type)parameterType);
            if (processor != null) {
                processor.process(this.swaggerGenerator, this, parameterGenerator);
            } else {
                parameterGenerator.getParameterGeneratorContext().setSchema(SwaggerUtils.resolveTypeSchemas(this.swagger, (Type)parameterType));
            }
        }
    }

    @Override
    public boolean isForm() {
        for (ParameterGenerator parameterGenerator : this.parameterGenerators) {
            if (!parameterGenerator.isForm()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBinary() {
        for (ParameterGenerator parameterGenerator : this.parameterGenerators) {
            if (!parameterGenerator.isBinary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWebsocket() {
        return this.swaggerOperation.getTags() != null && this.swaggerOperation.getTags().contains("websocket");
    }

    @Override
    public void addOperationToSwagger() {
        PathItem pathObj;
        if (StringUtils.isEmpty((CharSequence)this.httpMethod)) {
            return;
        }
        if (this.swagger.getPaths() == null) {
            this.swagger.setPaths(new Paths());
        }
        if ((pathObj = (PathItem)this.swagger.getPaths().get((Object)this.path)) == null) {
            pathObj = new PathItem();
            this.swagger.path(this.path, pathObj);
        } else if (SwaggerUtils.methodExists(pathObj, this.httpMethod)) {
            throw new IllegalStateException(String.format("Duplicate operation path detected. method=%s:%s.", this.method.getDeclaringClass().getName(), this.method.getName()));
        }
        pathObj.operation(PathItem.HttpMethod.valueOf((String)this.httpMethod), this.swaggerOperation);
    }

    public void correctOperation() {
        SwaggerUtils.correctResponses(this.swaggerOperation);
    }

    public void scanResponse() {
        this.operationGeneratorContext.updateProduces();
        this.swaggerOperation.setResponses(new ApiResponses());
        for (Map.Entry<String, Schema<?>> response : this.operationGeneratorContext.getResponses().entrySet()) {
            Schema<?> schema;
            ApiResponse apiResponse = new ApiResponse();
            if (StringUtils.isNotEmpty((CharSequence)this.operationGeneratorContext.getResponseDescriptions().get(response.getKey()))) {
                apiResponse.setDescription(this.operationGeneratorContext.getResponseDescriptions().get(response.getKey()));
            }
            if (this.operationGeneratorContext.getResponseHeaders().get(response.getKey()) != null) {
                this.operationGeneratorContext.getResponseHeaders().get(response.getKey()).forEach((k, v) -> {
                    Header header = new Header();
                    header.setSchema(v);
                    apiResponse.addHeaderObject(k, header);
                });
            }
            Schema<?> schema2 = schema = response.getValue() != null ? response.getValue() : this.createResponseModel();
            if (schema == null) {
                this.swaggerOperation.getResponses().addApiResponse(response.getKey(), apiResponse);
                continue;
            }
            apiResponse.setContent(new Content());
            if ("string".equals(schema.getType()) && "binary".equals(schema.getFormat())) {
                MediaType mediaType = new MediaType();
                mediaType.setSchema(schema);
                apiResponse.getContent().addMediaType("*/*", mediaType);
            } else {
                for (String produce : this.operationGeneratorContext.getSupportedProduces()) {
                    MediaType mediaType = new MediaType();
                    mediaType.setSchema(schema);
                    apiResponse.getContent().addMediaType(produce, mediaType);
                }
            }
            this.swaggerOperation.getResponses().addApiResponse(response.getKey(), apiResponse);
        }
    }

    protected Schema<?> createResponseModel() {
        Type responseType = TypeToken.of(this.clazz).resolveType(this.method.getGenericReturnType()).getType();
        if (ReflectionUtils.isVoid((Type)responseType)) {
            return null;
        }
        ResponseTypeProcessor processor = SwaggerGeneratorUtils.findResponseTypeProcessor(responseType);
        return processor.process(this.swaggerGenerator, this, responseType);
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ParameterGenerator> getParameterGenerators() {
        return this.parameterGenerators;
    }

    public Operation getSwaggerOperation() {
        return this.swaggerOperation;
    }
}

