/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.loadbalance.ServerMetrics;
import org.apache.servicecomb.registry.api.DiscoveryInstance;

public class ServiceCombServer {
    private final Endpoint endpoint;
    private final String microserviceName;
    private final ServerMetrics serverMetrics;

    public ServiceCombServer(String microserviceName, Endpoint endpoint) {
        this.microserviceName = microserviceName;
        this.endpoint = endpoint;
        this.serverMetrics = new ServerMetrics();
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public DiscoveryInstance getInstance() {
        return this.endpoint.getMicroserviceInstance();
    }

    public String toString() {
        return this.endpoint.getEndpoint();
    }

    public String getHost() {
        return this.endpoint.getEndpoint();
    }

    public ServerMetrics getServerMetrics() {
        return this.serverMetrics;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceCombServer) {
            return this.getInstance().getInstanceId().equals(((ServiceCombServer)o).getInstance().getInstanceId()) && StringUtils.equals((CharSequence)this.endpoint.getEndpoint(), (CharSequence)((ServiceCombServer)o).getEndpoint().getEndpoint());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getInstance().getInstanceId(), this.endpoint);
    }
}

