/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.transport.AbstractTransport;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRestTransport
extends AbstractTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRestTransport.class);

    public String getName() {
        return "rest";
    }

    public boolean canInit() {
        String listenAddress = ServletConfig.getLocalServerAddress(this.environment);
        if (listenAddress == null) {
            return true;
        }
        if (!ServletUtils.canPublishEndpoint(listenAddress)) {
            LOGGER.info("ignore transport {}.", (Object)((Object)((Object)this)).getClass().getName());
            return false;
        }
        return true;
    }

    public boolean init() {
        String urlPrefix = ClassLoaderScopeContext.getClassLoaderScopeProperty((String)"urlPrefix");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)urlPrefix)) {
            queryMap.put("urlPrefix", urlPrefix);
        }
        String listenAddress = ServletConfig.getLocalServerAddress(this.environment);
        this.setListenAddressWithoutSchema(listenAddress, queryMap);
        return true;
    }
}

