/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverter;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverterFactor;
import org.apache.shenyu.admin.service.publish.InstanceInfoReportEventPublisher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@Configuration
@EnableTransactionManagement
public class ShenyuAdminConfiguration {
    @Bean
    public SelectorHandleConverterFactor selectorHandleConverterFactor(List<SelectorHandleConverter> converterList) {
        Map<String, SelectorHandleConverter> converterMap = converterList.stream().collect(Collectors.toMap(SelectorHandleConverter::pluginName, Function.identity()));
        return new SelectorHandleConverterFactor(converterMap);
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
        localeResolver.setSupportedLocales(Stream.of(Locale.US, Locale.SIMPLIFIED_CHINESE).collect(Collectors.toList()));
        return localeResolver;
    }

    @Bean
    public InstanceInfoReportEventPublisher instanceInfoReportEventPublisher(ApplicationEventPublisher publisher) {
        return new InstanceInfoReportEventPublisher(publisher);
    }
}

