/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TopHitsAggregate
extends AggregateBase
implements AggregateVariant {
    private final HitsMetadata<JsonData> hits;
    public static final JsonpDeserializer<TopHitsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopHitsAggregate::setupTopHitsAggregateDeserializer);

    private TopHitsAggregate(Builder builder) {
        super(builder);
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
    }

    public static TopHitsAggregate of(Function<Builder, ObjectBuilder<TopHitsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.TopHits;
    }

    public final HitsMetadata<JsonData> hits() {
        return this.hits;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    protected static void setupTopHitsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(JsonData._DESERIALIZER), "hits");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TopHitsAggregate> {
        private HitsMetadata<JsonData> hits;

        public final Builder hits(HitsMetadata<JsonData> value) {
            this.hits = value;
            return this;
        }

        public final Builder hits(Function<HitsMetadata.Builder<JsonData>, ObjectBuilder<HitsMetadata<JsonData>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TopHitsAggregate build() {
            this._checkSingleUse();
            return new TopHitsAggregate(this);
        }
    }
}

