/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc;

import com.qq.tars.net.client.Callback;
import com.qq.tars.net.client.ticket.Ticket;
import com.qq.tars.net.client.ticket.TicketManager;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.TCPSession;
import com.qq.tars.net.core.nio.UDPSession;
import com.qq.tars.rpc.exc.NotConnectedException;
import com.qq.tars.rpc.exc.TimeoutException;
import com.qq.tars.rpc.protocol.ServantRequest;
import com.qq.tars.rpc.protocol.ServantResponse;
import com.qq.tars.support.log.LoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ServantClient {
    private static final Logger logger = LoggerFactory.getClientLogger();
    private Session session = null;
    private String host = null;
    private int port = -1;
    private SelectorManager selectorManager = null;
    private long asyncTimeout = 1000L;
    private long syncTimeout = 1000L;
    private long connectTimeout = 200L;
    private boolean udpMode = false;
    private int tc = -1;
    private int bufferSize = 4096;
    private boolean tcpNoDelay = false;
    private static final int INVALID_TRAFFIC_CLASS_VALUE = -1;

    public ServantClient(String ip, int port, SelectorManager selectorManager, boolean udpMode) {
        this.host = ip;
        this.port = port;
        this.udpMode = udpMode;
        this.selectorManager = selectorManager;
    }

    protected synchronized void reConnect() throws IOException {
        if (this.isNotConnected()) {
            int event;
            InetSocketAddress server = new InetSocketAddress(this.host, this.port);
            AbstractSelectableChannel channel = null;
            UDPSession temp = null;
            if (this.udpMode) {
                channel = DatagramChannel.open();
                ((SelectableChannel)channel).configureBlocking(false);
                temp = new UDPSession(this.selectorManager);
                temp.setBufferSize(this.bufferSize);
                temp.setTarget((SocketAddress)server);
                event = 1;
                temp.setStatus(Session.SessionStatus.CLIENT_CONNECTED);
            } else {
                channel = SocketChannel.open();
                ((SelectableChannel)channel).configureBlocking(false);
                try {
                    if (this.tc != -1) {
                        ((SocketChannel)channel).socket().setTrafficClass(this.tc);
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getLocalizedMessage());
                }
                ((SocketChannel)channel).connect(server);
                temp = new TCPSession(this.selectorManager);
                ((TCPSession)temp).setTcpNoDelay(this.tcpNoDelay);
                event = 8;
            }
            temp.setChannel((SelectableChannel)channel);
            temp.setKeepAlive(this.selectorManager.isKeepAlive());
            this.selectorManager.nextReactor().registerChannel((SelectableChannel)channel, event, (Object)temp);
            if (!this.udpMode) {
                if (!temp.waitToConnect(this.connectTimeout)) {
                    temp.asyncClose();
                    throw new TimeoutException("connect " + this.connectTimeout + "ms timed out to " + this.getAddress());
                }
                if (temp.getStatus() == Session.SessionStatus.NOT_CONNECTED) {
                    temp.asyncClose();
                    throw new NotConnectedException("connect failed to " + this.getAddress());
                }
                if (temp.getStatus() == Session.SessionStatus.CLOSED) {
                    throw new NotConnectedException("connect failed to " + this.getAddress());
                }
            }
            this.session = temp;
        }
    }

    public void ensureConnected() throws IOException {
        if (this.isNotConnected()) {
            this.reConnect();
        }
    }

    public <T extends ServantResponse> T invokeWithSync(ServantRequest request) throws IOException {
        Ticket ticket = null;
        ServantResponse response = null;
        try {
            this.ensureConnected();
            request.setInvokeStatus(Request.InvokeStatus.SYNC_CALL);
            ticket = TicketManager.createTicket((Request)request, (Session)this.session, (long)this.syncTimeout);
            Session current = this.session;
            current.write((Request)request);
            if (!ticket.await(this.syncTimeout, TimeUnit.MILLISECONDS)) {
                if (current != null && current.getStatus() != Session.SessionStatus.CLIENT_CONNECTED) {
                    throw new IOException("Connection reset by peer|" + this.getAddress());
                }
                throw new TimeoutException("the operation has timeout, " + this.syncTimeout + "ms|" + this.getAddress());
            }
            response = (ServantResponse)((Object)ticket.response());
            if (response == null) {
                throw new IOException("the operation is failed.");
            }
            ServantResponse servantResponse = response;
            return (T)((Object)servantResponse);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        finally {
            if (ticket != null) {
                TicketManager.removeTicket((int)ticket.getTicketNumber());
            }
        }
    }

    public <T extends ServantResponse> void invokeWithAsync(ServantRequest request, Callback<T> callback) throws IOException {
        Ticket ticket = null;
        try {
            this.ensureConnected();
            request.setInvokeStatus(Request.InvokeStatus.ASYNC_CALL);
            ticket = TicketManager.createTicket((Request)request, (Session)this.session, (long)this.asyncTimeout, callback, (SelectorManager)this.selectorManager);
            Session current = this.session;
            current.write((Request)request);
        }
        catch (Exception ex) {
            if (ticket != null) {
                TicketManager.removeTicket((int)ticket.getTicketNumber());
            }
            throw new IOException("error occurred on invoker with async", ex);
        }
    }

    public <T extends ServantResponse> void invokeWithFuture(ServantRequest request, Callback<T> callback) throws IOException {
        Ticket ticket = null;
        try {
            this.ensureConnected();
            request.setInvokeStatus(Request.InvokeStatus.FUTURE_CALL);
            ticket = TicketManager.createTicket((Request)request, (Session)this.session, (long)this.asyncTimeout, callback, (SelectorManager)this.selectorManager);
            Session current = this.session;
            current.write((Request)request);
        }
        catch (Exception ex) {
            if (ticket != null) {
                TicketManager.removeTicket((int)ticket.getTicketNumber());
            }
            throw new IOException("error occurred on invoker with future", ex);
        }
    }

    private synchronized void shutdown() throws IOException {
        if (this.session != null) {
            this.session.asyncClose();
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Session getIoSession() {
        return this.session;
    }

    public int getTrafficClass() {
        return this.tc;
    }

    public void setTrafficClass(int tc) {
        if (this.session != null && this.session instanceof TCPSession) {
            try {
                ((SocketChannel)((TCPSession)this.session).getChannel()).socket().setTrafficClass(tc);
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage());
            }
        }
        this.tc = tc;
    }

    public void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
        if (this.session != null && this.session instanceof TCPSession) {
            try {
                ((SocketChannel)((TCPSession)this.session).getChannel()).socket().setTcpNoDelay(on);
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage());
            }
        }
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSyncTimeout() {
        return this.syncTimeout;
    }

    public void setSyncTimeout(long syncTimeout) {
        this.syncTimeout = syncTimeout;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    public void close() throws IOException {
        this.shutdown();
    }

    private boolean isNotConnected() {
        return this.session == null || this.session.getStatus() == Session.SessionStatus.CLOSED || this.session.getStatus() == Session.SessionStatus.NOT_CONNECTED;
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    public String toString() {
        return "ServantClient [client=" + this.getAddress() + "]";
    }
}

