/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ApplicationMetric
implements Metric {
    private final ApplicationModel applicationModel;
    protected Map<String, String> extraInfo;
    private volatile int hashCode;

    public ApplicationMetric(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public String getApplicationName() {
        return this.getApplicationModel().getApplicationName();
    }

    @Override
    public Map<String, String> getTags() {
        return this.hostTags(this.gitTags(MetricsSupport.applicationTags(this.applicationModel, this.getExtraInfo())));
    }

    public Map<String, String> gitTags(Map<String, String> tags) {
        return MetricsSupport.gitTags(tags);
    }

    public Map<String, String> hostTags(Map<String, String> tags) {
        return MetricsSupport.hostTags(tags);
    }

    public Map<String, String> getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(Map<String, String> extraInfo) {
        this.extraInfo = extraInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationMetric that = (ApplicationMetric)o;
        return this.getApplicationName().equals(that.applicationModel.getApplicationName()) && Objects.equals(this.extraInfo, that.extraInfo);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.getApplicationName(), this.extraInfo);
        }
        return this.hashCode;
    }
}

