/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.security.cert;

import java.util.Objects;

public class CertPair {
    private final String privateKey;
    private final String certificate;
    private final String trustCerts;
    private final long expireTime;

    public CertPair(String privateKey, String certificate, String trustCerts, long expireTime) {
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.trustCerts = trustCerts;
        this.expireTime = expireTime;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getTrustCerts() {
        return this.trustCerts;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() > this.expireTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertPair certPair = (CertPair)o;
        return this.expireTime == certPair.expireTime && Objects.equals(this.privateKey, certPair.privateKey) && Objects.equals(this.certificate, certPair.certificate) && Objects.equals(this.trustCerts, certPair.trustCerts);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.certificate, this.trustCerts, this.expireTime);
    }
}

