/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.generator;

import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class TraceIdGenerator {
    private static String IP_16 = "ffffffff";
    private static AtomicInteger count = new AtomicInteger(1000);

    private static String getTraceId(String ip, long timestamp, int nextId) {
        StringBuilder appender = new StringBuilder(30);
        appender.append(ip).append(timestamp).append(nextId).append(TracerUtils.getPID());
        return appender.toString();
    }

    public static String generate() {
        return TraceIdGenerator.getTraceId(IP_16, System.currentTimeMillis(), TraceIdGenerator.getNextId());
    }

    private static String getIP_16(String ip) {
        String[] ips = ip.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String column : ips) {
            String hex = Integer.toHexString(Integer.parseInt(column));
            if (hex.length() == 1) {
                sb.append('0').append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static int getNextId() {
        int next;
        int current;
        while (!count.compareAndSet(current, next = (current = count.get()) > 9000 ? 1000 : current + 1)) {
        }
        return next;
    }

    static {
        try {
            String ipAddress = TracerUtils.getInetAddress();
            if (ipAddress != null) {
                IP_16 = TraceIdGenerator.getIP_16(ipAddress);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

