/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class V2TableUtil$
implements SQLConfHelper {
    public static final V2TableUtil$ MODULE$ = new V2TableUtil$();

    static {
        SQLConfHelper.$init$(MODULE$);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public String toQualifiedName(CatalogPlugin catalog, Identifier ident) {
        return package$.MODULE$.quoteIfNeeded(catalog.name()) + "." + CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted();
    }

    public Seq<String> validateCapturedColumns(Table table, DataSourceV2Relation relation) {
        return this.validateCapturedColumns(table, (Seq<Column>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)relation.table().columns()).toImmutableArraySeq());
    }

    public Seq<String> validateCapturedColumns(Table table, Seq<Column> originCols) {
        ArrayBuffer errors = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, Column> colsByNormalizedName = this.indexColumns((Seq<Column>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)table.columns()).toImmutableArraySeq());
        Map<String, Column> originColsByNormalizedName = this.indexColumns(originCols);
        originColsByNormalizedName.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String normalizedName = (String)tuple2._1();
                Column originCol = (Column)tuple2._2();
                Option option = colsByNormalizedName.get((Object)normalizedName);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Column col = (Column)some.value();
                    DataType dataType = originCol.dataType();
                    DataType dataType2 = col.dataType();
                    if ((dataType != null ? !dataType.equals(dataType2) : dataType2 != null) || originCol.nullable() != col.nullable()) {
                        String oldType = MODULE$.formatType(originCol.dataType(), originCol.nullable());
                        String newType = MODULE$.formatType(col.dataType(), col.nullable());
                        return errors.$plus$eq((Object)("`" + originCol.name() + "` type has changed from " + oldType + " to " + newType));
                    }
                    return BoxedUnit.UNIT;
                }
                if (None$.MODULE$.equals(option)) {
                    return errors.$plus$eq((Object)(MODULE$.formatColumn(originCol) + " has been removed"));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        colsByNormalizedName.foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String normalizedName = (String)tuple2._1();
                Column col = (Column)tuple2._2();
                if (!originColsByNormalizedName.contains((Object)normalizedName)) {
                    return errors.$plus$eq((Object)(MODULE$.formatColumn(col) + " has been added"));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        return errors.toSeq();
    }

    public Seq<String> validateCapturedMetadataColumns(Table table, DataSourceV2Relation relation) {
        return this.validateCapturedMetadataColumns(table, this.extractMetadataColumns(relation));
    }

    public Seq<MetadataColumn> extractMetadataColumns(DataSourceV2Relation relation) {
        Seq metaAttrs = (Seq)relation.output().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)V2TableUtil$.$anonfun$extractMetadataColumns$1(x$1)));
        if (metaAttrs.nonEmpty()) {
            Seq<MetadataColumn> metaCols = this.metadataColumns(relation.table());
            Set normalizedMetaAttrNames = ((IterableOnceOps)metaAttrs.map((Function1 & Serializable)attr -> MODULE$.normalize(attr.name()))).toSet();
            return (Seq)metaCols.filter((Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)normalizedMetaAttrNames.contains((Object)V2TableUtil$.MODULE$.normalize(col.name()))));
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public Seq<String> validateCapturedMetadataColumns(Table table, Seq<MetadataColumn> originMetaCols) {
        ArrayBuffer errors = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq<MetadataColumn> metaCols = this.metadataColumns(table);
        Map<String, MetadataColumn> metaColsByNormalizedName = this.indexMetadataColumns(metaCols);
        originMetaCols.foreach((Function1 & Serializable)originMetaCol -> {
            String normalizedName = MODULE$.normalize(originMetaCol.name());
            Option option = metaColsByNormalizedName.get((Object)normalizedName);
            if (option instanceof Some) {
                Some some = (Some)option;
                MetadataColumn metaCol = (MetadataColumn)some.value();
                DataType dataType = originMetaCol.dataType();
                DataType dataType2 = metaCol.dataType();
                if ((dataType != null ? !dataType.equals(dataType2) : dataType2 != null) || originMetaCol.isNullable() != metaCol.isNullable()) {
                    String oldType = MODULE$.formatType(originMetaCol.dataType(), originMetaCol.isNullable());
                    String newType = MODULE$.formatType(metaCol.dataType(), metaCol.isNullable());
                    return errors.$plus$eq((Object)("`" + originMetaCol.name() + "` type has changed from " + oldType + " to " + newType));
                }
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                return errors.$plus$eq((Object)(MODULE$.formatMetadataColumn((MetadataColumn)originMetaCol) + " has been removed"));
            }
            throw new MatchError((Object)option);
        });
        return errors.toSeq();
    }

    private String formatColumn(Column col) {
        return "`" + col.name() + "` " + this.formatType(col.dataType(), col.nullable());
    }

    private String formatMetadataColumn(MetadataColumn col) {
        return "`" + col.name() + "` " + this.formatType(col.dataType(), col.isNullable());
    }

    private String formatType(DataType dataType, boolean nullable) {
        if (nullable) {
            return dataType.sql();
        }
        return dataType.sql() + " NOT NULL";
    }

    private Map<String, Column> indexColumns(Seq<Column> cols) {
        return this.index(cols, (Function1 & Serializable)x$2 -> x$2.name());
    }

    private Map<String, MetadataColumn> indexMetadataColumns(Seq<MetadataColumn> cols) {
        return this.index(cols, (Function1 & Serializable)x$3 -> x$3.name());
    }

    private <C> Map<String, C> index(Seq<C> cols, Function1<C, String> extractName) {
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq<String>)((Seq)cols.map(extractName)), this.conf().caseSensitiveAnalysis());
        return ((IterableOnceOps)cols.map((Function1 & Serializable)col -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.normalize((String)extractName.apply(col))), col))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Seq<MetadataColumn> metadataColumns(Table table) {
        Table table2 = table;
        if (table2 instanceof SupportsMetadataColumns) {
            SupportsMetadataColumns supportsMetadataColumns = (SupportsMetadataColumns)table2;
            return ArrayImplicits$.MODULE$.SparkArrayOps((Object)supportsMetadataColumns.metadataColumns()).toImmutableArraySeq();
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private String normalize(String name) {
        if (this.conf().caseSensitiveAnalysis()) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$extractMetadataColumns$1(AttributeReference x$1) {
        return package$.MODULE$.MetadataColumnHelper(x$1).isMetadataCol();
    }

    private V2TableUtil$() {
    }
}

