/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.debugbar;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.StandardDebugPanel;
import org.apache.wicket.devutils.pagestore.PageStorePage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class PageStoreDebugPanel
extends StandardDebugPanel {
    private static final long serialVersionUID = 1L;
    public static final IDebugBarContributor DEBUG_BAR_CONTRIB = new IDebugBarContributor(){
        private static final long serialVersionUID = 1L;

        @Override
        public Component createComponent(String id, DebugBar debugBar) {
            return new PageStoreDebugPanel(id);
        }
    };

    public PageStoreDebugPanel(String id) {
        super(id);
    }

    @Override
    protected Class<? extends Page> getLinkPageClass() {
        return PageStorePage.class;
    }

    @Override
    protected ResourceReference getImageResourceReference() {
        return new PackageResourceReference(PageStoreDebugPanel.class, "harddrive.png");
    }

    @Override
    protected IModel<String> getDataModel() {
        return new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                IPersistentPageStore store = PageStorePage.getPersistentPageStore();
                return String.format("Persisted pages: %s", store == null ? "N/A" : store.getTotalSize());
            }
        };
    }
}

