use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'RFC3464';
my $samplepath = sprintf("./set-of-emails/private/%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce', 'toxic'], [...]]
#   '1001'  => [['5.0.947', '',    'expired',         0, 0]],
#   '1002'  => [['5.0.911', '550', 'userunknown',     1, 1]],
    '1003'  => [['5.0.934', '553', 'mesgtoobig',      0, 0]],
#   '1004'  => [['5.0.910', '550', 'filtered',        0, 1]],
#   '1005'  => [['5.0.944', '554', 'networkerror',    0, 0]],
#   '1007'  => [['5.0.901', '',    'onhold',          0, 0]],
#   '1008'  => [['5.0.947', '',    'expired',         0, 0]],
    '1009'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1011'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1013'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1014'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1015'  => [['5.0.912', '',    'hostunknown',     1, 1]],
    '1016'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1017'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1018'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
    '1020'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1021'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1022'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1024'  => [['5.1.0',   '550', 'userunknown',     1, 1]],
#   '1025'  => [['5.0.910', '',    'filtered',        0, 0]],
#   '1026'  => [['5.0.910', '',    'filtered',        0, 0]],
    '1031'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1033'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1035'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1036'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1037'  => [['5.5.0',   '554', 'systemerror',     0, 0]],
    '1038'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1039'  => [['5.1.2',   '550', 'hostunknown',     1, 1]],
    '1040'  => [['5.4.6',   '554', 'networkerror',    0, 0]],
    '1041'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1042'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1043'  => [['5.0.901', '',    'onhold',          0, 0],
#               ['5.0.911', '550', 'userunknown',     1, 1]],
    '1044'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1045'  => [['5.0.911', '550', 'userunknown',     1, 1]],
    '1046'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1047'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1048'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1049'  => [['5.1.1',   '550', 'userunknown',     1, 1],
                ['5.1.1',   '550', 'userunknown',     1, 1]],
    '1050'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1051'  => [['5.1.1',   '550', 'userunknown',     1, 1],
                ['5.1.1',   '550', 'userunknown',     1, 1]],
    '1052'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1053'  => [['5.0.0',   '554', 'filtered',        0, 1]],
    '1054'  => [['5.0.901', '',    'onhold',          0, 0]],
#   '1055'  => [['5.0.910', '',    'filtered',        0, 0]],
#   '1056'  => [['5.0.922', '554', 'mailboxfull',     0, 1]],
    '1057'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1058'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1059'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1060'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1062'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1063'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1064'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1065'  => [['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1066'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1067'  => [['5.0.930', '',    'systemerror',     0, 0]],
    '1068'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1069'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1070'  => [['5.5.0',   '554', 'userunknown',     1, 1]],
#   '1071'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
    '1072'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1073'  => [['5.0.911', '550', 'userunknown',     1, 1]],
    '1074'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1075'  => [['5.0.910', '',    'filtered',        0, 0]],
    '1076'  => [['5.5.0',   '554', 'systemerror',     0, 0]],
    '1077'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1078'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1079'  => [['5.0.910', '',    'filtered',        0, 0]],
    '1083'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1086'  => [['2.1.5',   '',    'delivered',       0, 0],
#               ['2.1.5',   '250', 'delivered',       0, 0],
#               ['2.0.0',   '250', 'delivered',       0, 0],
#               ['2.0.0',   '250', 'delivered',       0, 0],
#               ['2.0.0',   '250', 'delivered',       0, 0],
#               ['2.1.5',   '',    'delivered',       0, 0]],
    '1085'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1087'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1089'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1090'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1091'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1092'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1093'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1095'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1096'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1097'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1098'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1099'  => [['4.7.0',   '',    'securityerror',   0, 0]],
    '1100'  => [['4.7.0',   '',    'securityerror',   0, 0]],
    '1101'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1102'  => [['5.3.0',   '553', 'userunknown',     1, 1]],
#   '1103'  => [['5.0.947', '',    'expired',         0, 0]],
    '1104'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1105'  => [['5.0.910', '',    'filtered',        0, 0]],
#   '1106'  => [['5.0.947', '',    'expired',         0, 0]],
    '1107'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1108'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1111'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
    '1112'  => [['5.1.0',   '550', 'userunknown',     1, 1]],
    '1113'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1114'  => [['5.0.930', '',    'systemerror',     0, 0]],
    '1117'  => [['5.0.934', '553', 'mesgtoobig',      0, 0]],
    '1118'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1120'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1121'  => [['4.4.0',   '',    'expired',         0, 0]],
#   '1122'  => [['5.0.911', '550', 'userunknown',     1, 1]],
    '1123'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1124'  => [['4.0.0',   '',    'systemerror',     0, 0]],
#   '1125'  => [['5.0.944', '',    'networkerror',    0, 0]],
    '1126'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1127'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1128'  => [['5.0.930', '',    'systemerror',     0, 0],
#               ['5.0.901', '',    'onhold',          0, 0]],
    '1129'  => [['5.1.1',   '',    'userunknown',     1, 1]],
#   '1130'  => [['5.0.930', '',    'systemerror',     0, 0]],
    '1131'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1132'  => [['5.0.930', '',    'systemerror',     0, 0]],
#   '1133'  => [['5.0.930', '',    'systemerror',     0, 0]],
    '1134'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1135'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1136'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1138'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1139'  => [['4.4.1',   '',    'expired',         0, 0]],
    '1140'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1142'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1143'  => [['5.0.901', '',    'onhold',          0, 0]],
#   '1146'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
#   '1148'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
    '1149'  => [['4.4.7',   '',    'expired',         0, 0]],
#   '1150'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
#   '1153'  => [['5.0.972', '',    'policyviolation', 0, 0]],
    '1154'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1155'  => [['5.4.6',   '554', 'networkerror',    0, 0]],
    '1156'  => [['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0],
                ['5.7.1',   '550', 'spamdetected',    0, 0]],
    '1157'  => [['5.3.0',   '',    'filtered',        0, 1]],
#   '1158'  => [['5.0.947', '',    'expired',         0, 0],
#               ['5.0.901', '',    'onhold',          0, 0]],
    '1159'  => [['5.1.1',   '550', 'mailboxfull',     0, 1]],
#   '1160'  => [['5.0.910', '',    'filtered',        0, 0]],
    '1163'  => [['5.1.1',   '550', 'mesgtoobig',      0, 0]],
    '1164'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1165'  => [['5.0.944', '554', 'networkerror',    0, 0]],
#   '1166'  => [['5.0.930', '',    'systemerror',     0, 0]],
#   '1167'  => [['5.0.912', '',    'hostunknown',     1, 1]],
#   '1168'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
#   '1169'  => [['5.0.911', '550', 'userunknown',     1, 1]],
#   '1170'  => [['5.0.901', '',    'onhold',          0, 0]],
#   '1171'  => [['5.0.901', '',    'onhold',          0, 0]],
#   '1172'  => [['5.0.922', '552', 'mailboxfull',     0, 1]],
#   '1173'  => [['5.0.944', '554', 'networkerror',    0, 0]],
#   '1175'  => [['5.0.910', '',    'filtered',        0, 0]],
#   '1177'  => [['5.0.918', '',    'rejected',        0, 0],
#               ['5.0.901', '',    'onhold',          0, 0]],
#   '1179'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1180'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
#   '1181'  => [['5.0.910', '550', 'filtered',        0, 1]],
#   '1182'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1183'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
#   '1184'  => [['5.0.901', '',    'onhold',          0, 0],
#               ['5.0.901', '',    'onhold',          0, 0]],
    '1212'  => [['4.2.2',   '',    'mailboxfull',     0, 0]],
    '1213'  => [['5.0.0',   '501', 'spamdetected',    0, 0]],
#   '1216'  => [['5.0.901', '',    'onhold',          0, 0]],
#   '1217'  => [['5.1.1',   '550', 'userunknown',     1, 1]], # TODO:
#   '1218'  => [['5.0.945', '',    'toomanyconn',     0, 0]],
#   '1219'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1220'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1222'  => [['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '1223'  => [['4.0.0',   '',    'mailboxfull',     0, 0]],
#   '1224'  => [['5.1.1',   '550', 'authfailure',     0, 0]],
#   '1225'  => [['4.4.7',   '',    'expired',         0, 0]],
#   '1227'  => [['5.5.0',   '',    'userunknown',     1, 1],
#               ['5.5.0',   '',    'userunknown',     1, 1]],
#   '1228'  => [['5.0.901', '',    'onhold',          0, 0]],
    '1229'  => [['5.2.0',   '',    'filtered',        0, 1]],
    '1230'  => [['5.2.0',   '',    'filtered',        0, 1]],
#   '1232'  => [['5.0.944', '554', 'networkerror',    0, 0]],
    '1233'  => [['5.5.0',   '554', 'systemerror',     0, 0]],
#   '1234'  => [['5.0.901', '',    'onhold',          0, 0],
#               ['5.0.911', '550', 'userunknown',     1, 1],
#               ['5.0.911', '550', 'userunknown',     1, 1]],
    '1235'  => [['5.0.0',   '550', 'filtered',        0, 1],
                ['5.0.0',   '550', 'filtered',        0, 1],
                ['5.0.0',   '550', 'filtered',        0, 1],
                ['5.0.0',   '550', 'filtered',        0, 1]],
    '1236'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1237'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1238'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1239'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1240'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1241'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1242'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1243'  => [['5.5.0',   '503', 'syntaxerror',     0, 0]],
    '1244'  => [['5.2.2',   '',    'mailboxfull',     0, 1]],
    '1245'  => [['5.2.2',   '',    'mailboxfull',     0, 1]],
    '1246'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1247'  => [['5.1.1',   '',    'userunknown',     1, 1],
                ['5.1.1',   '',    'userunknown',     1, 1]],
    '1248'  => [['5.2.2',   '',    'mailboxfull',     0, 1]],
    '1249'  => [['5.5.0',   '503', 'syntaxerror',     0, 0]],
    '1250'  => [['5.0.922', '',    'mailboxfull',     0, 0]],
    '1251'  => [['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '1252'  => [['5.0.944', '554', 'networkerror',    0, 0]],
#   '1253'  => [['5.0.912', '',    'hostunknown',     1, 1]],
    '1255'  => [['4.4.7',   '',    'expired',         0, 0]],
#   '1260'  => [['5.0.945', '',    'toomanyconn',     0, 0]],
#   '1262'  => [['5.0.947', '',    'expired',         0, 0]],
    '1263'  => [['4.4.1',   '',    'networkerror',    0, 0]],
    '1265'  => [['5.0.0',   '554', 'policyviolation', 0, 0]],
    '1266'  => [['4.7.0',   '',    'policyviolation', 0, 0]],
    '1267'  => [['5.1.6',   '550', 'hasmoved',        1, 1]],
#   '1268'  => [['5.7.1',   '554', 'spamdetected',    0, 0]],
    '1271'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1272'  => [['5.0.980', '554', 'spamdetected',    0, 0]],
    '1273'  => [['4.3.0',   '',    'mailboxfull',     0, 0]],
    '1274'  => [['4.2.2',   '',    'mailboxfull',     0, 0]],
#   '1275'  => [['5.0.971', '',    'virusdetected',   0, 0]],
#   '1276'  => [['5.0.910', '',    'filtered',        0, 0]],
    '1277'  => [['5.0.0',   '550', 'rejected',        0, 0],
                ['4.0.0',   '',    'networkerror',    0, 0],
                ['5.0.0',   '550', 'filtered',        0, 1]],
    '1278'  => [['4.0.0',   '',    'expired',         0, 0]],
    '1279'  => [['4.4.6',   '',    'networkerror',    0, 0]],
#   '1280'  => [['5.4.0',   '',    'networkerror',    0, 0]],
    '1282'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
#   '1283'  => [['5.0.947', '',    'expired',         0, 0]],
#   '1284'  => [['5.0.972', '',    'policyviolation', 0, 0]],
    '1285'  => [['5.7.0',   '554', 'spamdetected',    0, 0]],
#   '1286'  => [['5.5.0',   '550', 'rejected',        0, 0]], # TODO:
    '1287'  => [['5.0.0',   '550', 'filtered',        0, 1]],
    '1288'  => [['5.3.4',   '552', 'mesgtoobig',      0, 0]],
    '1289'  => [['4.0.0',   '',    'notaccept',       0, 0]],
    '1290'  => [['4.3.0',   '451', 'systemerror',     0, 0]],
    '1300'  => [['5.1.0',   '550', 'userunknown',     1, 1]],
    '1301'  => [['5.0.0',   '',    'spamdetected',    0, 0]],
    '1302'  => [['5.0.0',   '550', 'filtered',        0, 1]],
    '1303'  => [['5.0.0',   '550', 'userunknown',     1, 1]],
    '1304'  => [['4.0.0',   '',    'notaccept',       0, 0]],
    '1305'  => [['5.1.8',   '501', 'rejected',        0, 0]],
    '1306'  => [['4.0.0',   '',    'networkerror',    0, 0]],
    '1307'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1308'  => [['5.0.0',   '',    'policyviolation', 0, 0]],
    '1309'  => [['5.0.0',   '553', 'systemerror',     0, 0]],
    '1310'  => [['4.0.0',   '',    'networkerror',    0, 0]],
    '1312'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1314'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1315'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1318'  => [['5.4.1',   '550', 'rejected',        0, 0]],
    '1319'  => [['5.0.0',   '',    'userunknown',     1, 1]],
    '1320'  => [['5.7.0',   '550', 'filtered',        0, 1]],
    '1321'  => [['5.4.1',   '550', 'userunknown',     1, 1]],
    '1322'  => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '1323'  => [['5.7.0',   '554', 'spamdetected',    0, 0]],
    '1324'  => [['5.4.14',  '554', 'networkerror',    0, 0]],
    '1325'  => [['5.1.2',   '',    'hostunknown',     1, 1]],
    '1326'  => [['5.7.0',   '554', 'spamdetected',    0, 0]],
    '1327'  => [['4.4.7',   '',    'expired',         0, 0]],
    '1328'  => [['5.4.4',   '',    'hostunknown',     1, 1]],
    '1329'  => [['5.7.1',   '',    'securityerror',   0, 0]],
    '1330'  => [['5.0.911', '550', 'userunknown',     1, 1]],
    '1331'  => [['5.4.7',   '',    'expired',         0, 0]],
    '1332'  => [['5.3.0',   '550', 'filtered',        0, 1]],
    '1333'  => [['4.4.1',   '',    'expired',         0, 0]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

