/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.tree.util.Navigator;

public class RuleSetWithWarnings
implements BuiltInRuleSet {
    private BuiltInRuleSet baseRuleSet;

    public RuleSetWithWarnings(BuiltInRuleSet baseRuleSet) {
        this.baseRuleSet = baseRuleSet;
    }

    public BuiltInRuleSet getBaseRuleSet() {
        return this.baseRuleSet;
    }

    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, XPathContext context, Location locationId) throws XPathException {
        this.outputWarning(item, context);
        this.baseRuleSet.process(item, parameters, tunnelParams, context, locationId);
    }

    public void outputWarning(Item item, XPathContext context) {
        String id = item instanceof NodeInfo ? "the node " + Navigator.getPath((NodeInfo)item) : "the atomic value " + item.getStringValue();
        XPathException warning = new XPathException("No user-defined template rule matches " + id, "XTDE0555");
        context.getController().getErrorListener().warning(warning);
    }

    public int[] getActionForParentNodes(int nodeKind) {
        return this.baseRuleSet.getActionForParentNodes(nodeKind);
    }
}

