/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by generate_gr_fir_filter_XXX.py
 * Any changes made to this file will be overwritten.
 */

#ifndef @GUARD_NAME@
#define	@GUARD_NAME@

#include <gr_sync_interpolator.h>

class @NAME@;
typedef boost::shared_ptr<@NAME@> @SPTR_NAME@;
@SPTR_NAME@ gr_make_@BASE_NAME@ (unsigned interpolation, const std::vector<@TAP_TYPE@> &taps);

class @FIR_TYPE@;

/*!
 * \brief Interpolating FIR filter with @I_TYPE@ input, @O_TYPE@ output and @TAP_TYPE@ taps
 * \ingroup filter
 */
class @NAME@ : public gr_sync_interpolator
{
 private:
  friend @SPTR_NAME@ gr_make_@BASE_NAME@ (unsigned interpolation, const std::vector<@TAP_TYPE@> &taps);

  std::vector<@TAP_TYPE@>	d_new_taps;
  bool			d_updated;
  std::vector<@FIR_TYPE@ *> d_firs;

  /*!
   * Construct a FIR filter with the given taps
   */
  @NAME@ (unsigned interpolation, const std::vector<@TAP_TYPE@> &taps);

  void install_taps (const std::vector<@TAP_TYPE@> &taps);

 public:
  ~@NAME@ ();

  void set_taps (const std::vector<@TAP_TYPE@> &taps);

  int work (int noutput_items,
	    gr_vector_const_void_star &input_items,
	    gr_vector_void_star &output_items);
};

#endif
